<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            <i class="fa fa-cubes"></i>
            <?php echo $this->lang->line('manage_theme'); ?>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo site_url('dashboard'); ?>"><i class="fa fa-home"></i> <?php echo $this->lang->line('home'); ?></a></li>
            <li class="active"><?php echo $this->lang->line('manage_theme'); ?></li>
        </ol>
    </section>

    <!-- Main content -->
    <section class="content">
        <!-- Default box -->
        <div class="box box-primary">
            <div class="box-header with-border">
                <h3 class="box-title"><?php echo $this->lang->line('theme'); ?></h3>
            </div>
            <div class="box-body">
                <div class="row">
                    <?php if (isset($themes) && !empty($themes)) { ?>
                        <?php foreach ($themes as $obj) { ?>
                            <div class="col-md-3 col-sm-3 col-xs-6">
                                <div class="theme-box">
                                    <img src="<?php echo IMG_URL; ?>theme/<?php echo $obj->slug; ?>.png" alt="" />
                                    <a href="<?php echo site_url('theme/activate/' . $obj->id); ?>"><button class="btn btn-success" style="background: <?php echo $obj->color_code; ?>;border: 1px solid <?php echo $obj->color_code; ?>;"> <?php echo $obj->slug == $this->session->userdata('theme') ? '<i class="fa fa-check"></i> ' . $this->lang->line('active') : $this->lang->line('activate'); ?></button></a>
                                </div>
                            </div>
                        <?php } ?>
                    <?php } ?>
                </div>
            </div>
            <!-- /.box-body -->
        </div>
        <!-- /.box -->
    </section>
    <!-- /.content -->
</div>
<!-- /.content-wrapper -->