<!-- Vertical Nav -->
<nav class="hk-nav <?php echo $this->session->userdata('top_nav') == 0 ? 'hk-nav-light' : 'hk-nav-dark'; ?>">
    <a href="javascript:void(0);" id="hk_nav_close" class="hk-nav-close"><i class="fa fa-bars"></i></span></a>
    <div class="nicescroll-bar">
        <div class="navbar-nav-wrap">
            <ul class="navbar-nav flex-column">
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo site_url('dashboard'); ?>">
                        <i class="fa fa-tachometer"></i>
                        <span class="nav-link-text"><?php echo $this->lang->line('dashboard'); ?></span>
                    </a>
                </li>
                <hr class="nav-separator mt-0 mb-0">
                <?php if (
                    has_permission(VIEW, 'frontoffice', 'appointment') ||
                    has_permission(VIEW, 'frontoffice', 'complaint') ||
                    has_permission(VIEW, 'frontoffice', 'visitor') ||
                    has_permission(VIEW, 'frontoffice', 'calllog') ||
                    has_permission(VIEW, 'frontoffice', 'dispatch') ||
                    has_permission(VIEW, 'frontoffice', 'receive')
                ) { ?>
                    <li class="nav-item <?php echo $this->uri->segment(1) == 'frontoffice' ? 'active' : ''; ?>">
                        <a class="nav-link" href="javascript:void(0);" data-toggle="collapse" data-target="#front_office">
                            <i class="fa fa-tty" aria-hidden="true"></i>
                            <span class="nav-link-text"><?php echo $this->lang->line('front_office'); ?></span>
                        </a>
                        <ul id="front_office" class="nav flex-column <?php echo $this->uri->segment(1) == 'frontoffice' ? 'show' : ''; ?> collapse collapse-level-1">
                            <li class="nav-item">
                                <ul class="nav flex-column">
                                    <?php if (has_permission(VIEW, 'frontoffice', 'appointment')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_class() == 'appointment' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('frontoffice/appointment'); ?>"><?php echo $this->lang->line('appointment'); ?></a>
                                        </li>
                                    <?php } ?>
                                    <?php if (has_permission(VIEW, 'frontoffice', 'complaint')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_class() == 'complaint' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('frontoffice/complaint'); ?>"><?php echo $this->lang->line('complaint'); ?></a>
                                        </li>
                                    <?php } ?>
                                    <?php if (has_permission(VIEW, 'frontoffice', 'visitor')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_class() == 'visitor' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('frontoffice/visitor'); ?>"><?php echo $this->lang->line('visitor'); ?> <?php echo $this->lang->line('info'); ?></a>
                                        </li>
                                    <?php } ?>
                                    <?php if (has_permission(VIEW, 'frontoffice', 'calllog')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_class() == 'calllog' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('frontoffice/calllog'); ?>"><?php echo $this->lang->line('call_log'); ?></a>
                                        </li>
                                    <?php } ?>
                                    <?php if (has_permission(VIEW, 'frontoffice', 'dispatch')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_class() == 'dispatch' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('frontoffice/dispatch'); ?>"><?php echo $this->lang->line('postal'); ?> <?php echo $this->lang->line('dispatch'); ?></a>
                                        </li>
                                    <?php } ?>
                                    <?php if (has_permission(VIEW, 'frontoffice', 'receive')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_class() == 'receive' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('frontoffice/receive'); ?>"><?php echo $this->lang->line('postal'); ?> <?php echo $this->lang->line('receive'); ?></a>
                                        </li>
                                    <?php } ?>
                                </ul>
                            </li>
                        </ul>
                    </li>
                <?php } ?>


                <?php if (has_permission(VIEW, 'patient', 'patient')) { ?>
                    <hr class="nav-separator mt-0 mb-0">
                    <li class="nav-item <?php echo $this->router->fetch_class() == 'patient' ? 'active' : ''; ?>">
                        <a class="nav-link" href="<?php echo site_url('patient'); ?>">
                            <i class="fa fa-user-circle-o"></i>
                            <span class="nav-link-text"><?php echo $this->lang->line('patient'); ?></span>
                        </a>
                    </li>
                <?php } ?>

                <?php if (has_permission(VIEW, 'opd', 'opd')) { ?>
                    <hr class="nav-separator mt-0 mb-0">
                    <li class="nav-item <?php echo $this->router->fetch_class() == 'opd' ? 'active' : ''; ?>">
                        <a class="nav-link" href="<?php echo site_url('opd'); ?>">
                            <i class="fa fa-user-md"></i>
                            <span class="nav-link-text"><?php echo $this->lang->line('opd'); ?></span>
                        </a>
                    </li>
                <?php } ?>

                <hr class="nav-separator mt-0 mb-0">
                <?php if (
                    has_permission(VIEW, 'ipd', 'ipd')
                ) { ?>
                    <hr class="nav-separator mt-0 mb-0">
                    <li class="nav-item <?php echo $this->uri->segment(1) == 'ipd' ? 'active' : ''; ?>">
                        <a class="nav-link" href="javascript:void(0);" data-toggle="collapse" data-target="#ipd_setup">
                            <i class="fa fa-bed"></i>
                            <span class="nav-link-text"><?php echo $this->lang->line('ipd'); ?></span>
                        </a>
                        <ul id="ipd_setup" class="nav flex-column <?php echo $this->uri->segment(1) == 'ipd' ? 'show' : ''; ?> collapse collapse-level-1">
                            <li class="nav-item">
                                <ul class="nav flex-column">
                                    <?php if (has_permission(VIEW, 'ipd', 'ipd')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_class() == 'ipd' &&  $this->router->fetch_method() == 'admitted' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('ipd/admitted'); ?>"><?php echo $this->lang->line('admitted'); ?> <?php echo $this->lang->line('patient'); ?></a>
                                        </li>
                                    <?php } ?>

                                    <?php if (has_permission(VIEW, 'ipd', 'ipd')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_class() == 'ipd' &&  $this->router->fetch_method() == 'discharge' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('ipd/discharge'); ?>"><?php echo $this->lang->line('discharge'); ?> <?php echo $this->lang->line('patient'); ?></a>
                                        </li>
                                    <?php } ?>

                                    <?php if (has_permission(VIEW, 'ipd', 'ipd')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_method() == 'billing' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('ipd/billing'); ?>"><?php echo $this->lang->line('billing'); ?> <?php echo $this->lang->line('list'); ?></a>
                                        </li>
                                    <?php } ?>
                                </ul>
                            </li>
                        </ul>
                    </li>
                <?php } ?>

                <hr class="nav-separator mt-0 mb-0">
                <?php if (has_permission(VIEW, 'billing', 'billing')) { ?>
                    <li class="nav-item <?php echo $this->uri->segment(1) == 'billing' ? 'active' : ''; ?>">
                        <a class="nav-link" href="javascript:void(0);" data-toggle="collapse" data-target="#billing">
                            <i class="fa fa-bold"></i>
                            <span class="nav-link-text"><?php echo $this->lang->line('billing'); ?></span>
                        </a>
                        <ul id="billing" class="nav flex-column <?php echo $this->uri->segment(1) == 'billing' ? 'show' : ''; ?> collapse collapse-level-1">
                            <li class="nav-item">
                                <ul class="nav flex-column">
                                    <?php if (has_permission(ADD, 'billing', 'billing')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_method() == 'index' ||  $this->router->fetch_method() == 'create' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('billing'); ?>"><?php echo $this->lang->line('create'); ?> <?php echo $this->lang->line('bill'); ?></a>
                                        </li>
                                    <?php } ?>

                                    <?php if (has_permission(VIEW, 'billing', 'billing')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_method() == 'bill' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('billing/bill'); ?>"><?php echo $this->lang->line('bill'); ?> <?php echo $this->lang->line('list'); ?></a>
                                        </li>
                                    <?php } ?>

                                    <?php if (has_permission(VIEW, 'billing', 'billing')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_method() == 'due' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('billing/due'); ?>"><?php echo $this->lang->line('due'); ?> <?php echo $this->lang->line('bill'); ?></a>
                                        </li>
                                    <?php } ?>

                                    <?php if (has_permission(VIEW, 'billing', 'billing')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_method() == 'paid' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('billing/paid'); ?>"><?php echo $this->lang->line('paid'); ?> <?php echo $this->lang->line('bill'); ?></a>
                                        </li>
                                    <?php } ?>
                                </ul>
                            </li>
                        </ul>
                    </li>
                <?php } ?>

                <hr class="nav-separator mt-0 mb-0">
                <?php if (
                    has_permission(VIEW, 'pharmacy', 'pharmacy') ||
                    has_permission(VIEW, 'pharmacy', 'sale') ||
                    has_permission(VIEW, 'pharmacy', 'purchase') ||
                    has_permission(VIEW, 'pharmacy', 'stock') ||
                    has_permission(VIEW, 'pharmacy', 'refund') ||
                    has_permission(VIEW, 'pharmacy', 'medicine') ||
                    has_permission(VIEW, 'pharmacy', 'manufacturer') ||
                    has_permission(VIEW, 'pharmacy', 'supplier') ||
                    has_permission(VIEW, 'pharmacy', 'report')
                ) { ?>
                    <hr class="nav-separator mt-0 mb-0">
                    <li class="nav-item <?php echo $this->uri->segment(1) == 'pharmacy' ? 'active' : ''; ?>">
                        <a class="nav-link" href="javascript:void(0);" data-toggle="collapse" data-target="#pharmacy_setup">
                            <i class="fa fa-medkit"></i>
                            <span class="nav-link-text"><?php echo $this->lang->line('pharmacy'); ?></span>
                        </a>
                        <ul id="pharmacy_setup" class="nav flex-column <?php echo $this->uri->segment(1) == 'pharmacy' ? 'show' : ''; ?> collapse collapse-level-1">
                            <li class="nav-item">
                                <ul class="nav flex-column">
                                    <?php if (has_permission(VIEW, 'pharmacy', 'dashboard')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_class() == 'dashboard' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('pharmacy/dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a>
                                        </li>
                                    <?php } ?>
                                    <?php if (has_permission(VIEW, 'pharmacy', 'sale')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_class() == 'sale' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('pharmacy/sale'); ?>"><?php echo $this->lang->line('manage_sale'); ?></a>
                                        </li>
                                    <?php } ?>
                                    <?php if (has_permission(VIEW, 'pharmacy', 'purchase')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_class() == 'purchase' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('pharmacy/purchase'); ?>"><?php echo $this->lang->line('manage_purchase'); ?></a>
                                        </li>
                                    <?php } ?>
                                    <?php if (has_permission(VIEW, 'pharmacy', 'stock')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_class() == 'stock' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('pharmacy/stock'); ?>"><?php echo $this->lang->line('manage_stock'); ?></a>
                                        </li>
                                    <?php } ?>
                                    <?php if (has_permission(VIEW, 'pharmacy', 'refund')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_class() == 'refund' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('pharmacy/refund'); ?>"><?php echo $this->lang->line('manage_refund'); ?></a>
                                        </li>
                                    <?php } ?>
                                    <?php if (has_permission(VIEW, 'pharmacy', 'medicine')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_class() == 'medicine' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('pharmacy/medicine'); ?>"><?php echo $this->lang->line('manage_medicine'); ?></a>
                                        </li>
                                    <?php } ?>
                                    <?php if (has_permission(VIEW, 'pharmacy', 'manufacturer')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_class() == 'manufacturer' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('pharmacy/manufacturer'); ?>"><?php echo $this->lang->line('manage_manufacturer'); ?></a>
                                        </li>
                                    <?php } ?>
                                    <?php if (has_permission(VIEW, 'pharmacy', 'supplier')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_class() == 'supplier' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('pharmacy/supplier'); ?>"><?php echo $this->lang->line('manage_supplier'); ?></a>
                                        </li>
                                    <?php } ?>
                                    <?php if (has_permission(VIEW, 'pharmacy', 'report')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_class() == 'report' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('pharmacy/report'); ?>"><?php echo $this->lang->line('manage_report'); ?></a>
                                        </li>
                                    <?php } ?>
                                </ul>
                            </li>
                        </ul>
                    </li>
                <?php } ?>

                <hr class="nav-separator mt-0 mb-0">
                <?php if (
                    has_permission(VIEW, 'radiology', 'radiology') ||
                    has_permission(VIEW, 'radiology', 'report')
                ) { ?>
                    <hr class="nav-separator mt-0 mb-0">
                    <li class="nav-item <?php echo $this->uri->segment(1) == 'radiology' ? 'active' : ''; ?>">
                        <a class="nav-link" href="javascript:void(0);" data-toggle="collapse" data-target="#radiology_setup">
                            <i class="fa fa-adjust"></i>
                            <span class="nav-link-text"><?php echo $this->lang->line('radiology'); ?></span>
                        </a>
                        <ul id="radiology_setup" class="nav flex-column <?php echo $this->uri->segment(1) == 'radiology' ? 'show' : ''; ?> collapse collapse-level-1">
                            <li class="nav-item">
                                <ul class="nav flex-column">
                                    <?php if (has_permission(VIEW, 'radiology', 'report')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_method() == 'create' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('radiology/report/create'); ?>"><?php echo $this->lang->line('create'); ?> <?php echo $this->lang->line('report'); ?></a>
                                        </li>
                                    <?php } ?>
                                    <?php if (has_permission(VIEW, 'radiology', 'report')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_method() == 'index' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('radiology/report'); ?>"><?php echo $this->lang->line('manage'); ?> <?php echo $this->lang->line('report'); ?></a>
                                        </li>
                                    <?php } ?>
                                </ul>
                            </li>
                        </ul>
                    </li>
                <?php } ?>

                <?php if (
                    has_permission(VIEW, 'doctor', 'doctor') ||
                    has_permission(VIEW, 'doctor', 'vd') ||
                    has_permission(VIEW, 'doctor', 'anesthesia') ||
                    has_permission(VIEW, 'doctor', 'assistant') ||
                    has_permission(VIEW, 'doctor', 'schedule') ||
                    has_permission(VIEW, 'doctor', 'charge')
                ) { ?>
                    <hr class="nav-separator mt-0 mb-0">
                    <li class="nav-item <?php echo $this->uri->segment(1) == 'doctor' ? 'active' : ''; ?>">
                        <a class="nav-link" href="javascript:void(0);" data-toggle="collapse" data-target="#doctor">
                            <i class="fa fa-user-md"></i>
                            <span class="nav-link-text"><?php echo $this->lang->line('doctor'); ?></span>
                        </a>
                        <ul id="doctor" class="nav flex-column collapse <?php echo $this->uri->segment(1) == 'doctor' ? 'show' : ''; ?> collapse-level-1">
                            <li class="nav-item">
                                <ul class="nav flex-column">
                                    <?php if (has_permission(VIEW, 'doctor', 'doctor')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_class() == 'doctor' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('doctor'); ?>"><?php echo $this->lang->line('manage_doctor'); ?></a>
                                        </li>
                                    <?php } ?>

                                    <?php if (has_permission(VIEW, 'doctor', 'vd')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_class() == 'vd' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('doctor/vd'); ?>"><?php echo $this->lang->line('manage'); ?> <?php echo $this->lang->line('vd'); ?></a>
                                        </li>
                                    <?php } ?>

                                    <?php if (has_permission(VIEW, 'doctor', 'anesthetist')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_class() == 'anesthetist' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('doctor/anesthetist'); ?>"><?php echo $this->lang->line('manage_anesthetist'); ?></a>
                                        </li>
                                    <?php } ?>

                                    <?php if (has_permission(VIEW, 'doctor', 'assistant')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_class() == 'assistant' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('doctor/assistant'); ?>"><?php echo $this->lang->line('manage_assistant'); ?></a>
                                        </li>
                                    <?php } ?>

                                    <?php if (has_permission(VIEW, 'doctor', 'schedule')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_class() == 'schedule' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('doctor/schedule'); ?>"><?php echo $this->lang->line('manage_schedule'); ?></a>
                                        </li>
                                    <?php } ?>

                                    <?php if (has_permission(VIEW, 'doctor', 'charge')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_class() == 'charge' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('doctor/charge'); ?>"><?php echo $this->lang->line('manage_charge'); ?></a>
                                        </li>
                                    <?php } ?>
                                </ul>
                            </li>
                        </ul>
                    </li>
                <?php } ?>
                <hr class="nav-separator mt-0 mb-0">
                <?php if ($this->session->userdata('role_id') == SUPER_ADMIN) { ?>
                    <li class="nav-item <?php echo $this->uri->segment(1) == 'hrm' ? 'active' : ''; ?>">
                        <a class="nav-link" href="<?php echo site_url('hrm/employee'); ?>">
                            <i class="fa fa-user-o"></i>
                            <span class="nav-link-text"><?php echo $this->lang->line('human_resource'); ?></span>
                        </a>
                    </li>
                <?php } else { ?>
                    <?php if (
                        has_permission(VIEW, 'hrm', 'department') ||
                        has_permission(VIEW, 'hrm', 'designation') ||
                        has_permission(VIEW, 'hrm', 'employee')
                    ) { ?>
                        <li class="nav-item <?php echo $this->uri->segment(1) == 'hrm' ? 'active' : ''; ?>">
                            <a class="nav-link" href="javascript:void(0);" data-toggle="collapse" data-target="#human_resource">
                                <i class="fa fa-user-o"></i>
                                <span class="nav-link-text"><?php echo $this->lang->line('human_resource'); ?></span>
                            </a>
                            <ul id="human_resource" class="nav flex-column collapse <?php echo $this->uri->segment(1) == 'hrm' ? 'show' : ''; ?> collapse-level-1">
                                <li class="nav-item">
                                    <ul class="nav flex-column">
                                        <?php if (has_permission(VIEW, 'hrm', 'department')) { ?>
                                            <li class="nav-item <?php echo $this->router->fetch_class() == 'department' ? 'active' : ''; ?>">
                                                <a class="nav-link" href="<?php echo site_url('hrm/department'); ?>"><?php echo $this->lang->line('manage_department'); ?></a>
                                            </li>
                                        <?php } ?>

                                        <?php if (has_permission(VIEW, 'hrm', 'designation')) { ?>
                                            <li class="nav-item <?php echo $this->router->fetch_class() == 'designation' ? 'active' : ''; ?>">
                                                <a class="nav-link" href="<?php echo site_url('hrm/designation'); ?>"><?php echo $this->lang->line('manage_designation'); ?></a>
                                            </li>
                                        <?php } ?>

                                        <?php if (has_permission(VIEW, 'hrm', 'employee')) { ?>
                                            <li class="nav-item <?php echo $this->router->fetch_class() == 'employee' ? 'active' : ''; ?>">
                                                <a class="nav-link" href="<?php echo site_url('hrm/employee'); ?>"><?php echo $this->lang->line('manage_employee'); ?></a>
                                            </li>
                                        <?php } ?>
                                    </ul>
                                </li>
                            </ul>
                        </li>
                    <?php } ?>
                <?php } ?>


                <?php if (
                    has_permission(VIEW, 'diagnostic', 'report') ||
                    has_permission(VIEW, 'diagnostic', 'template') ||
                    has_permission(VIEW, 'report', 'laboratorist')
                ) { ?>

                    <hr class="nav-separator mt-0 mb-0">
                    <li class="nav-item <?php echo $this->uri->segment(1) == 'diagnostic' ? 'active' : ''; ?>">
                        <a class="nav-link" href="javascript:void(0);" data-toggle="collapse" data-target="#diagnostic_setup">
                            <i class="fa fa-flask" aria-hidden="true"></i>
                            <span class="nav-link-text"><?php echo $this->lang->line('diagnostic'); ?></span>
                        </a>
                        <ul id="diagnostic_setup" class="nav flex-column collapse <?php echo $this->uri->segment(1) == 'diagnostic' ? 'show' : ''; ?> collapse-level-1">
                            <li class="nav-item">
                                <ul class="nav flex-column">
                                    <?php if (has_permission(ADD, 'diagnostic', 'report')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_method() == 'create' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('diagnostic/report/create'); ?>"><?php echo $this->lang->line('create'); ?> <?php echo $this->lang->line('report'); ?></a>
                                        </li>
                                    <?php } ?>
                                    <?php if (has_permission(VIEW, 'diagnostic', 'report')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_method() == 'index' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('diagnostic/report'); ?>"><?php echo $this->lang->line('manage'); ?> <?php echo $this->lang->line('report'); ?></a>
                                        </li>
                                    <?php } ?>
                                    <?php if (has_permission(VIEW, 'diagnostic', 'template')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_class() == 'template' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('diagnostic/template'); ?>"><?php echo $this->lang->line('manage'); ?> <?php echo $this->lang->line('template'); ?></a>
                                        </li>
                                    <?php } ?>
                                    <?php if (has_permission(VIEW, 'diagnostic', 'ultrasonography')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_class() == 'ultrasonography' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('diagnostic/ultrasonography'); ?>"><?php echo $this->lang->line('ultrasonography'); ?> <?php echo $this->lang->line('template'); ?></a>
                                        </li>
                                    <?php } ?>
                                    <?php if (has_permission(VIEW, 'diagnostic', 'laboratorist')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_class() == 'laboratorist' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('diagnostic/laboratorist'); ?>"><?php echo $this->lang->line('manage'); ?> <?php echo $this->lang->line('laboratorist'); ?></a>
                                        </li>
                                    <?php } ?>
                                </ul>
                            </li>
                        </ul>
                    </li>
                <?php } ?>


                <?php if (
                    has_permission(VIEW, 'accounting', 'exphead') ||
                    has_permission(VIEW, 'accounting', 'expenditure') ||
                    has_permission(VIEW, 'accounting', 'incomehead') ||
                    has_permission(VIEW, 'accounting', 'income') ||
                    has_permission(VIEW, 'accounting', 'payment')
                ) { ?>

                    <hr class="nav-separator mt-0 mb-0">
                    <li class="nav-item <?php echo $this->uri->segment(1) == 'accounting' ? 'active' : ''; ?>">
                        <a class="nav-link" href="javascript:void(0);" data-toggle="collapse" data-target="#accounting_setup">
                            <i class="fa fa-calculator" aria-hidden="true"></i>
                            <span class="nav-link-text"><?php echo $this->lang->line('accounting'); ?></span>
                        </a>
                        <ul id="accounting_setup" class="nav flex-column collapse <?php echo $this->uri->segment(1) == 'accounting' ? 'show' : ''; ?> collapse-level-1">
                            <li class="nav-item">
                                <ul class="nav flex-column">
                                    <?php if (has_permission(VIEW, 'accounting', 'exphead')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_class() == 'exphead' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('accounting/exphead'); ?>"><?php echo $this->lang->line('manage_expenditure_head'); ?></a>
                                        </li>
                                    <?php } ?>
                                    <?php if (has_permission(VIEW, 'accounting', 'expenditure')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_class() == 'expenditure' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('accounting/expenditure'); ?>"><?php echo $this->lang->line('manage_expenditure'); ?></a>
                                        </li>
                                    <?php } ?>
                                    <?php if (has_permission(VIEW, 'accounting', 'incomehead')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_class() == 'incomehead' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('accounting/incomehead'); ?>"><?php echo $this->lang->line('manage_income_head'); ?></a>
                                        </li>
                                    <?php } ?>
                                    <?php if (has_permission(VIEW, 'accounting', 'income')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_class() == 'income' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('accounting/income'); ?>"><?php echo $this->lang->line('manage_income'); ?></a>
                                        </li>
                                    <?php } ?>
                                    <?php if (has_permission(VIEW, 'accounting', 'payment')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_class() == 'payment' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('accounting/payment'); ?>"><?php echo $this->lang->line('manage_payment'); ?></a>
                                        </li>
                                    <?php } ?>
                                </ul>
                            </li>
                        </ul>
                    </li>
                <?php } ?>

                <?php if (
                    has_permission(VIEW, 'report', 'appointment') ||
                    has_permission(VIEW, 'report', 'opd') ||
                    has_permission(VIEW, 'report', 'billing') ||
                    has_permission(VIEW, 'report', 'ipd') ||
                    has_permission(VIEW, 'report', 'diagnostic') ||
                    has_permission(VIEW, 'report', 'payment') ||
                    has_permission(VIEW, 'report', 'expenditure') ||
                    has_permission(VIEW, 'report', 'income') ||
                    has_permission(VIEW, 'report', 'employee')
                ) { ?>

                    <hr class="nav-separator mt-0 mb-0">
                    <li class="nav-item <?php echo $this->uri->segment(1) == 'report' ? 'active' : ''; ?>">
                        <a class="nav-link" href="javascript:void(0);" data-toggle="collapse" data-target="#report">
                            <i class="fa fa-bar-chart" aria-hidden="true"></i>
                            <span class="nav-link-text"><?php echo $this->lang->line('report'); ?></span>
                        </a>
                        <ul id="report" class="nav flex-column collapse <?php echo $this->uri->segment(1) == 'report' ? 'show' : ''; ?> collapse-level-1">
                            <li class="nav-item">
                                <ul class="nav flex-column">
                                    <?php if (has_permission(VIEW, 'report', 'appointment')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_class() == 'appointment' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('report/appointment'); ?>"><?php echo $this->lang->line('appointment'); ?> <?php echo $this->lang->line('report'); ?></a>
                                        </li>
                                    <?php } ?>
                                    <?php if (has_permission(VIEW, 'report', 'opd')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_class() == 'opd' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('report/opd'); ?>"><?php echo $this->lang->line('opd'); ?> <?php echo $this->lang->line('report'); ?></a>
                                        </li>
                                    <?php } ?>
                                    <?php if (has_permission(VIEW, 'report', 'billing')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_class() == 'billing' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('report/billing'); ?>"><?php echo $this->lang->line('billing'); ?> <?php echo $this->lang->line('report'); ?></a>
                                        </li>
                                    <?php } ?>
                                    <?php if (has_permission(VIEW, 'report', 'ipd')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_class() == 'ipd' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('report/ipd'); ?>"><?php echo $this->lang->line('ipd'); ?> <?php echo $this->lang->line('report'); ?></a>
                                        </li>
                                    <?php } ?>
                                    <?php if (has_permission(VIEW, 'report', 'marketing')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_class() == 'marketing' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('report/marketing'); ?>"><?php echo $this->lang->line('marketing'); ?> <?php echo $this->lang->line('report'); ?></a>
                                        </li>
                                    <?php } ?>
                                    <?php if (has_permission(VIEW, 'report', 'diagnostic')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_class() == 'diagnostic' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('report/diagnostic'); ?>"><?php echo $this->lang->line('diagnostic'); ?> <?php echo $this->lang->line('report'); ?></a>
                                        </li>
                                    <?php } ?>

                                    <?php if (has_permission(VIEW, 'report', 'payment')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_class() == 'payment' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('report/payment'); ?>"><?php echo $this->lang->line('payment'); ?> <?php echo $this->lang->line('report'); ?></a>
                                        </li>
                                    <?php } ?>

                                    <?php if (has_permission(VIEW, 'report', 'expenditure')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_class() == 'expenditure' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('report/expenditure'); ?>"><?php echo $this->lang->line('expenditure'); ?> <?php echo $this->lang->line('report'); ?></a>
                                        </li>
                                    <?php } ?>

                                    <?php if (has_permission(VIEW, 'report', 'income')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_class() == 'income' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('report/income'); ?>"><?php echo $this->lang->line('income'); ?> <?php echo $this->lang->line('report'); ?></a>
                                        </li>
                                    <?php } ?>

                                    <?php if (has_permission(VIEW, 'report', 'employee')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_class() == 'employee' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('report/employee'); ?>"><?php echo $this->lang->line('employee'); ?> <?php echo $this->lang->line('report'); ?></a>
                                        </li>
                                    <?php } ?>

                                    <?php if (has_permission(VIEW, 'report', 'sms')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_class() == 'sms' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('report/sms'); ?>"><?php echo $this->lang->line('sms'); ?> <?php echo $this->lang->line('report'); ?></a>
                                        </li>
                                    <?php } ?>

                                    <?php if (has_permission(VIEW, 'report', 'mis')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_class() == 'mis' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('report/mis'); ?>"><?php echo $this->lang->line('mis'); ?> <?php echo $this->lang->line('report'); ?></a>
                                        </li>
                                    <?php } ?>
                                </ul>
                            </li>
                        </ul>
                    </li>
                <?php } ?>


                <?php if (
                    has_permission(VIEW, 'announcement', 'notice') ||
                    has_permission(VIEW, 'announcement', 'news') ||
                    has_permission(VIEW, 'announcement', 'event')
                ) { ?>

                    <hr class="nav-separator mt-0 mb-0">
                    <li class="nav-item <?php echo $this->uri->segment(1) == 'announcement' ? 'active' : ''; ?>">
                        <a class="nav-link" href="javascript:void(0);" data-toggle="collapse" data-target="#announcement">
                            <i class="fa fa-bell" aria-hidden="true"></i>
                            <span class="nav-link-text"><?php echo $this->lang->line('announcement'); ?></span>
                        </a>
                        <ul id="announcement" class="nav flex-column collapse <?php echo $this->uri->segment(1) == 'announcement' ? 'show' : ''; ?> collapse-level-1">
                            <li class="nav-item">
                                <ul class="nav flex-column">
                                    <?php if (has_permission(VIEW, 'announcement', 'notice')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_class() == 'notice' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('announcement/notice'); ?>"><?php echo $this->lang->line('notice'); ?></a>
                                        </li>
                                    <?php } ?>
                                    <?php if (has_permission(VIEW, 'announcement', 'news')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_class() == 'news' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('announcement/news'); ?>"><?php echo $this->lang->line('news'); ?></a>
                                        </li>
                                    <?php } ?>
                                    <?php if (has_permission(VIEW, 'announcement', 'event')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_class() == 'event' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('announcement/event'); ?>"><?php echo $this->lang->line('event'); ?></a>
                                        </li>
                                    <?php } ?>
                                </ul>
                            </li>
                        </ul>
                    </li>
                <?php } ?>

                <?php if (
                    has_permission(VIEW, 'message', 'email') ||
                    has_permission(VIEW, 'message', 'sms') ||
                    has_permission(VIEW, 'message', 'patient') ||
                    has_permission(VIEW, 'message', 'opd') ||
                    has_permission(VIEW, 'message', 'ipd') ||
                    has_permission(VIEW, 'message', 'doctor') ||
                    has_permission(VIEW, 'message', 'vd') ||
                    has_permission(VIEW, 'announcement', 'employee')
                ) { ?>

                    <hr class="nav-separator mt-0 mb-0">
                    <li class="nav-item <?php echo $this->uri->segment(1) == 'message' ? 'active' : ''; ?>">
                        <a class="nav-link" href="javascript:void(0);" data-toggle="collapse" data-target="#message">
                            <i class="fa fa-envelope-o" aria-hidden="true"></i>
                            <span class="nav-link-text"><?php echo $this->lang->line('message'); ?></span>
                        </a>
                        <ul id="message" class="nav flex-column collapse <?php echo $this->uri->segment(1) == 'message' ? 'show' : ''; ?> collapse-level-1">
                            <li class="nav-item">
                                <ul class="nav flex-column">
                                    <?php if (has_permission(VIEW, 'message', 'email')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_class() == 'email' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('message/email'); ?>"><?php echo $this->lang->line('general'); ?> <?php echo $this->lang->line('email'); ?></a>
                                        </li>
                                    <?php } ?>
                                    <?php if (has_permission(VIEW, 'message', 'sms')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_class() == 'sms' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('message/sms'); ?>"><?php echo $this->lang->line('general'); ?> <?php echo $this->lang->line('sms'); ?></a>
                                        </li>
                                    <?php } ?>

                                    <?php if (has_permission(VIEW, 'message', 'patient')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_class() == 'patient' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('message/patient'); ?>"><?php echo $this->lang->line('patient'); ?></a>
                                        </li>
                                    <?php } ?>

                                    <?php if (has_permission(VIEW, 'message', 'opd')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_class() == 'opd' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('message/opd'); ?>"><?php echo $this->lang->line('opd'); ?> <?php echo $this->lang->line('patient'); ?></a>
                                        </li>
                                    <?php } ?>

                                    <?php if (has_permission(VIEW, 'message', 'ipd')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_class() == 'ipd' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('message/ipd'); ?>"><?php echo $this->lang->line('ipd'); ?> <?php echo $this->lang->line('patient'); ?></a>
                                        </li>
                                    <?php } ?>

                                    <?php if (has_permission(VIEW, 'message', 'doctor')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_class() == 'doctor' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('message/doctor'); ?>"><?php echo $this->lang->line('doctor'); ?></a>
                                        </li>
                                    <?php } ?>

                                    <?php if (has_permission(VIEW, 'message', 'vd')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_class() == 'vd' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('message/vd'); ?>"><?php echo $this->lang->line('vd'); ?></a>
                                        </li>
                                    <?php } ?>

                                    <?php if (has_permission(VIEW, 'message', 'employee')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_class() == 'employee' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('message/employee'); ?>"><?php echo $this->lang->line('employee'); ?></a>
                                        </li>
                                    <?php } ?>
                                </ul>
                            </li>
                        </ul>
                    </li>
                <?php } ?>

                <?php if (
                    has_permission(VIEW, 'hospital', 'diagnostic') ||
                    has_permission(VIEW, 'hospital', 'ipd') ||
                    has_permission(VIEW, 'hospital', 'bed') ||
                    has_permission(VIEW, 'hospital', 'frontoffice')
                ) { ?>
                    <hr class="nav-separator mt-0 mb-0">
                    <li class="nav-item <?php echo $this->uri->segment(1) == 'hospital' ? 'active' : ''; ?>">
                        <a class="nav-link" href="javascript:void(0);" data-toggle="collapse" data-target="#hospital_setup">
                            <i class="fa fa-h-square" aria-hidden="true"></i>
                            <span class="nav-link-text"><?php echo $this->lang->line('hospital'); ?> <?php echo $this->lang->line('setup'); ?></span>
                        </a>
                        <ul id="hospital_setup" class="nav flex-column collapse <?php echo $this->uri->segment(1) == 'hospital' ? 'show' : ''; ?> collapse-level-1">
                            <li class="nav-item">
                                <ul class="nav flex-column">
                                    <?php if (has_permission(VIEW, 'hospital', 'diagnostic')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_class() == 'diagnostic' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('hospital/diagnostic'); ?>"><?php echo $this->lang->line('diagnostic'); ?></a>
                                        </li>
                                    <?php } ?>

                                    <?php if (has_permission(VIEW, 'hospital', 'ipd')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_class() == 'ipd' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('hospital/ipd'); ?>"><?php echo $this->lang->line('ipd'); ?></a>
                                        </li>
                                    <?php } ?>

                                    <?php if (has_permission(VIEW, 'hospital', 'bed')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_class() == 'bed' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('hospital/bed/status'); ?>"><?php echo $this->lang->line('bed'); ?></a>
                                        </li>
                                    <?php } ?>
                                    <?php if (has_permission(VIEW, 'hospital', 'frontoffice')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_class() == 'frontoffice' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('hospital/frontoffice'); ?>"><?php echo $this->lang->line('front_office'); ?></a>
                                        </li>
                                    <?php } ?>
                                </ul>
                            </li>
                        </ul>
                    </li>
                <?php } ?>

                <?php if (
                    has_permission(VIEW, 'gallery', 'category') ||
                    has_permission(VIEW, 'gallery', 'photo') ||
                    has_permission(VIEW, 'gallery', 'video')
                ) { ?>
                    <hr class="nav-separator mt-0 mb-0">
                    <li class="nav-item <?php echo $this->uri->segment(1) == 'gallery' ? 'active' : ''; ?>">
                        <a class="nav-link" href="javascript:void(0);" data-toggle="collapse" data-target="#gallery_setup">
                            <i class="fa fa-camera" aria-hidden="true"></i>
                            <span class="nav-link-text"><?php echo $this->lang->line('manage_gallery'); ?></span>
                        </a>
                        <ul id="gallery_setup" class="nav flex-column collapse <?php echo $this->uri->segment(1) == 'gallery' ? 'show' : ''; ?> collapse-level-1">
                            <li class="nav-item">
                                <ul class="nav flex-column">
                                    <?php if (has_permission(VIEW, 'gallery', 'category')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_class() == 'category' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('gallery/category'); ?>"><?php echo $this->lang->line('manage_category'); ?></a>
                                        </li>
                                    <?php } ?>
                                    <?php if (has_permission(VIEW, 'gallery', 'photo')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_class() == 'photo' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('gallery/photo'); ?>"><?php echo $this->lang->line('manage_photo'); ?></a>
                                        </li>
                                    <?php } ?>
                                    <?php if (has_permission(VIEW, 'gallery', 'video')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_class() == 'video' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('gallery/video'); ?>"><?php echo $this->lang->line('manage_video'); ?></a>
                                        </li>
                                    <?php } ?>
                                </ul>
                            </li>
                        </ul>
                    </li>
                <?php } ?>

                <?php if (
                    has_permission(VIEW, 'frontend', 'frontend') ||
                    has_permission(VIEW, 'frontend', 'menu') ||
                    has_permission(VIEW, 'frontend', 'slider') ||
                    has_permission(VIEW, 'frontend', 'service') ||
                    has_permission(VIEW, 'frontend', 'testimonial')
                ) { ?>
                    <hr class="nav-separator mt-0 mb-0">
                    <li class="nav-item <?php echo $this->uri->segment(1) == 'frontend' ? 'active' : ''; ?>">
                        <a class="nav-link" href="javascript:void(0);" data-toggle="collapse" data-target="#frontend_setup">
                            <i class="fa fa-desktop" aria-hidden="true"></i>
                            <span class="nav-link-text"><?php echo $this->lang->line('frontend'); ?> <?php echo $this->lang->line('setup'); ?></span>
                        </a>
                        <ul id="frontend_setup" class="nav flex-column collapse <?php echo $this->uri->segment(1) == 'frontend' ? 'show' : ''; ?> collapse-level-1">
                            <li class="nav-item">
                                <ul class="nav flex-column">
                                    <?php if (has_permission(VIEW, 'frontend', 'frontend')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_class() == 'frontend' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('frontend'); ?>"><?php echo $this->lang->line('manage_frontend'); ?></a>
                                        </li>
                                    <?php } ?>
                                    <?php if (has_permission(VIEW, 'frontend', 'frontend')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_method() == 'about' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('frontend/about'); ?>"><?php echo $this->lang->line('about'); ?> <?php echo $this->lang->line('section'); ?></a>
                                        </li>
                                    <?php } ?>
                                    <?php if (has_permission(VIEW, 'frontend', 'frontend')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_method() == 'support' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('frontend/support'); ?>"><?php echo $this->lang->line('support'); ?> <?php echo $this->lang->line('section'); ?></a>
                                        </li>
                                    <?php } ?>
                                    <?php if (has_permission(VIEW, 'frontend', 'frontend')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_method() == 'section' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('frontend/section'); ?>"><?php echo $this->lang->line('other'); ?> <?php echo $this->lang->line('section'); ?></a>
                                        </li>
                                    <?php } ?>
                                    <?php if (has_permission(VIEW, 'frontend', 'menu')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_class() == 'menu' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('frontend/menu'); ?>"><?php echo $this->lang->line('manage_menu'); ?></a>
                                        </li>
                                    <?php } ?>
                                    <?php if (has_permission(VIEW, 'frontend', 'slider')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_class() == 'slider' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('frontend/slider'); ?>"><?php echo $this->lang->line('manage_slider'); ?></a>
                                        </li>
                                    <?php } ?>
                                    <?php if (has_permission(VIEW, 'frontend', 'service')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_class() == 'service' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('frontend/service'); ?>"><?php echo $this->lang->line('manage_service'); ?></a>
                                        </li>
                                    <?php } ?>
                                    <?php if (has_permission(VIEW, 'frontend', 'testimonial')) { ?>
                                        <li class="nav-item <?php echo $this->router->fetch_class() == 'testimonial' ? 'active' : ''; ?>">
                                            <a class="nav-link" href="<?php echo site_url('frontend/testimonial'); ?>"><?php echo $this->lang->line('manage_testimonial'); ?></a>
                                        </li>
                                    <?php } ?>
                                </ul>
                            </li>
                        </ul>
                    </li>
                <?php } ?>

                <hr class="nav-separator mt-0 mb-0">
                <?php if ($this->session->userdata('role_id') == SUPER_ADMIN) { ?>
                    <li class="nav-item <?php echo $this->uri->segment(1) == 'setting' ? 'active' : ''; ?>">
                        <a class="nav-link" href="<?php echo site_url('setting'); ?>">
                            <i class="fa fa-cogs"></i>
                            <span class="nav-link-text"><?php echo $this->lang->line('setting'); ?></span>
                        </a>
                    </li>
                <?php } else { ?>
                    <?php if (
                        has_permission(VIEW, 'setting', 'setting') ||
                        has_permission(VIEW, 'setting', 'module') ||
                        has_permission(VIEW, 'setting', 'operation') ||
                        has_permission(VIEW, 'setting', 'notification') ||
                        has_permission(VIEW, 'setting', 'emailsetting') ||
                        has_permission(VIEW, 'setting', 'smssetting') ||
                        has_permission(VIEW, 'setting', 'role') ||
                        has_permission(VIEW, 'setting', 'permission') ||
                        has_permission(VIEW, 'setting', 'user') ||
                        has_permission(VIEW, 'setting', 'password') ||
                        has_permission(VIEW, 'setting', 'email') ||
                        has_permission(VIEW, 'setting', 'usercredential') ||
                        has_permission(VIEW, 'setting', 'activitylog') ||
                        has_permission(VIEW, 'setting', 'emailtemplate') ||
                        has_permission(VIEW, 'setting', 'smstemplate') ||
                        has_permission(VIEW, 'setting', 'backup')
                    ) { ?>
                        <li class="nav-item <?php echo $this->uri->segment(1) == 'setting' ? 'active' : ''; ?>">
                            <a class="nav-link" href="javascript:void(0);" data-toggle="collapse" data-target="#setting">
                                <i class="fa fa-cogs"></i>
                                <span class="nav-link-text"><?php echo $this->lang->line('setting'); ?></span>
                            </a>
                            <ul id="setting" class="nav flex-column <?php echo $this->uri->segment(1) == 'setting' ? 'show' : ''; ?> collapse collapse-level-1">
                                <li class="nav-item">
                                    <ul class="nav flex-column">
                                        <?php if (has_permission(VIEW, 'setting', 'setting')) { ?>
                                            <li class="nav-item <?php echo $this->router->fetch_class() == 'setting' ? 'active' : ''; ?>">
                                                <a class="nav-link" href="<?php echo site_url('setting'); ?>"><?php echo $this->lang->line('manage_setting'); ?></a>
                                            </li>
                                        <?php } ?>

                                        <?php if (has_permission(VIEW, 'setting', 'module')) { ?>
                                            <li class="nav-item <?php echo $this->router->fetch_class() == 'module' ? 'active' : ''; ?>">
                                                <a class="nav-link" href="<?php echo site_url('setting/module'); ?>"><?php echo $this->lang->line('manage_module'); ?></a>
                                            </li>
                                        <?php } ?>

                                        <?php if (has_permission(VIEW, 'setting', 'operation')) { ?>
                                            <li class="nav-item <?php echo $this->router->fetch_class() == 'operation' ? 'active' : ''; ?>">
                                                <a class="nav-link" href="<?php echo site_url('setting/operation'); ?>"><?php echo $this->lang->line('manage_operation'); ?></a>
                                            </li>
                                        <?php } ?>

                                        <?php if (has_permission(VIEW, 'setting', 'notification')) { ?>
                                            <li class="nav-item <?php echo $this->router->fetch_class() == 'notification' ? 'active' : ''; ?>">
                                                <a class="nav-link" href="<?php echo site_url('setting/notification'); ?>"><?php echo $this->lang->line('manage_notification'); ?></a>
                                            </li>
                                        <?php } ?>

                                        <?php if (has_permission(VIEW, 'setting', 'emailsetting')) { ?>
                                            <li class="nav-item <?php echo $this->router->fetch_class() == 'emailsetting' ? 'active' : ''; ?>">
                                                <a class="nav-link" href="<?php echo site_url('setting/emailsetting'); ?>"><?php echo $this->lang->line('email'); ?> <?php echo $this->lang->line('setting'); ?></a>
                                            </li>
                                        <?php } ?>

                                        <?php if (has_permission(VIEW, 'setting', 'smssetting')) { ?>
                                            <li class="nav-item <?php echo $this->router->fetch_class() == 'smssetting' ? 'active' : ''; ?>">
                                                <a class="nav-link" href="<?php echo site_url('setting/smssetting'); ?>"><?php echo $this->lang->line('sms'); ?> <?php echo $this->lang->line('setting'); ?></a>
                                            </li>
                                        <?php } ?>

                                        <?php if (has_permission(VIEW, 'setting', 'role')) { ?>
                                            <li class="nav-item <?php echo $this->router->fetch_class() == 'role' ? 'active' : ''; ?>">
                                                <a class="nav-link" href="<?php echo site_url('setting/role'); ?>"><?php echo $this->lang->line('manage_role'); ?></a>
                                            </li>
                                        <?php } ?>

                                        <?php if (has_permission(VIEW, 'setting', 'permission')) { ?>
                                            <li class="nav-item <?php echo $this->router->fetch_class() == 'permission' ? 'active' : ''; ?>">
                                                <a class="nav-link" href="<?php echo site_url('setting/permission'); ?>"><?php echo $this->lang->line('manage_permission'); ?></a>
                                            </li>
                                        <?php } ?>

                                        <?php if (has_permission(VIEW, 'setting', 'user')) { ?>
                                            <li class="nav-item <?php echo $this->router->fetch_class() == 'user' ? 'active' : ''; ?>">
                                                <a class="nav-link" href="<?php echo site_url('setting/user'); ?>"><?php echo $this->lang->line('manage_user'); ?></a>
                                            </li>
                                        <?php } ?>

                                        <?php if (has_permission(VIEW, 'setting', 'password')) { ?>
                                            <li class="nav-item <?php echo $this->router->fetch_class() == 'password' ? 'active' : ''; ?>">
                                                <a class="nav-link" href="<?php echo site_url('setting/password'); ?>"><?php echo $this->lang->line('users'); ?> <?php echo $this->lang->line('reset_password'); ?></a>
                                            </li>
                                        <?php } ?>

                                        <?php if (has_permission(VIEW, 'setting', 'email')) { ?>
                                            <li class="nav-item <?php echo $this->router->fetch_class() == 'email' ? 'active' : ''; ?>">
                                                <a class="nav-link" href="<?php echo site_url('setting/email'); ?>"><?php echo $this->lang->line('users'); ?> <?php echo $this->lang->line('reset_email'); ?></a>
                                            </li>
                                        <?php } ?>

                                        <?php if (has_permission(VIEW, 'setting', 'usercredential')) { ?>
                                            <li class="nav-item <?php echo $this->router->fetch_class() == 'usercredential' ? 'active' : ''; ?>">
                                                <a class="nav-link" href="<?php echo site_url('setting/usercredential'); ?>"><?php echo $this->lang->line('users'); ?> <?php echo $this->lang->line('credential'); ?></a>
                                            </li>
                                        <?php } ?>

                                        <?php if (has_permission(VIEW, 'setting', 'activitylog')) { ?>
                                            <li class="nav-item <?php echo $this->router->fetch_class() == 'activitylog' ? 'active' : ''; ?>">
                                                <a class="nav-link" href="<?php echo site_url('setting/activitylog'); ?>"><?php echo $this->lang->line('manage_activity'); ?></a>
                                            </li>
                                        <?php } ?>

                                        <?php if (has_permission(VIEW, 'setting', 'backup')) { ?>
                                            <li class="nav-item <?php echo $this->router->fetch_class() == 'backup' ? 'active' : ''; ?>">
                                                <a class="nav-link" href="<?php echo site_url('setting/backup'); ?>"><?php echo $this->lang->line('manage_backup'); ?></a>
                                            </li>
                                        <?php } ?>

                                        <?php if (has_permission(VIEW, 'setting', 'custom')) { ?>
                                            <li class="nav-item <?php echo $this->router->fetch_class() == 'custom' ? 'active' : ''; ?>">
                                                <a class="nav-link" href="<?php echo site_url('setting/custom'); ?>"><?php echo $this->lang->line('custom'); ?> <?php echo $this->lang->line('permission'); ?></a>
                                            </li>
                                        <?php } ?>
                                    </ul>
                                </li>
                            </ul>
                        </li>
                    <?php } ?>
                <?php } ?>
            </ul>
            <hr class="nav-separator mt-0 mb-0">
            <div class="nav-header">
                <span><?php echo $this->lang->line('help'); ?></span>
                <span><?php echo $this->lang->line('help'); ?></span>
            </div>
            <ul class="navbar-nav flex-column">
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo site_url('setting/support'); ?>">
                        <i class="fa fa-phone"></i>
                        <span class="nav-link-text"><?php echo $this->lang->line('support'); ?></span>
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link link-with-badge" href="#">
                        <i class="fa fa-eye"></i>
                        <span class="nav-link-text"><?php echo $this->lang->line('version'); ?></span>
                        <span class="badge badge-sm badge-danger badge-pill">v 1.0</span>
                    </a>
                </li>
            </ul>
        </div>
    </div>
</nav>
<div id="hk_nav_backdrop" class="hk-nav-backdrop"></div>
<!-- /Vertical Nav -->