<!DOCTYPE html>
<html lang="en">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <!-- Meta, title, CSS, favicons, etc. -->
    <meta charset="utf-8">
    <meta charset="ISO-8859-15">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <title><?php echo $title; ?></title>
    <!-- Favicon -->
    <?php if ($this->global_setting->favicon) { ?>
        <link rel="icon" href="<?php echo UPLOAD_PATH; ?>icon/<?php echo $this->global_setting->favicon; ?>" type="image/x-icon" />
    <?php } else { ?>
        <link rel="icon" href="<?php echo IMG_URL; ?>favicon.ico" type="image/x-icon" />
    <?php } ?>

    <!-- Bootstrap 4.5 -->
    <link rel="stylesheet" href="<?php echo VENDOR_URL; ?>bootstrap/css/bootstrap.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="<?php echo VENDOR_URL; ?>font-awesome/css/font-awesome.min.css">
    <!-- Animate CSS -->
    <link href="<?php echo CSS_URL; ?>backend/animate.css" rel="stylesheet" type="text/css">
    <!-- Toastr CSS -->
    <link href="<?php echo VENDOR_URL; ?>toast/jquery.toast.min.css" rel="stylesheet" type="text/css">
    <!-- Toggles CSS -->
    <link href="<?php echo VENDOR_URL;  ?>jquery-toggles/css/toggles.css" rel="stylesheet" type="text/css">
    <!-- Theme style -->
    <link rel="stylesheet" href="<?php echo CSS_URL; ?>backend/style.css">
    <!-- Custom Theme Style -->
    <link href="<?php echo CSS_URL; ?>backend/custom.css" rel="stylesheet">

    <!-- jQuery -->
    <script src="<?php echo JS_URL; ?>jquery.min.js"></script>

    <!-- Bootstrap Core JavaScript -->
    <script src="<?php echo JS_URL; ?>popper.min.js"></script>
    <script src="<?php echo VENDOR_URL; ?>bootstrap/js/bootstrap.min.js"></script>
</head>

<body>
    <!-- HK Wrapper -->
    <?php if (isMobile()) { ?>
        <div class="hk-wrapper hk-vertical-nav">
        <?php } else {  ?>
            <div class="<?php echo $this->session->userdata('toggle_btn') ? 'hk-wrapper hk-vertical-nav hk-nav-toggle' : 'hk-wrapper hk-vertical-nav'; ?>">
            <?php } ?>
            <!-- top navigation -->
            <?php $this->load->view('layout/header'); ?>
            <!-- /top navigation -->
            <?php $this->load->view('layout/left-side'); ?>
            <!-- Main Content -->
            <div class="hk-pg-wrapper">
                <!-- Setting Panel -->
                <div class="hk-settings-panel">
                    <div class="nicescroll-bar position-relative">
                        <div class="settings-panel-wrap">
                            <div class="settings-panel-head">
                                <a href="javascript:void(0);" id="settings_panel_close" class="settings-panel-close"><i class="fa fa-times"></i></a>
                            </div>
                            <hr>

                            <h6 class="mb-5"> <?php echo $this->lang->line('language'); ?></h6>
                            <p class="font-14"><?php echo $this->lang->line('switch_language'); ?></p>
                            <div class="button-list hk-nav-select mb-10">
                                <a href="<?php echo base_url("language/english"); ?>" class="btn btn-outline-light btn-xs btn-wth-icon icon-wthot-bg">
                                    <span class="icon-label">
                                        <img src="<?php echo IMG_URL; ?>flag/en.png" alt="en">
                                    </span>
                                    <span class="btn-text"> <?php echo $this->lang->line('english'); ?></span>
                                </a>
                                <a href="<?php echo site_url('language/bengali'); ?>" class="btn btn-outline-primary btn-xs btn-wth-icon icon-wthot-bg">
                                    <span class="icon-label">
                                        <img src="<?php echo IMG_URL; ?>flag/bd.png" alt="bd">
                                    </span>
                                    <span class="btn-text"> <?php echo $this->lang->line('bengali'); ?></span>
                                </a>
                            </div>
                            <hr>

                            <h6 class="mb-5">Navigation</h6>
                            <p class="font-14">Menu comes in two modes: dark & light</p>
                            <div class="button-list hk-nav-select mb-10">
                                <button type="button" id="nav_light_select" class="btn btn-outline-light btn-sm btn-wth-icon icon-wthot-bg"><span class="icon-label"><i class="fa fa-sun-o"></i> </span><span class="btn-text">Light Mode</span></button>
                                <button type="button" id="nav_dark_select" class="btn btn-outline-primary btn-sm btn-wth-icon icon-wthot-bg"><span class="icon-label"><i class="fa fa-moon-o"></i> </span><span class="btn-text">Dark Mode</span></button>
                            </div>
                            <hr>
                            <h6 class="mb-5">Top Nav</h6>
                            <p class="font-14">Choose your liked color mode</p>
                            <div class="button-list hk-navbar-select mb-10">
                                <button type="button" id="navtop_light_select" class="btn btn-outline-light btn-sm btn-wth-icon icon-wthot-bg"><span class="icon-label"><i class="fa fa-sun-o"></i> </span><span class="btn-text">Light Mode</span></button>
                                <button type="button" id="navtop_dark_select" class="btn btn-outline-primary btn-sm btn-wth-icon icon-wthot-bg"><span class="icon-label"><i class="fa fa-moon-o"></i> </span><span class="btn-text">Dark Mode</span></button>
                            </div>
                            <hr>
                            <div class="d-flex justify-content-between align-items-center">
                                <h6>Scrollable Header</h6>
                                <div class="toggle toggle-sm toggle-simple toggle-light toggle-bg-primary scroll-nav-switch"></div>
                            </div>
                            <hr>
                            <div class="d-flex justify-content-between align-items-center">
                                <h6>Sidebar Toggle</h6>
                                <div class="toggle-wrap">
                                    <div class="navbar_toggle_btn toggle toggle-simple toggle-light toggle-bg-primary sidebar_nav_status"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /Setting Panel -->

                <!-- page content -->
                <?php echo $content ?>

                <!-- footer content -->
                <?php $this->load->view('layout/footer'); ?>
                <!-- /footer content -->
            </div>
            <!-- /page content -->
            </div>
            <!-- /HK Wrapper -->

            <!-- Jasny-bootstrap  JavaScript -->
            <script src="<?php echo VENDOR_URL; ?>jasny-bootstrap/dist/js/jasny-bootstrap.min.js"></script>
            <!-- Slimscroll JavaScript -->
            <script src="<?php echo JS_URL; ?>backend/jquery.slimscroll.js"></script>

            <!-- Fancy Dropdown JS -->
            <script src="<?php echo JS_URL; ?>backend/dropdown-bootstrap-extended.js"></script>

            <!-- Toastr JS -->
            <script src="<?php echo VENDOR_URL; ?>toast/jquery.toast.min.js"></script>

            <!-- Toggles JavaScript -->
            <script src="<?php echo VENDOR_URL; ?>jquery-toggles/toggles.min.js"></script>
            <?php $this->load->view('layout/message'); ?>

            <!-- Init JavaScript -->
            <script src="<?php echo JS_URL; ?>backend/init.js"></script>
            <script src="<?php echo JS_URL; ?>backend/custom.js"></script>
            <script src="<?php echo JS_URL; ?>backend/validation.js"></script>
            <script>
                $(".navbar_toggle_btn").on("click", function() {
                    $.ajax({
                        url: "<?php echo site_url('dashboard/get_navbar_toggle'); ?>",
                    });
                })
                $('.sidebar_nav_status').toggles({
                    on: <?php echo $this->session->userdata('toggle_btn') == 1 ? 'true' : 'false'; ?>,
                    animate: 250,
                    easing: 'swing',
                });
                $("#nav_light_select").on("click", function() {
                    $.ajax({
                        type: "POST",
                        url: "<?php echo site_url('dashboard/get_top_navbar'); ?>",
                        data: {
                            status: 0
                        },
                    });
                })
                $("#nav_dark_select").on("click", function() {
                    $.ajax({
                        type: "POST",
                        url: "<?php echo site_url('dashboard/get_top_navbar'); ?>",
                        data: {
                            status: 1
                        },
                    });
                })
                $("#navtop_light_select").on("click", function() {
                    $.ajax({
                        type: "POST",
                        url: "<?php echo site_url('dashboard/get_sidebar_nav'); ?>",
                        data: {
                            status: 0
                        },
                    });
                })
                $("#navtop_dark_select").on("click", function() {
                    $.ajax({
                        type: "POST",
                        url: "<?php echo site_url('dashboard/get_sidebar_nav'); ?>",
                        data: {
                            status: 1
                        },
                    });
                })
            </script>
</body>

</html>