<!-- Container -->
<div class="container mt-xl-50 mt-sm-30 mt-15">
    <!-- Title -->
    <div class="hk-pg-header align-items-top">
        <div>
            <h2 class="hk-pg-title font-weight-600 mb-10"><?php echo $this->lang->line('dashboard'); ?></h2>
        </div>
        <div class="btn-group d-sm-block d-md-none" role="group" aria-label="First group">
            <?php if (has_permission(ADD, 'frontoffice', 'appointment')) { ?>
                <a href="<?php echo site_url('frontoffice/appointment'); ?>" class="btn btn-sm btn-primary">
                    <i class="fa fa-plus"></i>
                    <?php echo $this->lang->line('add'); ?> <?php echo $this->lang->line('appointment'); ?>
                </a>
            <?php } ?>

            <?php if (has_permission(ADD, 'billing', 'billing')) { ?>
                <a href="<?php echo site_url('billing'); ?>" class="btn btn-sm btn-success">
                    <i class="fa fa-plus"></i>
                    <?php echo $this->lang->line('create'); ?> <?php echo $this->lang->line('bill'); ?>
                </a>
            <?php } ?>
        </div>
    </div>
    <!-- /Title -->
    <!-- Row -->
    <div class="row">
        <div class="col-xl-12">
            <!-- Counter Start -->
            <div class="hk-row">
                <div class="col-lg-3 col-md-3 col-sm-6">
                    <div class="card card-sm">
                        <div class="card-body">
                            <div class="d-flex align-items-center justify-content-between">
                                <div>
                                    <span class="d-block font-12 font-weight-bold text-dark text-uppercase mb-5">
                                        <?php echo $this->lang->line('total'); ?> <?php echo $this->lang->line('opd'); ?> <?php echo $this->lang->line('bill'); ?>
                                    </span>
                                    <span class="d-block display-6 font-weight-400 text-dark">
                                        <?php echo $this->global_setting->currency_symbol; ?> <?php echo number_format($total_opd_bill, 0) ?? 0; ?>
                                    </span>
                                </div>
                                <div>
                                    <a href="<?php echo site_url('opd'); ?>" class="btn btn-primary btn-sm">
                                        <i class="fa fa-stethoscope" aria-hidden="true"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!--/ col-lg-3 col-md-3 col-sm-6 -->
                <div class="col-lg-3 col-md-3 col-sm-6">
                    <div class="card card-sm">
                        <div class="card-body">
                            <div class="d-flex align-items-center justify-content-between">
                                <div>
                                    <span class="d-block font-12 font-weight-bold text-dark text-uppercase mb-5">
                                        <?php echo $this->lang->line('total'); ?> <?php echo $this->lang->line('ipd'); ?> <?php echo $this->lang->line('bill'); ?>
                                    </span>
                                    <span class="d-block display-6 font-weight-400 text-dark">
                                        <?php echo $this->global_setting->currency_symbol; ?> <?php echo number_format($total_ipd_bill, 0) ?? 0; ?>
                                    </span>
                                </div>
                                <div>
                                    <a href="<?php echo site_url('ipd/billing'); ?>" class="btn btn-success btn-sm">
                                        <i class="fa fa-bed" aria-hidden="true"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!--/ col-lg-3 col-md-3 col-sm-6 -->
                <div class="col-lg-3 col-md-3 col-sm-6">
                    <div class="card card-sm">
                        <div class="card-body">
                            <div class="d-flex align-items-center justify-content-between">
                                <div>
                                    <span class="d-block font-12 font-weight-bold text-dark text-uppercase mb-5">
                                        <?php echo $this->lang->line('total'); ?> <?php echo $this->lang->line('pharmacy'); ?> <?php echo $this->lang->line('bill'); ?>
                                    </span>
                                    <span class="d-block display-6 font-weight-400 text-dark">
                                        <?php echo $this->global_setting->currency_symbol; ?> <?php echo number_format($total_pharmacy_bill, 0) ?? 0; ?>
                                    </span>
                                </div>
                                <div>
                                    <a href="<?php echo site_url('pharmacy/sale'); ?>" class="btn btn-info btn-sm">
                                        <i class="fa fa-medkit" aria-hidden="true"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!--/ col-lg-3 col-md-3 col-sm-6 -->
                <div class="col-lg-3 col-md-3 col-sm-6">
                    <div class="card card-sm">
                        <div class="card-body">
                            <div class="d-flex align-items-center justify-content-between">
                                <div>
                                    <span class="d-block font-12 font-weight-bold text-dark text-uppercase mb-5">
                                        <?php echo $this->lang->line('total'); ?> <?php echo $this->lang->line('investigation'); ?> <?php echo $this->lang->line('bill'); ?>
                                    </span>
                                    <span class="d-block display-6 font-weight-400 text-dark">
                                        <?php echo $this->global_setting->currency_symbol; ?> <?php echo number_format($total_investigation_bill, 0) ?? 0; ?>
                                    </span>
                                </div>
                                <div>
                                    <a href="<?php echo site_url('billing/bill'); ?>" class="btn btn-indigo btn-sm">
                                        <i class="fa fa-flask" aria-hidden="true"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!--/ col-lg-3 col-md-3 col-sm-6 -->
                <div class="col-lg-3 col-md-3 col-sm-6">
                    <div class="card card-sm">
                        <div class="card-body">
                            <div class="d-flex align-items-center justify-content-between">
                                <div>
                                    <span class="d-block font-12 font-weight-bold text-dark text-uppercase mb-5">
                                        <?php echo $this->lang->line('total'); ?> <?php echo $this->lang->line('blood_bank'); ?> <?php echo $this->lang->line('bill'); ?>
                                    </span>
                                    <span class="d-block display-6 font-weight-400 text-dark">
                                        <?php echo $this->global_setting->currency_symbol; ?> 0.00
                                    </span>
                                </div>
                                <div>
                                    <a href="#" class="btn btn-sky btn-sm">
                                        <i class="fa fa-tint" aria-hidden="true"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!--/ col-lg-3 col-md-3 col-sm-6 -->
                <div class="col-lg-3 col-md-3 col-sm-6">
                    <div class="card card-sm">
                        <div class="card-body">
                            <div class="d-flex align-items-center justify-content-between">
                                <div>
                                    <span class="d-block font-12 font-weight-bold text-dark text-uppercase mb-5">
                                        <?php echo $this->lang->line('total'); ?> <?php echo $this->lang->line('ambulance'); ?> <?php echo $this->lang->line('bill'); ?>
                                    </span>
                                    <span class="d-block display-6 font-weight-400 text-dark">
                                        <?php echo $this->global_setting->currency_symbol; ?> 0.00
                                    </span>
                                </div>
                                <div>
                                    <a href="#" class="btn btn-orange btn-sm">
                                        <i class="fa fa-ambulance" aria-hidden="true"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!--/ col-lg-3 col-md-3 col-sm-6 -->
                <div class="col-lg-3 col-md-3 col-sm-6">
                    <div class="card card-sm">
                        <div class="card-body">
                            <div class="d-flex align-items-center justify-content-between">
                                <div>
                                    <span class="d-block font-12 font-weight-bold text-dark text-uppercase mb-5">
                                        <?php echo $this->lang->line('total'); ?> <?php echo $this->lang->line('income'); ?>
                                    </span>
                                    <span class="d-block display-6 font-weight-400 text-dark">
                                        <?php echo $this->global_setting->currency_symbol; ?>
                                        <?php
                                        $totalIncome = ($total_income + $total_invoice + $total_ipd_invoice + $total_opd_patient + $total_medicine_invoice);
                                        $totalExpense = ($total_expense + $total_payment + $total_medicine_purchase);
                                        echo number_format(($totalIncome - $totalExpense), 0);
                                        ?>
                                    </span>
                                </div>
                                <div>
                                    <a href="<?php echo site_url('accounting/income'); ?>" class="btn btn-success btn-sm">
                                        <i class="fa fa-money" aria-hidden="true"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!--/ col-lg-3 col-md-3 col-sm-6 -->
                <div class="col-lg-3 col-md-3 col-sm-6">
                    <div class="card card-sm">
                        <div class="card-body">
                            <div class="d-flex align-items-center justify-content-between">
                                <div>
                                    <span class="d-block font-12 font-weight-bold text-dark text-uppercase mb-5">
                                        <?php echo $this->lang->line('total'); ?> <?php echo $this->lang->line('expense'); ?>
                                    </span>
                                    <span class="d-block display-6 font-weight-400 text-dark">
                                        <?php echo $this->global_setting->currency_symbol; ?>
                                        <?php
                                        $totalExpense = ($total_expense + $total_payment + $total_medicine_purchase);
                                        echo number_format($totalExpense, 0);
                                        ?>
                                    </span>
                                </div>
                                <div>
                                    <a href="<?php echo site_url('accounting/expenditure'); ?>" class="btn btn-danger btn-sm">
                                        <i class="fa fa-money" aria-hidden="true"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!--/ col-lg-3 col-md-3 col-sm-6 -->
            </div>
            <!-- Counter End -->

            <div class="hk-row">
                <div class="col-lg-8">
                    <div class="card">
                        <div class="card-header">
                            <h6>Yearly Income & Expense</h6>
                        </div>
                        <div class="card-body">
                            <div id="running_year_ie" class="echart" style="height:190px;"></div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="card">
                        <div class="card-header">
                            <h6><?php echo date('F, Y'); ?></h6>
                        </div>
                        <div class="card-body">
                            <div class="hk-legend-wrap mb-20">
                                <div class="hk-legend">
                                    <span class="d-10 bg-primary rounded-circle d-inline-block"></span><span><?php echo $this->lang->line('income'); ?></span>
                                </div>
                                <div class="hk-legend">
                                    <span class="d-10 bg-danger rounded-circle d-inline-block"></span><span><?php echo $this->lang->line('expense'); ?></span>
                                </div>
                            </div>
                            <div id="running_month_ie" class="echart" style="height:150px;"></div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Patient & Role Start -->
            <div class="hk-row">
                <?php if (isset($patients) && !empty($patients)) { ?>
                    <div class="col-lg-9">
                        <div class="card">
                            <div class="card-header">
                                <h6>
                                    <i class="fa fa-user"></i>
                                    <?php echo $this->lang->line('patient'); ?> <?php echo $this->lang->line('list'); ?>
                                </h6>
                            </div>
                            <div class="card-body pa-0">
                                <div class="table-wrap">
                                    <div class="table-responsive">
                                        <table class="table table-sm table-hover mb-0">
                                            <thead>
                                                <tr>
                                                    <th><?php echo $this->lang->line('patient_id'); ?></th>
                                                    <th><?php echo $this->lang->line('name'); ?></th>
                                                    <th><?php echo $this->lang->line('age'); ?></th>
                                                    <th><?php echo $this->lang->line('gender'); ?></th>
                                                    <th><?php echo $this->lang->line('phone'); ?></th>
                                                    <th><?php echo $this->lang->line('created'); ?></th>
                                                    <th><?php echo $this->lang->line('action'); ?></th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php foreach ($patients as $obj) { ?>
                                                    <tr>
                                                        <td><?php echo $obj->patient_unique_id; ?></td>
                                                        <td><?php echo $obj->name; ?></td>
                                                        <td><?php echo floor((time() - strtotime($obj->dob)) / 31556926); ?></td>
                                                        <td><?php echo $this->lang->line($obj->gender); ?></td>
                                                        <td><?php echo $obj->phone; ?></td>
                                                        <td><?php echo date($this->global_setting->date_format, strtotime($obj->created_at)); ?></td>
                                                        <td>
                                                            <a href="#" class="btn btn-primary btn-sm">
                                                                <i class="fa fa-eye" aria-hidden="true"></i>
                                                            </a>
                                                        </td>
                                                    </tr>
                                                <?php } ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- /col-lg-9 -->
                <?php } ?>
                <div class="col-lg-3">
                    <!-- /info-box -->
                    <div class="info-box">
                        <a href="#">
                            <span class="info-box-icon bg-primary"><i class="fa fa-user text-white"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text"><?php echo $this->lang->line('admin'); ?></span>
                                <span class="info-box-number"><?php echo $total_admin ? $total_admin : 0; ?></span>
                            </div>
                        </a>
                    </div>
                    <!-- /info-box -->
                    <div class="info-box">
                        <a href="#">
                            <span class="info-box-icon bg-success"><i class="fa fa-user-md text-white"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text"><?php echo $this->lang->line('doctor'); ?></span>
                                <span class="info-box-number"><?php echo $total_doctor ? $total_doctor : 0; ?></span>
                            </div>
                        </a>
                    </div>
                    <!-- /info-box -->
                    <div class="info-box">
                        <a href="#">
                            <span class="info-box-icon bg-teal"><i class="fa fa-user-o text-white"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text"><?php echo $this->lang->line('patient'); ?></span>
                                <span class="info-box-number"><?php echo $total_patient ? $total_patient : 0; ?></span>
                            </div>
                        </a>
                    </div>
                    <!-- /info-box -->
                    <div class="info-box">
                        <a href="#">
                            <span class="info-box-icon bg-lime"><i class="fa fa-user text-white"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text"><?php echo $this->lang->line('accountant'); ?></span>
                                <span class="info-box-number"><?php echo $total_accountant ? $total_accountant : 0; ?></span>
                            </div>
                        </a>
                    </div>
                    <!-- /info-box -->
                    <div class="info-box">
                        <a href="#">
                            <span class="info-box-icon bg-orange"><i class="fa fa-user text-white"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text"><?php echo $this->lang->line('pathologist'); ?></span>
                                <span class="info-box-number"><?php echo $total_pathologist ? $total_pathologist : 0; ?></span>
                            </div>
                        </a>
                    </div>
                    <!-- /info-box -->
                    <div class="info-box">
                        <a href="#">
                            <span class="info-box-icon bg-violet"><i class="fa fa-user text-white"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text"><?php echo $this->lang->line('radiologist'); ?></span>
                                <span class="info-box-number"><?php echo $total_radiologist ? $total_radiologist : 0; ?></span>
                            </div>
                        </a>
                    </div>
                    <!-- /info-box -->
                    <div class="info-box">
                        <a href="#">
                            <span class="info-box-icon bg-indigo"><i class="fa fa-female text-white"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text"><?php echo $this->lang->line('nurse'); ?></span>
                                <span class="info-box-number"><?php echo $total_nurse ? $total_nurse : 0; ?></span>
                            </div>
                        </a>
                    </div>
                    <!-- /info-box -->
                    <div class="info-box">
                        <a href="#">
                            <span class="info-box-icon bg-blue"><i class="fa fa-user text-white"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text"><?php echo $this->lang->line('receptionist'); ?></span>
                                <span class="info-box-number"><?php echo $total_receptionist ? $total_receptionist : 0; ?></span>
                            </div>
                        </a>
                    </div>
                    <!-- /info-box -->
                </div>
                <!-- /col-lg-6 -->
            </div>
            <!-- Notice & Events end -->

            <!-- Notice & Events Start -->
            <div class="hk-row">
                <?php if (isset($notices) && !empty($notices)) { ?>
                    <div class="col-lg-6">
                        <div class="card">
                            <div class="card-header">
                                <i class="fa fa-bell"></i>
                                <?php echo $this->lang->line('notice'); ?>
                            </div>
                            <div class="card-body pa-0">
                                <div class="table-wrap">
                                    <div class="table-responsive">
                                        <table class="table table-sm table-hover mb-0">
                                            <tbody>
                                                <?php foreach ($notices as $obj) { ?>
                                                    <tr>
                                                        <td><?php echo word_limiter($obj->title, 5); ?></td>
                                                        <td><span class="badge badge-<?php echo get_badge_color($obj->role_id); ?>"><?php echo $obj->role; ?></span></td>
                                                        <td><?php echo date('M d, Y', strtotime($obj->date)); ?></td>
                                                        <td>
                                                            <button type="button" onclick="get_notice_modal(<?php echo $obj->id; ?>);" data-toggle="modal" data-target=".viewModalCenter" class="btn btn-primary btn-xs">
                                                                <i class="fa fa-eye"></i>
                                                            </button>
                                                        </td>
                                                    </tr>
                                                <?php } ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php } ?>
                <!-- /col-lg-6 -->
                <?php if (isset($events) && !empty($events)) { ?>
                    <div class="col-lg-6">
                        <div class="card">
                            <div class="card-header">
                                <i class="fa fa-calendar-check-o" aria-hidden="true"></i>
                                <?php echo $this->lang->line('event'); ?>
                            </div>
                            <div class="card-body pa-0">
                                <div class="table-wrap">
                                    <div class="table-responsive">
                                        <table class="table table-sm table-hover mb-0">
                                            <tbody>
                                                <?php foreach ($events as $obj) { ?>
                                                    <tr>
                                                        <td><?php echo word_limiter($obj->title, 5); ?></td>
                                                        <td><span class="badge badge-<?php echo get_badge_color($obj->role_id); ?>"><?php echo $obj->role; ?></span></td>
                                                        <td><?php echo date('M d, Y', strtotime($obj->event_from)); ?></td>
                                                        <td>
                                                            <button type="button" onclick="get_event_modal(<?php echo $obj->id; ?>);" data-toggle="modal" data-target=".viewModalCenter" class="btn btn-primary btn-xs">
                                                                <i class="fa fa-eye"></i>
                                                            </button>
                                                        </td>
                                                    </tr>
                                                <?php } ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php } ?>
                <!-- /col-lg-6 -->
            </div>
            <!-- Notice & Events end -->
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->

<!-- EChartJS JavaScript -->
<script src="<?php echo VENDOR_URL; ?>echarts/dist/echarts-en.min.js"></script>

<script>
    if ($('#running_month_ie').length > 0) {
        var running_month_ie = echarts.init(document.getElementById('running_month_ie'));
        var option = {
            tooltip: {
                show: true,
                backgroundColor: '#fff',
                borderRadius: 6,
                padding: 6,
                axisPointer: {
                    lineStyle: {
                        width: 0,
                    }
                },
                textStyle: {
                    color: '#324148',
                    fontFamily: '"Nunito", sans-serif',
                    fontSize: 12
                }
            },
            series: [{
                name: '',
                type: 'pie',
                radius: '60%',
                center: ['50%', '50%'],
                roseType: 'radius',
                color: ['#ab26aa', '#FF2F26'],
                data: [{
                        value: <?php echo ($get_total_monthly_income + $get_total_monthly_invoice + $get_total_monthly_ipd_invoice + $get_total_monthly_opd_patient + $get_total_monthly_medicine_invoice); ?>,
                        name: ''
                    },
                    {
                        value: <?php echo ($get_total_monthly_expenditure + $get_total_monthly_payment + $get_total_monthly_medicine_purchase); ?>,
                        name: ''
                    }
                ],
                label: {
                    normal: {
                        formatter: '{b}\n{d}%'
                    },

                }
            }]
        };
        running_month_ie.setOption(option);
        running_month_ie.resize();
    }

    // Running Yearly Income & Expense chart
    if ($('#running_year_ie').length > 0) {
        var running_year_ie = echarts.init(document.getElementById('running_year_ie'));
        var option = {
            color: ['#BC29BB', '#FF3329'],
            tooltip: {
                show: true,
                trigger: 'axis',
                backgroundColor: '#fff',
                borderRadius: 6,
                padding: 6,
                axisPointer: {
                    lineStyle: {
                        width: 0,
                    }
                },
                textStyle: {
                    color: '#324148',
                    fontFamily: '"Nunito", sans-serif',
                    fontSize: 12
                }
            },

            grid: {
                top: '3%',
                left: '3%',
                right: '3%',
                bottom: '3%',
                containLabel: true
            },
            xAxis: [{
                type: 'category',
                data: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sept', 'Oct', 'Nov', 'Dec'],
                axisLine: {
                    show: false
                },
                axisTick: {
                    show: false
                },
                axisLabel: {
                    textStyle: {
                        color: '#5e7d8a'
                    }
                }
            }],
            yAxis: [{
                type: 'value',
                axisLine: {
                    show: false
                },
                axisTick: {
                    show: false
                },
                axisLabel: {
                    textStyle: {
                        color: '#BC29BB'
                    }
                },
                splitLine: {
                    lineStyle: {
                        color: '#5e7d8a',
                    }
                }
            }],
            series: [{
                    name: '<?php echo $this->lang->line('income'); ?>',
                    type: 'bar',
                    barMaxWidth: 30,
                    data: [
                        <?php echo ($jan_total_monthly_income + $jan_total_monthly_invoice + $jan_total_monthly_ipd_invoice + $jan_total_monthly_opd_patient + $jan_total_monthly_medicine_invoice); ?>,
                        <?php echo ($feb_total_monthly_income + $feb_total_monthly_invoice + $feb_total_monthly_ipd_invoice + $feb_total_monthly_opd_patient + $feb_total_monthly_medicine_invoice); ?>,
                        <?php echo ($mar_total_monthly_income + $mar_total_monthly_invoice + $mar_total_monthly_ipd_invoice + $mar_total_monthly_opd_patient + $mar_total_monthly_medicine_invoice); ?>,
                        <?php echo ($apr_total_monthly_income + $apr_total_monthly_invoice + $apr_total_monthly_ipd_invoice + $apr_total_monthly_opd_patient + $apr_total_monthly_medicine_invoice); ?>,
                        <?php echo ($may_total_monthly_income + $may_total_monthly_invoice + $may_total_monthly_ipd_invoice + $may_total_monthly_opd_patient + $may_total_monthly_medicine_invoice); ?>,
                        <?php echo ($jun_total_monthly_income + $jun_total_monthly_invoice + $jun_total_monthly_ipd_invoice + $jun_total_monthly_opd_patient + $jun_total_monthly_medicine_invoice); ?>,
                        <?php echo ($jul_total_monthly_income + $jul_total_monthly_invoice + $jul_total_monthly_ipd_invoice + $jul_total_monthly_opd_patient + $jul_total_monthly_medicine_invoice); ?>,
                        <?php echo ($aug_total_monthly_income + $aug_total_monthly_invoice + $aug_total_monthly_ipd_invoice + $aug_total_monthly_opd_patient + $aug_total_monthly_medicine_invoice); ?>,
                        <?php echo ($sept_total_monthly_income + $sept_total_monthly_invoice + $sept_total_monthly_ipd_invoice + $sept_total_monthly_opd_patient + $sept_total_monthly_medicine_invoice); ?>,
                        <?php echo ($oct_total_monthly_income + $oct_total_monthly_invoice + $oct_total_monthly_ipd_invoice + $oct_total_monthly_opd_patient + $oct_total_monthly_medicine_invoice); ?>,
                        <?php echo ($nov_total_monthly_income + $nov_total_monthly_invoice + $nov_total_monthly_ipd_invoice + $nov_total_monthly_opd_patient + $nov_total_monthly_medicine_invoice); ?>,
                        <?php echo ($dec_total_monthly_income + $dec_total_monthly_invoice + $dec_total_monthly_ipd_invoice + $dec_total_monthly_opd_patient + $dec_total_monthly_medicine_invoice); ?>
                    ],
                    itemStyle: {
                        normal: {
                            barBorderRadius: [6, 6, 0, 0],
                        }
                    },
                },
                {
                    name: '<?php echo $this->lang->line('expense'); ?>',
                    type: 'bar',
                    barMaxWidth: 30,
                    data: [
                        <?php echo ($jan_total_monthly_expenditure + $jan_total_monthly_payment + $jan_total_monthly_medicine_purchase); ?>,
                        <?php echo ($feb_total_monthly_expenditure + $feb_total_monthly_payment + $feb_total_monthly_medicine_purchase); ?>,
                        <?php echo ($mar_total_monthly_expenditure + $mar_total_monthly_payment + $mar_total_monthly_medicine_purchase); ?>,
                        <?php echo ($apr_total_monthly_expenditure + $apr_total_monthly_payment + $apr_total_monthly_medicine_purchase); ?>,
                        <?php echo ($may_total_monthly_expenditure + $may_total_monthly_payment + $may_total_monthly_medicine_purchase); ?>,
                        <?php echo ($jun_total_monthly_expenditure + $jun_total_monthly_payment + $jun_total_monthly_medicine_purchase); ?>,
                        <?php echo ($jul_total_monthly_expenditure + $jul_total_monthly_payment + $jul_total_monthly_medicine_purchase); ?>,
                        <?php echo ($aug_total_monthly_expenditure + $aug_total_monthly_payment + $aug_total_monthly_medicine_purchase); ?>,
                        <?php echo ($sept_total_monthly_expenditure + $sept_total_monthly_payment + $sept_total_monthly_medicine_purchase); ?>,
                        <?php echo ($oct_total_monthly_expenditure + $oct_total_monthly_payment + $oct_total_monthly_medicine_purchase); ?>,
                        <?php echo ($nov_total_monthly_expenditure + $nov_total_monthly_payment + $nov_total_monthly_medicine_purchase); ?>,
                        <?php echo ($dec_total_monthly_expenditure + $dec_total_monthly_payment + $dec_total_monthly_medicine_purchase); ?>
                    ],
                    itemStyle: {
                        normal: {
                            barBorderRadius: [6, 6, 0, 0],
                        }
                    },
                }
            ]
        };

        running_year_ie.setOption(option);
        running_year_ie.resize();
    }
</script>

<div class="modal fade viewModalCenter" tabindex="-1" role="dialog" aria-labelledby="viewModalCenter" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header bg-gradient-primary">
                <h5 class="modal-title text-white"><?php echo $this->lang->line('info'); ?></h5>
                <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body modal_data bg-gradient-secondary"></div>
        </div>
    </div>
</div>

<script type="text/javascript">
    function get_notice_modal(id) {
        $('.modal_data').html('<p style="padding: 20px;"><p style="padding: 20px;text-align:center;"><img src="<?php echo IMG_URL; ?>loader.gif" /></p>');
        $.ajax({
            type: "POST",
            url: "<?php echo site_url('announcement/notice/get_single_notice'); ?>",
            data: {
                id: id
            },
            success: function(response) {
                if (response) {
                    $('.modal_data').html(response);
                }
            }
        });
    }
</script>

<script type="text/javascript">
    function get_event_modal(id) {
        $('.modal_data').html('<p style="padding: 20px;"><p style="padding: 20px;text-align:center;"><img src="<?php echo IMG_URL; ?>loader.gif" /></p>');
        $.ajax({
            type: "POST",
            url: "<?php echo site_url('announcement/event/get_single_event'); ?>",
            data: {
                id: id
            },
            success: function(response) {
                if (response) {
                    $('.modal_data').html(response);
                }
            }
        });
    }
</script>