<?php

if (!defined('BASEPATH')) exit('No direct script access allowed');

class Web_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }

    public function get_main_menu_list() {
        $this->db->select('MI.*');
        $this->db->from('menu_items AS MI');
        $this->db->join('menus AS M', 'M.id = MI.menu_id', 'left');
        $this->db->where('M.location', 'main_menu');
        $this->db->where('MI.status', '1');
        $this->db->order_by('MI.sort_by', 'ASC');
        return $this->db->get()->result();
    }

    public function get_sub_menu_list($parent_id) {
        $this->db->select('MI.*');
        $this->db->from('menu_items AS MI');
        $this->db->where('MI.parent_id', $parent_id);
        $this->db->order_by('MI.parent_id', 'ASC');
        $this->db->order_by('MI.sort_by', 'ASC');
        $this->db->where('MI.status', '1');
        return $this->db->get()->result();
    }

    public function get_footer_menu_list() {
        $this->db->select('MI.*, M.location');
        $this->db->from('menu_items AS MI');
        $this->db->join('menus AS M', 'M.id = MI.menu_id', 'left');
        $this->db->where('M.location !=', 'main_menu');
        $this->db->where('MI.status', '1');
        $this->db->order_by('MI.sort_by', 'ASC');
        return $this->db->get()->result();
    }

    public function get_page_list($id) {
        $this->db->select('MI.*, P.*');
        $this->db->from('menu_items AS MI');
        $this->db->join('pages AS P', 'P.id = MI.page_id', 'left');
        $this->db->where('MI.id', $id);
        return $this->db->get()->row();
    }

    public function get_department_doctor_list($id) {
        $this->db->select('E.*, DE.name as designation, DE.bn_name as bn_designation');
        $this->db->from('employees AS E');
        $this->db->join('departments AS D', 'D.id = E.department_id', 'left');
        $this->db->join('designations AS DE', 'DE.id = E.designation_id', 'left');
        $this->db->join('users AS U', 'U.id = E.user_id', 'left');
        $this->db->where('U.role_id', DOCTOR);
        $this->db->where('D.id', $id);
        $this->db->where('E.status', '1');
        $this->db->where('E.is_view_on_web', '1');
        $this->db->order_by('E.sort_by', 'ASC');
        return $this->db->get()->result();
    }

    public function get_doctor_list() {
        $this->db->select('E.*');
        $this->db->from('employees AS E');
        $this->db->join('users AS U', 'U.id = E.user_id', 'left');
        $this->db->where('U.role_id', DOCTOR);
        $this->db->where('E.status', '1');
        $this->db->where('E.is_view_on_web', '1');
        $this->db->order_by('E.sort_by', 'ASC');
        return $this->db->get()->result();
    }

    public function get_single_appointment($id) {
        $this->db->select('A.*, P.patient_unique_id, D.name as doctor, D.specialist');
        $this->db->from('appointments AS A');
        $this->db->join('patients AS P', 'P.user_id = A.patient_id', 'left');
        $this->db->join('employees AS D', 'D.user_id = A.doctor_id', 'left');
        $this->db->where('A.id', $id);
        return $this->db->get()->row();
    }

    public function get_doctor_search($department_id, $keyword) {
        $this->db->select('E.*, DE.name as designation, DE.bn_name as bn_designation');
        $this->db->from('employees AS E');
        $this->db->join('departments AS D', 'D.id = E.department_id', 'left');
        $this->db->join('designations AS DE', 'DE.id = E.designation_id', 'left');
        $this->db->join('users AS U', 'U.id = E.user_id', 'left');
        if ($department_id) {
            $this->db->where('E.department_id', $department_id);
        }
        if ($keyword) {
            $this->db->group_start();
            $this->db->like('E.name', $keyword, 'both');
            $this->db->or_like('E.bn_name', $keyword, 'both');
            $this->db->or_like('E.phone', $keyword, 'both');
            $this->db->or_like('E.phone', $keyword, 'both');
            $this->db->or_like('E.specialist', $keyword, 'both');
            $this->db->group_end();
        }
        $this->db->where('U.role_id', DOCTOR);
        $this->db->where('E.status', '1');
        $this->db->where('E.is_view_on_web', '1');
        $this->db->order_by('E.sort_by', 'ASC');
        return $this->db->get()->result();
    }

    public function get_single_doctor($id) {
        $this->db->select('E.*, D.name as department, D.bn_name as bn_department, DE.name as designation, DE.bn_name as bn_designation');
        $this->db->from('employees AS E');
        $this->db->join('departments AS D', 'D.id = E.department_id', 'left');
        $this->db->join('designations AS DE', 'DE.id = E.designation_id', 'left');
        $this->db->where('E.id', $id);
        $this->db->where('E.status', '1');
        $this->db->where('E.is_view_on_web', '1');
        $this->db->order_by('E.sort_by', 'ASC');
        return $this->db->get()->row();
    }

    public function get_single_social_info($id) {
        $this->db->select('S.*');
        $this->db->from('employee_socials AS S');
        $this->db->join('employees AS E', 'E.user_id = S.user_id', 'left');
        $this->db->where('E.id', $id);
        $this->db->where('S.status', '1');
        $this->db->where('S.is_view_on_web', '1');
        $this->db->order_by('S.sort_by', 'ASC');
        return $this->db->get()->row();
    }

    public function get_photo_gallery_list() {
        $this->db->select('G.*');
        $this->db->from('photos AS P');
        $this->db->join('galleries AS G', 'G.id = P.gallery_id', 'left');
        $this->db->where('P.status', '1');
        $this->db->where('P.is_view_on_web', '1');
        $this->db->group_by('G.id');
        $this->db->order_by('G.sort_by', 'ASC');
        return $this->db->get()->result();
    }

    public function get_single_photo_gallery_list($id) {
        $this->db->select('P.*');
        $this->db->from('photos AS P');
        $this->db->join('galleries AS G', 'G.id = P.gallery_id', 'left');
        $this->db->where('P.gallery_id', $id);
        $this->db->where('P.status', '1');
        $this->db->where('P.is_view_on_web', '1');
        $this->db->order_by('P.sort_by', 'ASC');
        return $this->db->get()->result();
    }

    public function get_video_gallery_list() {
        $this->db->select('G.*');
        $this->db->from('videos AS V');
        $this->db->join('galleries AS G', 'G.id = V.gallery_id', 'left');
        $this->db->where('V.status', '1');
        $this->db->where('V.is_view_on_web', '1');
        $this->db->group_by('G.id');
        $this->db->order_by('G.sort_by', 'ASC');
        return $this->db->get()->result();
    }

    public function get_single_video_gallery_list($id) {
        $this->db->select('V.*');
        $this->db->from('videos AS V');
        $this->db->join('galleries AS G', 'G.id = V.gallery_id', 'left');
        $this->db->where('V.gallery_id', $id);
        $this->db->where('V.status', '1');
        $this->db->where('V.is_view_on_web', '1');
        $this->db->order_by('V.sort_by', 'ASC');
        return $this->db->get()->result();
    }

    public function get_news_list($limit, $offset, $count) {
        $this->db->select('N.*');
        $this->db->from('news AS N');
        $this->db->where('N.is_view_on_web', 1);
        $this->db->where('N.status', 1);
        $this->db->order_by('N.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }
    
    
    public function get_mbbs_doctor_list($department_id) {
        $this->db->select('E.*, U.role_id');
        $this->db->from('employees AS E');
        $this->db->join('departments AS D', 'D.id = E.department_id', 'left');
        $this->db->join('users AS U', 'U.id = E.user_id', 'left');
        $this->db->join('roles AS R', 'R.id = U.role_id', 'left');
        if ($department_id) {
            $this->db->where('E.department_id', $department_id);
        }
        $this->db->where('U.role_id', DOCTOR);
        $this->db->where('E.commission_type', 'mbbs');
        $this->db->where('E.department_id >', 0);
        $this->db->where('E.is_view_on_web', '1');
        $this->db->where('E.status', '1');
        $this->db->order_by('E.sort_by', 'ASC');
        return $this->db->get()->result();
    }
}
