<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('notification'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title"><span class="pg-title-icon"><span class="feather-icon"><i data-feather="toggle-right"></i></span></span><?php echo $this->lang->line('manage_notification'); ?></h4>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <?php $this->load->view('setting/left-side'); ?>
        <!-- col-xl-8 -->
        <div class="col-lg-9">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(EDIT, 'setting', 'notification')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-user font-30 mr-10"></i>
                            <?php echo $this->lang->line('edit'); ?> <?php echo $this->lang->line('notification'); ?>
                        </h6>
                    <?php } ?>
                    <?php if (has_permission(VIEW, 'setting', 'notification')) { ?>
                        <div class="align-items-center">
                            <a href="<?php echo site_url('setting/notification'); ?>" class="btn btn-xs btn-primary">
                                <i class="fa fa-list"></i>
                                <?php echo $this->lang->line('notification'); ?> <?php echo $this->lang->line('list'); ?>
                            </a>
                        </div>
                    <?php } ?>
                </div>
                <?php echo form_open_multipart(site_url('setting/notification/edit/' . $notification->id), array('name' => 'edit', 'id' => 'edit', 'class' => 'needs-validation', 'novalidate' => 'novalidate'), ''); ?>
                <div class="card-body">
                    <div class="form-row">
                        <div class="col-md-6 mb-10">
                            <label for="type"><?php echo $this->lang->line('notification'); ?> <?php echo $this->lang->line('type'); ?></label>
                            <input type="text" class="form-control" name="type" id="type" value="<?php echo isset($notification->type) ?  $notification->type : ''; ?>" placeholder="<?php echo $this->lang->line('notification'); ?> <?php echo $this->lang->line('type'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="name" class="form-text text-muted">
                                <?php echo form_error('type'); ?>
                            </small>
                        </div>
                        <div class="col-md-3 mb-10">
                            <div class="custom-control custom-checkbox checkbox-primary mt-40 ml-20">
                                <input type="checkbox" class="custom-control-input" name="is_email" id="is_email" value="1" <?php echo $notification->is_email ? 'checked' : ''; ?>>
                                <label class="custom-control-label" for="is_email"><?php echo $this->lang->line('notification'); ?> <?php echo $this->lang->line('email'); ?></label>
                            </div>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo form_error('is_email'); ?>
                            </div>
                        </div>
                        <div class="col-md-3 mb-10">
                            <div class="custom-control custom-checkbox checkbox-info mt-40 ml-20">
                                <input type="checkbox" class="custom-control-input" name="is_sms" id="is_sms" value="1" <?php echo $notification->is_sms ? 'checked' : ''; ?>>
                                <label class="custom-control-label" for="is_sms"><?php echo $this->lang->line('notification'); ?> <?php echo $this->lang->line('sms'); ?></label>
                            </div>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo form_error('is_sms'); ?>
                            </div>
                        </div>
                        <div class="col-md-12 mb-10">
                            <label for="message"><?php echo $this->lang->line('message'); ?></label>
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><?php echo $this->lang->line('message'); ?></span>
                                </div>
                                <textarea class="form-control" name="message" id="message" aria-label="<?php echo $this->lang->line('message'); ?>"><?php echo isset($notification->message) ?  $notification->message : ''; ?></textarea>
                            </div>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo form_error('message'); ?>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Card Footer -->
                <div class="card-footer pt-0">
                    <div class="button-list">
                        <input type="hidden" name="id" value="<?php echo $notification->id; ?>">
                        <a class="btn btn-gradient-danger" href="<?php echo site_url('setting/notification'); ?>"><?php echo $this->lang->line('cancel'); ?></a>
                        <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('update'); ?></button>
                    </div>
                </div>
                <?php echo form_close(); ?>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->