<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('module'); ?> <?php echo $this->lang->line('setting'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('manage_module'); ?>
        </h4>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <?php $this->load->view('setting/left-side'); ?>
        <!-- col-xl-8 -->
        <div class="col-lg-9">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(VIEW, 'setting', 'module')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-modx font-30 mr-10"></i>
                            <?php echo $this->lang->line('module'); ?> <?php echo $this->lang->line('list'); ?>
                        </h6>
                    <?php  } ?>

                    <?php echo form_open_multipart(site_url('setting/module'), array('name' => 'search', 'id' => 'search', 'class' => 'needs-validation', 'novalidate' => 'novalidate', 'method' => 'get'), ''); ?>
                    <div class="form-group">
                        <div class="input-group input-group-sm">
                            <input type="text" class="form-control" name="search" id="search" value="<?php echo isset($search) ?  $search : ''; ?>" placeholder="<?php echo $this->lang->line('search'); ?>" required>
                            <div class="input-group-append">
                                <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('search'); ?></button>
                            </div>
                        </div>
                    </div>
                    <?php echo form_close(); ?>

                    <?php if (has_permission(ADD, 'setting', 'module')) { ?>
                        <div class="align-items-center">
                            <a href="<?php echo site_url('setting/module/add'); ?>" class="btn btn-xs btn-primary">
                                <i class="fa fa-plus"></i>
                                <?php echo $this->lang->line('add'); ?> <?php echo $this->lang->line('module'); ?>
                            </a>
                        </div>
                    <?php  } ?>
                </div>
                <div class="card-body">
                    <div class="table-wrap">
                        <div class="table-responsive">
                            <table class="table table-sm mb-0">
                                <thead>
                                    <tr>
                                        <th><?php echo $this->lang->line('sl_no'); ?></th>
                                        <th><?php echo $this->lang->line('module'); ?> <?php echo $this->lang->line('name'); ?></th>
                                        <th><?php echo $this->lang->line('module'); ?> <?php echo $this->lang->line('slug'); ?></th>
                                        <th><?php echo $this->lang->line('status'); ?></th>
                                        <th><?php echo $this->lang->line('action'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if (isset($modules) && !empty($modules)) { ?>
                                        <?php foreach ($modules as $obj) { ?>
                                            <tr>
                                                <td><?php echo $sl_count; ?></td>
                                                <td><?php echo $obj->module_name; ?></td>
                                                <td><?php echo $obj->module_slug; ?></td>
                                                <td>
                                                    <div class="toggle-wrap">
                                                        <div data-toggle-on="<?php echo $obj->status ? 'true' : 'false'; ?>" id="<?php echo $obj->id; ?>" status="<?php echo $obj->status ? '0' : '1'; ?>" class="toggle toggle-light toggle-bg-primary _status status_update"></div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <?php if (has_permission(EDIT, 'setting', 'module')) { ?>
                                                        <a href="<?php echo site_url('setting/module/edit/' . $obj->id); ?>" class="mr-25"> <i class="fa fa-pencil"></i> </a>
                                                    <?php } ?>
                                                    <?php if (has_permission(DELETE, 'setting', 'module')) { ?>
                                                        <a href="<?php echo site_url('setting/module/delete/' . $obj->id); ?>" onclick="javascript: return confirm('<?php echo $this->lang->line('confirm_alert'); ?>');"> <i class="fa fa-trash text-danger"></i> </a>
                                                    <?php } ?>
                                                </td>
                                            </tr>
                                            <?php $sl_count++; ?>
                                        <?php } ?>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <!-- Card Footer -->
                <?php if ($this->pagination->create_links()) { ?>
                    <div class="card-footer justify-content-end">
                        <?php echo $this->pagination->create_links(); ?>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->


<!-- Toggles CSS -->
<link href="<?php echo VENDOR_URL;  ?>jquery-toggles/css/toggles.css" rel="stylesheet" type="text/css">
<link href="<?php echo VENDOR_URL;  ?>jquery-toggles/css/themes/toggles-light.css" rel="stylesheet" type="text/css">
<!-- Toggles JavaScript -->
<script src="<?php echo VENDOR_URL; ?>jquery-toggles/toggles.min.js"></script>
<script>
    $('._status').toggles({
        drag: true, // allow dragging the toggle between positions
        click: true, // allow clicking on the toggle
        text: {
            on: '<?php echo $this->lang->line('on'); ?>', // text for the ON position
            off: '<?php echo $this->lang->line('off'); ?>' // and off
        },
        on: true, // is the toggle ON on init
        animate: 250, // animation time (ms)
        easing: 'swing', // animation transition easing function
        checkbox: null, // the checkbox to toggle (for use in forms)
        clicker: null, // element that can be clicked on to toggle. removes binding from the toggle itself (use nesting)

        type: 'compact' // if this is set to 'select' then the select style toggle will be used
    });
</script>

<script>
    $('.status_update').click(function() {
        var id = $(this).attr('id');
        var status = $(this).attr('status');
        $.ajax({
            type: "POST",
            url: "<?php echo site_url('ajax/update_module_status'); ?>",
            data: {
                id: id,
                status: status
            },
            async: false,
            success: function(response) {
                if (response) {
                    $.toast({
                        heading: 'Success !',
                        text: '<p><?php echo $this->lang->line('update_success'); ?></p>',
                        position: 'top-right',
                        loaderBg: '#7a5449',
                        class: 'jq-toast-primary',
                        hideAfter: 3500,
                        stack: 6,
                        showHideTransition: 'fade'
                    });
                    location.reload();
                }
            }
        });
    });
</script>