<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('email'); ?> <?php echo $this->lang->line('setting'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('email'); ?> <?php echo $this->lang->line('setting'); ?>
        </h4>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <?php $this->load->view('setting/left-side'); ?>
        <!-- col-xl-8 -->
        <div class="col-lg-9">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <h6 class="card-header d-flex align-items-center">
                        <i class="fa fa-envelope font-30 mr-10"></i>
                        <?php echo $this->lang->line('email'); ?> <?php echo $this->lang->line('setting'); ?>
                    </h6>
                    <div class="align-items-center">
                        <a href="<?php echo site_url('dashboard'); ?>" class="btn btn-xs btn-primary">
                            <i class="fa fa-dashboard"></i>
                            <?php echo $this->lang->line('dashboard'); ?>
                        </a>
                    </div>
                </div>
                <?php $action = isset($email_setting) ? 'edit' : 'add'; ?>
                <?php echo form_open_multipart(site_url('setting/emailsetting/' . $action), array('name' => 'emailsetting', 'id' => 'emailsetting', 'class' => 'needs-validation', 'novalidate' => 'novalidate'), ''); ?>
                <input type="hidden" value="<?php echo isset($email_setting) ? $email_setting->id : ''; ?>" name="id" />
                <div class="card-body">
                    <div class="form-row">
                        <div class="col-md-4 mb-10">
                            <label for="mail_protocol"><?php echo $this->lang->line('email'); ?> <?php echo $this->lang->line('protocol'); ?></label>
                            <?php $protocols = get_mail_protocol(); ?>
                            <select class="form-control custom-select d-block w-100" name="mail_protocol" id="mail_protocol" required>
                                <option value="">--<?php echo $this->lang->line('select'); ?>--</option>
                                <?php foreach ($protocols as $key => $value) { ?>
                                    <option value="<?php echo $key; ?>" <?php echo isset($email_setting) && $email_setting->mail_protocol == $key ? 'selected="selected"' : ""; ?>><?php echo $value; ?> </option>
                                <?php } ?>
                            </select>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="mail_type"><?php echo $this->lang->line('email'); ?> <?php echo $this->lang->line('type'); ?></label>
                            <?php $mail_types = get_mail_type(); ?>
                            <select class="form-control custom-select d-block w-100" name="mail_type" id="mail_type" required>
                                <option value="">--<?php echo $this->lang->line('select'); ?>--</option>
                                <?php foreach ($mail_types as $key => $value) { ?>
                                    <option value="<?php echo $key; ?>" <?php echo isset($email_setting->mail_type) && $email_setting->mail_type == $key ? 'selected="selected"' : ""; ?>><?php echo $value; ?> </option>
                                <?php } ?>
                            </select>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="char_set"><?php echo $this->lang->line('char_set'); ?></label>
                            <?php $char_sets = get_char_set(); ?>
                            <select class="form-control custom-select d-block w-100" name="char_set" id="char_set" required>
                                <option value="">--<?php echo $this->lang->line('select'); ?>--</option>
                                <?php foreach ($char_sets as $key => $value) { ?>
                                    <option value="<?php echo $key; ?>" <?php echo isset($email_setting->char_set) && $email_setting->char_set == $key ? 'selected="selected"' : ""; ?>><?php echo $value; ?> </option>
                                <?php } ?>
                            </select>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="priority"><?php echo $this->lang->line('priority'); ?></label>
                            <?php $email_priority = get_email_priority(); ?>
                            <select class="form-control custom-select d-block w-100" name="priority" id="priority" required>
                                <option value="">--<?php echo $this->lang->line('select'); ?>--</option>
                                <?php foreach ($email_priority as $key => $value) { ?>
                                    <option value="<?php echo $key; ?>" <?php echo isset($email_setting->priority) && $email_setting->priority == $key ? 'selected="selected"' : ""; ?>><?php echo $value; ?> </option>
                                <?php } ?>
                            </select>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="from_name"><?php echo $this->lang->line('email'); ?> <?php echo $this->lang->line('from'); ?> <?php echo $this->lang->line('name'); ?></label>
                            <input type="text" class="form-control" name="from_name" id="from_name" value="<?php echo isset($email_setting->from_name) ?  $email_setting->from_name : ''; ?>" placeholder="<?php echo $this->lang->line('email'); ?> <?php echo $this->lang->line('from'); ?> <?php echo $this->lang->line('name'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="from_address"><?php echo $this->lang->line('email'); ?> <?php echo $this->lang->line('from'); ?> <?php echo $this->lang->line('address'); ?></label>
                            <input type="text" class="form-control" name="from_address" id="from_address" value="<?php echo isset($email_setting->from_address) ?  $email_setting->from_address : ''; ?>" placeholder="<?php echo $this->lang->line('email'); ?> <?php echo $this->lang->line('from'); ?> <?php echo $this->lang->line('address'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                        </div>


                        <div id="fn_add_smtp" class="form-row  display">
                            <div class="col-md-4 mb-10">
                                <label for="smtp_host"><?php echo $this->lang->line('smtp'); ?> <?php echo $this->lang->line('host'); ?></label>
                                <input type="text" class="form-control" name="smtp_host" id="smtp_host" value="<?php echo isset($email_setting->smtp_host) ?  $email_setting->smtp_host : ''; ?>" placeholder="<?php echo $this->lang->line('smtp'); ?> <?php echo $this->lang->line('host'); ?>" required>
                                <div class="valid-feedback">
                                    <?php echo $this->lang->line('looks_good'); ?>
                                </div>
                                <div class="invalid-feedback">
                                    <?php echo $this->lang->line('required_field'); ?>
                                </div>
                            </div>
                            <div class="col-md-4 mb-10">
                                <label for="smtp_port"><?php echo $this->lang->line('smtp'); ?> <?php echo $this->lang->line('port'); ?></label>
                                <input type="text" class="form-control" name="smtp_port" id="smtp_port" value="<?php echo isset($email_setting->smtp_port) ?  $email_setting->smtp_port : ''; ?>" placeholder="<?php echo $this->lang->line('smtp'); ?> <?php echo $this->lang->line('port'); ?>" required>
                                <div class="valid-feedback">
                                    <?php echo $this->lang->line('looks_good'); ?>
                                </div>
                                <div class="invalid-feedback">
                                    <?php echo $this->lang->line('required_field'); ?>
                                </div>
                            </div>
                            <div class="col-md-4 mb-10">
                                <label for="smtp_user"><?php echo $this->lang->line('smtp'); ?> <?php echo $this->lang->line('user'); ?></label>
                                <input type="text" class="form-control" name="smtp_user" id="smtp_user" value="<?php echo isset($email_setting->smtp_user) ?  $email_setting->smtp_user : ''; ?>" placeholder="<?php echo $this->lang->line('smtp'); ?> <?php echo $this->lang->line('user'); ?>" required>
                                <div class="valid-feedback">
                                    <?php echo $this->lang->line('looks_good'); ?>
                                </div>
                                <div class="invalid-feedback">
                                    <?php echo $this->lang->line('required_field'); ?>
                                </div>
                            </div>
                            <div class="col-md-4 mb-10">
                                <label for="smtp_pass"><?php echo $this->lang->line('smtp'); ?> <?php echo $this->lang->line('password'); ?></label>
                                <input type="text" class="form-control" name="smtp_pass" id="smtp_pass" value="<?php echo isset($email_setting->smtp_pass) ?  $email_setting->smtp_pass : ''; ?>" placeholder="<?php echo $this->lang->line('smtp'); ?> <?php echo $this->lang->line('password'); ?>" required>
                                <div class="valid-feedback">
                                    <?php echo $this->lang->line('looks_good'); ?>
                                </div>
                                <div class="invalid-feedback">
                                    <?php echo $this->lang->line('required_field'); ?>
                                </div>
                            </div>
                            <div class="col-md-4 mb-10">
                                <label for="smtp_crypto"><?php echo $this->lang->line('smtp'); ?> <?php echo $this->lang->line('security'); ?></label>
                                <?php $cryptos = get_smtp_crypto(); ?>
                                <select class="form-control custom-select d-block w-100" name="smtp_crypto" id="smtp_crypto">
                                    <option value="">--<?php echo $this->lang->line('select'); ?>--</option>
                                    <?php foreach ($cryptos as $key => $value) { ?>
                                        <option value="<?php echo $key; ?>" <?php echo isset($email_setting->smtp_crypto) && $email_setting->smtp_crypto == $key ? 'selected="selected"' : ""; ?>><?php echo $value; ?> </option>
                                    <?php } ?>
                                </select>
                                <div class="valid-feedback">
                                    <?php echo $this->lang->line('looks_good'); ?>
                                </div>
                                <div class="invalid-feedback">
                                    <?php echo $this->lang->line('required_field'); ?>
                                </div>
                            </div>
                            <div class="col-md-4 mb-10">
                                <label for="smtp_timeout"><?php echo $this->lang->line('smtp'); ?> <?php echo $this->lang->line('time_out'); ?></label>
                                <input type="text" class="form-control" name="smtp_timeout" id="smtp_timeout" value="<?php echo isset($email_setting->smtp_timeout) ?  $email_setting->smtp_timeout : ''; ?>" placeholder="<?php echo $this->lang->line('smtp'); ?> <?php echo $this->lang->line('time_out'); ?>">
                                <div class="text-info">SMTP Timeout (in seconds) [ 5 - 10 ].</div>
                                <div class="valid-feedback">
                                    <?php echo $this->lang->line('looks_good'); ?>
                                </div>
                                <div class="invalid-feedback">
                                    <?php echo $this->lang->line('required_field'); ?>
                                </div>
                            </div>
                        </div>
                        <!-- Display End -->
                    </div>
                </div>
                <!-- Card Footer -->
                <div class="card-footer pt-0">
                    <div class="button-list mt-0">
                        <a class="btn btn-warning" href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('cancel'); ?></a>
                        <button class="btn btn-primary" type="submit"><?php echo $action == 'add' ? $this->lang->line('submit') : $this->lang->line('update'); ?></button>
                    </div>
                </div>
                <?php echo form_close(); ?>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->
<?php if ($email_setting->mail_protocol != 'smtp') { ?>
    <style>
        .display {
            display: none;
        }
    </style>
<?php } ?>
<script type="text/javascript">
    $('#mail_protocol').on('change', function() {
        if ($(this).val() == 'smtp') {
            document.getElementById('fn_add_smtp').style.display = "flex";
            $('#smtp_host').prop('required', true);
            $('#smtp_port').prop('required', true);
            $('#smtp_user').prop('required', true);
            $('#smtp_pass').prop('required', true);
        } else {
            $('#fn_add_smtp').hide();
            $('#smtp_host').prop('required', false);
            $('#smtp_port').prop('required', false);
            $('#smtp_user').prop('required', false);
            $('#smtp_pass').prop('required', false);
        }
    });
</script>