<?php

defined('BASEPATH') or exit('No direct script access allowed');

/* * *****************Email.php**********************************
 * @product name    : Hospital Management System
 * @type            : Class
 * @class name      : Email
 * @description     : Reset users email by System setting.  
 * @author          : South Bangla IT Zone Team
 * @url             : https://hms.sbitzone.com
 * @support         : rabibd.it@gmail.com
 * @copyright       : South Bangla IT Zone Team
 * ********************************************************** */

class Email extends MY_Controller {

    public $data = array();

    function __construct() {
        parent::__construct();
        $this->load->model('Setting_Model', 'setting', true);
    }


    /*****************Function index**********************************
     * @type            : Function
     * @function name   : index
     * @description     : Load reset email user interface
     *                    and reset user email processing
     * @param           : $id integer value
     * @return          : null
     * ********************************************************** */
    public function index() {

        check_permission(EDIT);

        if ($_POST) {
            $this->load->library('form_validation');
            $this->form_validation->set_error_delimiters('<div class="error-message" style="color: red;">', '</div>');
            $this->form_validation->set_rules('role_id', $this->lang->line('user') . ' ' . $this->lang->line('type'), 'trim|required');
            $this->form_validation->set_rules('user_id', $this->lang->line('user'), 'trim|required');
            $this->form_validation->set_rules('email', $this->lang->line('email'), 'trim|required|valid_email|callback_email');

            if ($this->form_validation->run() === TRUE) {
                $data['email'] = $this->input->post('email');
                $data['modified_at'] = date('Y-m-d H:i:s');
                $data['modified_by'] = logged_in_user_id();

                if ($this->input->post('role_id') == SUPER_ADMIN) {
                    $this->setting->update('employees', $data, array('user_id' => $this->input->post('user_id')));
                } else {
                    $this->setting->update('employees', $data, array('user_id' => $this->input->post('user_id')));
                }
                success($this->lang->line('update_success'));

                $user = $this->setting->get_single('employees', array('user_id' => $this->input->post('user_id')));
                create_log('Has been updated email for user : ' . $user->name);
                redirect('setting/email');
            }
        }
        $this->data['roles'] = $this->setting->get_list('roles', array('status' => 1), '', '', '', 'id', 'ASC');
        $this->data['role_id'] = $this->input->post('role_id');
        $this->data['user_id'] = $this->input->post('user_id');

        $this->layout->title($this->lang->line('reset_user_email') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('email/index', $this->data);
    }


    /*****************Function email**********************************
     * @type            : Function
     * @function name   : email
     * @description     : Unique check for "User Email" data/value
     *
     * @param           : null
     * @return          : boolean true/false
     * ********************************************************** */
    public function email() {
        if ($this->input->post('user_id') == '') {
            $email = $this->setting->duplicate_check_email($this->input->post('email'));
            if ($email) {
                $this->form_validation->set_message('email', $this->lang->line('already_exist'));
                return FALSE;
            } else {
                return TRUE;
            }
        } else if ($this->input->post('user_id') != '') {
            $email = $this->setting->duplicate_check_email($this->input->post('email'), $this->input->post('user_id'));
            if ($email) {
                $this->form_validation->set_message('email', $this->lang->line('already_exist'));
                return FALSE;
            } else {
                return TRUE;
            }
        } else {
            return TRUE;
        }
    }
}
