<?php

defined('BASEPATH') or exit('No direct script access allowed');

/* * *****************Backup.php**********************************
 * @product name    : Hospital Management System
 * @type            : Class
 * @class name      : Backup
 * @description     : Backup system database by system administrator.
 * @author          : South Bangla IT Zone Team
 * @url             : https://hms.sbitzone.com
 * @support         : rabibd.it@gmail.com
 * @copyright       : South Bangla IT Zone Team
 * ********************************************************** */

class Backup extends MY_Controller {

    public $data = array();

    function __construct() {
        parent::__construct();
        $this->load->model('Setting_Model', 'setting', true);
    }


    /*****************Function index**********************************
     * @type            : Function
     * @function name   : index
     * @description     : Load user interface for backup database and take backup database
     *
     * @param           : null integer value
     * @return          : null
     * ********************************************************** */
    public function index() {

        check_permission(VIEW);

        if ($_POST) {
            if (IS_LIVE == TRUE) {
                $this->load->helper('url');
                $this->load->helper('file');
                $this->load->helper('download');
                $this->load->library('zip');
                $this->load->dbutil();

                $db_name = 'backup-on-' . date("Y-m-d-H-i-s") . rand() . '.sql';
                $db_format = array('format' => 'zip', 'filename' => $db_name);
                $backup = $this->dbutil->backup($db_format);
                $zip_name = 'backup-on-' . date('Y-m-d') . rand() . '.zip';
                $save = 'assets/backup/' . $zip_name;
                write_file($save, $backup);

                $data['name'] = 'Backup-' . date('Y-m-d');
                $data['location'] = $zip_name;
                $data['status'] = 1;
                $data['created_at'] = date('Y-m-d H:i:s');
                $data['created_by'] = logged_in_user_id();
                $this->setting->insert('backups', $data);

                create_log('Has been taken database backup');
                redirect('setting/backup');
            } else {
                error($this->lang->line('in_demo_db_backup'));
                redirect('setting/backup');
            }
        } else {

            $search = $this->input->get('search');
            $config = array();
            $config = get_pagination(ADMIN_PER_PAGE);
            if ($search) {
                $config['base_url'] = site_url('doctor/?search=') . $search;
            } else {
                $config['base_url'] = current_url();
            }
            if ($this->input->get('page')) {
                $sgm = (int) trim($this->input->get('page'));
                $offset = $config['per_page'] * ($sgm - 1);
            } else {
                $offset = 0;
            }

            $config['total_rows'] = $this->setting->get_backup_list($config['per_page'], $offset, $search, $count = TRUE);
            $this->pagination->initialize($config);
            $this->data['backups'] = $this->setting->get_backup_list($config['per_page'], $offset, $search, $count = FALSE);

            $this->data['sl_count'] = ($this->input->get('page') == 0 ? 1 : (($this->input->get('page') - 1) * $config["per_page"] + 1));
            $this->data['search'] = $search;

            $this->data['list'] = TRUE;
            $this->layout->title($this->lang->line('backup') . ' ' . $this->lang->line('database') . ' | ' . $this->global_setting->brand_title);
            $this->layout->view('backup/index', $this->data);
        }
    }

    /*     * ***************Function delete**********************************
     * @type            : Function
     * @function name   : delete
     * @description     : delete "Employee" data from database
     *                     and unlink employee photo and Resume from server
     * @param           : $id integer value
     * @return          : null
     * ********************************************************** */

    public function delete($id = null) {

        check_permission(DELETE);

        if (!is_numeric($id)) {
            error($this->lang->line('unexpected_error'));
            redirect('setting/backup');
        }

        $backup = $this->setting->get_single('backups', array('id' => $id));

        if (!empty($backup)) {
            // delete database backup
            $this->setting->delete('backups', array('id' => $id));

            if (file_exists('assets/backup/' . $backup->location)) {
                @unlink('assets/backup/' .  $backup->location);
            }
            create_log('Has been deleted a datebase : ' . $backup->name);

            success($this->lang->line('delete_success'));
        } else {
            error($this->lang->line('delete_failed'));
        }
        redirect('setting/backup');
    }
}
