<?php

defined('BASEPATH') or exit('No direct script access allowed');

/* * *****************Activitylog.php**********************************
 * @product name    : Hospital Management System
 * @type            : Class
 * @class name      : Activitylog
 * @description     : Manage activity log.  
 * @author          : South Bangla IT Zone Team 	
 * @url             : http://hms.sbitzone.com    
 * @support         : rabibd.it@gmail.com	
 * @copyright       : South Bangla IT Zone Team	 	
 * ********************************************************** */

class Activitylog extends MY_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('Setting_Model', 'setting', true);
    }

    public $data = array();

    /*     * ***************Function index**********************************
     * @type            : Function
     * @function name   : index
     * @description     : Load user filtering interface                 
     *                      
     * @param           : null
     * @return          : null 
     * ********************************************************** */

    public function index() {

        check_permission(VIEW);

        $config = array();
        $config = get_pagination(ADMIN_PER_PAGE);

        if ($this->input->get('page')) {
            $sgm = (int) trim($this->input->get('page'));
            $offset = $config['per_page'] * ($sgm - 1);
        } else {
            $offset = 0;
        }

        if ($_GET && $this->input->get('date')) {
            $role_id = $this->input->get('role_id');
            $user_id = $this->input->get('user_id');
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $keyword = trim($this->input->get('keyword'));

            $config['base_url'] = site_url('setting/activitylog/?role_id=' . $role_id . '&user_id=' . $user_id . '&date=' . $date . '&keyword=' . $keyword);
            $config['total_rows'] = $this->setting->get_activity_log($config['per_page'], $offset, $role_id, $user_id, $form_date, $to_date, $keyword, $count = TRUE);
            $this->pagination->initialize($config);
            $this->data['activity_logs'] = $this->setting->get_activity_log($config['per_page'], $offset, $role_id, $user_id, $form_date, $to_date, $keyword, $count = FALSE);
            $this->data['sl_count'] = ($this->input->get('page') == 0 ? 1 : (($this->input->get('page') - 1) * $config["per_page"] + 1));

            $this->data['role_id'] = $role_id;
            $this->data['user_id'] = $user_id;
            $this->data['date'] = $date;
            $this->data['keyword'] = $keyword;
        } else {
            $config['base_url'] = current_url();
            $config['total_rows'] = $this->setting->get_activity_log($config['per_page'], $offset, null, null, null, null, null, $count = TRUE);
            $this->pagination->initialize($config);
            $this->data['activity_logs'] = $this->setting->get_activity_log($config['per_page'], $offset, null, null, null, null, null, $count = FALSE);
            $this->data['sl_count'] = ($this->input->get('page') == 0 ? 1 : (($this->input->get('page') - 1) * $config["per_page"] + 1));
        }

        $this->data['roles'] = $this->setting->get_list('roles', array('status' => 1), '', '', '', 'id', 'ASC');
        $this->layout->title($this->lang->line('manage') . ' ' . $this->lang->line('activity_log') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('log/index', $this->data);
    }

    /*     * ***************Function get_single_activitylog**********************************
     * @type            : Function
     * @function name   : get_single_activitylog
     * @description     : "Load single anesthesia information" from database                  
     *                    to the user interface   
     * @param           : null
     * @return          : null 
     * ********************************************************** */

    public function get_single_activitylog() {
        $id = $this->input->post('id');
        $this->data['activitylog'] = $this->setting->get_single('activity_logs', array('id' => $id));
        echo $this->load->view('setting/log/view', $this->data);
    }

    /*     * ***************Function delete**********************************
     * @type            : Function
     * @function name   : delete
     * @description     : delete "Activity log" from database                  
     *                       
     * @param           : $id integer value
     * @return          : null 
     * ********************************************************** */

    public function delete($id = null) {

        check_permission(DELETE);

        if (!is_numeric($id)) {
            error($this->lang->line('unexpected_error'));
            redirect('setting/activitylog');
        }

        if ($this->setting->delete('activity_logs', array('id' => $id))) {
            success($this->lang->line('delete_success'));
        } else {
            error($this->lang->line('delete_failed'));
        }
        redirect($_SERVER['HTTP_REFERER']);
    }

    /*     * ***************Function multidelete**********************************
     * @type            : Function
     * @function name   : multidelete
     * @description     : multidelete "Activity log" from database                  
     *                       
     * @param           : 
     * @return          : null 
     * ********************************************************** */

    public function multidelete() {

        check_permission(DELETE);
        if ($this->input->post('log')) {
            foreach ($this->input->post('log') as $key => $value) {
                $this->setting->delete('activity_logs', array('id' => $key));
            }
            success($this->lang->line('delete_success'));
        } else {
            error($this->lang->line('delete_failed'));
        }
        redirect($_SERVER['HTTP_REFERER']);
    }
}
