<!DOCTYPE html>
<html>

<head>
    <title>SMS</title>
    <style>
        body {
            font-family: "Time New Roman";
            font-size: 13px;
        }

        .page {
            width: 100%;
            margin: 0 auto;
        }

        .main_body {
            display: block;
        }

        .table {
            width: 100%;
            border-collapse: collapse;
        }

        .info_table {
            margin-top: 20px;
        }

        .content {
            margin-top: 20px;
        }

        .table_content thead th {
            padding: 0;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 12px;
        }

        .table_content tbody td {
            padding: 0 2px;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 12px;
        }

        .footer {
            margin-top: 100px;
        }
    </style>
</head>

<body>
    <div class="page">
        <div class="main_body">
            <table class="table" style="text-align: center;">
                <tbody>
                    <tr>
                        <td>
                            <h2 style="margin-bottom: 0; font-size: 28px;"><?php echo $this->global_setting->brand_title; ?></h2>
                        </td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->address; ?></b></td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->email; ?></b></td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->phone; ?></b></td>
                    </tr>
                </tbody>
            </table>

            <!-- Content Start-->

            <div class="info_table">
                <table class="table">
                    <tbody>
                        <tr>
                            <td width="70%" align="left">
                                <?php if ($this->input->get('role_id')) { ?>
                                    <b>Role:</b>
                                    <span style="font-size: 12px; margin: 0; padding: 0;"><?php echo $role->name; ?></span>
                                <?php } else { ?>
                                    <b>All</b>
                                <?php } ?>
                            </td>
                            <td width="30%" align="right">
                                <b>Date:</b>
                                <span style="font-size: 12px;"><?php echo date('d/m/Y h:i A'); ?></span>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>

            <!-- Content Start-->
            <div class="content">
                <table class="table table_content">
                    <thead>
                        <tr>
                            <th style="width: 8%;">SL No</th>
                            <th style="width: 20%;">Name</th>
                            <th style="width: 12%;">Phone</th>
                            <th style="width: 15%;">Type</th>
                            <th style="width: 10%;">Charge</th>
                            <th style="width: 15%;">Created</th>
                            <th style="width: 20%;">Created By</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $count = 1;
                        $total = 0;
                        foreach ($text_messages as $obj) {
                            $total += $obj->charged;
                            if ($obj->user_id && $obj->user_id > 0) {
                                $user = get_user_by_id($obj->user_id);
                            } else {
                                if ($obj->sms_type === 'appointment') {
                                    $data = $this->sms->get_single('appointments', array('id' => $obj->data_id));
                                }
                            }
                        ?>
                            <tr>
                                <td><?php echo $count++; ?></td>
                                <td><?php echo $obj->user_id > 0 ? $user->name : $data->name; ?></td>
                                <td><?php echo $obj->user_id > 0 ? $user->phone : $data->phone; ?></td>
                                <td><?php echo ucwords(str_replace('_', ' ', $obj->sms_type)); ?></td>
                                <td><?php echo $obj->charged; ?></td>
                                <td><?php echo date('M d, Y h:ia', strtotime($obj->created_at)); ?></td>
                                <td><?php echo $obj->created_by; ?></td>
                            </tr>
                        <?php } ?>
                    </tbody>
                </table>
            </div>
            <!-- Content End -->
            <h2 style="text-align: center; margin-top:20px;">Total: <?php echo number_format($total, 2); ?></h2>
            <!-- Footer -->
            <div class="footer">
                <table class="table">
                    <tbody>
                        <tr>
                            <td width="70%">
                                <p style="margin-left: 10%;">
                                    <b>Prepared By:</b>
                                    <?php echo $this->session->userdata('name'); ?>
                                </p>
                            </td>
                            <td width="30%" align="center">
                                <p style="border-top: 1px dashed red; width: 30%; margin: 5px auto;"></p>
                                <b>Signature</b>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</body>

</html>