<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item" aria-current="page"><?php echo $this->lang->line('report'); ?></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('sms'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container-fluid">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('sms'); ?> <?php echo $this->lang->line('report'); ?>
        </h4>
        <div class="d-flex">
            <?php if (has_permission(VIEW, 'report', 'opd')) { ?>
                <a href="<?php echo site_url('report/opd'); ?>" class="btn btn-primary btn-sm mr-15"><?php echo $this->lang->line('opd'); ?> <?php echo $this->lang->line('report'); ?></a>
            <?php } ?>
            <?php if (has_permission(VIEW, 'report', 'billing')) { ?>
                <a href="<?php echo site_url('report/billing'); ?>" class="btn btn-success btn-sm mr-15"><?php echo $this->lang->line('billing'); ?> <?php echo $this->lang->line('report'); ?></a>
            <?php } ?>
        </div>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <!-- col-lg-12 -->
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <?php echo form_open_multipart(site_url('report/sms'), array('name' => 'search', 'id' => 'search', 'method' => 'get'), ''); ?>
                    <div class="form-row">
                        <div class="col-md-3 mb-10">
                            <label for="keyword"><?php echo $this->lang->line('keyword'); ?></label>
                            <input type="text" class="form-control" name="keyword" id="keyword" value="<?php echo isset($keyword) ?  $keyword : ''; ?>" placeholder="<?php echo $this->lang->line('keyword'); ?>">
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="type"><?php echo $this->lang->line('type'); ?></label>
                            <select class="form-control custom-select" name="type" id="type">
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('type'); ?></option>
                                <?php $types = get_sms_type(); ?>
                                <?php foreach ($types as $key => $value) { ?>
                                    <option value="<?php echo $key; ?>" <?php echo isset($type) && $type == $key ? 'selected="selected"' : ""; ?>><?php echo $value; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="date"><?php echo $this->lang->line('date'); ?></label>
                            <input type="text" class="form-control" name="date" id="range" value="<?php echo isset($date) ?  $date : ''; ?>" placeholder="<?php echo $this->lang->line('date'); ?>">
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="role_id"><?php echo $this->lang->line('role'); ?></label>
                            <select class="form-control custom-select select2" name="role_id" id="role_id">
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('role'); ?></option>
                                <?php foreach ($roles as $obj) { ?>
                                    <?php if ($this->session->userdata('role_id') != SUPER_ADMIN) { ?>
                                        <?php if (in_array($obj->id, array(SUPER_ADMIN))) {
                                            continue;
                                        } ?>
                                    <?php } ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($role_id) && $role_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="operator"><?php echo $this->lang->line('operator'); ?></label>
                            <select class="form-control custom-select" name="operator" id="operator">
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('operator'); ?></option>
                                <?php $operators = get_operator_type(); ?>
                                <?php foreach ($operators as $key => $value) { ?>
                                    <option value="<?php echo $key; ?>" <?php echo isset($operator) && $operator == $key ? 'selected="selected"' : ""; ?>><?php echo $value; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="created_by"><?php echo $this->lang->line('created_by'); ?></label>
                            <select class="form-control custom-select select2" name="created_by" id="created_by">
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('employee'); ?></option>
                                <?php foreach ($employees as $obj) { ?>
                                    <option value="<?php echo $obj->user_id; ?>" <?php echo isset($created_by) && $created_by == $obj->user_id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?> [<?php echo $obj->phone; ?>]</option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-4">
                            <button class="btn btn-gradient-primary mt-35" type="submit"><?php echo $this->lang->line('search'); ?></button>
                        </div>
                    </div>
                    <?php echo form_close(); ?>
                </div>
            </div>
        </div>

        <?php if (isset($text_messages) && !empty($text_messages)) { ?>
            <!-- Report Details -->
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between">
                        <?php if (has_permission(VIEW, 'report', 'sms')) { ?>
                            <h6 class="card-header d-flex align-items-center">
                                <i class="fa fa-envelope-o font-30 mr-10"></i>
                                <?php echo $this->lang->line('sms'); ?> <?php echo $this->lang->line('report'); ?>
                            </h6>
                        <?php } ?>
                        <div class="button-list">
                            <a href="<?php echo site_url('report/sms/pdf/?keyword=' . $keyword . '&date=' . $date . '&role_id=' . $role_id . '&operator=' . $operator . '&created_by=' . $created_by); ?>" class="btn btn-success btn-xs">
                                <i class="fa fa-download"></i> <?php echo $this->lang->line('pdf'); ?> <?php echo $this->lang->line('generate'); ?>
                            </a>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-wrap">
                            <div class="table-responsive">
                                <table class="table table-sm mb-0">
                                    <thead>
                                        <tr>
                                            <th><?php echo $this->lang->line('sl_no'); ?></th>
                                            <th><?php echo $this->lang->line('name'); ?></th>
                                            <th><?php echo $this->lang->line('phone'); ?></th>
                                            <th><?php echo $this->lang->line('type'); ?></th>
                                            <th><?php echo $this->lang->line('charge'); ?></th>
                                            <th><?php echo $this->lang->line('status'); ?></th>
                                            <th><?php echo $this->lang->line('created'); ?></th>
                                            <th><?php echo $this->lang->line('created_by'); ?></th>
                                            <th><?php echo $this->lang->line('action'); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $count = 1;
                                        $total = 0;
                                        if (isset($text_messages) && !empty($text_messages)) { ?>
                                            <?php foreach ($text_messages as $obj) {
                                                $total += $obj->charged;
                                            ?>
                                                <tr>
                                                    <td><?php echo $count++; ?></td>
                                                    <td>
                                                        <div class="d-flex justify-content-left align-items-center">
                                                            <?php if ($obj->user_id && $obj->user_id > 0) {
                                                                $user = get_user_by_id($obj->user_id);
                                                                $path = $obj->role_id === PATIENT ? 'patient-photo' : 'employee-photo';
                                                            ?>
                                                                <div class="avatar avatar-sm mr-1">
                                                                    <?php if ($user->photo) { ?>
                                                                        <img src="<?php echo UPLOAD_PATH . $path; ?>/<?php echo $user->photo; ?>" alt="user" class="avatar-img rounded-circle">
                                                                    <?php } elseif ($user->gender == 'male') { ?>
                                                                        <img src="<?php echo IMG_URL; ?>male.png" alt="male" class="avatar-img rounded-circle">
                                                                    <?php } else { ?>
                                                                        <img src="<?php echo IMG_URL; ?>female.png" alt="female" class="avatar-img rounded-circle">
                                                                    <?php }  ?>
                                                                </div>
                                                                <div class="d-flex flex-column">
                                                                    <a href="#" class=" text-truncate text-body">
                                                                        <span class="font-weight-bold"><?php echo $user->name; ?></span>
                                                                    </a>
                                                                    <small class="text-muted">
                                                                        <?php
                                                                        if ($obj->role_id === PATIENT) {
                                                                            echo $user->patient_unique_id;
                                                                        } else {
                                                                            echo $user->device_id;
                                                                        }
                                                                        ?>
                                                                    </small>
                                                                    <small class="text-muted"><?php echo $obj->role; ?></small>
                                                                </div>
                                                            <?php } else {
                                                                if ($obj->sms_type === 'appointment') {
                                                                    $data = $this->sms->get_single('appointments', array('id' => $obj->data_id));
                                                                }
                                                            ?>
                                                                <div class="avatar avatar-sm mr-1">
                                                                    <?php if (isset($data->gender) && $data->gender == 'male') { ?>
                                                                        <img src="<?php echo IMG_URL; ?>male.png" alt="male" class="avatar-img rounded-circle">
                                                                    <?php } else { ?>
                                                                        <img src="<?php echo IMG_URL; ?>female.png" alt="female" class="avatar-img rounded-circle">
                                                                    <?php }  ?>
                                                                </div>
                                                                <div class="d-flex flex-column">
                                                                    <a href="#" class=" text-truncate text-body">
                                                                        <span class="font-weight-bold"><?php echo isset($data->name) ? $data->name : ''; ?></span>
                                                                    </a>
                                                                    <small class="text-muted">
                                                                        <?php echo isset($data->appointment_no) ? $data->appointment_no : ''; ?>
                                                                    </small>
                                                                    <small class="text-muted"><?php echo isset($data->address) ? $data->address : ''; ?></small>
                                                                </div>
                                                            <?php } ?>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <?php
                                                        if ($obj->user_id && $obj->user_id > 0) {
                                                            echo $user->phone;
                                                        } else {
                                                            echo isset($data->phone) ? $data->phone : '';
                                                        }
                                                        ?>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex justify-content-left align-items-center">
                                                            <div class="d-flex flex-column">
                                                                <span class="font-weight-bold"><?php echo ucwords(str_replace('_', ' ', $obj->sms_type)); ?></span>
                                                                <small class="text-muted"><?php echo $obj->sender_id; ?></small>
                                                                <small class="text-muted"><?php echo $obj->operator; ?></small>
                                                            </div>
                                                        </div>
                                                    </td>
                                                    <td><?php echo $obj->charged; ?></td>
                                                    <td>
                                                        <span class="badge badge-success">Delivered</span>
                                                    </td>
                                                    <td><?php echo date('M d, Y h:ia', strtotime($obj->created_at)); ?></td>
                                                    <td><?php echo $obj->created_by; ?></td>
                                                    <td>
                                                        <?php if (has_permission(VIEW, 'report', 'sms')) { ?>
                                                            <button class="btn btn-xs btn-info" type="button" onclick="get_view_modal(<?php echo $obj->id; ?>);" data-toggle="modal" data-target=".viewModalCenter"><i class="fa fa-eye"></i></button>
                                                        <?php } ?>
                                                        <?php if (has_permission(DELETE, 'report', 'sms')) { ?>
                                                            <a class="btn btn-xs btn-danger" href="<?php echo site_url('report/sms/delete/' . $obj->id); ?>" onclick="javascript: return confirm('<?php echo $this->lang->line('confirm_alert'); ?>');"> <i class="fa fa-trash text-white"></i></a>
                                                        <?php } ?>
                                                    </td>
                                                </tr>
                                            <?php } ?>
                                        <?php } else { ?>
                                            <tr class="text-center">
                                                <td colspan="9"><?php echo $this->lang->line('no_data_found'); ?></td>
                                            </tr>
                                        <?php } ?>
                                    </tbody>
                                    <tfoot class="border-bottom border-1">
                                        <tr>
                                            <th colspan="4" class="text-right font-weight-600">Total</th>
                                            <th colspan="5" class="text-left font-weight-600"><?php echo number_format($total, 2); ?></th>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php } ?>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->

<div class="modal fade viewModalCenter" tabindex="-1" role="dialog" aria-labelledby="viewModalCenter" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header bg-gradient-primary">
                <h5 class="modal-title text-white"><?php echo $this->lang->line('sms'); ?> <?php echo $this->lang->line('info'); ?></h5>
                <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body modal_data bg-gradient-secondary"></div>
        </div>
    </div>
</div>

<script type="text/javascript">
    function get_view_modal(id) {
        $('.modal_data').html('<p style="padding: 20px;"><p style="padding: 20px;text-align:center;"><img src="<?php echo IMG_URL; ?>loader.gif" /></p>');
        $.ajax({
            type: "POST",
            url: "<?php echo site_url('report/sms/get_single_sms'); ?>",
            data: {
                id: id
            },
            success: function(response) {
                if (response) {
                    $('.modal_data').html(response);
                }
            }
        });
    }
</script>


<!-- Daterangepicker -->
<link href="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>moment/min/moment.min.js"></script>
<script src="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.js"></script>

<!-- Select2 -->
<link href="<?php echo VENDOR_URL; ?>select2/dist/css/select2.min.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>select2/dist/js/select2.full.min.js"></script>

<style>
    .select2-container .select2-selection--single {
        height: calc(2.25rem + 4px) !important;
    }

    .select2-container--default .select2-search--dropdown .select2-search__field {
        color: #324148;
        border-width: 2px;
        border-color: #e0e3e4;
        padding: .375rem .75rem;
        height: calc(2.25rem + 4px);
    }

    .select2-container--default .select2-selection--single .select2-selection__arrow b {
        margin-top: 5px;
    }
</style>
<script>
    $(".select2").select2();
    $('#range').daterangepicker({
        startDate: new Date(),
        endDate: moment(),
        showDropdowns: true,
        minYear: 1901,
        locale: {
            format: 'YYYY/MM/DD',
        },
        ranges: {
            'Today': [moment(), moment()],
            'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
            'Tomorrow': [moment().subtract(-1, 'days'), moment().subtract(-1, 'days')],
            'Last 7 Days': [moment().subtract(6, 'days'), moment()],
            'Last 30 Days': [moment().subtract(29, 'days'), moment()],
            'This Month': [moment().startOf('month'), moment().endOf('month')],
            'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            'This Year': [moment().startOf('year'), moment().endOf('year')],
            'Last Year': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')]
        }
    });
</script>