<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('report'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container-fluid">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('payment'); ?> <?php echo $this->lang->line('report'); ?>
        </h4>
        <div class="d-flex">
            <?php if (has_permission(VIEW, 'accounting', 'payment')) { ?>
                <a href="<?php echo site_url('accounting/payment/investigation'); ?>" class="btn btn-info btn-sm mr-15"><?php echo $this->lang->line('investigation'); ?> <?php echo $this->lang->line('payment'); ?></a>
            <?php } ?>
            <?php if (has_permission(VIEW, 'report', 'appointment')) { ?>
                <a href="<?php echo site_url('report/appointment'); ?>" class="btn btn-primary btn-sm mr-15"><?php echo $this->lang->line('appointment'); ?> <?php echo $this->lang->line('report'); ?></a>
            <?php } ?>
            <?php if (has_permission(VIEW, 'report', 'opd')) { ?>
                <a href="<?php echo site_url('report/opd'); ?>" class="btn btn-success btn-sm mr-15"><?php echo $this->lang->line('opd'); ?> <?php echo $this->lang->line('report'); ?></a>
            <?php } ?>
        </div>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <!-- col-lg-12 -->
        <div class="col-lg-12">
            <div class="card">
                <?php echo form_open_multipart(site_url('report/payment'), array('name' => 'search', 'id' => 'search', 'class' => 'needs-validation', 'novalidate' => 'novalidate', 'method' => 'get'), ''); ?>
                <div class="card-body">
                    <div class="form-row">
                        <div class="col-md-2 mb-10">
                            <label for="invoice_type"><?php echo $this->lang->line('invoice'); ?> <?php echo $this->lang->line('type'); ?></label>
                            <select class="form-control custom-select" name="invoice_type" id="invoice_type" required>
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('type'); ?></option>
                                <!--<option value="all" <?php echo isset($invoice_type) && $invoice_type == 'all' ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('all'); ?> <?php echo $this->lang->line('payment'); ?></option>-->
                                <option value="opd" <?php echo isset($invoice_type) && $invoice_type == 'opd' ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('opd'); ?> <?php echo $this->lang->line('payment'); ?></option>
                                <option value="ipd" <?php echo isset($invoice_type) && $invoice_type == 'ipd' ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('ipd'); ?> <?php echo $this->lang->line('payment'); ?></option>
                                <option value="investigation" <?php echo isset($invoice_type) && $invoice_type == 'investigation' ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('investigations'); ?> <?php echo $this->lang->line('payment'); ?></option>
                                <option value="surgeon" <?php echo isset($invoice_type) && $invoice_type == 'surgeon' ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('surgeon'); ?> <?php echo $this->lang->line('payment'); ?></option>
                                <option value="anesthesia" <?php echo isset($invoice_type) && $invoice_type == 'anesthesia' ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('anesthesia'); ?> <?php echo $this->lang->line('payment'); ?></option>
                                <option value="assistant" <?php echo isset($invoice_type) && $invoice_type == 'assistant' ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('assistant'); ?> <?php echo $this->lang->line('payment'); ?></option>
                                <option value="consultant" <?php echo isset($invoice_type) && $invoice_type == 'consultant' ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('consultant'); ?> <?php echo $this->lang->line('payment'); ?></option>
                            </select>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="payment_type"><?php echo $this->lang->line('payment'); ?> <?php echo $this->lang->line('type'); ?></label>
                            <select class="form-control custom-select" name="payment_type" id="payment_type" required>
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('type'); ?></option>
                                <option value="single" <?php echo isset($payment_type) && $payment_type == 'single' ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('single'); ?> <?php echo $this->lang->line('payment'); ?></option>
                                <option value="multiple" <?php echo isset($payment_type) && $payment_type == 'multiple' ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('multiple'); ?> <?php echo $this->lang->line('payment'); ?></option>
                            </select>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="keyword"><?php echo $this->lang->line('keyword'); ?></label>
                            <input type="text" class="form-control" name="keyword" id="keyword" value="<?php echo isset($keyword) ?  $keyword : ''; ?>" placeholder="<?php echo $this->lang->line('keyword'); ?>">
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="range"><?php echo $this->lang->line('date'); ?></label>
                            <input type="text" required class="form-control" name="date" id="range" value="<?php echo isset($date) ?  $date : ''; ?>" placeholder="<?php echo $this->lang->line('date'); ?>" autocomplete="off">
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="doctor_id"><?php echo $this->lang->line('doctor'); ?></label>
                            <select class="form-control custom-select select2" name="doctor_id" id="doctor_id">
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('doctor'); ?></option>
                                <?php foreach ($doctors as $obj) { ?>
                                    <option value="<?php echo $obj->user_id; ?>" <?php echo isset($doctor_id) && $doctor_id == $obj->user_id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?> [<?php echo $obj->phone; ?>]</option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="reference_id"><?php echo $this->lang->line('reference'); ?></label>
                            <select class="form-control custom-select select2" name="reference_id" id="reference_id">
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('reference'); ?></option>
                                <?php foreach ($references as $obj) { ?>
                                    <option value="<?php echo $obj->user_id; ?>" <?php echo isset($reference_id) && $reference_id == $obj->user_id ? 'selected="selected"' : ""; ?>><?php echo $obj->id; ?> - <?php echo $obj->name; ?> [<?php echo $obj->phone; ?>]</option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="created_by"><?php echo $this->lang->line('created_by'); ?></label>
                            <select class="form-control custom-select select2" name="created_by" id="created_by">
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('employee'); ?></option>
                                <?php foreach ($employees as $obj) { ?>
                                    <option value="<?php echo $obj->user_id; ?>" <?php echo isset($created_by) && $created_by == $obj->user_id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?> [<?php echo $obj->phone; ?>]</option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-1">
                            <button class="btn btn-gradient-primary mt-35" type="submit"><?php echo $this->lang->line('search'); ?></button>
                        </div>
                    </div>
                </div>
                <?php echo form_close(); ?>
            </div>
        </div>
        <?php if (isset($payments) && !empty($payments)) { ?>
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between">
                        <h4 class="hk-pg-title">
                            <i class="fa fa-h-square"></i>
                            <?php echo $this->lang->line($invoice_type); ?> <?php echo $this->lang->line('report'); ?>
                        </h4>
                        <div class="button-list mt-0">
                            <a href="<?php echo site_url('report/payment/pdf/?invoice_type=' . $invoice_type . '&payment_type=' . $payment_type .  '&date=' . $date . '&keyword=' . $keyword . '&doctor_id=' . $doctor_id . '&reference_id=' . $reference_id . '&created_by=' . $created_by); ?>" class="btn btn-success btn-xs"><i class="fa fa-download"></i> <?php echo $this->lang->line('pdf'); ?> <?php echo $this->lang->line('generate'); ?></a>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-wrap">
                            <div class="table-responsive">
                                <table class="table table-sm mb-0">
                                    <thead>
                                        <?php if ($invoice_type == 'all') { ?>
                                            <tr>
                                                <th><?php echo $this->lang->line('sl_no'); ?></th>
                                                <th><?php echo $this->lang->line('type'); ?></th>
                                                <th><?php echo $this->lang->line('patient_id'); ?></th>
                                                <th><?php echo $this->lang->line('patient'); ?> <?php echo $this->lang->line('name'); ?></th>
                                                <th><?php echo $this->lang->line('payment_to'); ?></th>
                                                <th><?php echo $this->lang->line('amount'); ?></th>
                                                <th><?php echo $this->lang->line('payment'); ?></th>
                                                <th><?php echo $this->lang->line('payment'); ?> <?php echo $this->lang->line('date'); ?></th>
                                                <th><?php echo $this->lang->line('created_by'); ?></th>
                                            </tr>
                                        <?php } else { ?>
                                            <tr>
                                                <th><?php echo $this->lang->line('invoice_no'); ?></th>
                                                <th><?php echo $this->lang->line('type'); ?></th>
                                                <?php if ($invoice_type != 'investigation' && $payment_type != 'multiple') { ?>
                                                    <th><?php echo $this->lang->line('patient_id'); ?></th>
                                                    <th><?php echo $this->lang->line('patient'); ?> <?php echo $this->lang->line('name'); ?></th>
                                                <?php } ?>
                                                <th><?php echo $this->lang->line('payment_to'); ?></th>
                                                <th><?php echo $this->lang->line('amount'); ?></th>
                                                <th><?php echo $this->lang->line('payment'); ?></th>
                                                <th><?php echo $this->lang->line('payment'); ?> <?php echo $this->lang->line('date'); ?></th>
                                                <th><?php echo $this->lang->line('created_by'); ?></th>
                                                <?php if ($invoice_type != 'all') { ?>
                                                    <th><?php echo $this->lang->line('action'); ?></th>
                                                <?php } ?>
                                            </tr>
                                        <?php } ?>
                                    </thead>
                                    <tbody>
                                        <?php $sl = 1;
                                        foreach ($payments as $obj) { ?>
                                            <?php if ($invoice_type == 'all') { ?>
                                                <tr>
                                                    <td><?php echo $sl++; ?></td>
                                                    <td><?php echo $this->lang->line($obj->invoice_type); ?></td>
                                                    <td><?php echo $obj->patient_unique_id; ?></td>
                                                    <td><?php echo $obj->patient; ?></td>
                                                    <td>
                                                        <?php if ($obj->doctor) {
                                                            echo $obj->doctor;
                                                        } elseif ($obj->anesthetist) {
                                                            echo $obj->anesthetist;
                                                        } else {
                                                            echo $obj->assistant;
                                                        }
                                                        ?>
                                                    </td>
                                                    <td><?php echo $obj->commission_amount; ?></td>
                                                    <td><?php echo $obj->payable_amount; ?></td>
                                                    <td><?php echo date('M d, Y h:iA', strtotime($obj->date)); ?></td>
                                                    <td><?php echo $obj->created_by; ?></td>
                                                </tr>
                                            <?php } else { ?>
                                                <tr>
                                                    <td><?php echo $obj->custom_invoice_id; ?></td>
                                                    <td><?php echo $this->lang->line($obj->invoice_type); ?></td>
                                                    <?php if ($invoice_type != 'investigation' && $payment_type != 'multiple') { ?>
                                                        <td><?php echo $obj->patient_unique_id; ?></td>
                                                        <td><?php echo $obj->patient; ?></td>
                                                    <?php } ?>
                                                    <td>
                                                        <?php if ($obj->doctor) {
                                                            echo $obj->doctor;
                                                        } elseif ($obj->anesthetist) {
                                                            echo $obj->anesthetist;
                                                        } else {
                                                            echo $obj->assistant;
                                                        }
                                                        ?>
                                                    </td>
                                                    <?php if ($invoice_type == 'investigation' && $payment_type == 'multiple') { ?>
                                                        <td><?php echo $obj->total_commission_amount; ?></td>
                                                        <td><?php echo $obj->total_payable_commission; ?></td>
                                                    <?php } else { ?>
                                                        <td><?php echo $obj->commission_amount; ?></td>
                                                        <td><?php echo $obj->payable_amount; ?></td>
                                                    <?php } ?>
                                                    <td><?php echo date('M d, Y h:iA', strtotime($obj->date)); ?></td>
                                                    <td><?php echo $obj->created_by; ?></td>
                                                    <?php if ($invoice_type != 'all') { ?>
                                                        <td>
                                                            <button title="<?php echo $this->lang->line('print'); ?>" type="button" onclick="printBill(<?php echo $obj->id; ?>);" class="btn btn-info btn-xs">
                                                                <i class="fa fa-print"></i>
                                                            </button>
                                                        </td>
                                                    <?php } ?>
                                                </tr>
                                            <?php } ?>
                                        <?php } ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php } ?>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->

<!-- Daterangepicker -->
<link href="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>moment/min/moment.min.js"></script>
<script src="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.js"></script>

<!-- Select2 -->
<link href="<?php echo VENDOR_URL; ?>select2/dist/css/select2.min.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>select2/dist/js/select2.full.min.js"></script>

<style>
    .select2-container .select2-selection--single {
        height: calc(2.25rem + 4px) !important;
    }

    .select2-container--default .select2-search--dropdown .select2-search__field {
        color: #324148;
        border-width: 2px;
        border-color: #e0e3e4;
        padding: .375rem .75rem;
        height: calc(2.25rem + 4px);
    }

    .select2-container--default .select2-selection--single .select2-selection__arrow b {
        margin-top: 5px;
    }
</style>
<script>
    $(".select2").select2();
    $('#range').daterangepicker({
        autoUpdateInput: false,
        startDate: new Date(),
        endDate: moment(),
        showDropdowns: true,
        minYear: 1901,
        locale: {
            format: 'YYYY/MM/DD',
        },
        ranges: {
            'Today': [moment(), moment()],
            'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
            'Tomorrow': [moment().subtract(-1, 'days'), moment().subtract(-1, 'days')],
            'Last 7 Days': [moment().subtract(6, 'days'), moment()],
            'Last 30 Days': [moment().subtract(29, 'days'), moment()],
            'This Month': [moment().startOf('month'), moment().endOf('month')],
            'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            'This Year': [moment().startOf('year'), moment().endOf('year')],
            'Last Year': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')]
        }
    });
    $('input[id="range"]').on('apply.daterangepicker', function(ev, picker) {
        $(this).val(picker.startDate.format('YYYY/MM/DD') + ' - ' + picker.endDate.format('YYYY/MM/DD'));
    });

    $('input[id="range"]').on('cancel.daterangepicker', function(ev, picker) {
        $(this).val('');
    });
</script>

<script>
    <?php if (isset($invoice_type) && $invoice_type == 'opd') { ?>

        function printBill(id) {
            $.ajax({
                url: '<?php echo site_url('accounting/payment/opd_print'); ?>',
                type: 'POST',
                data: {
                    id: id,
                },
                success: function(result) {
                    $("#testdata").html(result);
                    popup(result);
                }
            });
        }
    <?php } ?>

    <?php if (isset($invoice_type) && $invoice_type == 'investigation' && $payment_type == 'single') { ?>

        function printBill(id) {
            $.ajax({
                url: '<?php echo site_url('accounting/payment/investigation_print'); ?>',
                type: 'POST',
                data: {
                    id: id,
                },
                success: function(result) {
                    $("#testdata").html(result);
                    popup(result);
                }
            });
        }
    <?php } ?>

    <?php if (isset($invoice_type) && $invoice_type == 'investigation' && $payment_type == 'multiple') { ?>

        function printBill(id) {
            $.ajax({
                url: '<?php echo site_url('accounting/payment/multi_investigation_print'); ?>',
                type: 'POST',
                data: {
                    id: id,
                },
                success: function(result) {
                    $("#testdata").html(result);
                    popup(result);
                }
            });
        }
    <?php } ?>


    <?php if (isset($invoice_type) && $invoice_type == 'surgeon') { ?>

        function printBill(id) {
            $.ajax({
                url: '<?php echo site_url('accounting/payment/surgeon_print'); ?>',
                type: 'POST',
                data: {
                    id: id,
                },
                success: function(result) {
                    $("#testdata").html(result);
                    popup(result);
                }
            });
        }
    <?php } ?>

    <?php if (isset($invoice_type) && $invoice_type == 'anesthesia') { ?>

        function printBill(id) {
            $.ajax({
                url: '<?php echo site_url('accounting/payment/anesthesia_print'); ?>',
                type: 'POST',
                data: {
                    id: id,
                },
                success: function(result) {
                    $("#testdata").html(result);
                    popup(result);
                }
            });
        }
    <?php } ?>

    <?php if (isset($invoice_type) && $invoice_type == 'assistant') { ?>

        function printBill(id) {
            $.ajax({
                url: '<?php echo site_url('accounting/payment/assistant_print'); ?>',
                type: 'POST',
                data: {
                    id: id,
                },
                success: function(result) {
                    $("#testdata").html(result);
                    popup(result);
                }
            });
        }
    <?php } ?>

    <?php if (isset($invoice_type) && $invoice_type == 'consultant') { ?>

        function printBill(id) {
            $.ajax({
                url: '<?php echo site_url('accounting/payment/consultant_print'); ?>',
                type: 'POST',
                data: {
                    id: id,
                },
                success: function(result) {
                    $("#testdata").html(result);
                    popup(result);
                }
            });
        }
    <?php } ?>

    <?php if (isset($invoice_type) && $invoice_type == 'ipd') { ?>

        function printBill(id) {
            $.ajax({
                url: '<?php echo site_url('accounting/payment/ipd_print'); ?>',
                type: 'POST',
                data: {
                    id: id,
                },
                success: function(result) {
                    $("#testdata").html(result);
                    popup(result);
                }
            });
        }
    <?php } ?>

    function popup(data) {
        var frame1 = $('<iframe />');
        frame1[0].name = "frame1";
        frame1.css({
            "position": "absolute",
            "top": "-1000000px"
        });
        $("body").append(frame1);
        var frameDoc = frame1[0].contentWindow ? frame1[0].contentWindow : frame1[0].contentDocument.document ? frame1[0].contentDocument.document : frame1[0].contentDocument;
        frameDoc.document.open();
        //Create a new HTML document.
        frameDoc.document.write('<html>');
        frameDoc.document.write('<head>');
        frameDoc.document.write('<title>Print Invoice</title>');

        frameDoc.document.write('</head>');
        frameDoc.document.write('<body>');
        frameDoc.document.write(data);
        frameDoc.document.write('</body>');
        frameDoc.document.write('</html>');
        frameDoc.document.close();
        setTimeout(function() {
            window.frames["frame1"].focus();
            window.frames["frame1"].print();
            frame1.remove();
            //window.location.reload(true);
        }, 500);

        return true;

    }
</script>