<!DOCTYPE html>
<html>

<head>
    <title>OPD</title>
    <style>
        body {
            font-family: "Time New Roman";
            font-size: 13px;
        }

        .page {
            width: 100%;
            margin: 0 auto;
        }

        .main_body {
            /* page-break-after: always; */
            display: block;
        }

        .table {
            width: 100%;
            border-collapse: collapse;
        }

        .info_table {
            margin-top: 20px;
        }

        .content {
            margin-top: 20px;
        }

        .table_content thead th {
            padding: 0;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 12px;
        }

        .table_content tbody td {
            padding: 0 2px;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 12px;
        }

        .total {
            margin-top: 20px;
        }

        .total_table tbody td {
            padding: 4px 2px;
            vertical-align: middle;
            border: 2px solid #000;
            font-size: 12px;
        }

        .footer {
            margin-top: 100px;
        }
    </style>
</head>

<body>
    <div class="page">
        <div class="main_body">
            <table class="table" style="text-align: center;">
                <tbody>
                    <tr>
                        <td>
                            <h2 style="margin-bottom: 0; font-size: 28px;"><?php echo $this->global_setting->brand_title; ?></h2>
                        </td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->address; ?></b></td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->email; ?></b></td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->phone; ?></b></td>
                    </tr>
                </tbody>
            </table>

            <!-- Content Start-->

            <div class="info_table">
                <table class="table">
                    <tbody>
                        <tr>
                            <td width="70%" align="left">
                                <?php if ($this->input->get('doctor_id')) { ?>
                                    <b>Consultant:</b>
                                    <span style="font-size: 12px; margin: 0; padding: 0;"><?php echo $doctor->doctor; ?>, <?php echo $doctor->specialist; ?></span>
                                <?php } elseif ($this->input->get('reference_person')) { ?>
                                    <b>Reference Person:</b>
                                    <span style="font-size: 12px; margin: 0; padding: 0;"><?php echo $reference_person->name; ?>, <?php echo $reference_person->phone; ?></span>
                                <?php } else { ?>
                                    <b>All:</b>
                                <?php } ?>
                            </td>
                            <td width="30%" align="right">
                                <b>Print Date:</b>
                                <span style="font-size: 12px;"><?php echo date('d/m/Y h:i A'); ?></span>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>

            <!-- Content Start-->
            <div class="content">
                <table class="table table_content">
                    <thead>
                        <tr>
                            <th style="width: 7%;">SL No</th>
                            <th style="width: 11%;">Bill No</th>
                            <th style="width: 12%;">Patient Name</th>
                            <th style="width: 9%;">Mobile</th>
                            <th style="width: 18%;">Doctor</th>
                            <th style="width: 18%;">Reference</th>
                            <th style="width: 5%;">Type</th>
                            <th style="width: 8%;">Amount</th>
                            <th style="width: 13%;">Created</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $count = 1;
                        $total_count_old_patient = 0;
                        $total_amount_old_patient = 0;
                        $total_count_new_patient = 0;
                        $total_amount_new_patient = 0;
                        $total_patient = 0;
                        $total_charge = 0;
                        $total_discount = 0;
                        foreach ($opds as $obj) {
                            $total_charge += $obj->doctor_charge;
                            $total_discount += $obj->discount;
                            if ($obj->old_patient) {
                                $total_count_old_patient += $obj->old_patient;
                                $total_amount_old_patient += $obj->doctor_charge;
                            }
                            if ($obj->old_patient == 0) {
                                $total_count_new_patient += 1;
                                $total_amount_new_patient += $obj->doctor_charge;
                            }
                        ?>
                            <tr>
                                <td align="center"><?php echo $count++; ?></td>
                                <td align="center"><?php echo $obj->custom_invoice_id; ?></td>
                                <td style="padding-left: 1px;"><?php echo $obj->patient; ?></td>
                                <td style="padding-left: 1px;"><?php echo $obj->phone; ?></td>
                                <td style="padding-left: 1px;"><?php echo $obj->doctor; ?></td>
                                <td style="padding-left: 1px;"><?php echo $obj->reference; ?></td>
                                <td align="center"><?php echo $obj->old_patient ? 'Old' : 'New'; ?></td>
                                <td align="center"><?php echo $obj->doctor_charge; ?></td>
                                <td style="padding-left: 1px;"><?php echo date('d/m/Y h:i A', strtotime($obj->created_at)); ?></td>
                            </tr>
                        <?php } ?>
                    </tbody>
                </table>
            </div>
            <!-- Content End -->
            <div class="total">
                <table class="table total_table">
                    <tbody>
                        <tr>
                            <td colspan="4" align="center">
                                <b>Statistics</b>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <b>Total Old Patient:</b>
                                <?php echo number_format($total_count_old_patient); ?>
                            </td>
                            <td>
                                <b>Total Amount:</b>
                                <?php echo number_format($total_amount_old_patient, 2); ?>
                            </td>
                            <td>
                                <b>Total New Patient:</b>
                                <?php echo number_format($total_count_new_patient); ?>
                            </td>
                            <td>
                                <b>Total Amount:</b>
                                <?php echo number_format($total_amount_new_patient, 2); ?>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <b>Total Patient:</b>
                                <?php echo number_format($total_count_old_patient + $total_count_new_patient); ?>
                            </td>
                            <td>
                                <b>Total Amount:</b>
                                <?php echo number_format($total_charge, 2); ?>
                            </td>
                            <td>
                                <b>Total Discount:</b>
                                <?php echo number_format($total_discount, 2); ?>
                            </td>
                            <td>
                                <b>Grand Total:</b>
                                <?php echo number_format($total_charge - $total_discount, 2); ?>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>

            <!-- Footer -->
            <div class="footer">
                <table class="table">
                    <tbody>
                        <tr>
                            <td width="70%">
                                <p style="margin-left: 10%;">
                                    <b>Prepared By:</b>
                                    <?php echo $this->session->userdata('name'); ?>
                                </p>
                            </td>
                            <td width="30%" align="center">
                                <p style="border-top: 1px dashed red; width: 30%; margin: 5px auto;"></p>
                                <b>Signature</b>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</body>

</html>