<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('report'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container-fluid">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('transaction'); ?> <?php echo $this->lang->line('report'); ?>
        </h4>
        <div class="align-items-center">
            <?php echo $this->load->view('header'); ?>
        </div>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <!-- col-lg-12 -->
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <?php echo form_open_multipart(site_url('report/mis/transaction_detail'), array('name' => 'search', 'id' => 'search', 'method' => 'get'), ''); ?>
                    <div class="form-row">
                        <div class="col-md-2 mb-10">
                            <label for="type"><?php echo $this->lang->line('type'); ?></label>
                            <select class="form-control custom-select" name="type" id="type">
                                <option selected value="0"><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('type'); ?></option>
                                <option value="1" <?php echo isset($type) && $type == 1 ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('paid'); ?></option>
                                <option value="2" <?php echo isset($type) && $type == 2 ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('unpaid'); ?></option>
                                <option value="3" <?php echo isset($type) && $type == 3 ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('no_reference'); ?></option>
                                <option value="4" <?php echo isset($type) && $type == 4 ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('reference'); ?></option>
                            </select>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="date"><?php echo $this->lang->line('date'); ?></label>
                            <input type="text" class="form-control" name="date" id="range" value="<?php echo isset($date) ?  $date : ''; ?>" placeholder="<?php echo $this->lang->line('date'); ?>" autocomplete="off">
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="reference_id"><?php echo $this->lang->line('reference'); ?></label>
                            <select class="form-control custom-select select2" name="reference_id" id="reference_id">
                                <option selected value="0"><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('reference'); ?></option>
                                <?php foreach ($references as $obj) { ?>
                                    <option value="<?php echo $obj->user_id; ?>" <?php echo isset($reference_id) && $reference_id == $obj->user_id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?> [<?php echo $obj->phone; ?>]</option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="created_by"><?php echo $this->lang->line('created_by'); ?></label>
                            <select class="form-control custom-select select2" name="created_by" id="created_by">
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('employee'); ?></option>
                                <?php foreach ($employees as $obj) { ?>
                                    <option value="<?php echo $obj->user_id; ?>" <?php echo isset($created_by) && $created_by == $obj->user_id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?> [<?php echo $obj->phone; ?>]</option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-1">
                            <button class="btn btn-gradient-primary mt-35" type="submit"><?php echo $this->lang->line('search'); ?></button>
                        </div>
                    </div>
                    <?php echo form_close(); ?>
                </div>
            </div>
        </div>

        <?php if ($_GET && $this->input->get('date')) { ?>
            <!-- Report Details -->
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between">
                        <?php if (has_permission(VIEW, 'report', 'mis')) { ?>
                            <h6 class="card-header d-flex align-items-center">
                                <i class="fa fa-exchange font-30 mr-10"></i>
                                <?php echo $this->lang->line('transaction'); ?> <?php echo $this->lang->line('detail'); ?> <?php echo $this->lang->line('report'); ?>
                            </h6>
                        <?php } ?>
                        <div class="button-list">
                            <a href="<?php echo site_url('report/mis/transaction_detail_pdf?type=' . $type . '&date=' . $date . '&reference_id=' . $reference_id . '&created_by=' . $created_by); ?>" class="btn btn-success btn-xs">
                                <i class="fa fa-download"></i> <?php echo $this->lang->line('pdf'); ?> <?php echo $this->lang->line('generate'); ?>
                            </a>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-wrap">
                            <div class="table-responsive">
                                <table class="table table-sm table-bordered mb-0">
                                    <thead>
                                        <tr>
                                            <th>SL No.</th>
                                            <th>Invoice ID</th>
                                            <th>ID</th>
                                            <th>Name</th>
                                            <th>Type</th>
                                            <th>Tr. Type</th>
                                            <th>Amount</th>
                                            <th>Remark</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        $sl = 1;
                                        $total_income_diagnostic_transaction = 0;
                                        $total_income_ipd_transaction = 0;
                                        $total_income_opd_transaction = 0;


                                        $total_expense_sd_diagnostic_payment = 0;
                                        $total_expense_sd_ipd_payment = 0;
                                        $total_expense_surgeon_payment = 0;
                                        $total_expense_anesthesia_payment = 0;
                                        $total_expense_assistant_payment = 0;
                                        $total_other_income = 0;
                                        $total_other_expense = 0;


                                        if (isset($diagnostic_transaction) && !empty($diagnostic_transaction)) { ?>
                                            <?php foreach ($diagnostic_transaction as $obj) {
                                                $total_income_diagnostic_transaction +=  $obj->advanced;
                                            ?>
                                                <tr>
                                                    <td><?php echo $sl++; ?></td>
                                                    <td><?php echo $obj->custom_invoice_id; ?></td>
                                                    <td><?php echo $obj->patient_unique_id; ?></td>
                                                    <td><?php echo $obj->patient; ?></td>
                                                    <td>Diagnostic</td>
                                                    <td>Income</td>
                                                    <td><?php echo $obj->advanced; ?></td>
                                                    <td><?php echo $obj->note; ?></td>
                                                </tr>
                                            <?php } ?>
                                        <?php } ?>


                                        <!-- IPD Transaction -->
                                        <?php if (isset($ipd_transaction) && !empty($ipd_transaction)) { ?>
                                            <?php foreach ($ipd_transaction as $obj) {
                                                $total_income_ipd_transaction +=  $obj->amount;
                                            ?>
                                                <tr>
                                                    <td><?php echo $sl++; ?></td>
                                                    <td><?php echo $obj->custom_invoice_id; ?></td>
                                                    <td><?php echo $obj->patient_unique_id; ?></td>
                                                    <td><?php echo $obj->patient; ?></td>
                                                    <td>IPD</td>
                                                    <td>Income</td>
                                                    <td><?php echo $obj->amount; ?></td>
                                                    <td><?php echo $obj->note; ?></td>
                                                </tr>
                                            <?php } ?>
                                        <?php } ?>

                                        <!-- OPD Transaction -->
                                        <?php if (isset($opd_transaction) && !empty($opd_transaction)) { ?>
                                            <?php foreach ($opd_transaction as $obj) {
                                                $total_income_opd_transaction +=  $obj->doctor_charge;
                                            ?>
                                                <tr>
                                                    <td><?php echo $sl++; ?></td>
                                                    <td><?php echo $obj->custom_invoice_id; ?></td>
                                                    <td><?php echo $obj->patient_unique_id; ?></td>
                                                    <td><?php echo $obj->patient; ?></td>
                                                    <td>OPD</td>
                                                    <td>Income</td>
                                                    <td><?php echo $obj->doctor_charge; ?></td>
                                                    <td><?php echo $obj->note; ?></td>
                                                </tr>
                                            <?php } ?>
                                        <?php } ?>

                                        <!-- SD Payment Transaction -->
                                        <?php if (isset($sd_diagnostic_payment) && !empty($sd_diagnostic_payment)) { ?>
                                            <?php foreach ($sd_diagnostic_payment as $obj) {
                                                $total_expense_sd_diagnostic_payment +=  $obj->payable_amount;
                                            ?>
                                                <tr>
                                                    <td><?php echo $sl++; ?></td>
                                                    <td><?php echo $obj->custom_invoice_id; ?></td>
                                                    <td><?php echo $obj->sd_id; ?></td>
                                                    <td><?php echo $obj->sd_name; ?></td>
                                                    <td>SD Comm.</td>
                                                    <td>Expense</td>
                                                    <td><?php echo $obj->payable_amount; ?></td>
                                                    <td><?php echo $obj->note; ?></td>
                                                </tr>
                                            <?php } ?>
                                        <?php } ?>

                                        <!-- IPD Payment Transaction -->
                                        <?php if (isset($sd_ipd_payment) && !empty($sd_ipd_payment)) { ?>
                                            <?php foreach ($sd_ipd_payment as $obj) {
                                                $total_expense_sd_ipd_payment +=  $obj->payable_amount;
                                            ?>
                                                <tr>
                                                    <td><?php echo $sl++; ?></td>
                                                    <td><?php echo $obj->custom_invoice_id; ?></td>
                                                    <td><?php echo $obj->sd_id; ?></td>
                                                    <td><?php echo $obj->sd_name; ?></td>
                                                    <td>IPD Comm.</td>
                                                    <td>Expense</td>
                                                    <td><?php echo $obj->payable_amount; ?></td>
                                                    <td><?php echo $obj->note; ?></td>
                                                </tr>
                                            <?php } ?>
                                        <?php } ?>

                                        <!-- Surgeon Payment Transaction -->
                                        <?php if (isset($surgeon_payment) && !empty($surgeon_payment)) { ?>
                                            <?php foreach ($surgeon_payment as $obj) {
                                                $total_expense_surgeon_payment +=  $obj->payable_amount;
                                            ?>
                                                <tr>
                                                    <td><?php echo $sl++; ?></td>
                                                    <td><?php echo $obj->custom_invoice_id; ?></td>
                                                    <td><?php echo $obj->surgeon_id; ?></td>
                                                    <td><?php echo $obj->surgeon_name; ?></td>
                                                    <td>Surgeon</td>
                                                    <td>Expense</td>
                                                    <td><?php echo $obj->payable_amount; ?></td>
                                                    <td><?php echo $obj->note; ?></td>
                                                </tr>
                                            <?php } ?>
                                        <?php } ?>

                                        <!-- Anesthesia Payment Transaction -->
                                        <?php if (isset($anesthesia_payment) && !empty($anesthesia_payment)) { ?>
                                            <?php foreach ($anesthesia_payment as $obj) {
                                                $total_expense_anesthesia_payment +=  $obj->payable_amount;
                                            ?>
                                                <tr>
                                                    <td><?php echo $sl++; ?></td>
                                                    <td><?php echo $obj->custom_invoice_id; ?></td>
                                                    <td><?php echo $obj->anesthesia_id; ?></td>
                                                    <td><?php echo $obj->anesthesia_name; ?></td>
                                                    <td>Anesthesia</td>
                                                    <td>Expense</td>
                                                    <td><?php echo $obj->payable_amount; ?></td>
                                                    <td><?php echo $obj->note; ?></td>
                                                </tr>
                                            <?php } ?>
                                        <?php } ?>

                                        <!-- Assistant Payment Transaction -->
                                        <?php if (isset($assistant_payment) && !empty($assistant_payment)) { ?>
                                            <?php foreach ($assistant_payment as $obj) {
                                                $total_expense_assistant_payment +=  $obj->payable_amount;
                                            ?>
                                                <tr>
                                                    <td><?php echo $sl++; ?></td>
                                                    <td><?php echo $obj->custom_invoice_id; ?></td>
                                                    <td><?php echo $obj->assistant_id; ?></td>
                                                    <td><?php echo $obj->assistant_name; ?></td>
                                                    <td>Assistant</td>
                                                    <td>Expense</td>
                                                    <td><?php echo $obj->payable_amount; ?></td>
                                                    <td><?php echo $obj->note; ?></td>
                                                </tr>
                                            <?php } ?>
                                        <?php } ?>

                                        <!-- Other Income Transaction -->
                                        <?php if (isset($other_income) && !empty($other_income)) { ?>
                                            <?php foreach ($other_income as $obj) {
                                                $total_other_income +=  $obj->amount;
                                            ?>
                                                <tr>
                                                    <td><?php echo $sl++; ?></td>
                                                    <td><?php echo $obj->custom_invoice_id; ?></td>
                                                    <td></td>
                                                    <td><?php echo $obj->income_head; ?></td>
                                                    <td>Other</td>
                                                    <td>Income</td>
                                                    <td><?php echo $obj->amount; ?></td>
                                                    <td><?php echo $obj->note; ?></td>
                                                </tr>
                                            <?php } ?>
                                        <?php } ?>

                                        <!-- Other Expense Transaction -->
                                        <?php if (isset($other_expense) && !empty($other_expense)) { ?>
                                            <?php foreach ($other_expense as $obj) {
                                                $total_other_expense +=  $obj->amount;
                                            ?>
                                                <tr>
                                                    <td><?php echo $sl++; ?></td>
                                                    <td><?php echo $obj->custom_invoice_id; ?></td>
                                                    <td></td>
                                                    <td><?php echo $obj->expense_head; ?></td>
                                                    <td>Other</td>
                                                    <td>Expense</td>
                                                    <td><?php echo $obj->amount; ?></td>
                                                    <td><?php echo $obj->note; ?></td>
                                                </tr>
                                            <?php } ?>
                                        <?php } ?>
                                    </tbody>
                                </table>

                                <!-- Total -->
                                <table class="table table-sm table-bordered mt-4" style="width: 50%; margin: 0 auto;">
                                    <tbody>
                                        <tr>
                                            <th class="text-right font-weight-600">Total Hospital Income</th>
                                            <th class="text-left font-weight-600">
                                                <?php echo $this->global_setting->currency_symbol; ?>
                                                <?php $total_grand_income = ($total_income_diagnostic_transaction + $total_income_ipd_transaction + $total_income_opd_transaction + $total_other_income); ?>
                                                <?php echo number_format(($total_grand_income), 2);
                                                ?>
                                            </th>
                                        </tr>
                                        <tr>
                                            <th class="text-right font-weight-600">Total Hospital Expense</th>
                                            <th class="text-left font-weight-600">
                                                <?php echo $this->global_setting->currency_symbol; ?>
                                                <?php $total_grand_expense = ($total_expense_sd_diagnostic_payment + $total_expense_sd_ipd_payment + $total_expense_surgeon_payment + $total_expense_anesthesia_payment + $total_expense_assistant_payment + $total_other_expense); ?>
                                                <?php echo number_format(($total_grand_expense), 2);
                                                ?>
                                            </th>
                                        </tr>
                                        <tr>
                                            <th class="text-right font-weight-600">Total Hospital Balance</th>
                                            <th class="text-left font-weight-600">
                                                <?php echo $this->global_setting->currency_symbol; ?>
                                                <?php echo number_format(($total_grand_income - $total_grand_expense), 2);
                                                ?>
                                            </th>
                                        </tr>
                                    </tbody>
                                </table>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php } ?>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->


<!-- Daterangepicker -->
<link href="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>moment/min/moment.min.js"></script>
<script src="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.js"></script>

<!-- Select2 -->
<link href="<?php echo VENDOR_URL; ?>select2/dist/css/select2.min.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>select2/dist/js/select2.full.min.js"></script>

<style>
    .select2-container .select2-selection--single {
        height: calc(2.25rem + 4px) !important;
    }

    .select2-container--default .select2-search--dropdown .select2-search__field {
        color: #324148;
        border-width: 2px;
        border-color: #e0e3e4;
        padding: .375rem .75rem;
        height: calc(2.25rem + 4px);
    }

    .select2-container--default .select2-selection--single .select2-selection__arrow b {
        margin-top: 5px;
    }
</style>
<script>
    $(".select2").select2();
    $('#range').daterangepicker({
        // autoUpdateInput: false,
        startDate: new Date(),
        endDate: moment(),
        showDropdowns: true,
        minYear: 1901,
        locale: {
            format: 'YYYY/MM/DD',
        },
        ranges: {
            'Today': [moment(), moment()],
            'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
            'Tomorrow': [moment().subtract(-1, 'days'), moment().subtract(-1, 'days')],
            'Last 7 Days': [moment().subtract(6, 'days'), moment()],
            'Last 30 Days': [moment().subtract(29, 'days'), moment()],
            'This Month': [moment().startOf('month'), moment().endOf('month')],
            'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            'This Year': [moment().startOf('year'), moment().endOf('year')],
            'Last Year': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')]
        }
    });

    // $('input[id="range"]').on('apply.daterangepicker', function(ev, picker) {
    //     $(this).val(picker.startDate.format('YYYY/MM/DD') + ' - ' + picker.endDate.format('YYYY/MM/DD'));
    // });

    // $('input[id="range"]').on('cancel.daterangepicker', function(ev, picker) {
    //     $(this).val('');
    // });
</script>