<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('report'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container-fluid">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('mis'); ?> <?php echo $this->lang->line('report'); ?>
        </h4>
        <div class="d-flex">
            <?php if (has_permission(VIEW, 'report', 'opd')) { ?>
                <a href="<?php echo site_url('report/opd'); ?>" class="btn btn-primary btn-sm mr-15"><?php echo $this->lang->line('opd'); ?> <?php echo $this->lang->line('report'); ?></a>
            <?php } ?>
            <?php if (has_permission(VIEW, 'report', 'appointment')) { ?>
                <a href="<?php echo site_url('report/appointment'); ?>" class="btn btn-success btn-sm mr-15"><?php echo $this->lang->line('appointment'); ?> <?php echo $this->lang->line('report'); ?></a>
            <?php } ?>
        </div>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <?php if (has_permission(VIEW, 'report', 'mis')) { ?>
            <div class="col-lg-3 col-md-4 col-sm-6 col-xs-12 mb-30">
                <div class="card text-white bg-gradient-primary">
                    <div class="card-header font-weight-bold font-18">
                        <i class="fa fa-money"></i>
                        <?php echo $this->lang->line('hospital'); ?> <?php echo $this->lang->line('credit'); ?>
                    </div>
                    <div class="card-body text-center" style="min-height: 100px;">
                        <a href="<?php echo site_url('report/mis/credit'); ?>" class="btn btn-success">
                            <?php echo $this->lang->line('view'); ?> <?php echo $this->lang->line('credit'); ?>
                        </a>
                    </div>
                </div>
            </div>
        <?php } ?>

        <?php if (has_permission(VIEW, 'report', 'mis')) { ?>
            <div class="col-lg-3 col-md-4 col-sm-6 col-xs-12 mb-30">
                <div class="card text-white bg-gradient-success">
                    <div class="card-header font-weight-bold font-18">
                        <i class="fa fa-exchange"></i>
                        <?php echo $this->lang->line('hospital'); ?> <?php echo $this->lang->line('transaction'); ?>
                    </div>
                    <div class="card-body text-center" style="min-height: 100px;">
                        <a href="<?php echo site_url('report/mis/transaction'); ?>" class="btn btn-success">
                            <?php echo $this->lang->line('view'); ?> <?php echo $this->lang->line('transaction'); ?>
                        </a>
                    </div>
                </div>
            </div>
        <?php } ?>

        <?php if (has_permission(VIEW, 'report', 'mis')) { ?>
            <div class="col-lg-3 col-md-4 col-sm-6 col-xs-12 mb-30">
                <div class="card text-white bg-gradient-info">
                    <div class="card-header font-weight-bold font-18">
                        <i class="fa fa-exchange"></i>
                        <?php echo $this->lang->line('transaction'); ?> <?php echo $this->lang->line('detail'); ?>
                    </div>
                    <div class="card-body text-center" style="min-height: 100px;">
                        <a href="<?php echo site_url('report/mis/transaction_detail'); ?>" class="btn btn-success">
                            <?php echo $this->lang->line('view'); ?> <?php echo $this->lang->line('transaction'); ?>
                        </a>
                    </div>
                </div>
            </div>
        <?php } ?>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->