<!DOCTYPE html>
<html>

<head>
    <title>Employee</title>
    <style>
        body {
            font-family: "Time New Roman";
            font-size: 13px;
        }

        .page {
            width: 100%;
            margin: 0 auto;
        }

        .main_body {
            width: 100%;
            display: block;
        }

        .table {
            width: 100%;
            border-collapse: collapse;
        }

        .info_table {
            margin-top: 20px;
        }

        .content {
            margin-top: 20px;
        }

        .table_content thead th {
            padding: 0;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 12px;
            padding: 0 2px;
        }

        .table_content tbody td {
            padding: 0 2px;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 12px;
        }

        .total {
            margin-top: 20px;
        }

        .total_table tbody td {
            padding: 2px 2px;
            vertical-align: middle;
            border: 2px solid #000;
            font-size: 12px;
        }

        .footer {
            margin-top: 100px;
        }
    </style>
</head>

<body>
    <div class="page">
        <div class="main_body">
            <table class="table" style="text-align: center;">
                <tbody>
                    <tr>
                        <td>
                            <h2 style="margin-bottom: 0; font-size: 28px;"><?php echo $this->global_setting->brand_title; ?></h2>
                        </td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->address; ?></b></td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->email; ?></b></td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->phone; ?></b></td>
                    </tr>
                </tbody>
            </table>

            <!-- Content Start-->
            <h2 align="center">EMPLOYEE EVALUATION REPORT</h2>
            <div class="info_table">
                <table class="table">
                    <tbody>
                        <tr>
                            <td width="80%" align="left">
                                <?php if (isset($reference_person) && !empty($reference_person)) { ?>
                                    <b>Employee:</b>
                                    <span style="font-size: 12px; margin: 0; padding: 0;">
                                        <?php echo $reference->name; ?>, <?php echo $reference->phone; ?>
                                    </span>
                                <?php } else { ?>
                                    <b>Employee:</b>
                                    <span style="font-size: 12px; margin: 0; padding: 0;">
                                        All
                                    </span>
                                <?php } ?>
                            </td>
                            <td width="20%" align="right">
                                <b>Date:</b>
                                <span style="font-size: 12px;"><?php echo date('d/m/Y h:i A'); ?></span>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>

            <!-- Content Start-->
            <div class="content">
                <table class="table table_content">
                    <thead>
                        <tr>
                            <?php if ($reference_person) { ?>
                                <th><?php echo $this->lang->line('sl_no'); ?></th>
                                <th><?php echo $this->lang->line('invoice_no'); ?></th>
                                <th><?php echo $this->lang->line('date'); ?></th>
                                <th><?php echo $this->lang->line('patient_id'); ?></th>
                                <th><?php echo $this->lang->line('patient'); ?> <?php echo $this->lang->line('name'); ?></th>
                                <th><?php echo $this->lang->line('doctor'); ?></th>
                                <th><?php echo $this->lang->line('total'); ?> <?php echo $this->lang->line('bill'); ?></th>
                                <th><?php echo $this->lang->line('discount'); ?></th>
                                <th><?php echo $this->lang->line('advanced'); ?></th>
                                <th><?php echo $this->lang->line('due'); ?></th>
                                <th><?php echo $this->lang->line('total'); ?></th>
                            <?php } else { ?>
                                <th style="width:5%;"><?php echo $this->lang->line('sl_no'); ?></th>
                                <th style="width:30%;"><?php echo $this->lang->line('name'); ?></th>
                                <th style="width:20%;"><?php echo $this->lang->line('designation'); ?></th>
                                <th style="width:15%;"><?php echo $this->lang->line('phone'); ?></th>
                                <th style="width:10%;"><?php echo $this->lang->line('blood_group'); ?></th>
                                <th style="width:10%;"><?php echo $this->lang->line('join_date'); ?></th>
                                <th style="width:10%;"><?php echo $this->lang->line('total'); ?></th>
                            <?php } ?>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $count = 1;
                        $total = 0;
                        if (isset($employees) && !empty($employees)) { ?>
                            <?php foreach ($employees as $obj) {
                                $total += $reference_person ? 1 : $obj->total;
                            ?>
                                <tr>
                                    <?php if ($reference_person) { ?>
                                        <td><?php echo $count++; ?></td>
                                        <td><?php echo $obj->custom_invoice_id; ?></td>
                                        <td><?php echo date('d/m/Y h:i A', strtotime($obj->bill_date)); ?></td>
                                        <td><?php echo $obj->patient_unique_id; ?></td>
                                        <td><?php echo $obj->patient; ?></td>
                                        <td><?php echo $obj->doctor; ?></td>
                                        <td><?php echo $obj->total_bill; ?></td>
                                        <td><?php echo $obj->discount; ?></td>
                                        <td><?php echo $obj->advanced; ?></td>
                                        <td><?php echo $obj->due_amount; ?></td>
                                        <td>1</td>
                                    <?php } else { ?>
                                        <td><?php echo $count++; ?></td>
                                        <td><?php echo $obj->employee; ?></td>
                                        <td><?php echo $obj->designation; ?></td>
                                        <td><?php echo $obj->phone; ?></td>
                                        <td><?php echo $obj->blood_group ? $this->lang->line($obj->blood_group) : ''; ?></td>
                                        <td><?php echo $obj->joining_date ? date('M d, Y', strtotime($obj->joining_date)) : ''; ?></td>
                                        <td><?php echo $obj->total; ?></td>
                                    <?php } ?>
                                </tr>
                            <?php } ?>
                        <?php } ?>
                        <tr>
                            <?php if ($reference_person) { ?>
                                <th colspan="10" align="right" style="padding-right: 5px;">Grand Total</th>
                            <?php } else { ?>
                                <th colspan="6" align="right" style="padding-right: 5px;">Grand Total</th>
                            <?php } ?>
                            <th align="left" style="padding-left: 5px;"><?php echo number_format($total, 2); ?></th>
                        </tr>
                    </tbody>
                </table>
            </div>
            <!-- Content End -->
            <!-- Footer -->
            <div class="footer">
                <table class="table">
                    <tbody>
                        <tr>
                            <td width="70%">
                                <p style="margin-left: 10%;">
                                    <b>Prepared By:</b>
                                    <?php echo $this->session->userdata('name'); ?>
                                </p>
                            </td>
                            <td width="30%" align="center">
                                <p style="border-top: 1px dashed red; width: 30%; margin: 5px auto;"></p>
                                <b>Signature</b>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</body>

</html>