<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Opd_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }
    public function get_doctor_list() {
        $this->db->select('C.*, E.name, E.phone, E.user_id');
        $this->db->from('doctor_charges AS C');
        $this->db->join('employees AS E', 'E.user_id = C.doctor_id', 'left');
        $this->db->join('users AS U', 'U.id = E.user_id', 'left');
        $this->db->where('U.role_id', DOCTOR);
        $this->db->where('E.status', 1);
        $this->db->order_by('E.id', 'ASC');
        return $this->db->get()->result();
    }

    public function get_employee_list() {
        $this->db->select('E.*');
        $this->db->from('employees AS E');
        $this->db->join('users AS U', 'U.id = E.user_id', 'left');
        $this->db->where('E.status', '1');
        if ($this->session->userdata('role_id') == SUPER_ADMIN) {
            $this->db->where_in('U.role_id', array(SUPER_ADMIN, ADMIN, ACCOUNTANT, RECEPTIONIST));
        } else {
            $this->db->where_in('U.role_id', array(ADMIN, ACCOUNTANT, RECEPTIONIST));
        }
        $this->db->order_by('E.id ', 'DESC');
        return $this->db->get()->result();
    }

    public function get_reference_person_list() {
        $this->db->select('E.*');
        $this->db->from('employees AS E');
        $this->db->join('users AS U', 'U.id = E.user_id', 'left');
        $this->db->where('E.commission_type', 'emp');
        $this->db->where('E.status', '1');
        $this->db->order_by('E.id ', 'DESC');
        return $this->db->get()->result();
    }

    public function get_opd_list($keyword, $type, $form_date, $to_date, $doctor_id, $reference_id, $reference_person, $created_by) {
        $this->db->select('OP.*, P.patient_unique_id, P.name as patient, P.phone, P.old_patient, D.name as doctor, R.name as reference');
        $this->db->from('opd_patients AS OP');
        $this->db->join('patients AS P', 'P.user_id = OP.patient_id', 'left');
        $this->db->join('employees AS D', 'D.user_id = OP.doctor_id', 'left');
        $this->db->join('employees AS R', 'R.user_id = OP.reference_id', 'left');
        if ($keyword) {
            $this->db->like('P.patient_unique_id', $keyword);
            $this->db->or_like('P.name', $keyword, 'both');
            $this->db->or_like('P.phone', $keyword, 'both');
            $this->db->or_like('D.name', $keyword, 'both');
            $this->db->or_like('R.name', $keyword, 'both');
        }
        if ($type == 1) {
            $this->db->group_start();
            $this->db->where('OP.reference_id', 0);
            $this->db->or_where('OP.reference_id', NULL);
            $this->db->or_where('OP.reference_id', '');
            $this->db->group_end();
        }
        if ($type == 2) {
            $this->db->where('OP.reference_id >', 0);
        }
        if ($form_date && $to_date) {
            $this->db->where("DATE(OP.created_at) BETWEEN '$form_date' AND '$to_date'");
        }
        if ($doctor_id) {
            $this->db->where('OP.doctor_id', $doctor_id);
        }
        if ($reference_id) {
            $this->db->where('OP.reference_id', $reference_id);
        }
        if ($reference_person) {
            $this->db->where('OP.reference_person', $reference_person);
        }
        if ($created_by) {
            $this->db->where('OP.created_by', $created_by);
        }
        $this->db->where('OP.payment_status', 'complete');
        $this->db->order_by('OP.id', 'ASC');
        return $this->db->get()->result();
    }

    public function get_single_doctor($doctor_id) {
        $this->db->select('OP.*, E.name as doctor, E.specialist');
        $this->db->from('opd_patients AS OP');
        $this->db->join('employees AS E', 'E.user_id = OP.doctor_id', 'left');
        if ($doctor_id) {
            $this->db->where('OP.doctor_id', $doctor_id);
        }
        return $this->db->get()->row();
    }
}
