<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Appointment_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }
    public function get_doctor_list() {
        $this->db->select('C.*, E.name, E.phone, E.user_id');
        $this->db->from('doctor_charges AS C');
        $this->db->join('employees AS E', 'E.user_id = C.doctor_id', 'left');
        $this->db->join('users AS U', 'U.id = E.user_id', 'left');
        $this->db->where('U.role_id', DOCTOR);
        $this->db->where('E.status', 1);
        $this->db->order_by('E.id', 'ASC');
        return $this->db->get()->result();
    }
    public function get_employee_list() {
        $this->db->select('E.*');
        $this->db->from('employees AS E');
        $this->db->join('users AS U', 'U.id = E.user_id', 'left');
        $this->db->where('E.status', '1');
        if ($this->session->userdata('role_id') == SUPER_ADMIN) {
            $this->db->where_in('U.role_id', array(SUPER_ADMIN, ADMIN, ACCOUNTANT, RECEPTIONIST, MARKETING));
        } else {
            $this->db->where_in('U.role_id', array(ADMIN, ACCOUNTANT, RECEPTIONIST, MARKETING));
        }
        $this->db->order_by('E.id ', 'DESC');
        return $this->db->get()->result();
    }
    public function get_appointment_list($keyword, $type, $form_date, $to_date, $doctor_id, $reference_id, $created_by) {
        $this->db->select('A.*, D.name as doctor, R.name as reference');
        $this->db->from('appointments AS A');
        $this->db->join('employees AS D', 'D.user_id = A.doctor_id', 'left');
        $this->db->join('employees AS R', 'R.user_id = A.reference_id', 'left');
        if ($keyword) {
            $this->db->like('A.phone', $keyword);
            $this->db->or_like('A.name', $keyword, 'both');
            $this->db->or_like('D.name', $keyword, 'both');
            $this->db->or_like('R.name', $keyword, 'both');
            $this->db->or_like('A.gender', $keyword, 'both');
            $this->db->or_like('A.serial_no', $keyword, 'both');
            $this->db->or_like('A.address', $keyword, 'both');
        }
        if ($type == 1) {
            $this->db->group_start();
            $this->db->where('A.reference_id', 0);
            $this->db->or_where('A.reference_id', NULL);
            $this->db->or_where('A.reference_id', '');
            $this->db->group_end();
        }
        if ($type == 2) {
            $this->db->where('A.reference_id >', 0);
        }
        if ($form_date && $to_date) {
            $this->db->where("DATE(A.date) BETWEEN '$form_date' AND '$to_date'");
        }
        if ($doctor_id) {
            $this->db->where('A.doctor_id', $doctor_id);
        }
        if ($reference_id) {
            $this->db->where('A.reference_id', $reference_id);
        }
        if ($created_by) {
            $this->db->where('A.created_by', $created_by);
        }
        $this->db->order_by('A.serial_no', 'ASC');
        return $this->db->get()->result();
    }

    public function get_single_doctor($doctor_id) {
        $this->db->select('A.*, E.name as doctor, E.specialist');
        $this->db->from('appointments AS A');
        $this->db->join('employees AS E', 'E.user_id = A.doctor_id', 'left');
        if ($doctor_id) {
            $this->db->where('A.doctor_id', $doctor_id);
        }
        return $this->db->get()->row();
    }
}
