<?php

defined('BASEPATH') or exit('No direct script access allowed');

/* * *****************Employee.php**********************************
 * @product name    : Hospital Management System
 * @type            : Class
 * @class name      : Employee
 * @description     : Manage employee report.
 * @author          : South Bangla IT Zone Team
 * @url             : http://hms.sbitzone.com
 * @support         : rabibd.it@gmail.com
 * @copyright       : South Bangla IT Zone Team
 * ********************************************************** */

class Employee extends MY_Controller {

    public $data = array();

    function __construct() {
        parent::__construct();
        $this->load->model('Employee_Model', 'employee', true);
    }

    /*****************Function index**********************************
     * @type            : Function
     * @function name   : index
     * @description     : Load "Employee Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function index() {

        check_permission(VIEW);

        if ($_GET) {
            $keyword = trim($this->input->get('keyword'));
            $role_id = $this->input->get('role_id');
            $commission_type = $this->input->get('commission_type');
            $department_id = $this->input->get('department_id');
            $designation_id = $this->input->get('designation_id');
            $gender = $this->input->get('gender');
            $religion = $this->input->get('religion');
            $blood_group = $this->input->get('blood_group');
            $this->data['employees'] = $this->employee->get_employee_list($keyword, $role_id, $commission_type, $department_id, $designation_id, $gender, $religion, $blood_group);

            $this->data['keyword'] = $keyword;
            $this->data['role_id'] = $role_id;
            $this->data['commission_type'] = $commission_type;
            $this->data['department_id'] = $department_id;
            $this->data['designation_id'] = $designation_id;
            $this->data['gender'] = $gender;
            $this->data['religion'] = $religion;
            $this->data['blood_group'] = $blood_group;
            $this->data['role'] = $this->employee->get_single('roles', array('id' => $role_id));
        }
        $this->data['roles'] = $this->employee->get_list('roles', array('status' => 1), '', '', '', 'id', 'ASC');
        $this->data['departments'] = $this->employee->get_list('departments', array('status' => 1), '', '', '', 'id', 'ASC');

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('employee') . ' ' . $this->lang->line('report') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('report/employee/index', $this->data);
    }

    public function pdf() {
        if ($_GET) {
            $keyword = trim($this->input->get('keyword'));
            $role_id = $this->input->get('role_id');
            $commission_type = $this->input->get('commission_type');
            $department_id = $this->input->get('department_id');
            $designation_id = $this->input->get('designation_id');
            $gender = $this->input->get('gender');
            $religion = $this->input->get('religion');
            $blood_group = $this->input->get('blood_group');

            $this->data['employees'] = $this->employee->get_employee_list($keyword, $role_id, $commission_type, $department_id, $designation_id, $gender, $religion, $blood_group);
            $this->data['role'] = $this->employee->get_single('roles', array('id' => $role_id));
            $this->data['department'] = $this->employee->get_single('departments', array('id' => $department_id));
            $this->data['role_id'] = $role_id;
            $this->data['department_id'] = $department_id;

            $this->load->library('pdf');
            $mpdf = new \Mpdf\Mpdf([
                'mode' => 'utf-8',
                'orientation' => 'L'
            ]);
            $html =  $this->load->view('report/employee/pdf', $this->data, true);
            $mpdf->WriteHTML($html);
            $mpdf->Output('employee_' . date('Y-m-d') . '.pdf', 'D');
        }
    }
}
