<?php

defined('BASEPATH') or exit('No direct script access allowed');

/* * *****************Diagnostic.php**********************************
 * @product name    : Hospital Management System
 * @type            : Class
 * @class name      : Diagnostic
 * @description     : Manage diagnostic report.
 * @author          : South Bangla IT Zone Team
 * @url             : http://hms.sbitzone.com
 * @support         : rabibd.it@gmail.com
 * @copyright       : South Bangla IT Zone Team
 * ********************************************************** */

class Diagnostic extends MY_Controller {

    public $data = array();

    function __construct() {
        parent::__construct();
        $this->load->model('Diagnostic_Model', 'diagnostic', true);
    }

    /*****************Function index**********************************
     * @type            : Function
     * @function name   : index
     * @description     : Load "Diagnostic Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function index() {

        check_permission(VIEW);

        if ($_GET) {
            $keyword = trim($this->input->get('keyword'));
            $special_discount = $this->input->get('special_discount');
            $department_id = $this->input->get('department_id');
            $group_id = $this->input->get('group_id');

            $this->data['diagnostics'] = $this->diagnostic->get_diagnostic_list($keyword, $special_discount, $department_id, $group_id);
            $this->data['keyword'] = $keyword;
            $this->data['special_discount'] = $special_discount;
            $this->data['department_id'] = $department_id;
            $this->data['group_id'] = $group_id;
            $this->data['department'] = $this->diagnostic->get_single('diagnostic_departments', array('id' => $department_id));
        }
        $this->data['departments'] = $this->diagnostic->get_list('diagnostic_departments', array('status' => 1), '', '', '', 'sort_by', 'ASC');
        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('diagnostic') . ' ' . $this->lang->line('report') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('report/diagnostic/index', $this->data);
    }

    public function pdf() {
        if ($_GET) {
            $keyword = trim($this->input->get('keyword'));
            $special_discount = $this->input->get('special_discount');
            $department_id = $this->input->get('department_id');
            $group_id = $this->input->get('group_id');

            $this->data['diagnostics'] = $this->diagnostic->get_diagnostic_list($keyword, $special_discount, $department_id, $group_id);
            $this->data['keyword'] = $keyword;
            $this->data['special_discount'] = $special_discount;
            $this->data['department'] = $this->diagnostic->get_single('diagnostic_departments', array('id' => $department_id));

            $this->data['department_id'] = $department_id;
            $this->data['group_id'] = $group_id;
            $this->load->library('pdf');
            $mpdf = new \Mpdf\Mpdf([
                'mode' => 'utf-8',
                'orientation' => 'L'
            ]);
            $html =  $this->load->view('report/diagnostic/pdf', $this->data, true);
            $mpdf->WriteHTML($html);
            $mpdf->Output('diagnostic_' . date('Y-m-d') . '.pdf', 'D');
        }
    }
}
