<?php

defined('BASEPATH') or exit('No direct script access allowed');

/* * *****************Billing.php**********************************
 * @product name    : Hospital Management System
 * @type            : Class
 * @class name      : Billing
 * @description     : Manage billing report.
 * @author          : South Bangla IT Zone Team
 * @url             : http://hms.sbitzone.com
 * @support         : rabibd.it@gmail.com
 * @copyright       : South Bangla IT Zone Team
 * ********************************************************** */

class Billing extends MY_Controller {

    public $data = array();

    function __construct() {
        parent::__construct();
        $this->load->model('Billing_Model', 'billing', true);

        $this->data['doctors'] = $this->billing->get_doctor_list();
        $this->data['references'] = $this->billing->get_list('employees', array('status' => 1));
        $this->data['employees'] = $this->billing->get_employee_list();
        $this->data['reference_persons'] = $this->billing->get_reference_person_list();
    }

    /*****************Function index**********************************
     * @type            : Function
     * @function name   : index
     * @description     : Load "Billing Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function index() {

        check_permission(VIEW);

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('billing') . ' ' . $this->lang->line('report') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('report/billing/index', $this->data);
    }

    /*****************Function collection**********************************
     * @type            : Function
     * @function name   : collection
     * @description     : Load "Collection Billing Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function collection() {

        check_permission(VIEW);

        if ($_GET) {
            $collection_type = $this->input->get('collection_type');
            $keyword = trim($this->input->get('keyword'));
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $doctor_id = $this->input->get('doctor_id');
            $reference_id = $this->input->get('reference_id');
            $created_by = $this->input->get('created_by');

            $this->data['collections'] = $this->billing->get_collection_list($collection_type, $keyword, $form_date, $to_date, $doctor_id, $reference_id, $created_by);
            $this->data['collection_type'] = $collection_type;
            $this->data['keyword'] = $keyword;
            $this->data['date'] = $date;
            $this->data['doctor_id'] = $doctor_id;
            $this->data['reference_id'] = $reference_id;
            $this->data['created_by'] = $created_by;
        }

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('collection') . ' ' . $this->lang->line('report') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('report/billing/collection', $this->data);
    }

    /*****************Function collection_pdf**********************************
     * @type            : Function
     * @function name   : collection_pdf
     * @description     : Load "Generate Collection Billing Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function collection_pdf() {
        if ($_GET) {
            $collection_type = $this->input->get('collection_type');
            $keyword = trim($this->input->get('keyword'));
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $doctor_id = $this->input->get('doctor_id');
            $reference_id = $this->input->get('reference_id');
            $created_by = $this->input->get('created_by');

            $this->data['collections'] = $this->billing->get_collection_list($collection_type, $keyword, $form_date, $to_date, $doctor_id, $reference_id, $created_by);
            $this->data['collection_type'] = $collection_type;
            $this->data['keyword'] = $keyword;
            $this->data['date'] = $date;
            $this->data['doctor_id'] = $doctor_id;
            $this->data['reference_id'] = $reference_id;
            $this->data['created_by'] = $created_by;
            $this->data['createdby'] = $this->billing->get_single('employees', array('user_id' => $created_by, 'status' => 1));
            $this->data['doctor'] = $this->billing->get_single('employees', array('user_id' => $doctor_id, 'status' => 1));

            $this->load->library('pdf');
            $mpdf = new \Mpdf\Mpdf([
                'mode' => 'utf-8',
                'orientation' => 'L'
            ]);
            $html =  $this->load->view('report/billing/pdf/collection', $this->data, true);
            $mpdf->WriteHTML($html);
            $mpdf->Output('collection_' . rand() . '.pdf', 'D');
        }
    }

    /*****************Function due**********************************
     * @type            : Function
     * @function name   : due
     * @description     : Load "Due Billing Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function due() {

        check_permission(ADD);
        if ($_GET) {
            $keyword = trim($this->input->get('keyword'));
            $type = $this->input->get('type');
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $doctor_id = $this->input->get('doctor_id');
            $reference_id = $this->input->get('reference_id');
            $created_by = $this->input->get('created_by');

            $this->data['dues'] = $this->billing->get_due_list($keyword, $type, $form_date, $to_date, $doctor_id, $reference_id, $created_by);
            $this->data['keyword'] = $keyword;
            $this->data['type'] = $type;
            $this->data['date'] = $date;
            $this->data['to_date'] = date('Y/m/d', strtotime($to_date));
            $this->data['doctor_id'] = $doctor_id;
            $this->data['reference_id'] = $reference_id;
            $this->data['created_by'] = $created_by;
        }

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('due') . ' ' . $this->lang->line('report') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('report/billing/due', $this->data);
    }

    /*****************Function due_pdf**********************************
     * @type            : Function
     * @function name   : due_pdf
     * @description     : Load "Generate PDF Due Billing Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function due_pdf() {

        check_permission(ADD);

        if ($_GET) {
            $keyword = trim($this->input->get('keyword'));
            $type = $this->input->get('type');
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $doctor_id = $this->input->get('doctor_id');
            $reference_id = $this->input->get('reference_id');
            $created_by = $this->input->get('created_by');

            $this->data['dues'] = $this->billing->get_due_list($keyword, $type, $form_date, $to_date, $doctor_id, $reference_id, $created_by);
            $this->data['keyword'] = $keyword;
            $this->data['type'] = $type;
            $this->data['date'] = $date;
            $this->data['form_date'] = $form_date;
            $this->data['to_date'] = $to_date;
            $this->data['doctor_id'] = $doctor_id;
            $this->data['reference_id'] = $reference_id;
            $this->data['created_by'] = $created_by;

            $this->data['createdby'] = $this->billing->get_single('employees', array('user_id' => $created_by, 'status' => 1));
            $this->data['doctor'] = $this->billing->get_single('employees', array('user_id' => $doctor_id, 'status' => 1));

            $this->load->library('pdf');
            $mpdf = new \Mpdf\Mpdf([
                'mode' => 'utf-8',
                'orientation' => 'L'
            ]);
            $html =  $this->load->view('report/billing/pdf/due', $this->data, true);
            $mpdf->WriteHTML($html);
            $mpdf->Output('due_' . rand() . '.pdf', 'D');
        }
    }


    /*****************Function rejected**********************************
     * @type            : Function
     * @function name   : rejected
     * @description     : Load "Rejected Billing Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function rejected() {

        check_permission(ADD);

        if ($_GET) {
            $keyword = trim($this->input->get('keyword'));
            $type = $this->input->get('type');
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $doctor_id = $this->input->get('doctor_id');
            $reference_id = $this->input->get('reference_id');
            $created_by = $this->input->get('created_by');
            $rejected_by = $this->input->get('rejected_by');

            $this->data['rejecteds'] = $this->billing->get_rejected_list($keyword, $type, $form_date, $to_date, $doctor_id, $reference_id, $created_by, $rejected_by);
            $this->data['keyword'] = $keyword;
            $this->data['type'] = $type;
            $this->data['date'] = $date;
            $this->data['doctor_id'] = $doctor_id;
            $this->data['reference_id'] = $reference_id;
            $this->data['created_by'] = $created_by;
            $this->data['rejected_by'] = $rejected_by;
        }

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('rejected') . ' ' . $this->lang->line('report') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('report/billing/rejected', $this->data);
    }

    /*****************Function rejected_pdf**********************************
     * @type            : Function
     * @function name   : rejected_pdf
     * @description     : Load "Generate PDF Rejected Billing Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function rejected_pdf() {

        check_permission(ADD);

        if ($_GET) {
            $keyword = trim($this->input->get('keyword'));
            $type = $this->input->get('type');
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $doctor_id = $this->input->get('doctor_id');
            $reference_id = $this->input->get('reference_id');
            $created_by = $this->input->get('created_by');
            $rejected_by = $this->input->get('rejected_by');

            $this->data['rejecteds'] = $this->billing->get_rejected_list($keyword, $type, $form_date, $to_date, $doctor_id, $reference_id, $created_by, $rejected_by);
            $this->data['keyword'] = $keyword;
            $this->data['type'] = $type;
            $this->data['date'] = $date;
            $this->data['form_date'] = $form_date;
            $this->data['to_date'] = $to_date;
            $this->data['doctor_id'] = $doctor_id;
            $this->data['reference_id'] = $reference_id;
            $this->data['created_by'] = $created_by;
            $this->data['rejected_by'] = $rejected_by;

            $this->data['createdby'] = $this->billing->get_single('employees', array('user_id' => $created_by, 'status' => 1));
            $this->data['doctor'] = $this->billing->get_single('employees', array('user_id' => $doctor_id, 'status' => 1));

            $this->load->library('pdf');
            $mpdf = new \Mpdf\Mpdf([
                'mode' => 'utf-8',
                'orientation' => 'L'
            ]);
            $html =  $this->load->view('report/billing/pdf/rejected', $this->data, true);
            $mpdf->WriteHTML($html);
            $mpdf->Output('rejected_' . rand() . '.pdf', 'D');
        }
    }

    /*****************Function income**********************************
     * @type            : Function
     * @function name   : income
     * @description     : Load "Income Billing Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function income() {

        check_permission(ADD);

        if ($_GET) {
            $keyword = trim($this->input->get('keyword'));
            $type = $this->input->get('type');
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $doctor_id = $this->input->get('doctor_id');
            $reference_id = $this->input->get('reference_id');
            $reference_person = $this->input->get('reference_person');
            $created_by = $this->input->get('created_by');

            $this->data['incomes'] = $this->billing->get_income_list($keyword, $type, $form_date, $to_date, $doctor_id, $reference_id, $reference_person, $created_by);
            $this->data['keyword'] = $keyword;
            $this->data['type'] = $type;
            $this->data['date'] = $date;
            $this->data['doctor_id'] = $doctor_id;
            $this->data['reference_id'] = $reference_id;
            $this->data['reference_person'] = $reference_person;
            $this->data['created_by'] = $created_by;
        }

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('income') . ' ' . $this->lang->line('report') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('report/billing/income', $this->data);
    }

    /*****************Function income_pdf**********************************
     * @type            : Function
     * @function name   : income_pdf
     * @description     : Load "Generate PDF Income Billing Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function income_pdf() {

        check_permission(ADD);

        if ($_GET) {
            $keyword = trim($this->input->get('keyword'));
            $type = $this->input->get('type');
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $doctor_id = $this->input->get('doctor_id');
            $reference_id = $this->input->get('reference_id');
            $reference_person = $this->input->get('reference_person');
            $created_by = $this->input->get('created_by');

            $this->data['incomes'] = $this->billing->get_income_list($keyword, $type, $form_date, $to_date, $doctor_id, $reference_id, $reference_person, $created_by);
            $this->data['keyword'] = $keyword;
            $this->data['type'] = $type;
            $this->data['date'] = $date;
            $this->data['form_date'] = $form_date;
            $this->data['to_date'] = $to_date;
            $this->data['doctor_id'] = $doctor_id;
            $this->data['reference_id'] = $reference_id;
            $this->data['reference_person'] = $reference_person;
            $this->data['created_by'] = $created_by;

            $this->data['createdby'] = $this->billing->get_single('employees', array('user_id' => $created_by, 'status' => 1));
            $this->data['doctor'] = $this->billing->get_single('employees', array('user_id' => $doctor_id, 'status' => 1));
            $this->data['reference_person'] = $this->billing->get_single('employees', array('user_id' => $reference_person, 'status' => 1));

            $this->load->library('pdf');
            $mpdf = new \Mpdf\Mpdf([
                'mode' => 'utf-8',
                'orientation' => 'L'
            ]);
            $html =  $this->load->view('report/billing/pdf/income', $this->data, true);
            $mpdf->WriteHTML($html);
            $mpdf->Output('income_' . rand() . '.pdf', 'D');
        }
    }

    /*****************Function investigation**********************************
     * @type            : Function
     * @function name   : investigation
     * @description     : Load "investigation Billing Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function investigation() {

        check_permission(VIEW);

        if ($_GET) {
            $keyword = trim($this->input->get('keyword'));
            $type = $this->input->get('type');
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $doctor_id = $this->input->get('doctor_id');
            $reference_id = $this->input->get('reference_id');
            $created_by = $this->input->get('created_by');

            $this->data['investigations'] = $this->billing->get_patient_investigation_list($keyword, $type, $form_date, $to_date, $doctor_id, $reference_id, $created_by);
            $this->data['keyword'] = $keyword;
            $this->data['type'] = $type;
            $this->data['date'] = $date;
            $this->data['doctor_id'] = $doctor_id;
            $this->data['reference_id'] = $reference_id;
            $this->data['created_by'] = $created_by;
        }

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('investigation') . ' ' . $this->lang->line('report') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('report/billing/investigation', $this->data);
    }

    /*****************Function investigation_pdf**********************************
     * @type            : Function
     * @function name   : investigation_pdf
     * @description     : Load "Generate PDF Investigation Billing Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function investigation_pdf() {

        check_permission(VIEW);

        if ($_GET) {
            $keyword = trim($this->input->get('keyword'));
            $type = $this->input->get('type');
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $doctor_id = $this->input->get('doctor_id');
            $reference_id = $this->input->get('reference_id');
            $created_by = $this->input->get('created_by');

            $this->data['investigations'] = $this->billing->get_patient_investigation_list($keyword, $type, $form_date, $to_date, $doctor_id, $reference_id, $created_by);
            $this->data['keyword'] = $keyword;
            $this->data['type'] = $type;
            $this->data['date'] = $date;
            $this->data['form_date'] = $form_date;
            $this->data['to_date'] = $to_date;
            $this->data['doctor_id'] = $doctor_id;
            $this->data['reference_id'] = $reference_id;
            $this->data['created_by'] = $created_by;

            $this->data['createdby'] = $this->billing->get_single('employees', array('user_id' => $created_by, 'status' => 1));
            $this->data['reference'] = $this->billing->get_single('employees', array('user_id' => $reference_id, 'status' => 1));

            $this->load->library('pdf');
            $mpdf = new \Mpdf\Mpdf([
                'mode' => 'utf-8',
                'orientation' => 'L'
            ]);
            $html =  $this->load->view('report/billing/pdf/investigation', $this->data, true);
            $mpdf->WriteHTML($html);
            $mpdf->Output('investigation_' . rand() . '.pdf', 'D');
        }
    }

    /*****************Function summary**********************************
     * @type            : Function
     * @function name   : summary
     * @description     : Load "Collection Summary Billing Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function summary() {
        check_permission(ADD);

        if ($_GET) {
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $type = $this->input->get('type');
            $doctor_id = $this->input->get('doctor_id');
            $created_by = $this->input->get('created_by');

            $this->data['summares'] = $this->billing->get_summary_list($form_date, $to_date, $type, $doctor_id, $created_by);
            $total_advanced = 0;
            $total_due = 0;
            foreach ($this->data['summares'] as $obj) {
                if ($obj->collection_type == '1') {
                    $total_advanced += $obj->amount;
                } else {
                    $total_due += $obj->amount;
                }
            }
            $this->data['total_advanced'] = $total_advanced;
            $this->data['total_due'] = $total_due;

            $opd =  $this->billing->get_opd_summary_list($form_date, $to_date, $type, $doctor_id, $created_by);
            $this->data['total_opd_advanced'] = $opd->total_doctor_charge;
            $this->data['total_opd_due'] = 0;

            $this->data['date'] = $date;
            $this->data['form_date'] = $form_date;
            $this->data['to_date'] = $to_date;
            $this->data['type'] = $type;
            $this->data['doctor_id'] = $doctor_id;
            $this->data['created_by'] = $created_by;
        }
        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('summary') . ' ' . $this->lang->line('report') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('report/billing/summary', $this->data);
    }

    /*****************Function statement**********************************
     * @type            : Function
     * @function name   : statement
     * @description     : Load "Collection Statement Billing Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function statement() {

        check_permission(ADD);

        if ($_GET) {
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $type = $this->input->get('type');
            $doctor_id = $this->input->get('doctor_id');
            $created_by = $this->input->get('created_by');

            $this->data['date'] = $date;
            $this->data['type'] = $type;
            $this->data['doctor_id'] = $doctor_id;
            $this->data['created_by'] = $created_by;

            // OPD START
            $opd = $this->billing->get_opd_statement_list($form_date, $to_date, $type, $doctor_id, $created_by);

            $total_opd_doctor_charge = 0;
            $total_opd_discount = 0;
            $total_opd_rejected_charge = 0;
            $total_opd_rejected_discount = 0;

            foreach ($opd as $opdObj) {
                if ($opdObj->payment_status == 'complete') {
                    $total_opd_doctor_charge += $opdObj->doctor_charge;
                }
                if ($opdObj->payment_status == 'rejected') {
                    $total_opd_rejected_charge += $opdObj->doctor_charge;
                    $total_opd_rejected_discount += $opdObj->discount;
                }
                if ($opdObj->discount > 0) {
                    $total_opd_discount += $opdObj->discount;
                }
            }

            $this->data['total_opd_doctor_charge'] = $total_opd_doctor_charge;
            $this->data['total_opd_discount'] = $total_opd_discount;
            $this->data['total_opd_rejected_charge'] = $total_opd_rejected_charge;
            $this->data['total_opd_rejected_discount'] = $total_opd_rejected_discount;


            // OPD END

            // Investigation  Start
            $investigation = $this->billing->get_investigation_list($form_date, $to_date, $type, $doctor_id, $created_by);

            $total_bill = 0;
            $total_special_discount = 0;
            $total_discount = 0;
            $total_net_payable = 0;
            $total_advanced = 0;
            $total_due_amount = 0;

            // rejected bill
            $total_rejected_bill = 0;
            $total_rejected_special_discount = 0;
            $total_rejected_discount = 0;
            $total_rejected_net_payable = 0;
            $total_rejected_advanced = 0;


            foreach ($investigation as $item) {
                if ($item->payment_status == 'complete') {
                    $total_bill += $item->total_bill;
                    $total_special_discount += $item->special_discount;
                    $total_discount += $item->discount;
                    $total_net_payable += $item->net_payable;
                    $total_advanced += $item->advanced;
                    $total_due_amount += $item->due_amount;
                }
                if ($item->payment_status == 'rejected') {
                    $total_rejected_bill += $item->total_bill;
                    $total_rejected_special_discount += $item->special_discount;
                    $total_rejected_discount += $item->discount;
                    $total_rejected_net_payable += $item->net_payable;
                    $total_rejected_advanced += $item->advanced;
                }
            }

            $this->data['total_bill'] = $total_bill;
            $this->data['total_discount'] = $total_special_discount;
            $this->data['total_special_discount'] = $total_discount;
            $this->data['total_net_payable'] = $total_net_payable;
            $this->data['total_advanced'] = $total_advanced;
            $this->data['total_due_amount'] = $total_due_amount;

            // rejected bill

            $this->data['total_rejected_bill'] = $total_rejected_bill;
            $this->data['total_rejected_special_discount'] = $total_rejected_special_discount;
            $this->data['total_rejected_discount'] = $total_rejected_discount;
            $this->data['total_rejected_net_payable'] = $total_rejected_net_payable;
            $this->data['total_rejected_advanced'] = $total_rejected_advanced;

            // Investigation  End
            $payment = $this->billing->get_investigation_payment_list($form_date, $to_date, $type, $doctor_id, $created_by);

            $total_second_less = 0;
            $total_due_collection = 0;
            foreach ($payment as $row) {
                if ($row->payment_status == 'complete') {
                    $total_second_less += $row->second_less;
                    if ($row->collection_type == '2') {
                        $total_due_collection += $row->amount;
                    }
                }
            }
            $this->data['total_second_less'] = $total_second_less;
            $this->data['total_due_collection'] = $total_due_collection;
        }
        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('statement') . ' ' . $this->lang->line('report') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('report/billing/statement', $this->data);
    }

    /*****************Function sales**********************************
     * @type            : Function
     * @function name   : sales
     * @description     : Load "Sales Statement Billing Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function sales() {

        check_permission(ADD);

        if ($_GET) {
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $type = $this->input->get('type');
            $doctor_id = $this->input->get('doctor_id');
            $created_by = $this->input->get('created_by');

            $this->data['sales'] = $this->billing->get_sale_list($form_date, $to_date, $type, $doctor_id, $created_by);
            $this->data['date'] = $date;
            $this->data['form_date'] = $form_date;
            $this->data['to_date'] = $to_date;
            $this->data['type'] = $type;
            $this->data['doctor_id'] = $doctor_id;
            $this->data['created_by'] = $created_by;
        }

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('sales') . ' ' . $this->lang->line('statement') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('report/billing/sales', $this->data);
    }

    /*****************Function sales_pdf**********************************
     * @type            : Function
     * @function name   : sales_pdf
     * @description     : Load "Generate PDF Sales Summary Billing Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function sales_pdf() {

        check_permission(ADD);

        if ($_GET) {
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $type = $this->input->get('type');
            $doctor_id = $this->input->get('doctor_id');
            $created_by = $this->input->get('created_by');

            $this->data['sales'] = $this->billing->get_sale_list($form_date, $to_date, $type, $doctor_id, $created_by);
            $this->data['date'] = $date;
            $this->data['form_date'] = $form_date;
            $this->data['to_date'] = $to_date;
            $this->data['type'] = $type;
            $this->data['doctor_id'] = $doctor_id;
            $this->data['created_by'] = $created_by;

            $this->data['createdby'] = $this->billing->get_single('employees', array('user_id' => $created_by, 'status' => 1));
            $this->data['doctor'] = $this->billing->get_single('employees', array('user_id' => $doctor_id, 'status' => 1));

            $this->load->library('pdf');
            $mpdf = new \Mpdf\Mpdf([
                'mode' => 'utf-8',
                'orientation' => 'L'
            ]);
            $html =  $this->load->view('report/billing/pdf/sales', $this->data, true);
            $mpdf->WriteHTML($html);
            $mpdf->Output('sales_summary_' . rand() . '.pdf', 'D');
        }
    }

    /*****************Function test**********************************
     * @type            : Function
     * @function name   : test
     * @description     : Load "Test Summary Billing Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function test() {

        check_permission(ADD);

        if ($_GET) {
            $keyword = trim($this->input->get('keyword'));
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $type = $this->input->get('type');
            $department_id = $this->input->get('department_id');
            $group_id = $this->input->get('group_id');
            $doctor_id = $this->input->get('doctor_id');
            $reference_id = $this->input->get('reference_id');
            $created_by = $this->input->get('created_by');

            $this->data['tests'] = $this->billing->get_test_list($keyword, $department_id, $group_id);
            $this->data['keyword'] = $keyword;
            $this->data['date'] = $date;
            $this->data['form_date'] = $form_date;
            $this->data['to_date'] = $to_date;
            $this->data['type'] = $type;
            $this->data['department_id'] = $department_id;
            $this->data['group_id'] = $group_id;
            $this->data['doctor_id'] = $doctor_id;
            $this->data['reference_id'] = $reference_id;
            $this->data['created_by'] = $created_by;
        }

        $this->data['departments'] = $this->billing->get_list('diagnostic_departments', array('status' => 1), '', '', '', 'sort_by', 'ASC');
        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('test') . ' ' . $this->lang->line('summary') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('report/billing/test', $this->data);
    }

    /*****************Function test_pdf**********************************
     * @type            : Function
     * @function name   : test_pdf
     * @description     : Load "Generate PDF Test Summary Billing Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function test_pdf() {

        check_permission(ADD);

        if ($_GET) {
            $keyword = trim($this->input->get('keyword'));
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $type = $this->input->get('type');
            $department_id = $this->input->get('department_id');
            $group_id = $this->input->get('group_id');
            $doctor_id = $this->input->get('doctor_id');
            $reference_id = $this->input->get('reference_id');
            $created_by = $this->input->get('created_by');

            $this->data['tests'] = $this->billing->get_test_list($keyword, $department_id, $group_id);
            $this->data['keyword'] = $keyword;
            $this->data['date'] = $date;
            $this->data['form_date'] = $form_date;
            $this->data['to_date'] = $to_date;
            $this->data['type'] = $type;
            $this->data['department_id'] = $department_id;
            $this->data['group_id'] = $group_id;
            $this->data['doctor_id'] = $doctor_id;
            $this->data['reference_id'] = $reference_id;
            $this->data['created_by'] = $created_by;

            $this->data['createdby'] = $this->billing->get_single('employees', array('user_id' => $created_by, 'status' => 1));
            $this->data['doctor'] = $this->billing->get_single('employees', array('user_id' => $doctor_id, 'status' => 1));

            $this->load->library('pdf');
            $mpdf = new \Mpdf\Mpdf([
                'mode' => 'utf-8',
                'orientation' => 'L'
            ]);
            $html =  $this->load->view('report/billing/pdf/test', $this->data, true);
            $mpdf->WriteHTML($html);
            $mpdf->Output('test_summary_' . rand() . '.pdf', 'D');
        }
    }

    /*****************Function authorized**********************************
     * @type            : Function
     * @function name   : collection
     * @description     : Load "Authorized Billing Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function authorized() {

        check_permission(ADD);

        if ($_GET) {
            $keyword = trim($this->input->get('keyword'));
            $type = $this->input->get('type');
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $doctor_id = $this->input->get('doctor_id');
            $reference_id = $this->input->get('reference_id');
            $created_by = $this->input->get('created_by');

            $this->data['authorized'] = $this->billing->get_authorized_list($keyword, $type, $form_date, $to_date, $doctor_id, $reference_id, $created_by);
            $this->data['keyword'] = $keyword;
            $this->data['type'] = $type;
            $this->data['date'] = $date;
            $this->data['doctor_id'] = $doctor_id;
            $this->data['reference_id'] = $reference_id;
            $this->data['created_by'] = $created_by;
        }

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('authorized') . ' ' . $this->lang->line('report') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('report/billing/authorized', $this->data);
    }

    /*****************Function authorized_pdf**********************************
     * @type            : Function
     * @function name   : authorized_pdf
     * @description     : Load "Generate Authorized Billing Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function authorized_pdf() {
        if ($_GET) {
            $keyword = trim($this->input->get('keyword'));
            $type = $this->input->get('type');
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $doctor_id = $this->input->get('doctor_id');
            $reference_id = $this->input->get('reference_id');
            $created_by = $this->input->get('created_by');

            $this->data['authorized'] = $this->billing->get_authorized_list($keyword, $type, $form_date, $to_date, $doctor_id, $reference_id, $created_by);
            $this->data['keyword'] = $keyword;
            $this->data['type'] = $type;
            $this->data['date'] = $date;
            $this->data['doctor_id'] = $doctor_id;
            $this->data['reference_id'] = $reference_id;
            $this->data['created_by'] = $created_by;
            $this->data['createdby'] = $this->billing->get_single('employees', array('user_id' => $created_by, 'status' => 1));
            $this->data['doctor'] = $this->billing->get_single('employees', array('user_id' => $doctor_id, 'status' => 1));

            $this->load->library('pdf');
            $mpdf = new \Mpdf\Mpdf([
                'mode' => 'utf-8',
                'orientation' => 'L'
            ]);
            $html =  $this->load->view('report/billing/pdf/authorized', $this->data, true);
            $mpdf->WriteHTML($html);
            $mpdf->Output('authorized_' . rand() . '.pdf', 'D');
        }
    }

    /*****************Function employee**********************************
     * @type            : Function
     * @function name   : collection
     * @description     : Load "Employee Billing Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function employee() {

        check_permission(ADD);

        if ($_GET && $this->input->get('date')) {
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $reference_person = $this->input->get('reference_person');

            $this->data['employees'] = $this->billing->get_employee_evaluation_list($form_date, $to_date, $reference_person);
            $this->data['date'] = $date;
            $this->data['reference_person'] = $reference_person;
        }

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('employee') . ' ' . $this->lang->line('report') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('report/billing/employee', $this->data);
    }

    /*****************Function employee_pdf**********************************
     * @type            : Function
     * @function name   : employee_pdf
     * @description     : Load "Generate Employee Billing Report List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function employee_pdf() {
        if ($_GET && $this->input->get('date')) {
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $reference_person = $this->input->get('reference_person');

            $this->data['employees'] = $this->billing->get_employee_evaluation_list($form_date, $to_date, $reference_person);
            $this->data['date'] = $date;
            $this->data['reference_person'] = $reference_person;
            $this->data['reference'] = $this->billing->get_single('employees', array('user_id' => $reference_person, 'status' => 1));

            $this->load->library('pdf');
            $mpdf = new \Mpdf\Mpdf([
                'mode' => 'utf-8',
                'orientation' => 'L'
            ]);
            $html =  $this->load->view('report/billing/pdf/employee', $this->data, true);
            $mpdf->WriteHTML($html);
            $mpdf->Output('employee_' . rand() . '.pdf', 'I');
        }
    }
}
