<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('report'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('manage'); ?> <?php echo $this->lang->line('report'); ?>
        </h4>
        <div class="d-flex">
            <?php if (has_permission(VIEW, 'radiology', 'report')) { ?>
                <?php if ($template->template_status) { ?>
                    <button class="btn btn-orange btn-xs mr-10" onclick="getPrint('<?php echo $template->id; ?>')" type="button">
                        <i class="fa fa-print"></i> <?php echo $this->lang->line('print'); ?>
                    </button>
                    <a href="#" class="btn btn-success btn-xs mr-10"><i class="fa fa-download"></i> <?php echo $this->lang->line('download'); ?></a>
                <?php } ?>
            <?php } ?>
            <?php if (has_permission(VIEW, 'radiology', 'report')) { ?>
                <a href="<?php echo site_url('radiology/report/view/' . $template->invoice_id); ?>" class="btn btn-info btn-xs mr-10"><i class="fa fa-arrow-circle-left"></i> <?php echo $this->lang->line('return'); ?></a>
            <?php } ?>

            <?php if (has_permission(VIEW, 'radiology', 'report')) { ?>
                <a href="<?php echo site_url('radiology/report'); ?>" class="btn btn-success btn-xs mr-10"><i class="fa fa-flask"></i> <?php echo $this->lang->line('report'); ?> <?php echo $this->lang->line('list'); ?></a>
            <?php } ?>

            <?php if (has_permission(ADD, 'radiology', 'report')) { ?>
                <a href="<?php echo site_url('radiology/report/create'); ?>" class="btn btn-primary btn-xs"><i class="fa fa-plus"></i> <?php echo $this->lang->line('create'); ?> <?php echo $this->lang->line('report'); ?></a>
            <?php } ?>
        </div>
    </div>
    <!-- /Title -->
    <section class="hk-sec-wrapper">
        <!-- Row -->
        <div class="row">
            <div class="col-xl-12">
                <!-- Patient Info -->
                <div class="table-wrap">
                    <div class="table-responsive">
                        <table class="table table-bordered table-sm mb-0">
                            <thead>
                                <tr>
                                    <th colspan="2" class="text-center font-weight-bold font-16 text-uppercase">Patient Info</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td class="w-70 text-left">
                                        <?php echo $this->lang->line('name'); ?> :
                                        <span class="text-uppercase"><?php echo $template->patient; ?></span>
                                    </td>
                                    <td class="w-30 text-left">
                                        <?php echo $this->lang->line('age'); ?>: <?php echo $template->dob != NULL ? floor((time() - strtotime($template->dob)) / 31556926) : ''; ?> Yrs
                                    </td>
                                </tr>
                                <tr>
                                    <td class="w-70 text-left">
                                        <?php echo $this->lang->line('gender'); ?>: <?php echo $this->lang->line($template->gender); ?>
                                    </td>
                                    <td class="w-30 text-left">
                                        <?php echo $this->lang->line('patient_id'); ?>: <?php echo $template->patient_unique_id; ?>
                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="2" class="w-10 text-left">
                                        <?php echo $this->lang->line('date'); ?>: <?php echo date('d/m/Y h:i A', strtotime($template->created_at)); ?>
                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="2" class="w-10 text-left">
                                        <?php echo $this->lang->line('ref_by'); ?>:
                                        <?php if ($template->self) {
                                            echo 'Self';
                                        } elseif ($template->ref_dr_id > 0) {
                                            echo $template->doctor . ', ' . $template->specialist;
                                        } else {
                                            echo $template->ref_dr_name;
                                        }
                                        ?>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="w-10 text-left">
                                        Speciment:
                                        <span class="text-uppercase"><?php echo $template->specimen; ?></span>
                                    </td>
                                    <td class="w-10 text-left">
                                        <?php echo $this->lang->line('created_by'); ?>:
                                        <span><?php echo $created_by->name; ?></span>
                                    </td>
                                </tr>
                                <?php if ($template->remark) { ?>
                                    <tr>
                                        <td colspan="2" class="w-10 text-left">
                                            <?php echo $this->lang->line('remark'); ?>:
                                            <?php echo $template->remark; ?>
                                        </td>
                                    </tr>
                                <?php } ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <!-- Patient Info end-->

                <!-- Template Start -->
                <style>
                    .custom_table table {
                       width:100%;
                    }
                    .custom_table table td {
                        border: 1px solid #000;
                    }
                </style>
                <div class="mt-50 w-100 custom_table">
                    <?php echo $template->template ? $template->template : ''; ?>
                </div>
                <!-- Template End -->
            </div>
        </div>
        <!-- /Row -->
        <div class="row mt-50">
            <div class="col-md-4">
                
            </div>
            <div class="col-md-4">
                
            </div>
            <div class="col-md-4">
               
            </div>
        </div>
    </section>
</div>
<!-- /Container -->

<script>
    function getPrint(report_id) {
        var base_url = '<?php echo base_url() ?>';
        $.ajax({
            url: base_url + 'radiology/report/print',
            type: 'POST',
            data: {
                report_id: report_id,
            },
            success: function(result) {
                $("#testdata").html(result);
                popup(result);
            }
        });
    }

    function popup(data) {
        var base_url = '<?php echo base_url() ?>';
        var frame1 = $('<iframe />');
        frame1[0].name = "frame1";
        frame1.css({
            "position": "absolute",
            "top": "-1000000px"
        });
        $("body").append(frame1);
        var frameDoc = frame1[0].contentWindow ? frame1[0].contentWindow : frame1[0].contentDocument.document ? frame1[0].contentDocument.document : frame1[0].contentDocument;
        frameDoc.document.open();
        //Create a new HTML document.
        frameDoc.document.write('<html>');
        frameDoc.document.write('<head>');
        frameDoc.document.write('<title></title>');

        frameDoc.document.write('</head>');
        frameDoc.document.write('<body>');
        frameDoc.document.write(data);
        frameDoc.document.write('</body>');
        frameDoc.document.write('</html>');
        frameDoc.document.close();
        setTimeout(function() {
            window.frames["frame1"].focus();
            window.frames["frame1"].print();
            frame1.remove();
           // window.location.reload(true);
        }, 500);
        return true;
    }
</script>