<!DOCTYPE html>
<html>

<head>
    <title>Report Print</title>
    <style>
        body {
            font-family: "Time New Roman";
            font-size: 13px;
        }

        .page {
            width: 100%;
            margin: 0 auto;
        }

        .main_body {
            margin-top: 110px;
        }


        .table {
            width: 100%;
            border-collapse: collapse;
        }

        .table_patient thead th {
            padding: 0;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 13px;
        }

        .table_patient tbody td {
            padding: 5px 3px;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 16px;
        }

        .report {
            margin-top: 10px;
            min-height: 545px;
            font-size: 14px;
        }

        .report table td {
            padding-left: 3px;
            vertical-align: middle;
        }

        .footer p {
            font-size: 10px;
        }

        .footer strong {
            font-size: 10px;
        }
    </style>
</head>

<body>
    <div class="page">
        <div class="main_body">
            <table class="table table_patient">
                <tbody>
                    <tr>
                        <td width="14%" style="border-right:none;"><b>Name</b></td>
                        <td width="1%" style="border-left:none; border-right:none;"><b>:</b></td>
                        <td style="border-left:none; border-right:none; text-transform:uppercase"><b><?php echo $template->patient; ?></b></td>
                        <td width="20%"><b>Age: <?php echo $template->dob != NULL ? floor((time() - strtotime($template->dob)) / 31556926) : ''; ?> Yrs</b></td>
                    </tr>
                    <tr>
                        <td width="14%" style="border-right:none;"><b>Gender</b></td>
                        <td width="1%" style="border-left:none; border-right:none;"><b>:</b></td>
                        <td style="border-left:none; border-right:none;"><b><?php echo $this->lang->line($template->gender); ?></b></td>
                        <td><b>ID No: <?php echo $template->patient_unique_id; ?></b></td>
                    </tr>
                    <tr>
                        <td width="14%" style="border-right:none;"><b>Date</b></td>
                        <td width="1%" style="border-left:none; border-right:none;"><b>:</b></td>
                        <td colspan="2" style="border-left:none;"><b><?php echo date('d/m/Y h:i A'); ?></b></td>
                    </tr>
                    <tr>
                        <td width="14%" style="border-right:none;"><b>Refd. By</b></td>
                        <td width="1%" style="border-left:none; border-right:none;"><b>:</b></td>
                        <td colspan="2" style="border-left:none;">
                            <b>
                                <?php if ($template->self) {
                                    echo 'Self';
                                } elseif ($template->ref_dr_id > 0) {
                                    echo $template->doctor . ', ' . $template->specialist;
                                } else {
                                    echo $template->ref_dr_name;
                                }
                                ?>
                            </b>
                        </td>
                    </tr>
                    <tr>
                        <td width="14%" style="border-right:none;"><b>Specimen:</b></td>
                        <td width="1%" style="border-left:none; border-right:none;"><b>:</b></td>
                        <td colspan="2" style="border-left:none; text-transform: uppercase;"><b><?php echo $template->specimen; ?></b></td>
                    </tr>
                    <?php if ($template->remark) { ?>
                        <tr>
                            <td width="14%" style="border-right:none;"><b>Remark:</b></td>
                            <td width="1%" style="border-left:none; border-right:none;"><b>:</b></td>
                            <td colspan="2" style="border-left:none;"><b><?php echo $template->remark; ?></b></td>
                        </tr>
                    <?php } ?>
                </tbody>
            </table>

            <!-- Repoart Body Start-->
            <div class="report">
                <?php echo $template->template ? $template->template : ''; ?>
            </div>
            <!-- Repoart Body End-->

            <!-- Footer -->

            <div class="footer" style="width: 100%;">
                <div style="width: 30%; float: left;">

                </div>
                <div style="width: 30%; margin: 0 5%; float: left;">

                </div>
                <div style="width: 30%; float: left;">

                </div>
            </div>
        </div>
    </div>
</body>

</html>