<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('report'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container-fluid">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('collection'); ?> <?php echo $this->lang->line('report'); ?>
        </h4>
        <div class="align-items-center">
            <?php echo $this->load->view('header'); ?>
        </div>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <!-- col-lg-12 -->
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <?php echo form_open_multipart(site_url('pharmacy/report/collection'), array('name' => 'search', 'id' => 'search', 'method' => 'get'), ''); ?>
                    <div class="form-row">
                        <div class="col-md-3 mb-10">
                            <label for="keyword"><?php echo $this->lang->line('keyword'); ?></label>
                            <input type="text" class="form-control" name="keyword" id="keyword" value="<?php echo isset($keyword) ?  $keyword : ''; ?>" placeholder="<?php echo $this->lang->line('keyword'); ?>">
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="type"><?php echo $this->lang->line('type'); ?></label>
                            <select class="form-control custom-select" name="type" id="type">
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('type'); ?></option>
                                <option value="1" <?php echo isset($type) && $type == 1 ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('walking'); ?> <?php echo $this->lang->line('customer'); ?></option>
                                <option value="2" <?php echo isset($type) && $type == 2 ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('hospital'); ?> <?php echo $this->lang->line('patient'); ?></option>
                            </select>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="date"><?php echo $this->lang->line('date'); ?></label>
                            <input type="text" class="form-control" name="date" id="range" value="<?php echo isset($date) ?  $date : ''; ?>" placeholder="<?php echo $this->lang->line('date'); ?>">
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="created_by"><?php echo $this->lang->line('created_by'); ?></label>
                            <select class="form-control custom-select select2" name="created_by" id="created_by">
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('employee'); ?></option>
                                <?php foreach ($employees as $obj) { ?>
                                    <option value="<?php echo $obj->user_id; ?>" <?php echo isset($created_by) && $created_by == $obj->user_id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?> [<?php echo $obj->phone; ?>]</option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-1">
                            <button class="btn btn-gradient-primary mt-35" type="submit"><?php echo $this->lang->line('search'); ?></button>
                        </div>
                    </div>
                    <?php echo form_close(); ?>
                </div>
            </div>
        </div>

        <?php if (isset($collections) && !empty($collections)) { ?>
            <!-- Report Details -->
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between">
                        <?php if (has_permission(VIEW, 'pharmacy', 'report')) { ?>
                            <h6 class="card-header d-flex align-items-center">
                                <i class="fa fa-money font-30 mr-10"></i>
                                <?php echo $this->lang->line('collection'); ?> <?php echo $this->lang->line('report'); ?>
                            </h6>
                        <?php } ?>
                        <div class="button-list">
                            <a href="<?php echo site_url('pharmacy/report/collection_pdf/?keyword=' . $keyword . '&type=' . $type . '&date=' . $date . '&created_by=' . $created_by); ?>" class="btn btn-success btn-xs">
                                <i class="fa fa-download"></i> <?php echo $this->lang->line('pdf'); ?> <?php echo $this->lang->line('generate'); ?>
                            </a>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-wrap">
                            <div class="table-responsive">
                                <table class="table table-sm mb-0">
                                    <thead>
                                        <tr>
                                            <th><?php echo $this->lang->line('sl_no'); ?></th>
                                            <th><?php echo $this->lang->line('invoice_no'); ?></th>
                                            <th><?php echo $this->lang->line('bill'); ?> <?php echo $this->lang->line('date'); ?></th>
                                            <th><?php echo $this->lang->line('payment'); ?> <?php echo $this->lang->line('date'); ?></th>
                                            <th><?php echo $this->lang->line('patient_id'); ?></th>
                                            <th><?php echo $this->lang->line('customer'); ?> <?php echo $this->lang->line('name'); ?></th>
                                            <th><?php echo $this->lang->line('total'); ?> <?php echo $this->lang->line('bill'); ?></th>
                                            <th><?php echo $this->lang->line('collection'); ?></th>
                                            <th><?php echo $this->lang->line('created_by'); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $count = 1;
                                        $total_amount = 0;
                                        if (isset($collections) && !empty($collections)) { ?>
                                            <?php foreach ($collections as $obj) {
                                                $total_amount += $obj->amount;
                                            ?>
                                                <tr>
                                                    <td><?php echo $count++; ?></td>
                                                    <td><?php echo $obj->custom_invoice_id; ?></td>
                                                    <td><?php echo date('d/m/Y h:ia', strtotime($obj->bill_date)); ?></td>
                                                    <td><?php echo date('d/m/Y h:ia', strtotime($obj->payment_date)); ?></td>
                                                    <td><?php echo $obj->patient_unique_id; ?></td>
                                                    <td>
                                                        <?php
                                                        if ($obj->walking == 1) {
                                                            echo $this->lang->line('walking') . ' ' . $this->lang->line('customer');
                                                        } elseif ($obj->customer_id > 0) {
                                                            echo $obj->customer;
                                                        } else {
                                                            echo $obj->customer_name;
                                                        }
                                                        ?>
                                                    </td>
                                                    <td><?php echo $obj->total_bill; ?></td>
                                                    <td><?php echo $obj->amount; ?></td>
                                                    <td><?php echo $obj->created_by; ?></td>
                                                </tr>
                                            <?php } ?>
                                        <?php } ?>
                                    </tbody>
                                    <tfoot class="border-bottom border-1">
                                        <tr>
                                            <th colspan="7" class="text-right font-weight-600">Total Payable Amount</th>
                                            <th colspan="2" class="text-left font-weight-600"><?php echo $this->global_setting->currency_symbol; ?> <?php echo number_format($total_amount, 2); ?></th>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php } ?>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->


<!-- Daterangepicker -->
<link href="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>moment/min/moment.min.js"></script>
<script src="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.js"></script>

<!-- Select2 -->
<link href="<?php echo VENDOR_URL; ?>select2/dist/css/select2.min.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>select2/dist/js/select2.full.min.js"></script>

<style>
    .select2-container .select2-selection--single {
        height: calc(2.25rem + 4px) !important;
    }

    .select2-container--default .select2-search--dropdown .select2-search__field {
        color: #324148;
        border-width: 2px;
        border-color: #e0e3e4;
        padding: .375rem .75rem;
        height: calc(2.25rem + 4px);
    }

    .select2-container--default .select2-selection--single .select2-selection__arrow b {
        margin-top: 5px;
    }
</style>
<script>
    $(".select2").select2();
    $('#range').daterangepicker({
        startDate: new Date(),
        endDate: moment(),
        showDropdowns: true,
        minYear: 1901,
        locale: {
            format: 'YYYY/MM/DD',
        },
        ranges: {
            'Today': [moment(), moment()],
            'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
            'Tomorrow': [moment().subtract(-1, 'days'), moment().subtract(-1, 'days')],
            'Last 7 Days': [moment().subtract(6, 'days'), moment()],
            'Last 30 Days': [moment().subtract(29, 'days'), moment()],
            'This Month': [moment().startOf('month'), moment().endOf('month')],
            'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            'This Year': [moment().startOf('year'), moment().endOf('year')],
            'Last Year': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')]
        }
    });
</script>