<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('refund'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container-fluid">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('manage_refund'); ?>
        </h4>
        <div class="align-items-center">
            <?php if (has_permission(VIEW, 'pharmacy', 'purchase')) { ?>
                <a href="<?php echo site_url('pharmacy/purchase'); ?>" class="btn btn-xs btn-info">
                    <i class="fa fa-cart-plus font-12 mr-5"></i>
                    <?php echo $this->lang->line('purchase'); ?>
                </a>
            <?php } ?>
            <?php if (has_permission(VIEW, 'pharmacy', 'stock')) { ?>
                <a href="<?php echo site_url('pharmacy/stock'); ?>" class="btn btn-xs btn-success">
                    <i class="fa fa-bar-chart font-12 mr-5"></i>
                    <?php echo $this->lang->line('stock'); ?>
                </a>
            <?php } ?>
            <?php if (has_permission(VIEW, 'pharmacy', 'sale')) { ?>
                <a href="<?php echo site_url('pharmacy/sale'); ?>" class="btn btn-xs btn-danger">
                    <i class="fa fa-balance-scale font-12 mr-5"></i>
                    <?php echo $this->lang->line('sale'); ?>
                </a>
            <?php } ?>
        </div>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <!-- col-xl-12 -->
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(VIEW, 'pharmacy', 'refund')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-undo font-30 mr-10"></i>
                            <?php echo $this->lang->line('refund'); ?> <?php echo $this->lang->line('invoice'); ?>
                        </h6>
                    <?php } ?>
                    <?php if (has_permission(VIEW, 'pharmacy', 'refund')) { ?>
                        <div class="align-items-center">
                            <a href="<?php echo site_url('pharmacy/refund'); ?>" class="btn btn-xs btn-primary">
                                <i class="fa fa-repeat font-12 mr-5"></i>
                                <?php echo $this->lang->line('manage_refund'); ?>
                            </a>
                        </div>
                    <?php } ?>
                </div>

                <?php echo form_open_multipart(site_url('pharmacy/refund/add_customer_refund'), array('name' => 'add', 'id' => 'add', 'class' => 'needs-validation', 'novalidate' => 'novalidate'), ''); ?>
                <div class="card-body pt-0 pb-0">
                    <div class="table-wrap">
                        <div class="table-responsive">
                            <table class="table table-sm">
                                <tbody>
                                    <tr>
                                        <td>
                                            <span class="font-weight-bold"><?php echo $this->lang->line('customer'); ?>:</span>
                                            <span class="font-weight-bold text-red">
                                                <?php
                                                if ($invoice->walking == 1) {
                                                    echo $this->lang->line('walking') . ' ' . $this->lang->line('customer');
                                                } elseif ($invoice->customer_id > 0) {
                                                    echo $customer->name;
                                                    echo $customer->patient_unique_id ? ' [' . $customer->patient_unique_id . ']' : '';
                                                } else {
                                                    echo $invoice->customer_name;
                                                }
                                                ?>
                                            </span>
                                        </td>
                                        <td>
                                            <span class="font-weight-bold"><?php echo $this->lang->line('gender'); ?>:</span>
                                            <span class="font-weight-bold text-red">
                                                <?php echo isset($customer->gender) ? $this->lang->line($customer->gender) : ''; ?> / <?php echo isset($customer->dob) ? floor((time() - strtotime($customer->dob)) / 31556926) . 'Y' : ''; ?>
                                            </span>
                                        </td>
                                        <td>
                                            <span class="font-weight-bold"><?php echo $this->lang->line('phone'); ?>:</span>
                                            <span class="font-weight-bold text-red">
                                                <?php echo isset($customer->phone) ? $customer->phone : ''; ?>
                                            </span>
                                        </td>
                                        <td>
                                            <span class="font-weight-bold"><?php echo $this->lang->line('address'); ?>:</span>
                                            <span class="font-weight-bold text-red">
                                                <?php echo isset($customer->address) ? $customer->address : ''; ?>
                                            </span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <span class="font-weight-bold"><?php echo $this->lang->line('invoice_no'); ?>:</span>
                                            <span class="font-weight-bold text-red">
                                                <?php echo $invoice->custom_invoice_id; ?>
                                            </span>
                                        </td>
                                        <td>
                                            <span class="font-weight-bold"><?php echo $this->lang->line('bill'); ?> <?php echo $this->lang->line('date'); ?>:</span>
                                            <span class="font-weight-bold text-red">
                                                <?php echo date('d/m/Y, h:ia', strtotime($invoice->bill_date)); ?>
                                            </span>
                                        </td>
                                        <td>
                                            <span class="font-weight-bold"><?php echo $this->lang->line('total'); ?> <?php echo $this->lang->line('bill'); ?>:</span>
                                            <span class="font-weight-bold text-red">
                                                <?php echo $invoice->total_bill; ?>
                                            </span>
                                        </td>
                                        <td>
                                            <span class="font-weight-bold"><?php echo $this->lang->line('due'); ?>:</span>
                                            <span class="font-weight-bold text-red">
                                                <?php if ($invoice->paid_status == 'unpaid' && $invoice->due_amount > 0) { ?>
                                                    <?php echo $invoice->due_amount; ?>
                                                <?php } ?>
                                            </span>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <div class="form-row">
                        <div class="col-md-2 mb-10">
                            <label for="bill_date"><?php echo $this->lang->line('refund'); ?> <?php echo $this->lang->line('date'); ?></label>
                            <input type="text" class="form-control" name="bill_date" id="bill_date" value="<?php echo isset($bill_date) ?  $bill_date : ''; ?>" placeholder="<?php echo $this->lang->line('refund'); ?> <?php echo $this->lang->line('date'); ?>">
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="invoice_no"><?php echo $this->lang->line('invoice_no'); ?></label>
                            <input type="text" class="form-control" name="invoice_no" id="invoice_no" value="<?php echo get_custom_id('medicine_refunds', 'INV-', date('Y'), date('m')); ?>" readonly placeholder="<?php echo $this->lang->line('invoice_no'); ?>">
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="payment_type"><?php echo $this->lang->line('payment'); ?> <?php echo $this->lang->line('type'); ?></label>
                            <select class="form-control" name="payment_type" id="payment_type">
                                <option value="cash" <?php echo isset($payment_type) && $payment_type == 'cash' ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('cash'); ?></option>
                                <option value="credit" <?php echo isset($payment_type) && $payment_type == 'credit' ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('credit'); ?></option>
                                <option value="due" <?php echo isset($payment_type) && $payment_type == 'due' ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('due'); ?></option>
                            </select>
                        </div>
                        <div class="col-md-6 mb-10">
                            <label for="note"><?php echo $this->lang->line('remark'); ?></label>
                            <input type="text" class="form-control" name="note" id="note" value="<?php echo isset($note) ?  $note : ''; ?>" placeholder="<?php echo $this->lang->line('remark'); ?>">
                        </div>
                    </div>

                    <div class="table-wrap">
                        <div class="table-responsive">
                            <table class="table table-sm table-border">
                                <thead class="text-center bg-gradient-sunset">
                                    <tr>
                                        <th class="text-white font-weight-700 text-center w-10">Sl</th>
                                        <th class="text-white font-weight-700 text-left w-30">Medicine Name</th>
                                        <th class="text-white font-weight-700 text-left w-15">Sold Qty</th>
                                        <th class="text-white font-weight-700 text-left w-15">Refund Qty</th>
                                        <th class="text-white font-weight-700 text-left w-10">Sell Price</th>
                                        <th class="text-white font-weight-700 text-left w-10">Total</th>
                                        <th class="text-white font-weight-700 text-left w-10">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $sl = 1;
                                    if (isset($details) && !empty($details)) { ?>
                                        <?php foreach ($details as $obj) { ?>
                                            <tr>
                                                <td><?php echo $sl; ?></td>
                                                <td>
                                                    <?php echo $obj->medicine_name; ?>
                                                    <input type="hidden" class="form-control form-control-sm" name="medicine_id[]" id="medicine_id_<?php echo $sl; ?>" value="<?php echo $obj->medicine_id; ?>" />
                                                    <input type="hidden" class="form-control form-control-sm" name="batch_no[]" id="batch_no_<?php echo $sl; ?>" value="<?php echo $obj->batch_no; ?>" />
                                                </td>
                                                <td>
                                                    <?php echo $obj->quantity; ?>
                                                    <input type="hidden" class="form-control form-control-sm" name="sold_qty[]" id="sold_qty_<?php echo $sl; ?>" value="<?php echo $obj->quantity ?? '0'; ?>" placeholder="Sold Quantity" min="0" />
                                                </td>
                                                <td class="text-right">
                                                    <input type="text" class="form-control form-control-sm text-right total_refund_qty_<?php echo $sl; ?>" onkeyup="quantity_calculate(<?php echo $sl; ?>),checkrequird(<?php echo $sl; ?>),checkqty(<?php echo $sl; ?>);" onchange="quantity_calculate(<?php echo $sl; ?>);" id="total_refund_qty_<?php echo $sl; ?>" placeholder="Refund Qty" />
                                                </td>
                                                <td>
                                                    <?php echo $obj->rate; ?>
                                                    <input type="hidden" class="form-control form-control-sm text-right rate<?php echo $sl; ?>" value="<?php echo $obj->rate ?? ''; ?>" id="rate_<?php echo $sl; ?>" min="0" placeholder="Rate" readonly="" />
                                                </td>
                                                <td class="text-right">
                                                    <input type="text" class="form-control form-control-sm text-righ total_price" id="total_price_<?php echo $sl; ?>" readonly="readonly" />
                                                </td>
                                                <td>
                                                    <input type="checkbox" class="form-control form-control-sm" name='return[]' onclick="checkboxcheck(<?php echo $sl; ?>)" id="check_id_<?php echo $sl; ?>" value="<?php echo $sl; ?>">
                                                </td>
                                            </tr>
                                            <?php $sl++;  ?>
                                        <?php } ?>
                                    <?php } ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <td colspan="5" class="text-right"><b>Total Refund:</b></td>
                                        <td colspan="2">
                                            <input type="text" class="form-control form-control-sm text-right" id="grandTotal" name="total_refund" readonly="readonly" />
                                        </td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                    <!-- Medicine Add End -->
                </div>
                <!-- Card Footer -->
                <div class="card-footer pt-0">
                    <div class="button-list">
                        <input type="hidden" name="invoice_id" value="<?php echo $this->uri->segment(4, 0); ?>">
                        <input type="hidden" name="total_bill" value="<?php echo $invoice->total_bill ?? 0; ?>">
                        <a class="btn btn-gradient-danger" href="<?php echo site_url('pharmacy/refund'); ?>"><?php echo $this->lang->line('cancel'); ?></a>
                        <button class="btn btn-gradient-primary" id="submit" type="submit"><?php echo $this->lang->line('submit'); ?></button>
                    </div>
                </div>
                <?php echo form_close(); ?>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->


<!-- Daterangepicker -->
<link href="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>moment/min/moment.min.js"></script>
<script src="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.js"></script>


<script>
    $("#bill_date").daterangepicker({
        singleDatePicker: true,
        startDate: new Date(),
        showDropdowns: true,
        minYear: 1901,
        timePicker: true,
        timePicker24Hour: true,
        timePickerIncrement: 1,
        timePickerSeconds: false,
        autoUpdateInput: true,
        locale: {
            format: 'YYYY-MM-DD HH:mm',
        }
    });
</script>

<script type="text/javascript">
    function checkboxcheck(sl) {
        var check_id = 'check_id_' + sl;
        var total_refund_qty = 'total_refund_qty_' + sl;
        var rate = 'rate_' + sl;
        var total_price = 'total_price_' + sl;
        if ($('#' + check_id).prop("checked") == true) {
            document.getElementById(total_refund_qty).setAttribute("name", "quantity[]");
            document.getElementById(total_refund_qty).setAttribute("required", "");
            document.getElementById(rate).setAttribute("name", "rate[]");
            document.getElementById(total_price).setAttribute("name", "total_rate[]");
        } else if ($('#' + check_id).prop("checked") == false) {
            document.getElementById(total_refund_qty).removeAttribute("name");
            document.getElementById(total_refund_qty).removeAttribute("required");
            document.getElementById(rate).removeAttribute("name");
            document.getElementById(total_price).removeAttribute("name");
        }
    };

    function checkrequird(sl) {
        var quantity = $('#total_refund_qty_' + sl).val();
        var check_id = 'check_id_' + sl;
        if (quantity > 0) {
            document.getElementById(check_id).setAttribute("required", "required");
        } else {
            document.getElementById(check_id).removeAttribute("required");
        }
    }
</script>
<script type="text/javascript">
    $('#submit').prop("disabled", true);
    $('input:checkbox').click(function() {
        var check = $('[name="return[]"]:checked').length;
        if (check > 0) {
            $('#submit').prop("disabled", false);
        } else {
            if (check < 1) {
                $('#submit').attr('disabled', true);
            }
        }
    });

    function checkqty(sl) {
        var sold_qty = $('#sold_qty_' + sl).val();
        var refund_qty = $('#total_refund_qty_' + sl).val();
        if (isNaN(refund_qty)) {
            alert("Must Input Numbers!!!");
            document.getElementById("total_refund_qty_" + sl).value = '';
            return false;
        }
        if (parseInt(refund_qty) < 1) {
            alert("You can not return less than 1");
            document.getElementById("total_refund_qty_" + sl).value = '';
            return false;
        }
        if (parseInt(refund_qty) > parseInt(sold_qty)) {
            setTimeout(function() {
                alert("You can not return more than sold quantity");
                document.getElementById("total_price_" + sl).value = '';
                document.getElementById("total_refund_qty_" + sl).value = '';
            }, 500);
            return false;
        }
    }

    function quantity_calculate(item) {
        var quantity = $("#total_refund_qty_" + item).val();
        var price = $("#rate_" + item).val();
        var n = quantity * price;
        $("#total_price_" + item).val(n);
        calculateSum();
    }

    function calculateSum() {
        var t = 0;
        $(".total_price").each(function() {
            isNaN(this.value) || 0 == this.value.length || (t += parseFloat(this.value))
        });
        $("#grandTotal").val(t.toFixed(2, 2))
    }
</script>