<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('refund'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container-fluid">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('manage_refund'); ?>
        </h4>
        <div class="align-items-center">
            <?php if (has_permission(VIEW, 'pharmacy', 'purchase')) { ?>
                <a href="<?php echo site_url('pharmacy/purchase'); ?>" class="btn btn-xs btn-info">
                    <i class="fa fa-cart-plus font-12 mr-5"></i>
                    <?php echo $this->lang->line('purchase'); ?>
                </a>
            <?php } ?>
            <?php if (has_permission(VIEW, 'pharmacy', 'stock')) { ?>
                <a href="<?php echo site_url('pharmacy/stock'); ?>" class="btn btn-xs btn-success">
                    <i class="fa fa-bar-chart font-12 mr-5"></i>
                    <?php echo $this->lang->line('stock'); ?>
                </a>
            <?php } ?>
            <?php if (has_permission(VIEW, 'pharmacy', 'sale')) { ?>
                <a href="<?php echo site_url('pharmacy/sale'); ?>" class="btn btn-xs btn-danger">
                    <i class="fa fa-balance-scale font-12 mr-5"></i>
                    <?php echo $this->lang->line('sale'); ?>
                </a>
            <?php } ?>
        </div>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <?php echo form_open_multipart(site_url('pharmacy/refund/customer'), array('name' => 'search', 'id' => 'search', 'method' => 'get'), ''); ?>
                    <div class="form-row">
                        <div class="col-md-2 mb-10">
                            <label for="keyword"><?php echo $this->lang->line('keyword'); ?></label>
                            <input type="text" class="form-control" name="keyword" id="keyword" value="<?php echo isset($keyword) ?  $keyword : ''; ?>" placeholder="<?php echo $this->lang->line('keyword'); ?>">
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="type"><?php echo $this->lang->line('type'); ?></label>
                            <select class="form-control custom-select" name="type" id="type">
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <option value="1" <?php echo isset($type) && $type == 1 ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('paid'); ?></option>
                                <option value="2" <?php echo isset($type) && $type == 2 ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('due'); ?></option>
                                <option value="3" <?php echo isset($type) && $type == 3 ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('walking'); ?></option>
                                <option value="4" <?php echo isset($type) && $type == 4 ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('customer'); ?></option>
                                <option value="5" <?php echo isset($type) && $type == 5 ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('complete'); ?></option>
                                <option value="6" <?php echo isset($type) && $type == 6 ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('rejected'); ?></option>
                            </select>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="date"><?php echo $this->lang->line('date'); ?></label>
                            <input type="text" class="form-control" name="date" id="range" value="<?php echo isset($date) ?  $date : ''; ?>" placeholder="<?php echo $this->lang->line('date'); ?>">
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="created_by"><?php echo $this->lang->line('created_by'); ?></label>
                            <select class="form-control custom-select select2" name="created_by" id="created_by">
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('employee'); ?></option>
                                <?php foreach ($employees as $obj) { ?>
                                    <option value="<?php echo $obj->user_id; ?>" <?php echo isset($created_by) && $created_by == $obj->user_id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?> [<?php echo $obj->phone; ?>]</option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-1">
                            <button class="btn btn-gradient-primary mt-35" type="submit"><?php echo $this->lang->line('search'); ?></button>
                        </div>
                    </div>
                    <?php echo form_close(); ?>
                </div>
            </div>
        </div>

        <div class="col-lg-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(VIEW, 'pharmacy', 'refund')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-undo font-30 mr-10"></i>
                            <?php echo $this->lang->line('customer'); ?> <?php echo $this->lang->line('refund'); ?> <?php echo $this->lang->line('list'); ?>
                        </h6>
                    <?php } ?>
                    <div class="align-items-center">
                        <?php if (has_permission(VIEW, 'pharmacy', 'refund')) { ?>
                            <a href="<?php echo site_url('pharmacy/refund/manufacturer'); ?>" class="btn btn-xs btn-success">
                                <i class="fa fa-industry font-12 mr-5"></i>
                                <?php echo $this->lang->line('manufacturer'); ?> <?php echo $this->lang->line('refund'); ?>
                            </a>
                        <?php } ?>
                        <?php if (has_permission(VIEW, 'pharmacy', 'refund')) { ?>
                            <a href="<?php echo site_url('pharmacy/refund/wastage'); ?>" class="btn btn-xs btn-danger">
                                <i class="fa fa-ban font-12 mr-5"></i>
                                <?php echo $this->lang->line('wastage'); ?> <?php echo $this->lang->line('refund'); ?>
                            </a>
                        <?php } ?>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-wrap">
                        <div class="table-responsive">
                            <table class="table table-sm mb-0" id="mainTable">
                                <thead>
                                    <tr>
                                        <th><?php echo $this->lang->line('sl_no'); ?></th>
                                        <th><?php echo $this->lang->line('invoice_no'); ?></th>
                                        <th><?php echo $this->lang->line('date'); ?></th>
                                        <th><?php echo $this->lang->line('patient_id'); ?></th>
                                        <th><?php echo $this->lang->line('customer'); ?></th>
                                        <th><?php echo $this->lang->line('total'); ?> <?php echo $this->lang->line('bill'); ?></th>
                                        <th><?php echo $this->lang->line('total'); ?> <?php echo $this->lang->line('refund'); ?></th>
                                        <th><?php echo $this->lang->line('due'); ?></th>
                                        <th><?php echo $this->lang->line('status'); ?></th>
                                        <th width="10%"><?php echo $this->lang->line('action'); ?></th>
                                    </tr>
                                </thead>
                                <tbody id="bodyTable">
                                    <?php if (isset($refunds) && !empty($refunds)) { ?>
                                        <?php foreach ($refunds as $obj) { ?>
                                            <tr>
                                                <td><?php echo $sl_count; ?></td>
                                                <td><?php echo $obj->custom_invoice_id; ?></td>
                                                <td><?php echo date('d M, Y h:ia', strtotime($obj->bill_date)); ?></td>
                                                <td><?php echo $obj->patient_unique_id; ?></td>
                                                <td>
                                                    <?php
                                                    if ($obj->walking == 1) {
                                                        echo $this->lang->line('walking') . ' ' . $this->lang->line('customer');
                                                    } elseif ($obj->customer_id > 0) {
                                                        echo $obj->customer;
                                                    } else {
                                                        echo $obj->customer_name;
                                                    }
                                                    ?>
                                                </td>
                                                <td><?php echo $obj->total_bill; ?></td>
                                                <td><?php echo $obj->total_refund; ?></td>
                                                <td><?php echo $obj->due_amount; ?></td>
                                                <td>
                                                    <?php if ($obj->payment_status == 'complete') { ?>
                                                        <span class="badge badge-success"><?php echo $this->lang->line('complete'); ?></span>
                                                    <?php } elseif ($obj->payment_status == 'rejected') { ?>
                                                        <span class="badge badge-danger"><?php echo $this->lang->line('rejected'); ?></span>
                                                    <?php } else { ?>
                                                        <span class="badge badge-warning"><?php echo $this->lang->line('cancel'); ?></span>
                                                    <?php } ?>
                                                </td>
                                                <td>
                                                    <?php if (has_permission(VIEW, 'pharmacy', 'refund')) { ?>
                                                        <a href="<?php echo site_url('pharmacy/refund/customer_invoice/' . $obj->id); ?>" class="btn btn-xs btn-primary"><i class="fa fa-eye"></i> <?php echo $this->lang->line('invoice'); ?></a>
                                                    <?php } ?>
                                                </td>
                                            </tr>
                                        <?php $sl_count++;
                                        } ?>
                                    <?php } else { ?>
                                        <tr class="text-center">
                                            <td colspan="10"><?php echo $this->lang->line('no_data_found'); ?></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <!-- Card Footer -->
                <?php if ($this->pagination->create_links()) { ?>
                    <div class="card-footer justify-content-end">
                        <?php echo $this->pagination->create_links(); ?>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->


<!-- Daterangepicker -->
<link href="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>moment/min/moment.min.js"></script>
<script src="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.js"></script>

<!-- Select2 -->
<link href="<?php echo VENDOR_URL; ?>select2/dist/css/select2.min.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>select2/dist/js/select2.full.min.js"></script>

<style>
    .select2-container .select2-selection--single {
        height: calc(2.25rem + 4px) !important;
    }

    .select2-container--default .select2-search--dropdown .select2-search__field {
        color: #324148;
        border-width: 2px;
        border-color: #e0e3e4;
        padding: .375rem .75rem;
        height: calc(2.25rem + 4px);
    }

    .select2-container--default .select2-selection--single .select2-selection__arrow b {
        margin-top: 5px;
    }
</style>
<script>
    $(".select2").select2();
    $('#range').daterangepicker({
        startDate: new Date(),
        endDate: moment(),
        showDropdowns: true,
        minYear: 1901,
        locale: {
            format: 'YYYY/MM/DD',
        },
        ranges: {
            'Today': [moment(), moment()],
            'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
            'Tomorrow': [moment().subtract(-1, 'days'), moment().subtract(-1, 'days')],
            'Last 7 Days': [moment().subtract(6, 'days'), moment()],
            'Last 30 Days': [moment().subtract(29, 'days'), moment()],
            'This Month': [moment().startOf('month'), moment().endOf('month')],
            'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            'This Year': [moment().startOf('year'), moment().endOf('year')],
            'Last Year': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')]
        }
    });
</script>