<!DOCTYPE html>
<html>

<head>
	<title>Invoice Print</title>
	<style>
		body {
			font-family: "Time New Roman";
			font-size: 13px;
		}

		.page {
			width: 100%;
			margin: 0 auto;
		}

		.main_body {
			width: 100%;
			display: block;
		}

		.table {
			width: 100%;
			border-collapse: collapse;
		}

		.info_table {
			margin-top: 20px;
		}

		.content {
			margin-top: 20px;
		}

		.table_content thead th {
			padding: 0;
			vertical-align: middle;
			border: 1px solid #000;
			font-size: 12px;
			padding: 0 2px;
		}

		.table_content tbody td {
			padding: 0 2px;
			vertical-align: middle;
			border: 1px solid #000;
			font-size: 12px;
		}

		.total {
			margin-top: 20px;
		}

		.total_table tbody td {
			padding: 2px 2px;
			vertical-align: middle;
			border: 2px solid #000;
			font-size: 12px;
		}

		.footer {
			margin-top: 100px;
		}

		.billing_table tbody td {
			padding: 2px 0;
			vertical-align: middle;
			font-size: 14px;
		}
		.content{
			min-height: 650px;
		}
	</style>
</head>

<body>
	<div class="page">
		<div class="main_body">
			<!-- Billing Info -->
			<table class="table billing_table">
				<tbody>
					<tr>
						<td width="50%">
							<table class="table">
								<tbody>
									<tr>
										<td align="left">BILLING TO</td>
									</tr>
									<tr>
										<td align="left"><b style="text-transform: uppercase;"><?php echo $manufacturer->name ?? ''; ?></b></td>
									</tr>
									<tr>
										<td align="left"><?php echo $manufacturer->address; ?></td>
									</tr>
									<tr>
										<td align="left">Phone: <?php echo $manufacturer->phone; ?></td>
									</tr>
									<tr>
										<td align="left">Email : <?php echo $manufacturer->email; ?></td>
									</tr>
									<tr>
										<td align="left">Fax : <?php echo $manufacturer->fax; ?></td>
									</tr>
									<tr>
										<td align="left">Web : <?php echo $manufacturer->web; ?></td>
									</tr>
								</tbody>
							</table>
						</td>
						<td width="50%">
							<table class="table">
								<tbody>
									<tr>
										<td align="right">BILLING FROM</td>
									</tr>
									<tr>
										<td align="right"><b style="text-transform: uppercase;"><?php echo $this->global_setting->brand_title; ?></b></td>
									</tr>
									<tr>
										<td align="right"><?php echo $this->global_setting->address; ?></td>
									</tr>
									<tr>
										<td align="right">Phone: <?php echo $this->global_setting->phone; ?></td>
									</tr>
									<tr>
										<td align="right">Email: <?php echo $this->global_setting->email; ?></td>
									</tr>
									<tr>
										<td align="right"><b>Invoice#:</b> <?php echo $invoice->custom_invoice_id; ?></td>
									</tr>
									<tr>
										<td align="right"><b>Purchase Date:</b> <?php echo date('d/m/Y, h:ia', strtotime($invoice->purchase_date)); ?></td>
									</tr>
								</tbody>
							</table>
						</td>
					</tr>
				</tbody>
			</table>

			<center>
				<h2>PURCHASE INVOICE</h2>
			</center>

			<!-- Content Start-->
			<div class="content">
				<table class="table table_content">
					<thead>
						<tr>
							<th style="width: 10%;">Sl. No</th>
							<th style="width: 38%;">Medicine Name</th>
							<th style="width: 10%;">Batch No</th>
							<th style="width: 14%;">Expiry Date</th>
							<th style="width: 9%;">Quantity</th>
							<th style="width: 9%;">Rate</th>
							<th style="width: 10%;">Total</th>
						</tr>
					</thead>
					<tbody>
						<?php if (isset($details) & !empty($details)) { ?>
							<?php $count = 1; ?>
							<?php foreach ($details as $obj) { ?>
								<tr>
									<td class="text-center"><?php echo $count++; ?></td>
									<td class="text-left"><?php echo $obj->category . ' => ' . $obj->medicine_name; ?></td>
									<td class="text-right"><?php echo $obj->batch_no; ?></td>
									<td class="text-right"><?php echo $obj->expiry_date; ?></td>
									<td class="text-center"><?php echo $obj->quantity; ?></td>
									<td class="text-right"><?php echo $obj->purchase; ?></td>
									<td class="text-right"><?php echo $obj->total; ?></td>
								</tr>
							<?php } ?>
						<?php } ?>
					</tbody>
				</table>
			</div>
			<!-- Content End -->

			<!-- Footer -->
			<div class="footer">
				<table class="table">
					<tbody>
						<tr>
							<td width="70%"><b>Prepared By</b></td>
							<td width="30%">Signature</td>
						</tr>
						<tr>
							<td>
								<?php echo $employee->name; ?>
							</td>
							<td></td>
						</tr>
					</tbody>
				</table>
			</div>
		</div>
	</div>
</body>

</html>