<div class="table-wrap">
	<div class="table-responsive">
		<table class="table table-sm text-white">
			<tbody>
				<tr>
					<td><?php echo $this->lang->line('type'); ?></td>
					<td><?php echo $medicine->type; ?></td>
					<td><?php echo $this->lang->line('category'); ?></td>
					<td><?php echo $medicine->category; ?></td>
				</tr>
				<tr>
					<td><?php echo $this->lang->line('manufacturer'); ?></td>
					<td><?php echo $medicine->manufacturer; ?></td>
					<td><?php echo $this->lang->line('generic'); ?></td>
					<td><?php echo $medicine->generic; ?></td>
				</tr>
				<tr>
					<td><?php echo $this->lang->line('unit'); ?></td>
					<td><?php echo $medicine->unit; ?></td>
					<td><?php echo $this->lang->line('strength'); ?></td>
					<td><?php echo $medicine->strength; ?></td>
				</tr>
				<tr>
					<td><?php echo $this->lang->line('medicine'); ?> <?php echo $this->lang->line('name'); ?></td>
					<td><?php echo $medicine->medicine_name; ?></td>
					<td><?php echo $this->lang->line('rack_no'); ?></td>
					<td><?php echo $medicine->rack_no; ?></td>
				</tr>
				<tr>
					<td><?php echo $this->lang->line('mrp'); ?></td>
					<td><?php echo $medicine->mrp; ?></td>
					<td><?php echo $this->lang->line('purchase'); ?> <?php echo $this->lang->line('price'); ?></td>
					<td><?php echo $medicine->purchase_price; ?></td>
				</tr>
				<tr>
					<td><?php echo $this->lang->line('sell'); ?> <?php echo $this->lang->line('price'); ?></td>
					<td><?php echo $medicine->sell_price; ?></td>
					<td><?php echo $this->lang->line('wholesale'); ?> <?php echo $this->lang->line('price'); ?></td>
					<td><?php echo $medicine->whole_sale_price; ?></td>
				</tr>
				<tr>
					<td><?php echo $this->lang->line('minimum_stock'); ?></td>
					<td><?php echo $medicine->minimum_stock; ?></td>
					<td><?php echo $this->lang->line('code'); ?></td>
					<td><?php echo $medicine->code; ?></td>
				</tr>
				<tr>
					<td><?php echo $this->lang->line('photo'); ?></td>
					<td>
						<div class="avatar mr-10">
							<?php if ($medicine->photo) { ?>
								<img class="avatar-img rounded" src="<?php echo UPLOAD_PATH; ?>medicine-photo/<?php echo $medicine->photo; ?>" alt="<?php echo $medicine->medicine_name; ?>" />
							<?php } else { ?>
								<img class="avatar-img rounded" src="<?php echo IMG_URL; ?>no-image.png" alt="no-image" />
							<?php } ?>
						</div>
					</td>
					<td><?php echo $this->lang->line('status'); ?></td>
					<td><?php echo $medicine->status ? '<span class="badge badge-primary">' . $this->lang->line('active') . '</span>' : '<span class="badge badge-danger">' . $this->lang->line('in_active') . '</span>'; ?></td>
				</tr>
				<tr>
					<td><?php echo $this->lang->line('created_by'); ?></td>
					<td><?php echo $medicine->created_by; ?></td>
					<td><?php echo $this->lang->line('date'); ?></td>
					<td><?php echo date('d F, Y h:i A', strtotime($medicine->created_at)); ?></td>
				</tr>
				<?php if ($this->session->userdata('role_id') == SUPER_ADMIN || !empty(custom_permission('modified_by'))) { ?>
					<tr>
						<td><?php echo $this->lang->line('modified_by'); ?></td>
						<td><?php echo $medicine->modified_by; ?></td>
						<td><?php echo $this->lang->line('date'); ?></td>
						<td><?php echo $medicine->modified_by ? date('d F, Y h:i A', strtotime($medicine->modified_at)) : ''; ?>
						</td>
					</tr>
				<?php } ?>
			</tbody>
		</table>
	</div>
</div>