<!-- Container -->
<div class="container mt-xl-50 mt-sm-30 mt-15">
    <!-- Title -->
    <div class="hk-pg-header align-items-top">
        <div>
            <h2 class="hk-pg-title font-weight-600 mb-10"><?php echo $this->lang->line('dashboard'); ?></h2>
        </div>
        <div class="align-items-center">
            <?php if (has_permission(ADD, 'pharmacy', 'sale')) { ?>
                <a href="<?php echo site_url('pharmacy/sale/add'); ?>" class="btn btn-xs btn-danger">
                    <i class="fa fa-plus font-12 mr-5"></i>
                    <?php echo $this->lang->line('create'); ?> <?php echo $this->lang->line('sale'); ?>
                </a>
            <?php } ?>

            <?php if (has_permission(ADD, 'pharmacy', 'sale')) { ?>
                <a href="<?php echo site_url('pharmacy/sale/gui'); ?>" class="btn btn-xs btn-info">
                    <i class="fa fa-plus font-12 mr-5"></i>
                    <?php echo $this->lang->line('create'); ?> <?php echo $this->lang->line('gui_pos'); ?> <?php echo $this->lang->line('sale'); ?>
                </a>
            <?php } ?>

            <?php if (has_permission(VIEW, 'pharmacy', 'sale')) { ?>
                <a href="<?php echo site_url('pharmacy/sale'); ?>" class="btn btn-xs btn-success">
                    <i class="fa fa-balance-scale font-12 mr-5"></i>
                    <?php echo $this->lang->line('sale'); ?>
                </a>
            <?php } ?>
            <?php if (has_permission(VIEW, 'pharmacy', 'purchase')) { ?>
                <a href="<?php echo site_url('pharmacy/purchase'); ?>" class="btn btn-xs btn-warning">
                    <i class="fa fa-cart-plus font-12 mr-5"></i>
                    <?php echo $this->lang->line('purchase'); ?>
                </a>
            <?php } ?>
            <?php if (has_permission(VIEW, 'pharmacy', 'stock')) { ?>
                <a href="<?php echo site_url('pharmacy/stock'); ?>" class="btn btn-xs btn-primary">
                    <i class="fa fa-bar-chart font-12 mr-5"></i>
                    <?php echo $this->lang->line('stock'); ?>
                </a>
            <?php } ?>
        </div>
    </div>
    <!-- /Title -->
    <!-- Row -->
    <div class="row">
        <div class="col-xl-12">
            <!-- Counter Start -->
            <div class="hk-row">
                <div class="col-lg-3 col-md-3 col-sm-6">
                    <div class="card card-sm">
                        <div class="card-body">
                            <div class="d-flex align-items-center justify-content-between">
                                <div>
                                    <span class="d-block font-12 font-weight-bold text-dark text-uppercase mb-5">
                                        <?php echo $this->lang->line('total'); ?> <?php echo $this->lang->line('customer'); ?>
                                    </span>
                                    <span class="d-block display-6 font-weight-400 text-dark">
                                        <?php echo number_format($total_customer, 0) ?? 0; ?>
                                    </span>
                                </div>
                                <div>
                                    <a href="<?php echo site_url('patient'); ?>" class="btn btn-primary btn-sm">
                                        <i class="fa fa-user" aria-hidden="true"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!--/ col-lg-3 col-md-3 col-sm-6 -->
                <div class="col-lg-3 col-md-3 col-sm-6">
                    <div class="card card-sm">
                        <div class="card-body">
                            <div class="d-flex align-items-center justify-content-between">
                                <div>
                                    <span class="d-block font-12 font-weight-bold text-dark text-uppercase mb-5">
                                        <?php echo $this->lang->line('total'); ?> <?php echo $this->lang->line('manufacturer'); ?>
                                    </span>
                                    <span class="d-block display-6 font-weight-400 text-dark">
                                        <?php echo number_format($total_manufacturer, 0) ?? 0; ?>
                                    </span>
                                </div>
                                <div>
                                    <a href="<?php echo site_url('pharmacy/manufacturer'); ?>" class="btn btn-success btn-sm">
                                        <i class="fa fa-industry" aria-hidden="true"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!--/ col-lg-3 col-md-3 col-sm-6 -->
                <div class="col-lg-3 col-md-3 col-sm-6">
                    <div class="card card-sm">
                        <div class="card-body">
                            <div class="d-flex align-items-center justify-content-between">
                                <div>
                                    <span class="d-block font-12 font-weight-bold text-dark text-uppercase mb-5">
                                        <?php echo $this->lang->line('total'); ?> <?php echo $this->lang->line('medicine'); ?>
                                    </span>
                                    <span class="d-block display-6 font-weight-400 text-dark">
                                        <?php echo number_format($total_medicine, 0) ?? 0; ?>
                                    </span>
                                </div>
                                <div>
                                    <a href="<?php echo site_url('pharmacy/stock'); ?>" class="btn btn-info btn-sm">
                                        <i class="fa fa-medkit" aria-hidden="true"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!--/ col-lg-3 col-md-3 col-sm-6 -->
                <div class="col-lg-3 col-md-3 col-sm-6">
                    <div class="card card-sm">
                        <div class="card-body">
                            <div class="d-flex align-items-center justify-content-between">
                                <div>
                                    <span class="d-block font-12 font-weight-bold text-dark text-uppercase mb-5">
                                        <?php echo $this->lang->line('total'); ?> <?php echo $this->lang->line('medicine'); ?> <?php echo $this->lang->line('purchase'); ?>
                                    </span>
                                    <span class="d-block display-6 font-weight-400 text-dark">
                                        <?php echo number_format($total_medicine_purchase, 0) ?? 0; ?>
                                    </span>
                                </div>
                                <div>
                                    <a href="<?php echo site_url('pharmacy/purchase'); ?>" class="btn btn-indigo btn-sm">
                                        <i class="fa fa-cart-plus" aria-hidden="true"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!--/ col-lg-3 col-md-3 col-sm-6 -->
                <div class="col-lg-3 col-md-3 col-sm-6">
                    <div class="card card-sm">
                        <div class="card-body">
                            <div class="d-flex align-items-center justify-content-between">
                                <div>
                                    <span class="d-block font-12 font-weight-bold text-dark text-uppercase mb-5">
                                        <?php echo $this->lang->line('total'); ?> <?php echo $this->lang->line('medicine'); ?> <?php echo $this->lang->line('sale'); ?>
                                    </span>
                                    <span class="d-block display-6 font-weight-400 text-dark">
                                        <?php echo number_format($total_medicine_sale, 0) ?? 0; ?>
                                    </span>
                                </div>
                                <div>
                                    <a href="<?php echo site_url('pharmacy/sale'); ?>" class="btn btn-sky btn-sm">
                                        <i class="fa fa-balance-scale" aria-hidden="true"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!--/ col-lg-3 col-md-3 col-sm-6 -->
                <div class="col-lg-3 col-md-3 col-sm-6">
                    <div class="card card-sm">
                        <div class="card-body">
                            <div class="d-flex align-items-center justify-content-between">
                                <div>
                                    <span class="d-block font-12 font-weight-bold text-dark text-uppercase mb-5">
                                        <?php echo $this->lang->line('total'); ?> <?php echo $this->lang->line('refund'); ?>
                                    </span>
                                    <span class="d-block display-6 font-weight-400 text-dark">
                                        <?php echo number_format($total_medicine_refund, 0) ?? 0; ?>
                                    </span>
                                </div>
                                <div>
                                    <a href="<?php echo site_url('pharmacy/refund'); ?>" class="btn btn-sun btn-sm">
                                        <i class="fa fa-undo" aria-hidden="true"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!--/ col-lg-3 col-md-3 col-sm-6 -->
                <div class="col-lg-3 col-md-3 col-sm-6">
                    <div class="card card-sm">
                        <div class="card-body">
                            <div class="d-flex align-items-center justify-content-between">
                                <div>
                                    <span class="d-block font-12 font-weight-bold text-dark text-uppercase mb-5">
                                        <?php echo $this->lang->line('total'); ?> <?php echo $this->lang->line('medicine'); ?> <?php echo $this->lang->line('stock'); ?>
                                    </span>
                                    <span class="d-block display-6 font-weight-400 text-dark">
                                        <?php echo number_format(($total_medicine_purchase - ($total_medicine_sale - $total_medicine_refund)), 0); ?>
                                    </span>
                                </div>
                                <div>
                                    <a href="<?php echo site_url('pharmacy/stock'); ?>" class="btn btn-orange btn-sm">
                                        <i class="fa fa-bar-chart" aria-hidden="true"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!--/ col-lg-3 col-md-3 col-sm-6 -->
                <div class="col-lg-3 col-md-3 col-sm-6">
                    <div class="card card-sm">
                        <div class="card-body">
                            <div class="d-flex align-items-center justify-content-between">
                                <div>
                                    <span class="d-block font-12 font-weight-bold text-dark text-uppercase mb-5">
                                        <?php echo $this->lang->line('total'); ?> <?php echo $this->lang->line('medicine'); ?> <?php echo $this->lang->line('expire'); ?>
                                    </span>
                                    <span class="d-block display-6 font-weight-400 text-dark">
                                        <?php echo number_format($total_medicine_expire, 0) ?? 0; ?>
                                    </span>
                                </div>
                                <div>
                                    <a href="<?php echo site_url('pharmacy/stock'); ?>" class="btn btn-danger btn-sm">
                                        <i class="fa fa-times" aria-hidden="true"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!--/ col-lg-3 col-md-3 col-sm-6 -->
            </div>
            <!-- Counter End -->

            <div class="hk-row">
                <div class="col-lg-8">
                    <div class="card">
                        <div class="card-header">
                            <h6>Yearly Income & Expense</h6>
                        </div>
                        <div class="card-body">
                            <div id="running_year_ie" class="echart" style="height:190px;"></div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="card">
                        <div class="card-header">
                            <h6><?php echo date('F, Y'); ?></h6>
                        </div>
                        <div class="card-body">
                            <div class="hk-legend-wrap mb-20">
                                <div class="hk-legend">
                                    <span class="d-10 bg-primary rounded-circle d-inline-block"></span><span><?php echo $this->lang->line('sale'); ?></span>
                                </div>
                                <div class="hk-legend">
                                    <span class="d-10 bg-danger rounded-circle d-inline-block"></span><span><?php echo $this->lang->line('purchase'); ?></span>
                                </div>
                            </div>
                            <div id="running_month_ie" class="echart" style="height:150px;"></div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Invoice & Role -->
            <div class="hk-row">
                <?php if (isset($invoices) && !empty($invoices)) { ?>
                    <div class="col-lg-9">
                        <div class="card">
                            <div class="card-header">
                                <h6>
                                    <i class="fa fa-file-text"></i>
                                    <?php echo $this->lang->line('invoice'); ?> <?php echo $this->lang->line('list'); ?>
                                </h6>
                            </div>
                            <div class="card-body pa-0">
                                <div class="table-wrap">
                                    <div class="table-responsive">
                                        <table class="table table-sm table-hover mb-0">
                                            <thead>
                                                <tr>
                                                    <th><?php echo $this->lang->line('invoice_no'); ?></th>
                                                    <th><?php echo $this->lang->line('date'); ?></th>
                                                    <th><?php echo $this->lang->line('patient_id'); ?></th>
                                                    <th><?php echo $this->lang->line('customer'); ?></th>
                                                    <th><?php echo $this->lang->line('total'); ?> <?php echo $this->lang->line('bill'); ?></th>
                                                    <th><?php echo $this->lang->line('action'); ?></th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php foreach ($invoices as $obj) { ?>
                                                    <tr>
                                                        <td><?php echo $obj->custom_invoice_id; ?></td>
                                                        <td><?php echo date('d M, Y h:ia', strtotime($obj->bill_date)); ?></td>
                                                        <td><?php echo $obj->patient_unique_id; ?></td>
                                                        <td>
                                                            <?php
                                                            if ($obj->walking == 1) {
                                                                echo $this->lang->line('walking') . ' ' . $this->lang->line('customer');
                                                            } elseif ($obj->customer_id > 0) {
                                                                echo $obj->customer;
                                                            } else {
                                                                echo $obj->customer_name;
                                                            }
                                                            ?>
                                                        </td>
                                                        <td><?php echo $obj->total_bill; ?></td>
                                                        <td>
                                                            <a href="<?php echo site_url('pharmacy/sale/invoice/' . $obj->id); ?>" class="btn btn-primary btn-sm">
                                                                <i class="fa fa-eye" aria-hidden="true"></i>
                                                            </a>
                                                        </td>
                                                    </tr>
                                                <?php } ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- /col-lg-9 -->
                <?php } ?>
                <div class="col-lg-3">
                    <!-- /info-box -->
                    <div class="info-box">
                        <a href="#">
                            <span class="info-box-icon bg-primary"><i class="fa fa-user text-white"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text"><?php echo $this->lang->line('admin'); ?></span>
                                <span class="info-box-number"><?php echo $total_admin ? $total_admin : 0; ?></span>
                            </div>
                        </a>
                    </div>
                    <!-- /info-box -->
                    <div class="info-box">
                        <a href="#">
                            <span class="info-box-icon bg-success"><i class="fa fa-user-md text-white"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text"><?php echo $this->lang->line('doctor'); ?></span>
                                <span class="info-box-number"><?php echo $total_doctor ? $total_doctor : 0; ?></span>
                            </div>
                        </a>
                    </div>
                    <!-- /info-box -->
                    <div class="info-box">
                        <a href="#">
                            <span class="info-box-icon bg-teal"><i class="fa fa-user-o text-white"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text"><?php echo $this->lang->line('patient'); ?></span>
                                <span class="info-box-number"><?php echo $total_patient ? $total_patient : 0; ?></span>
                            </div>
                        </a>
                    </div>
                    <!-- /info-box -->
                    <div class="info-box">
                        <a href="#">
                            <span class="info-box-icon bg-lime"><i class="fa fa-user text-white"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text"><?php echo $this->lang->line('accountant'); ?></span>
                                <span class="info-box-number"><?php echo $total_accountant ? $total_accountant : 0; ?></span>
                            </div>
                        </a>
                    </div>
                    <!-- /info-box -->
                    <div class="info-box">
                        <a href="#">
                            <span class="info-box-icon bg-orange"><i class="fa fa-user text-white"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text"><?php echo $this->lang->line('pathologist'); ?></span>
                                <span class="info-box-number"><?php echo $total_pathologist ? $total_pathologist : 0; ?></span>
                            </div>
                        </a>
                    </div>
                    <!-- /info-box -->
                    <div class="info-box">
                        <a href="#">
                            <span class="info-box-icon bg-violet"><i class="fa fa-user text-white"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text"><?php echo $this->lang->line('radiologist'); ?></span>
                                <span class="info-box-number"><?php echo $total_radiologist ? $total_radiologist : 0; ?></span>
                            </div>
                        </a>
                    </div>
                    <!-- /info-box -->
                    <div class="info-box">
                        <a href="#">
                            <span class="info-box-icon bg-indigo"><i class="fa fa-female text-white"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text"><?php echo $this->lang->line('nurse'); ?></span>
                                <span class="info-box-number"><?php echo $total_nurse ? $total_nurse : 0; ?></span>
                            </div>
                        </a>
                    </div>
                    <!-- /info-box -->
                    <div class="info-box">
                        <a href="#">
                            <span class="info-box-icon bg-blue"><i class="fa fa-user text-white"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text"><?php echo $this->lang->line('receptionist'); ?></span>
                                <span class="info-box-number"><?php echo $total_receptionist ? $total_receptionist : 0; ?></span>
                            </div>
                        </a>
                    </div>
                    <!-- /info-box -->
                </div>
                <!-- /col-lg-6 -->
            </div>
            <!-- Invoice & Role End -->
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->

<!-- EChartJS JavaScript -->
<script src="<?php echo VENDOR_URL; ?>echarts/dist/echarts-en.min.js"></script>

<script>
    if ($('#running_month_ie').length > 0) {
        var running_month_ie = echarts.init(document.getElementById('running_month_ie'));
        var option9 = {
            tooltip: {
                show: true,
                backgroundColor: '#fff',
                borderRadius: 6,
                padding: 6,
                axisPointer: {
                    lineStyle: {
                        width: 0,
                    }
                },
                textStyle: {
                    color: '#324148',
                    fontFamily: '"Nunito", sans-serif',
                    fontSize: 12
                }
            },
            series: [{
                name: '',
                type: 'pie',
                radius: '60%',
                center: ['50%', '50%'],
                roseType: 'radius',
                color: ['#ab26aa', '#FF2F26'],
                data: [{
                        value: <?php echo $total_sale ?? 0; ?>, // Income
                        name: ''
                    },
                    {
                        value: <?php echo $total_purchase ?? 0; ?>, //Expense
                        name: ''
                    }
                ],
                label: {
                    normal: {
                        formatter: '{b}\n{d}%'
                    },

                }
            }]
        };
        running_month_ie.setOption(option9);
        running_month_ie.resize();
    }

    // Running Yearly Income & Expense chart
    if ($('#running_year_ie').length > 0) {
        var eChart_1 = echarts.init(document.getElementById('running_year_ie'));
        var option = {
            color: ['#BC29BB'],
            tooltip: {
                show: true,
                trigger: 'axis',
                backgroundColor: '#fff',
                borderRadius: 6,
                padding: 6,
                axisPointer: {
                    lineStyle: {
                        width: 0,
                    }
                },
                textStyle: {
                    color: '#324148',
                    fontFamily: '"Nunito", sans-serif',
                    fontSize: 12
                }
            },

            xAxis: [{
                type: 'category',
                data: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sept', 'Oct', 'Nov', 'Dec'],
                axisLine: {
                    show: false
                },
                axisTick: {
                    show: false
                },
                axisLabel: {
                    textStyle: {
                        color: '#5e7d8a'
                    }
                }
            }],
            yAxis: {
                type: 'value',
                axisLine: {
                    show: false
                },
                axisTick: {
                    show: false
                },
                axisLabel: {
                    textStyle: {
                        color: '#BC29BB'
                    }
                },
                splitLine: {
                    lineStyle: {
                        color: '#5e7d8a',
                    }
                }
            },
            grid: {
                top: '3%',
                left: '3%',
                right: '3%',
                bottom: '3%',
                containLabel: true
            },
            series: [{
                data: [120, 200, 150, 80, 70, 110, 130, 150, 80, 70, 110, 130],
                type: 'bar',
                barMaxWidth: 30,
                itemStyle: {
                    normal: {
                        barBorderRadius: [6, 6, 0, 0],
                    }
                },
            }]
        };
        eChart_1.setOption(option);
        eChart_1.resize();
    }
</script>