<?php

defined('BASEPATH') or exit('No direct script access allowed');

/* * *****************Stock.php**********************************
 * @product name    : Hospital Management System
 * @type            : Class
 * @class name      : Stock
 * @description     : Manage stock.
 * @author          : South Bangla IT Zone Team
 * @url             : http://hms.sbitzone.com
 * @support         : rabibd.it@gmail.com
 * @copyright       : South Bangla IT Zone Team
 * ********************************************************** */

class Stock extends MY_Controller {

    public $data = array();

    function __construct() {
        parent::__construct();
        $this->load->model('Stock_Model', 'stock', true);
    }

    /*****************Function index**********************************
     * @type            : Function
     * @function name   : index
     * @description     : Load "Stock List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function index() {

        check_permission(VIEW);

        if ($_GET) {
            $keyword = trim($this->input->get('keyword'));
            $type_id = $this->input->get('type_id');
            $category_id = $this->input->get('category_id');
            $generic_id = $this->input->get('generic_id');
            $manufacturer_id = $this->input->get('manufacturer_id');
            $medicine_id = $this->input->get('medicine_id');

            $config = array();
            $config = get_pagination(ADMIN_PER_PAGE);
            $config['base_url'] = site_url('pharmacy/stock/?keyword=' . $keyword . '&type_id=' . $type_id . '&category_id=' . $category_id . '&generic_id=' . $generic_id . '&manufacturer_id=' . $manufacturer_id . '&medicine_id=' . $medicine_id);
            if ($this->input->get('page')) {
                $sgm = (int) trim($this->input->get('page'));
                $offset = $config['per_page'] * ($sgm - 1);
            } else {
                $offset = 0;
            }

            $config['total_rows'] = $this->stock->get_medicine_stock_list($config['per_page'], $offset, $keyword, $type_id, $category_id, $generic_id, $manufacturer_id, $medicine_id, $count = TRUE);
            $this->pagination->initialize($config);
            $this->data['stocks'] = $this->stock->get_medicine_stock_list($config['per_page'], $offset, $keyword, $type_id, $category_id, $generic_id, $manufacturer_id, $medicine_id, $count = FALSE);
            $this->data['sl_count'] = ($this->input->get('page') == 0 ? 1 : (($this->input->get('page') - 1) * $config["per_page"] + 1));
            $this->data['keyword'] = $keyword;
            $this->data['type_id'] = $type_id;
            $this->data['category_id'] = $category_id;
            $this->data['generic_id'] = $generic_id;
            $this->data['manufacturer_id'] = $manufacturer_id;
            $this->data['medicine_id'] = $medicine_id;
        } else {
            $config = array();
            $config = get_pagination(ADMIN_PER_PAGE);
            $config['base_url'] = current_url();
            if ($this->input->get('page')) {
                $sgm = (int) trim($this->input->get('page'));
                $offset = $config['per_page'] * ($sgm - 1);
            } else {
                $offset = 0;
            }

            $config['total_rows'] = $this->stock->get_medicine_stock_list($config['per_page'], $offset, null, null, null, null, null, null, $count = TRUE);
            $this->pagination->initialize($config);
            $this->data['stocks'] = $this->stock->get_medicine_stock_list($config['per_page'], $offset, null, null, null, null, null, null, $count = FALSE);
            $this->data['sl_count'] = ($this->input->get('page') == 0 ? 1 : (($this->input->get('page') - 1) * $config["per_page"] + 1));
        }

        $this->data['types'] = $this->stock->get_list('medicine_types', array('status' => 1), '', '', '', 'id', 'ASC');
        $this->data['categories'] = $this->stock->get_list('medicine_categories', array('status' => 1), '', '', '', 'id', 'ASC');
        $this->data['manufacturers'] = $this->stock->get_list('manufacturers', array('status' => 1), '', '', '', 'id', 'ASC');
        $this->data['generics'] = $this->stock->get_list('medicine_generics', array('status' => 1), '', '', '', 'id', 'ASC');
        $this->data['medicines'] = $this->stock->get_list('medicines', array('status' => 1, 'manufacturer_id' => $this->input->get('manufacturer_id')), '', '', '', 'id', 'ASC');

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('manage_stock') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('stock/index', $this->data);
    }

    /*****************Function detail**********************************
     * @type            : Function
     * @function name   : view
     * @description     : Load "Stock Details List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function detail() {

        check_permission(VIEW);

        $this->data['medicine'] = $this->stock->get_single_medicine($this->uri->segment(4, 0));
        $this->data['total_purchase'] = $this->stock->get_total_purchase($this->uri->segment(4, 0));
        $this->data['total_sale'] = $this->stock->get_total_sale($this->uri->segment(4, 0));

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('detail') . ' ' . $this->lang->line('medicine') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('stock/detail', $this->data);
    }


    /*****************Function ajaxPurchase**********************************
     * @type            : Function
     * @function name   : view
     * @description     : Load "Purchase List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */

    public function ajaxPurchase($offset = null) {
        $search = array(
            'keyword' => trim($this->input->post('search_key')),
        );

        $config = array();
        $config = get_ajax_pagination();
        $limit = ADMIN_PER_PAGE;
        $config['per_page'] = $limit;
        $offset = ($this->uri->segment(5)) ? $this->uri->segment(5) : 0;
        $config['base_url'] = site_url('pharmacy/stock/ajaxPurchase/' . $this->uri->segment(4));

        $config['total_rows'] = $this->stock->get_purchase_report_list($limit, $offset, $search, $count = true);
        $this->pagination->initialize($config);
        $this->data['purchases'] = $this->stock->get_purchase_report_list($limit, $offset, $search, $count = false);
        $this->data['sl_count'] = ($offset == 0 ? 1 : (($offset - 1) * $config["per_page"] + 1));
        $this->data['pagination_link'] = $this->pagination->create_links();

        $this->load->view('pharmacy/stock/ajax-purchase-data', $this->data);
    }


    /*****************Function ajaxSale**********************************
     * @type            : Function
     * @function name   : view
     * @description     : Load "Sale List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */

    public function ajaxSale($offset = null) {
        $search = array(
            'keyword' => trim($this->input->post('search_key')),
        );

        $config = array();
        $config = get_ajax_pagination();
        $limit = ADMIN_PER_PAGE;
        $config['per_page'] = $limit;
        $offset = ($this->uri->segment(5)) ? $this->uri->segment(5) : 0;
        $config['base_url'] = site_url('pharmacy/stock/ajaxSale/' . $this->uri->segment(4));

        $config['total_rows'] = $this->stock->get_sale_report_list($limit, $offset, $search, $count = true);
        $this->pagination->initialize($config);
        $this->data['sales'] = $this->stock->get_sale_report_list($limit, $offset, $search, $count = false);
        $this->data['sl_count'] = ($offset == 0 ? 1 : (($offset - 1) * $config["per_page"] + 1));
        $this->data['pagination_link'] = $this->pagination->create_links();

        $this->load->view('pharmacy/stock/ajax-sale-data', $this->data);
    }
}
