<!-- Nav tabs -->
<ul class="nav nav-tabs" role="tablist">
    <li class="nav-item">
        <a class="nav-link active" data-toggle="tab" href="#tab_basic_info">
            <i class="fa fa-info-circle"></i> <?php echo $this->lang->line('basic'); ?> <?php echo $this->lang->line('information'); ?>
        </a>
    </li>
    <?php if ($this->session->userdata('role_id') == SUPER_ADMIN) { ?>
        <li class="nav-item">
            <a class="nav-link" data-toggle="tab" href="#tab_login_info">
                <i class="fa fa-key"></i> <?php echo $this->lang->line('login'); ?> <?php echo $this->lang->line('information'); ?>
            </a>
        </li>
    <?php } ?>
</ul>

<!-- Tab panes -->
<div class="tab-content">
    <div id="tab_basic_info" class="container tab-pane active">
        <div class="table-wrap">
            <div class="table-responsive">
                <table class="table table-sm mt-30 text-white">
                    <tbody>
                        <tr>
                            <td><?php echo $this->lang->line('name'); ?></td>
                            <td><?php echo $patient->name; ?></td>
                            <td><?php echo $this->lang->line('bangla'); ?> <?php echo $this->lang->line('name'); ?></td>
                            <td><?php echo $patient->bn_name; ?></td>
                        </tr>
                        <tr>
                            <td><?php echo $this->lang->line('email'); ?></td>
                            <td><?php echo $patient->email; ?></td>
                            <td><?php echo $this->lang->line('phone'); ?></td>
                            <td><?php echo $patient->phone; ?></td>
                        </tr>
                        <tr>
                            <td><?php echo $this->lang->line('gender'); ?></td>
                            <td><?php echo $patient->gender ? $this->lang->line($patient->gender) : ''; ?></td>
                            <td><?php echo $this->lang->line('religion'); ?></td>
                            <td><?php echo $patient->religion ? $this->lang->line($patient->religion) : ''; ?></td>
                        </tr>
                        <tr>
                            <td><?php echo $this->lang->line('blood_group'); ?></td>
                            <td><?php echo $patient->blood_group ? $this->lang->line($patient->blood_group) : ''; ?></td>
                            <td><?php echo $this->lang->line('marital_status'); ?></td>
                            <td><?php echo $patient->marital_status ? $this->lang->line($patient->marital_status) : ''; ?></td>
                        </tr>
                        <tr>
                            <td><?php echo $this->lang->line('birth_date'); ?></td>
                            <td><?php echo date($this->global_setting->date_format, strtotime($patient->dob)); ?> (<?php echo $this->lang->line('age'); ?> : <?php echo $patient->age; ?> <?php echo $this->lang->line('year'); ?>)</td>
                            <td><?php echo $this->lang->line('national_id'); ?></td>
                            <td><?php echo $patient->national_id; ?></td>
                        </tr>
                        <tr>
                            <td><?php echo $this->lang->line('status'); ?></td>
                            <td><?php echo $patient->status ? $this->lang->line('active') : $this->lang->line('in_active'); ?></td>
                            <td><?php echo $this->lang->line('photo'); ?></td>
                            <td>
                                <div class="avatar mr-10">
                                    <?php if ($patient->photo) { ?>
                                        <img class="avatar-img rounded" src="<?php echo UPLOAD_PATH; ?>patient-photo/<?php echo $patient->photo; ?>" alt="<?php echo $patient->name; ?>" />
                                    <?php } elseif ($patient->gender == 'male') { ?>
                                        <img class="avatar-img rounded" src="<?php echo IMG_URL; ?>male.png" alt="male" />
                                    <?php } else { ?>
                                        <img class="avatar-img rounded" src="<?php echo IMG_URL; ?>female.png" alt="female" />
                                    <?php } ?>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <td><?php echo $this->lang->line('created_by'); ?></td>
                            <td><?php echo $patient->created_by; ?></td>
                            <td><?php echo $this->lang->line('date'); ?></td>
                            <td><?php echo date('d F, Y h:i A', strtotime($patient->created_at)); ?></td>
                        </tr>
                        <?php if ($this->session->userdata('role_id') == SUPER_ADMIN || !empty(custom_permission('modified_by'))) { ?>
                            <tr>
                                <td><?php echo $this->lang->line('modified_by'); ?></td>
                                <td><?php echo $patient->modified_by; ?></td>
                                <td><?php echo $this->lang->line('date'); ?></td>
                                <td><?php echo $patient->modified_by ? date('d F, Y h:i A', strtotime($patient->modified_at)) : ''; ?>
                                </td>
                            </tr>
                        <?php } ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <!-- Basic Info End -->
    <?php if ($this->session->userdata('role_id') == SUPER_ADMIN) { ?>
        <div id="tab_login_info" class="container tab-pane fade">
            <div class="table-wrap">
                <div class="table-responsive">
                    <table class="table table-sm mt-30 text-white">
                        <tbody>
                            <tr>
                                <td><?php echo $this->lang->line('username'); ?></td>
                                <td><?php echo $patient->username; ?></td>
                                <td><?php echo $this->lang->line('password'); ?></td>
                                <td><?php echo base64_decode($patient->temp_password); ?></td>
                            </tr>
                            <tr>
                                <td><?php echo $this->lang->line('device_id'); ?></td>
                                <td><?php echo $patient->device_id; ?></td>
                                <td><?php echo $this->lang->line('sbiz_id'); ?></td>
                                <td><?php echo $patient->sbiz_id; ?></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    <?php } ?>
    <!-- Login Info End -->
</div>