<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('patient'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('manage_patient'); ?>
        </h4>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <!-- col-lg-12 -->
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(EDIT, 'patient', 'patient')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-user-circle-o font-30 mr-10"></i>
                            <?php echo $this->lang->line('edit'); ?> <?php echo $this->lang->line('patient'); ?>
                        </h6>
                    <?php } ?>
                    <?php if (has_permission(VIEW, 'patient', 'patient')) { ?>
                        <div class="align-items-center">
                            <a href="<?php echo site_url('patient'); ?>" class="btn btn-xs btn-primary">
                                <i class="fa fa-list font-12 mr-5"></i>
                                <?php echo $this->lang->line('patient'); ?> <?php echo $this->lang->line('list'); ?>
                            </a>
                        </div>
                    <?php } ?>
                </div>

                <?php echo form_open_multipart(site_url('patient/edit/' . $patient->user_id), array('name' => 'edit', 'id' => 'edit', 'class' => 'needs-validation', 'novalidate' => 'novalidate'), ''); ?>
                <div class="card-body">
                    <div class="form-row">
                        <div class="col-md-3 mb-10">
                            <label for="name"><?php echo $this->lang->line('patient'); ?> <?php echo $this->lang->line('name'); ?></label>
                            <input type="text" class="form-control" name="name" id="name" value="<?php echo isset($patient->name) ?  $patient->name : ''; ?>" placeholder="<?php echo $this->lang->line('patient'); ?> <?php echo $this->lang->line('name'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="name" class="form-text text-muted">
                                <?php echo form_error('name'); ?>
                            </small>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="bn_name"><?php echo $this->lang->line('patient'); ?> <?php echo $this->lang->line('bn_name'); ?></label>
                            <input type="text" class="form-control" name="bn_name" id="bn_name" value="<?php echo isset($patient->bn_name) ?  $patient->bn_name : ''; ?>" placeholder="<?php echo $this->lang->line('patient'); ?> <?php echo $this->lang->line('bn_name'); ?>">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="guardian_name"><?php echo $this->lang->line('guardian_name'); ?></label>
                            <input type="text" class="form-control" name="guardian_name" id="guardian_name" value="<?php echo isset($patient->guardian_name) ?  $patient->guardian_name : ''; ?>" placeholder="<?php echo $this->lang->line('guardian_name'); ?>">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="phone"><?php echo $this->lang->line('phone'); ?></label>
                            <input type="number" class="form-control" name="phone" id="phone" value="<?php echo isset($patient->phone) ?  $patient->phone : ''; ?>" placeholder="<?php echo $this->lang->line('phone'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="phone" class="form-text text-muted">
                                <?php echo form_error('phone'); ?>
                            </small>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="birth_date"><?php echo $this->lang->line('birth_date'); ?></label>
                            <input type="text" class="form-control" name="dob" id="dob" value="<?php echo isset($patient->dob) ?  $patient->dob : ''; ?>" placeholder="<?php echo $this->lang->line('birth_date'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="name" class="form-text text-muted">
                                <?php echo form_error('birth_date'); ?>
                            </small>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="gender"><?php echo $this->lang->line('gender'); ?></label>
                            <select class="form-control custom-select" name="gender" id="gender" required>
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php $genders = get_genders(); ?>
                                <?php foreach ($genders as $key => $value) { ?>
                                    <option value="<?php echo $key; ?>" <?php echo isset($patient->gender) && $patient->gender == $key ? 'selected="selected"' : ""; ?>><?php echo $value; ?></option>
                                <?php } ?>
                            </select>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="name" class="form-text text-muted">
                                <?php echo form_error('gender'); ?>
                            </small>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="religion"><?php echo $this->lang->line('religion'); ?></label>
                            <select class="form-control custom-select" name="religion" id="religion" required>
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php $religions = get_religion(); ?>
                                <?php foreach ($religions as $key => $value) { ?>
                                    <option value="<?php echo $key; ?>" <?php echo isset($patient->religion) && $patient->religion == $key ? 'selected="selected"' : ""; ?>><?php echo $value; ?></option>
                                <?php } ?>
                            </select>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="name" class="form-text text-muted">
                                <?php echo form_error('religion'); ?>
                            </small>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="blood_group"><?php echo $this->lang->line('blood_group'); ?></label>
                            <select class="form-control custom-select" name="blood_group" id="blood_group">
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php $bloods = get_blood_group(); ?>
                                <?php foreach ($bloods as $key => $value) { ?>
                                    <option value="<?php echo $key; ?>" <?php echo isset($patient->blood_group) && $patient->blood_group == $key ? 'selected="selected"' : ""; ?>><?php echo $value; ?></option>
                                <?php } ?>
                            </select>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="marital_status"><?php echo $this->lang->line('marital_status'); ?></label>
                            <select class="form-control custom-select" name="marital_status" id="marital_status">
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php $marital_status = get_marital_status(); ?>
                                <?php foreach ($marital_status as $key => $value) { ?>
                                    <option value="<?php echo $key; ?>" <?php echo isset($patient->marital_status) && $patient->marital_status == $key ? 'selected="selected"' : ""; ?>><?php echo $value; ?></option>
                                <?php } ?>
                            </select>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-12 mt-10 mb-10">
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><?php echo $this->lang->line('address'); ?></span>
                                </div>
                                <textarea class="form-control" name="address" id="address" aria-label="<?php echo $this->lang->line('address'); ?>"><?php echo isset($patient->address) ?  $patient->address : ''; ?></textarea>
                                <div class="valid-feedback">
                                    <?php echo $this->lang->line('looks_good'); ?>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="national_id"><?php echo $this->lang->line('national_id'); ?></label>
                            <input type="number" class="form-control" name="national_id" id="national_id" value="<?php echo isset($patient->national_id) ?  $patient->national_id : ''; ?>" placeholder="<?php echo $this->lang->line('national_id'); ?>">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="email"><?php echo $this->lang->line('email'); ?></label>
                            <input type="text" class="form-control" name="email" id="email" value="<?php echo isset($patient->email) ?  $patient->email : ''; ?>" placeholder="<?php echo $this->lang->line('email'); ?>">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="patient_category">Patient Category</label>
                            <select class="form-control custom-select" name="patient_category" id="patient_category">
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php $patient_category = get_patient_category(); ?>
                                <?php foreach ($patient_category as $key => $value) { ?>
                                    <option value="<?php echo $key; ?>" <?php echo isset($patient->patient_category) && $patient->patient_category == $key ? 'selected="selected"' : ""; ?>><?php echo $value; ?></option>
                                <?php } ?>
                            </select>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="reference_emp"><?php echo $this->lang->line('reference'); ?> <?php echo $this->lang->line('employee'); ?></label>
                            <select class="form-control custom-select select2" name="reference_emp" id="reference_emp">
                                <option value="" selected><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('employee'); ?></option>
                                <?php foreach ($reference_employees as $obj) { ?>
                                    <option value="<?php echo $obj->user_id; ?>" <?php echo $obj->user_id == $patient->reference_emp ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?> [<?php echo $obj->phone; ?>]</option>
                                <?php } ?>
                            </select>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="photo"><?php echo $this->lang->line('photo'); ?></label>
                            <div class="fileinput fileinput-new input-group" data-provides="fileinput">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><?php echo $this->lang->line('upload'); ?></span>
                                </div>
                                <div class="form-control text-truncate" data-trigger="fileinput"><i class="glyphicon glyphicon-file fileinput-exists"></i> <span class="fileinput-filename"></span></div>
                                <span class="input-group-append">
                                    <span class=" btn btn-primary btn-file"><span class="fileinput-new">Select file</span><span class="fileinput-exists">Change</span>
                                        <input type="file" name="photo">
                                    </span>
                                    <a href="#" class="btn btn-secondary fileinput-exists" data-dismiss="fileinput">Remove</a>
                                </span>
                            </div>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-12 mt-10 mb-10">
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><?php echo $this->lang->line('patient'); ?> <?php echo $this->lang->line('note'); ?></span>
                                </div>
                                <textarea class="form-control" name="note" id="note" aria-label="<?php echo $this->lang->line('patient'); ?> <?php echo $this->lang->line('note'); ?>"><?php echo isset($patient->note) ?  $patient->note : ''; ?></textarea>
                                <div class="valid-feedback">
                                    <?php echo $this->lang->line('looks_good'); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Card Footer -->
                <div class="card-footer pt-0">
                    <div class="button-list">
                        <input type="hidden" name="role_id" value="<?php echo PATIENT; ?>">
                        <input type="hidden" name="id" value="<?php echo $patient->user_id; ?>" />
                        <a class="btn btn-gradient-danger" href="<?php echo site_url('patient'); ?>"><?php echo $this->lang->line('cancel'); ?></a>
                        <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('update'); ?></button>
                    </div>
                </div>
                <?php echo form_close(); ?>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->

<!-- Daterangepicker -->
<link href="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>moment/min/moment.min.js"></script>
<script src="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.js"></script>

<!-- Select2 -->
<link href="<?php echo VENDOR_URL; ?>select2/dist/css/select2.min.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>select2/dist/js/select2.full.min.js"></script>

<script>
    $(".select2").select2();
    $("#dob").daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        minYear: 1901,
        locale: {
            format: 'YYYY/MM/DD'
        }
    });
</script>
<style>
    .select2-container .select2-selection--single {
        height: calc(2.25rem + 4px) !important
    }

    .select2-container--default .select2-search--dropdown .select2-search__field {
        color: #324148;
        border-width: 2px;
        border-color: #e0e3e4;
        padding: .375rem .75rem;
        height: calc(2.25rem + 4px);
    }

    .select2-container--default .select2-selection--single .select2-selection__arrow b {
        margin-top: 5px;
    }
</style>