<?php

defined('BASEPATH') or exit('No direct script access allowed');

/* * *****************Opd.php**********************************
 * @product name    : Hospital Management System
 * @type            : Class
 * @class name      : Opd
 * @description     : Manage OPD Patient.
 * @author          : South Bangla IT Zone Team
 * @url             : http://hms.sbitzone.com
 * @support         : rabibd.it@gmail.com
 * @copyright       : South Bangla IT Zone Team
 * ********************************************************** */

class Opd extends MY_Controller {

    public $data = array();

    function __construct() {
        parent::__construct();
        $this->load->model('Opd_Model', 'opd', true);
        $this->load->library('Numbertowords');
    }

    public function set_barcode($code) {
        $this->load->library('zend');
        $this->zend->load('Zend/Barcode');
        Zend_Barcode::render('code128', 'image', array('text' => $code, 'drawText' => false), array());
    }

    public function index() {

        check_permission(VIEW);

        if ($_GET && $this->input->get('date')) {
            $collection_type = $this->input->get('collection_type');
            $keyword = trim($this->input->get('keyword'));
            $date = $this->input->get('date') ?? date('Y-m-d');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $doctor_id = $this->input->get('doctor_id');
            $reference_id = $this->input->get('reference_id');
            $created_by = $this->input->get('created_by');

            $config = array();
            $config = get_pagination(ADMIN_PER_PAGE);
            $config['base_url'] =  site_url('opd/?collection_type=' . $collection_type . '&keyword=' . $keyword . '&date=' . $date . '&doctor_id=' . $doctor_id . '&reference_id=' . $reference_id . '&created_by=' . $created_by);
            if ($this->input->get('page')) {
                $sgm = (int) trim($this->input->get('page'));
                $offset = $config['per_page'] * ($sgm - 1);
            } else {
                $offset = 0;
            }

            $config['total_rows'] = $this->opd->get_opd_patient_list($config['per_page'], $offset, $collection_type, $keyword, $form_date, $to_date, $doctor_id, $reference_id, $created_by, $count = TRUE);
            $this->pagination->initialize($config);
            $this->data['opd_patients'] = $this->opd->get_opd_patient_list($config['per_page'], $offset, $collection_type, $keyword, $form_date, $to_date, $doctor_id, $reference_id, $created_by, $count = FALSE);
            $this->data['sl_count'] = ($this->input->get('page') == 0 ? 1 : (($this->input->get('page') - 1) * $config["per_page"] + 1));

            $this->data['collection_type'] = $collection_type;
            $this->data['keyword'] = $keyword;
            $this->data['date'] = $date;
            $this->data['doctor_id'] = $doctor_id;
            $this->data['reference_id'] = $reference_id;
            $this->data['created_by'] = $created_by;
        } else {
            $collection_type = $this->input->get('collection_type');
            $keyword = trim($this->input->get('keyword'));
            $form_date = date('Y-m-d');
            $to_date = date('Y-m-d');
            $doctor_id = $this->input->get('doctor_id');
            $reference_id = $this->input->get('reference_id');
            $created_by = $this->input->get('created_by');

            $config = array();
            $config = get_pagination(ADMIN_PER_PAGE);
            $config['base_url'] = current_url();
            if ($this->input->get('page')) {
                $sgm = (int) trim($this->input->get('page'));
                $offset = $config['per_page'] * ($sgm - 1);
            } else {
                $offset = 0;
            }

            $config['total_rows'] = $this->opd->get_opd_patient_list($config['per_page'], $offset, $collection_type, $keyword, $form_date, $to_date, $doctor_id, $reference_id, $created_by, $count = TRUE);
            $this->pagination->initialize($config);
            $this->data['opd_patients'] = $this->opd->get_opd_patient_list($config['per_page'], $offset, $collection_type, $keyword, $form_date, $to_date, $doctor_id, $reference_id, $created_by, $count = FALSE);
            $this->data['sl_count'] = ($this->input->get('page') == 0 ? 1 : (($this->input->get('page') - 1) * $config["per_page"] + 1));
        }

        $this->data['doctors'] = $this->opd->get_doctor_list();
        $this->data['references'] = $this->opd->get_list('employees', array('status' => 1));
        $this->data['employees'] = $this->opd->get_employee_list();

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('opd_patient') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('opd/index', $this->data);
    }

    public function profile($patient_id) {

        check_permission(VIEW);

        $this->data["profile"] = $this->opd->get_single_patient($patient_id);
        $this->data["latest_patients"] = $this->opd->get_list('patients', array('status' => 1), '', '12', '', 'id', 'DESC');
        $this->data['doctors'] = $this->opd->get_doctor_list();
        $this->data['references'] = $this->opd->get_list('employees', array('status' => 1), '', '', '', 'id', 'DESC');


        if ($_GET) {
            $search = trim($this->input->get('search'));
            $config = array();
            $config = get_pagination(2);
            $config['base_url'] =  site_url('opd/profile/' . $patient_id . '?search=' . $search);
            if ($this->input->get('page')) {
                $sgm = (int) trim($this->input->get('page'));
                $offset = $config['per_page'] * ($sgm - 1);
            } else {
                $offset = 0;
            }

            $config['total_rows'] = $this->opd->get_opd_patient_details($config['per_page'], $offset, $patient_id, $search, $count = TRUE);
            $this->pagination->initialize($config);
            $this->data['opd_details'] = $this->opd->get_opd_patient_details($config['per_page'], $offset, $patient_id, $search, $count = FALSE);
            $this->data['sl_count'] = ($this->input->get('page') == 0 ? 1 : (($this->input->get('page') - 1) * $config["per_page"] + 1));
            $this->data['search'] = $search;
        } else {
            $config = array();
            $config = get_pagination(2);
            $config['base_url'] =  site_url('opd/profile/' . $patient_id);
            if ($this->input->get('page')) {
                $sgm = (int) trim($this->input->get('page'));
                $offset = $config['per_page'] * ($sgm - 1);
            } else {
                $offset = 0;
            }

            $config['total_rows'] = $this->opd->get_opd_patient_details($config['per_page'], $offset, $patient_id, null, $count = TRUE);
            $this->pagination->initialize($config);
            $this->data['opd_details'] = $this->opd->get_opd_patient_details($config['per_page'], $offset, $patient_id, null, $count = FALSE);
            $this->data['sl_count'] = ($this->input->get('page') == 0 ? 1 : (($this->input->get('page') - 1) * $config["per_page"] + 1));
        }
        $this->layout->title($this->lang->line('opd_patient') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('opd/profile', $this->data);
    }

    /*****************Function get_opd_visit_details**********************************
     * @type            : Function
     * @function name   : get_opd_visit_details
     * @description     : Load "Opd Visit Data" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function get_opd_visit_details($id) {
        if (!empty($id)) {
            $visit = $this->opd->get_single('opd_patients', array('id' => $id));
            echo json_encode($visit);
        }
    }
    public function editVisit() {

        check_permission(ADD);

        if ($_POST) {
            $this->load->library('form_validation');
            $this->form_validation->set_error_delimiters('<div class="error-message" style="color: red;">', '</div>');
            $this->form_validation->set_rules('doctor_id', $this->lang->line('doctor') . ' ' . $this->lang->line('name'), 'trim');
            $this->form_validation->set_rules('old_patient', $this->lang->line('patient') . ' ' . $this->lang->line('type'), 'trim|required');

            if ($this->form_validation->run() === TRUE) {
                $data['height'] = $this->input->post('height');
                $data['weight'] = $this->input->post('weight');
                $data['bp'] = $this->input->post('bp');
                $data['symptoms'] = $this->input->post('symptoms');
                //$data['doctor_id'] = $this->input->post('doctor_id');
                $data['doctor_charge'] = $this->input->post('doctor_charge');
                $data['discount'] = $this->input->post('discount');
                if ($data['discount'] > 0) {
                    $data['hospital_commission'] = $this->input->post('hospital_commission') - $this->input->post('discount');
                } else {
                    $data['hospital_commission'] = $this->input->post('hospital_commission');
                }
                $data['old_patient'] = $this->input->post('old_patient');
                $data['case'] = $this->input->post('case');
                $data['casualty'] = $this->input->post('casualty');
                $data['reference_id'] = $this->input->post('reference_id');
                $data['payment_status'] = $this->input->post('payment_status');
                $data['note'] = $this->input->post('note');

                $data['modified_at'] = date('Y-m-d H:i:s');
                $data['modified_by'] = logged_in_user_id();

                $updated_id = $this->opd->update('opd_patients', $data, array('id' => $this->input->post('id')));
                $opd = $this->opd->get_single('opd_patients', array('id' => $this->input->post('id')));
                if ($updated_id) {
                    create_log('Has been updated a OPD Patient : ' . $opd->custom_invoice_id . ' ' . $opd->opd_no);
                }
                $array = array('status' => 'success', 'error' => '', 'message' => $this->lang->line('update_success'));

                if ($this->input->post('old_patient') == 1) {
                    $this->opd->update('patients', array('old_patient' => 1), array('user_id' => $opd->patient_id));
                } else {
                    $this->opd->update('patients', array('old_patient' => 0), array('user_id' =>  $opd->patient_id));
                }
            } else {
                $this->data = $_POST;
                $msg = array(
                    'doctor_id' => form_error('doctor_id'),
                    'old_patient' => form_error('old_patient'),
                );
                $array = array('status' => 'failed', 'error' => $msg, 'message' => '');
            }
            echo json_encode($array);
        }
    }

    /*     * ***************Function get_single_visit**********************************
     * @type            : Function
     * @function name   : get_single_visit
     * @description     : "Load single visit information" from database                  
     *                    to the user interface   
     * @param           : null
     * @return          : null 
     * ********************************************************** */

    public function get_single_visit() {

        check_permission(VIEW);

        $id = $this->input->post('id');
        $this->data['opd'] = $this->opd->get_single_opd_visit_details($id);
        echo $this->load->view('opd/view', $this->data);
    }

    public function get_patient_visit_bill() {

        check_permission(VIEW);

        $patient_id = $this->input->post("patient_id");
        $opd_id = $this->input->post("opd_id");
        $this->data["patient"] = $this->opd->get_patient_visit_bill($patient_id, $opd_id);
        $this->load->view('opd/visit_bill', $this->data);
    }

    /*****************Function get_patient_details**********************************
     * @type            : Function
     * @function name   : get_patient_details
     * @description     : Load "Opd Single Patient" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function get_patient_details() {
        $user_id = $this->input->post('user_id');
        if (!empty($user_id)) {
            $patient = $this->opd->get_patient_details($user_id);
            echo json_encode($patient);
        }
    }


    public function get_patients() {
        $patients = $this->opd->get_list('patients', array('status' => 1), '', '', '', 'id', 'DESC');
        $this->data['patients'] = $patients;
        echo json_encode($patients);
    }

    /*****************Function get_doctor_charge**********************************
     * @type            : Function
     * @function name   : get_doctor_charge
     * @description     : Load "Opd Doctor Charge" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function get_doctor_charge() {
        $user_id = $this->input->post('user_id');
        $old_patient = $this->input->post('old_patient');
        if ($user_id > 0 && $old_patient != "") {
            $doctor_charges = $this->opd->get_doctor_charges($user_id);
            if ($old_patient == 0) {
                $doctor_charge = array(
                    'charge' => $doctor_charges->first_fee,
                    'hospital_commission' => $doctor_charges->hospital_commission,
                );
            } else {
                $doctor_charge = array(
                    'charge' => $doctor_charges->second_fee,
                    'hospital_commission' => 0,
                );
            }
        } else {
            $doctor_charge = array(
                'charge' => 0,
                'hospital_commission' => 0,
            );
        }
        echo (json_encode($doctor_charge));
    }

    /*****************Function opd_visit_delete**********************************
     * @type            : Function
     * @function name   : opd_visit_delete
     * @description     : delete "OPD Patient Visit" data from database
     *
     * @param           : $id integer value
     * @return          : null
     * ********************************************************** */
    public function opd_visit_delete($id = null) {

        check_permission(DELETE);

        if (!is_numeric($id)) {
            error($this->lang->line('unexpected_error'));
            redirect('opd');
        }

        $opd = $this->opd->get_single('opd_patients', array('id' => $id));

        if ($this->opd->delete('opd_patients', array('id' => $id))) {
            create_log('Has been deleted a OPD No : ' . $opd->opd_no);
            success($this->lang->line('delete_success'));
        } else {
            error($this->lang->line('delete_failed'));
        }
        redirect($_SERVER['HTTP_REFERER']);
    }
}
