<!DOCTYPE html>
<html>

<head>
    <title>Print Invoice</title>

    <style>
        body {
            font-family: monospace;
            font-size: 14px;
        }

        .page {
            width: 64%;
            margin: 0 auto;
        }

        @page {
            size: A4;
            margin: 0;
        }

        @media print {

            html,
            body {
                font-family: Arial, Helvetica, sans-serif;
            }

            .page {
                width: 64%;
                margin: 0 auto;
                border: initial;
                border-radius: initial;
                min-height: initial;
                box-shadow: initial;
                background: initial;
                page-break-after: always;
            }
        }

        .patient_copy {
            page-break-after: always;
            display: block;
            margin-top: 100px;
        }

        .diagnostic_copy {
            display: block;
            margin-top: 100px;
        }

        .title {
            width: 30%;
            font-size: 14px;
            font-weight: bold;
            border: 1px solid #333;
            padding: 5px;
            font-family: monospace;
            text-transform: uppercase;
            letter-spacing: 2px;
            border-radius: 3px;
            text-align: center;
            margin: 3px auto;
        }

        .paid {
            width: 25%;
            margin: 30px auto 0 auto;
            text-align: center;
            font-size: 25px;
            font-weight: bold;
            background: #eee;
            border: 1px solid #000;
            padding: 3px 10px;
            font-family: monospace;
            text-transform: uppercase;
            letter-spacing: 5px;
            border-radius: 3px;
        }

        .table {
            font-size: 14px;
            width: 100%;
            border-collapse: collapse;
        }

        .patient_table {
            width: 100%;
            text-align: left;
            border-collapse: collapse;
            margin-top: 15px;
        }

        .patient_table tbody td {
            color: #000;
            padding: 2px;
            vertical-align: top;
            border: 2px solid #000;
        }

        /* test_table */
        .test_table {
            margin-top: 10px;
            width: 100%;
            text-align: left;
            border-collapse: collapse;
            border: 1px solid #000;
        }

        .test_table tbody td {
            color: #000;
            padding: 0px 4px;
            vertical-align: top;
            border-top: 1px solid #000;
        }

        /*  payment_info*/
        .payment_table {
            font-size: 14px;
            width: 100%;
            text-align: left;
        }

        .payment_table tbody td {
            vertical-align: top;
            border: 0;
        }
    </style>
</head>

<body>
    <div class="page">
        <div class="patient_copy">
            <div class="title">Patient Copy</div>
            <!-- Patient Info Start-->
            <table class="table patient_table">
                <tr>
                    <td style="width: 35%;">
                        <span>Patient ID :</span>
                        <span style="text-transform: uppercase; font-weight: bold;"><?php echo $patient->patient_unique_id; ?></span>
                    </td>
                    <td style="width: 23%;">
                        <img src="<?php echo site_url('ipd/payment/set_barcode/' . $patient->patient_unique_id); ?>" alt="" height="30" width="100%">
                    </td>
                    <td style="width: 42%;">
                        <span>Invoice ID :</span>
                        <span><?php echo $patient->custom_invoice_id; ?></span>
                    </td>
                </tr>
                <tr>
                    <td colspan="2">
                        <span>Name :</span>
                        <span style="text-transform: uppercase; font-weight: bold;"><?php echo $patient->patient_name; ?></span>
                    </td>
                    <td>
                        <span>Date :</span>
                        <span><?php echo date('d/m/Y h:i A', strtotime($patient->payment_date)); ?></span>
                    </td>
                </tr>
                <tr>
                    <td>
                        <span>Age :</span>
                        <span style="text-transform: uppercase; font-weight: bold;"><?php echo $patient->dob != NULL ? floor((time() - strtotime($patient->dob)) / 31556926) : ''; ?>Y</span>
                    </td>
                    <td>
                        <span>Gender :</span>
                        <span style="text-transform: capitalize; font-weight: bold;"><?php echo $this->lang->line($patient->gender); ?></span>
                    </td>
                    <td>
                        <span>Contact No :</span>
                        <span style="text-transform: uppercase; font-weight: bold;"><?php echo $patient->phone; ?></span>
                    </td>
                </tr>
                <tr>
                    <td colspan="3">
                        <span>Ref. By :</span>
                        <span style="font-size:12px; text-transform: uppercase; font-weight: bold;">
                            <?php echo $patient->doctor ? $patient->doctor . ', ' . $patient->specialist : ''; ?>
                        </span>
                    </td>
                </tr>
            </table>
            <!-- Patient Info End-->
            <table class="test_table">
                <tbody>
                    <tr>
                        <td width="15%" align="left"><b>SL. No</b></td>
                        <td width="55%" align="left"><b>Service Name</b></td>
                        <td width="30%" align="right"><b>Amount (Tk.)</b></td>
                    </tr>
                    <tr>
                        <td width="15%" align="left">01</td>
                        <td width="55%" align="left">IPD Advanced</td>
                        <td width="30%" align="right"><?php echo $patient->amount; ?></td>
                    </tr>
                </tbody>
            </table>
            <?php if ($patient->note != NULL) { ?>
                <p style="margin-top:20px;">
                    <b>Remark: </b>
                    <?php echo $patient->note; ?>
                </p>
            <?php } ?>
            <p style="margin-top:30px;">
                <span style="font-size: 14px; font-weight: bold;">Prepared By:</span>
                <?php echo $patient->created_by; ?>
            </p>
        </div>
    </div>
</body>

</html>