<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('ipd'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container-fluid">
    <!-- Row -->
    <div class="row">
        <?php echo $this->load->view('ipd/patient-info'); ?>

        <!-- col-lg-12 -->
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(VIEW, 'ipd', 'payment')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-user-md font-30 mr-10"></i>
                            <?php echo $this->lang->line('payment'); ?> <?php echo $this->lang->line('chart'); ?>
                        </h6>
                    <?php } ?>
                    <?php echo form_open_multipart(site_url('ipd/payment/index/' . $patient->id), array('name' => 'search', 'id' => 'search', 'class' => 'needs-validation', 'novalidate' => 'novalidate', 'method' => 'get'), ''); ?>
                    <div class="form-group">
                        <div class="input-group input-group-sm">
                            <input type="text" class="form-control" name="search" id="search" value="<?php echo isset($search) ?  $search : ''; ?>" placeholder="<?php echo $this->lang->line('search'); ?>">
                            <div class="input-group-append">
                                <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('search'); ?></button>
                            </div>
                        </div>
                    </div>
                    <?php echo form_close(); ?>

                    <div class="align-items-center">
                        <?php if (has_permission(VIEW, 'ipd', 'payment')) { ?>
                            <button type="button" class="btn btn-xs btn-orange" onclick="printAllBill(<?php echo $patient->id; ?>, <?php echo $patient->patient_id; ?>)">
                                <i class="fa fa-print"></i>
                                <?php echo $this->lang->line('print'); ?>
                            </button>
                        <?php } ?>

                        <?php if ($patient->discharged == 0 || $this->session->userdata('role_id') == SUPER_ADMIN ||  !empty(custom_permission('modified_discharged'))) { ?>
                            <?php if (has_permission(ADD, 'ipd', 'payment')) { ?>
                                <button type="button" class="btn btn-xs btn-primary" data-toggle="modal" data-target="#addPaymentModal">
                                    <i class="fa fa-plus font-12 mr-5"></i>
                                    <?php echo $this->lang->line('add'); ?> <?php echo $this->lang->line('payment'); ?>
                                </button>
                            <?php } ?>
                        <?php } ?>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-wrap">
                        <div class="table-responsive">
                            <table class="table table-sm mb-0">
                                <thead>
                                    <tr>
                                        <th><?php echo $this->lang->line('sl_no'); ?></th>
                                        <th><?php echo $this->lang->line('invoice_id'); ?></th>
                                        <th><?php echo $this->lang->line('payment'); ?> <?php echo $this->lang->line('date'); ?></th>
                                        <th><?php echo $this->lang->line('amount'); ?></th>
                                        <th><?php echo $this->lang->line('note'); ?></th>
                                        <th><?php echo $this->lang->line('status'); ?></th>
                                        <th class="w-15"><?php echo $this->lang->line('action'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if (isset($payments) && !empty($payments)) { ?>
                                        <?php foreach ($payments as $obj) { ?>
                                            <tr>
                                                <td><?php echo $sl_count; ?></td>
                                                <td><?php echo $obj->custom_invoice_id; ?></td>
                                                <td><?php echo date('d/m/Y h:i A', strtotime($obj->payment_date)); ?></td>
                                                <td><?php echo $obj->amount; ?></td>
                                                <td><?php echo $obj->note; ?></td>
                                                <td>
                                                    <?php if ($obj->payment_status == 'complete') {
                                                        echo "<span class='badge badge-success'>" . $this->lang->line('complete') . "</span>";
                                                    } elseif ($obj->payment_status == 'rejected') {
                                                        echo "<span class='badge badge-danger'>" . $this->lang->line('rejected') . "</span>";
                                                    } elseif ($obj->payment_status == 'canceled') {
                                                        echo "<span class='badge badge-warning'>" . $this->lang->line('cancel') . "</span>";
                                                    } else {
                                                        echo "<span class='badge badge-info'>" . $this->lang->line('pending') . "</span>";
                                                    } ?>
                                                </td>
                                                <td>
                                                    <?php if (has_permission(VIEW, 'ipd', 'payment')) { ?>
                                                        <button type="button" class="btn btn-xs btn-orange" onclick="printBill('<?php echo $obj->id; ?>')">
                                                            <i class="fa fa-print"></i>
                                                        </button>
                                                    <?php } ?>
                                                    <?php if (has_permission(VIEW, 'ipd', 'ipd_payment_sms')) { ?>
                                                        <button type="button" onclick="send_sms(<?php echo $obj->id; ?>);" class="btn btn-warning btn-xs">
                                                            <i class="fa fa-envelope-o"></i>
                                                        </button>
                                                    <?php } ?>
                                                    <?php if (has_permission(VIEW, 'ipd', 'payment')) { ?>
                                                        <button type="button" onclick="get_view_modal(<?php echo $obj->id; ?>);" data-toggle="modal" data-target=".viewModalCenter" class="btn btn-primary btn-xs">
                                                            <i class="fa fa-eye"></i>
                                                        </button>
                                                    <?php } ?>

                                                    <?php if ($patient->discharged == 0 || $this->session->userdata('role_id') == SUPER_ADMIN ||  !empty(custom_permission('modified_discharged'))) { ?>
                                                        <?php if (has_permission(EDIT, 'ipd', 'payment')) { ?>
                                                            <button type="button" onclick="editPayment('<?php echo $obj->id; ?>')" class="btn btn-xs btn-success" data-toggle="modal" data-target="#editPaymentModal">
                                                                <i class="fa fa-pencil-square-o"></i>
                                                            </button>
                                                        <?php } ?>
                                                    <?php } ?>

                                                    <?php if ($patient->discharged == 0 || $this->session->userdata('role_id') == SUPER_ADMIN ||  !empty(custom_permission('modified_discharged'))) { ?>
                                                        <?php if (has_permission(DELETE, 'ipd', 'payment')) { ?>
                                                            <a class="btn btn-xs btn-danger round" href="<?php echo site_url('ipd/payment/delete/' . $obj->id); ?>" onclick="javascript: return confirm('<?php echo $this->lang->line('confirm_alert'); ?>');"> <i class="fa fa-trash text-white"></i></a>
                                                        <?php } ?>
                                                    <?php } ?>
                                                </td>
                                            </tr>
                                            <?php $sl_count++; ?>
                                        <?php } ?>
                                    <?php } else { ?>
                                        <tr class="text-center">
                                            <td colspan="7"><?php echo $this->lang->line('no_data_found'); ?></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <!-- Card Footer -->
                <?php if ($this->pagination->create_links()) { ?>
                    <div class="card-footer justify-content-end">
                        <?php echo $this->pagination->create_links(); ?>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->

<!-- Add Consultan Modal-->
<div class="modal fade" id="addPaymentModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalForms" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?php echo $this->lang->line('add'); ?> <?php echo $this->lang->line('payment'); ?></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <form id="addPaymentForm" enctype="multipart/form-data" method="POST" action="<?php echo site_url('ipd/payment/add'); ?>">
                <div class="modal-body">
                    <div class="form-row">
                        <div class="col-md-6 mb-10">
                            <label for="payment_date"><?php echo $this->lang->line('date'); ?></label>
                            <input type="text" class="form-control" name="payment_date" id="payment_date" value="<?php echo isset($payment_date) ?  $payment_date : ''; ?>" placeholder="<?php echo $this->lang->line('date'); ?>" required>
                        </div>
                        <div class="col-md-6 mb-10">
                            <label for="amount"><?php echo $this->lang->line('amount'); ?></label>
                            <input type="number" class="form-control" name="amount" id="amount" value="<?php echo isset($amount) ?  $amount : ''; ?>" placeholder="<?php echo $this->lang->line('amount'); ?>" required>
                        </div>
                        <div class="col-md-12 mb-10">
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><?php echo $this->lang->line('remark'); ?></span>
                                </div>
                                <textarea class="form-control" name="note" id="note" aria-label="<?php echo $this->lang->line('remark'); ?>"><?php echo isset($note) ?  $note : ''; ?></textarea>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer pt-0">
                    <div class="button-list">
                        <input type="hidden" name="ipd_id" value="<?php echo $patient->id; ?>">
                        <input type="hidden" name="patient_id" value="<?php echo $patient->patient_id; ?>">
                        <button type="button" class="btn btn-gradient-danger" data-dismiss="modal"><?php echo $this->lang->line('cancel'); ?></button>
                        <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('submit'); ?></button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Edit Payment Modal-->
<div class="modal fade" id="editPaymentModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalForms" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?php echo $this->lang->line('edit'); ?> <?php echo $this->lang->line('payment'); ?></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <form id="editPaymentForm" enctype="multipart/form-data" method="POST" action="#">
                <div class="modal-body">
                    <div class="form-row">
                        <div class="col-md-4 mb-10">
                            <label for="edit_payment_date"><?php echo $this->lang->line('date'); ?></label>
                            <input type="text" class="form-control" name="payment_date" id="edit_payment_date" value="<?php echo isset($payment_date) ?  $payment_date : ''; ?>" placeholder="<?php echo $this->lang->line('date'); ?>" required>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="edit_amount"><?php echo $this->lang->line('amount'); ?></label>
                            <input type="number" class="form-control" name="amount" id="edit_amount" value="<?php echo isset($amount) ?  $amount : ''; ?>" placeholder="<?php echo $this->lang->line('amount'); ?>" required>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="edit_payment_status"><?php echo $this->lang->line('status'); ?></label>
                            <select class="form-control custom-select" name="payment_status" id="edit_payment_status" required>
                                <?php $invoice_status = get_invoice_status(); ?>
                                <?php foreach ($invoice_status as $key => $value) { ?>
                                    <option value="<?php echo $key; ?>" <?php echo isset($payment_status) && $payment_status == $key ? 'selected="selected"' : ""; ?>><?php echo $value; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-12 mb-10">
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><?php echo $this->lang->line('remark'); ?></span>
                                </div>
                                <textarea class="form-control" name="note" id="edit_note" aria-label="<?php echo $this->lang->line('remark'); ?>"><?php echo isset($note) ?  $note : ''; ?></textarea>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer pt-0">
                    <div class="button-list">
                        <input type="hidden" name="id" id="edit_payment_id">
                        <input type="hidden" name="ipd_id" id="edit_ipd_id" value="<?php echo $patient->id; ?>">
                        <input type="hidden" name="patient_id" id="edit_patient_id" value="<?php echo $patient->patient_id; ?>">
                        <button type="button" class="btn btn-gradient-danger" data-dismiss="modal"><?php echo $this->lang->line('cancel'); ?></button>
                        <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('update'); ?></button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>


<script>
    function editPayment(id) {
        $.ajax({
            url: '<?php echo site_url('ipd/payment/get_payment/') ?>' + id,
            dataType: 'json',
            success: function(data) {
                $('#edit_payment_id').val(data.id);
                $('#edit_ipd_id').val(data.ipd_id);
                $('#edit_patient_id').val(data.patient_id);
                $('#edit_payment_date').val(data.payment_date);
                $('#edit_amount').val(data.amount);
                $('#edit_payment_status').val(data.payment_status);
                $('#edit_note').val(data.note);
            }
        });
    }

    $(document).ready(function(e) {
        $("#editPaymentForm").on('submit', (function(e) {
            e.preventDefault();
            if ($("#edit_payment_date").val() != "" && $("#edit_amount").val() != "") {
                $.ajax({
                    url: '<?php echo site_url('ipd/payment/edit') ?>',
                    type: "POST",
                    data: new FormData(this),
                    dataType: 'json',
                    contentType: false,
                    cache: false,
                    processData: false,
                    success: function(data) {
                        if (data.status == "failed") {
                            var message = "";
                            $.each(data.error, function(index, value) {
                                $("." + index).html(value);
                                message += value;
                            });
                            $.toast({
                                text: message,
                                position: 'top-right',
                                loaderBg: '#7a5449',
                                class: 'jq-toast-danger',
                                hideAfter: 3500,
                                stack: 6,
                                showHideTransition: 'fade'
                            });
                        } else {
                            $.toast({
                                text: data.message,
                                position: 'top-right',
                                loaderBg: '#7a5449',
                                class: 'jq-toast-primary',
                                hideAfter: 3500,
                                stack: 6,
                                showHideTransition: 'fade'
                            });
                            location.reload(true);
                        }
                        $('#editPaymentForm').find('form')[0].reset();
                    },
                    error: function() {
                        alert("Fail")
                    }
                });
            } else {
                $.toast({
                    text: "Please select all required field",
                    position: 'top-right',
                    loaderBg: '#7a5449',
                    class: 'jq-toast-danger',
                    hideAfter: 3500,
                    stack: 6,
                    showHideTransition: 'fade'
                });
            }
        }));
    });
</script>

<div class="modal fade viewModalCenter" tabindex="-1" role="dialog" aria-labelledby="viewModalCenter" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header bg-gradient-primary">
                <h5 class="modal-title text-white"><?php echo $this->lang->line('payment'); ?> <?php echo $this->lang->line('info'); ?></h5>
                <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body modal_data bg-gradient-secondary"></div>
        </div>
    </div>
</div>

<script type="text/javascript">
    function get_view_modal(id) {
        $('.modal_data').html('<p style="padding: 20px;"><p style="padding: 20px;text-align:center;"><img src="<?php echo IMG_URL; ?>loader.gif" /></p>');
        $.ajax({
            type: "POST",
            url: "<?php echo site_url('ipd/payment/get_single_payment'); ?>",
            data: {
                id: id
            },
            success: function(response) {
                if (response) {
                    $('.modal_data').html(response);
                }
            }
        });
    }
</script>


<!-- Daterangepicker -->
<link href="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>moment/min/moment.min.js"></script>
<script src="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.2/jquery-confirm.min.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.2/jquery-confirm.min.js"></script>
<script>
    $('#payment_date, #edit_payment_date').daterangepicker({
        singleDatePicker: true,
        startDate: new Date(),
        showDropdowns: true,
        minYear: 1901,
        timePicker: true,
        timePicker24Hour: true,
        timePickerIncrement: 1,
        timePickerSeconds: false,
        autoUpdateInput: true,
        autoApply: true,
        locale: {
            format: 'YYYY-MM-DD HH:mm',
        }
    });
</script>

<script>
    function printBill(id) {
        $.ajax({
            url: '<?php echo site_url('ipd/payment/print'); ?>',
            type: 'POST',
            data: {
                id: id,
            },
            success: function(result) {
                $("#testdata").html(result);
                popup(result);
            }
        });
    }

    function popup(data) {
        var frame1 = $('<iframe />');
        frame1[0].name = "frame1";
        frame1.css({
            "position": "absolute",
            "top": "-1000000px"
        });
        $("body").append(frame1);
        var frameDoc = frame1[0].contentWindow ? frame1[0].contentWindow : frame1[0].contentDocument.document ? frame1[0].contentDocument.document : frame1[0].contentDocument;
        frameDoc.document.open();
        //Create a new HTML document.
        frameDoc.document.write('<html>');
        frameDoc.document.write('<head>');
        frameDoc.document.write('<title>Print</title>');

        frameDoc.document.write('</head>');
        frameDoc.document.write('<body>');
        frameDoc.document.write(data);
        frameDoc.document.write('</body>');
        frameDoc.document.write('</html>');
        frameDoc.document.close();
        setTimeout(function() {
            window.frames["frame1"].focus();
            window.frames["frame1"].print();
            frame1.remove();
            //window.location.reload(true);
        }, 500);

        return true;

    }
</script>


<script>
    function printAllBill(ipd_id, patient_id) {
        $.ajax({
            url: '<?php echo site_url('ipd/payment/all_print'); ?>',
            type: 'POST',
            data: {
                ipd_id: ipd_id,
                patient_id: patient_id,
            },
            success: function(result) {
                $("#testdata").html(result);
                popup(result);
            }
        });
    }

    function popup(data) {
        var frame1 = $('<iframe />');
        frame1[0].name = "frame1";
        frame1.css({
            "position": "absolute",
            "top": "-1000000px"
        });
        $("body").append(frame1);
        var frameDoc = frame1[0].contentWindow ? frame1[0].contentWindow : frame1[0].contentDocument.document ? frame1[0].contentDocument.document : frame1[0].contentDocument;
        frameDoc.document.open();
        //Create a new HTML document.
        frameDoc.document.write('<html>');
        frameDoc.document.write('<head>');
        frameDoc.document.write('<title>Print</title>');

        frameDoc.document.write('</head>');
        frameDoc.document.write('<body>');
        frameDoc.document.write(data);
        frameDoc.document.write('</body>');
        frameDoc.document.write('</html>');
        frameDoc.document.close();
        setTimeout(function() {
            window.frames["frame1"].focus();
            window.frames["frame1"].print();
            frame1.remove();
            //window.location.reload(true);
        }, 500);

        return true;

    }

    function send_sms(id) {
        $.confirm({
            title: 'Send SMS!',
            content: 'Are you sure to send SMS?',
            type: 'red',
            typeAnimated: true,
            buttons: {
                tryAgain: {
                    text: 'Yes',
                    btnClass: 'btn-red',
                    action: function() {
                        $.ajax({
                            url: "<?php echo site_url('ipd/payment/ipd_payment_sms'); ?>/" + id,
                            method: 'get'
                        });
                        $.alert('SMS Sent Successfully!');
                    }
                },
                close: function() {}
            }
        });
    }
</script>