<!DOCTYPE html>
<html>

<head>
    <title>Print Invoice</title>

    <style>
        body {
            font-family: monospace;
            font-size: 14px;
        }

        .page {
            width: 70%;
            margin: 0 auto;
        }

        @page {
            size: A4;
            margin: 0;
        }

        @media print {

            html,
            body {
                font-family: Arial, Helvetica, sans-serif;
            }

            .page {
                width: 70%;
                margin: 0 auto;
                border: initial;
                border-radius: initial;
                min-height: initial;
                box-shadow: initial;
                background: initial;
                page-break-after: always;
            }
        }

        .patient_copy {
            page-break-after: always;
            display: block;
            margin-top: 0px;
        }

        .diagnostic_copy {
            display: block;
            margin-top: 100px;
        }

        .title {
            width: 50%;
            font-size: 14px;
            font-weight: bold;
            border: 1px solid #333;
            padding: 5px;
            font-family: monospace;
            text-transform: uppercase;
            letter-spacing: 2px;
            border-radius: 3px;
            text-align: center;
            margin: 3px auto;
        }

        .paid {
            width: 25%;
            margin: 30px auto 0 auto;
            text-align: center;
            font-size: 25px;
            font-weight: bold;
            background: #eee;
            border: 1px solid #000;
            padding: 3px 10px;
            font-family: monospace;
            text-transform: uppercase;
            letter-spacing: 5px;
            border-radius: 3px;
        }

        .table {
            font-size: 14px;
            width: 100%;
            border-collapse: collapse;
        }

        .patient_table {
            width: 100%;
            text-align: left;
            border-collapse: collapse;
            margin-top: 15px;
        }

        .patient_table tbody td {
            color: #000;
            padding: 2px;
            vertical-align: top;
            border: 2px solid #000;
        }

        /* test_table */
        .test_table {
            margin-top: 10px;
            width: 100%;
            text-align: left;
            border-collapse: collapse;
            border: 1px solid #000;
        }

        .test_table tbody td {
            color: #000;
            padding: 0px 4px;
            vertical-align: top;
            border-top: 1px solid #000;
        }

        /*  payment_info*/
        .payment_table {
            font-size: 14px;
            width: 100%;
            text-align: left;
        }

        .payment_table tbody td {
            vertical-align: top;
            border: 0;
        }
        .table_sign {
            width: 100%;
            margin-top: 100px;
        }
        .table_less{
            width: 100%;
            margin-top: 20px;
        }
    </style>
</head>

<body>
    <div class="page">
            <table class="table">
                <tr>
                    <td rowspan="3" width="10%">
                        <?php if($this->global_setting->brand_logo){ ?>
                            <img width="80" valign="middle" align="center" src="<?php echo UPLOAD_PATH; ?>logo/<?php echo $this->global_setting->brand_logo; ?>">
                        <?php } else { ?>
                            <img width="80" valign="middle" align="center" src="<?php echo IMG_URL; ?>logo.png">
                        <?php } ?>
                    </td>
                    <td width="90%" align="center"><h1 style="margin: 0px; padding:0; font-size: 36px;"><?php echo $this->global_setting->brand_title; ?></h1></td>
                </tr>
                <tr>
                    <td align="center"><p style="margin: 0px; padding: 0; font-size: 14px;"><?php echo $this->global_setting->address; ?></p></td>
                </tr>
                <tr>
                     <td align="center"><p style="margin: 0; font-size: 14px;">Phone: <?php echo $this->global_setting->phone; ?></p></td>
                </tr>
            </table>
            <table class="table">
                <tr>
                    <td width="10%">&nbsp;</td>
                    <td class="" width="90%" align="center">Indoor Patient Bill</td>
                 </tr>
            </table>
        <div class="patient_copy">
            <!-- Patient Info Start-->
            <table class="table patient_table">
                <tr>
                    <td style="width: 35%;">
                        <span>Reg No :</span>
                        <span style="text-transform: uppercase; font-weight: bold;"><?php echo $patient->registration_no; ?></span>
                    </td>
                    <td style="width: 23%;" rowspan="2">
                        <img src="<?php echo site_url('ipd/set_barcode/' . $patient->patient_unique_id); ?>" alt="" height="30" width="100%">
                    </td>
                    <td style="width: 42%;">
                        <span>Invoice ID :</span>
                        <span>Draft Invoice</span>
                    </td>
                </tr>
                <tr>
                    <td style="width: 35%;">
                        <span>Patient ID :</span>
                        <span style="text-transform: uppercase; font-weight: bold;"><?php echo $patient->patient_unique_id; ?></span>
                    </td>
                    <td style="width: 42%;">
                        <span>Bill Date :</span>
                        <span><?php echo date('d/m/Y h:iA'); ?></span>
                    </td>
                </tr>
                <tr>
                    <td colspan="2">
                        <span>Name :</span>
                        <span style="text-transform: uppercase; font-weight: bold;"><?php echo $patient->patient_name; ?></span>
                    </td>
                    <td>
                        <span>Print Date :</span>
                        <span><?php echo date('d/m/Y h:i A'); ?></span>
                    </td>
                </tr>
                <tr>
                    <td>
                        <span>Age :</span>
                        <span style="text-transform: uppercase; font-weight: bold;"><?php echo $patient->dob != NULL ? floor((time() - strtotime($patient->dob)) / 31556926) : ''; ?>Y</span>
                    </td>
                    <td>
                        <span>Gender :</span>
                        <span style="text-transform: capitalize; font-weight: bold;"><?php echo $this->lang->line($patient->gender); ?></span>
                    </td>
                    <td>
                        <span>Contact No :</span>
                        <span style="text-transform: uppercase; font-weight: bold;"><?php echo $patient->phone; ?></span>
                    </td>
                </tr>
                <tr>
                    <td colspan="3">
                        <span>Ref. By :</span>
                        <span style="font-size:12px; text-transform: uppercase; font-weight: bold;">
                            <?php echo $patient->doctor ? $patient->doctor . ', ' . $patient->specialist : ''; ?>
                        </span>
                    </td>
                </tr>
            </table>
            <!-- Patient Info End-->

            <table class="table patient_table" style="margin: 0;">
                <tbody>
                    <tr>
                        <td style="border-top: 0;" width="50%">
                            <span>Admission Date :</span>
                            <?php echo date('d/m/Y h:ia', strtotime($patient->admission_date)); ?>
                        </td>
                        <td style="border-top: 0;" width="50%">
                            <span>Discharge Date :</span>
                            <?php echo date('d/m/Y h:iA'); ?>
                        </td>
                    </tr>
                </tbody>
            </table>
            
            <table class="test_table" id="vue-app">
                <thead>
                    <tr>
                        <td width="15%" align="left"><b>SL. No</b></td>
                        <td width="55%" align="left"><b>Service Name</b></td>
                        <td width="10%" align="left"><b>Qty</b></td>
                        <td width="10%" align="right"><b>Rate</b></td>
                        <td width="10%" align="right"><b>Total</b></td>
                    </tr>
                </thead>
                <tbody v-if="adf.charges.length>0">
                    <tr v-for="(charge, index) in adf.charges">
                        <td class="text-center">{{ index + 1}}</td>
                        <td class="text-left">
                            <span v-html="charge.name"></span>
                        </td>
                        <td class="text-center">
                            {{ charge.quantity }}
                        </td>
                        <td class="text-left">
                            <span v-html="charge.price"></span>
                        </td>
                        <td class="text-right">
                            {{ charge.total }}
                        </td>
                    </tr>
                    <tr class="bg-transparent">
                        <td colspan="4" class="text-right text-light">Sub Total</td>
                        <td class="text-right">{{ calc.bill }}</td>
                    </tr>
                    <tr class="bg-transparent">
                        <td colspan="4" class="text-right text-light border-top-0">Discount</td>
                        <td class="text-right border-top-0">0.00</td>
                    </tr>
                    <tr class="bg-transparent">
                        <td colspan="4" class="text-right text-light border-top-0">Net Payable</td>
                        <td class="text-right border-top-0">{{ calc.payable }}</td>
                    </tr>
                    <tr class="bg-transparent">
                        <td colspan="4" class="text-right text-light border-top-0">Advanced Amount</td>
                        <td class="text-right border-top-0">{{ advanced }}</td>
                    </tr>
                </tbody>
                <tfoot class="border-bottom border-1">
                    <tr>
                        <th colspan="4" class="text-right font-weight-600">Due Amount</th>
                        <th class="text-right font-weight-600 text-red">{{ calc.due }}</th>
                    </tr>
                </tfoot>
            </table>
            <p style="margin-top:15px;">
                <span style="font-size: 14px; font-weight: bold;">Prepared By:</span>
                <?php echo $this->session->userdata('name'); ?>
            </p>
            <table class="table_sign">
                <tr>
                    <td width="40%" align="left">Investigation Due: <?php echo number_format($investigation_due->total_due_amount, 0) ?? 0; ?></td>
                    <td width="30%" align="center">Pharmacy Due:</td>
                    <td width="30%" align="right">Signature</td>
                </tr>
            </table>
            <table class="table_less">
                <tr>
                    <td width="45%" align="left">Investigation Less:</td>
                    <td width="55%" align="left">Pharmacy Less:</td>
                </tr>
            </table>
        </div>
    </div>
</body>

</html>

<!-- Autocomplete -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/collect.js/4.28.4/collect.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/axios/0.20.0/axios.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/vue@2.6.12"></script>
<link href="https://unpkg.com/vue-bootstrap-typeahead/dist/VueBootstrapTypeahead.css" rel="stylesheet">
<script src="https://unpkg.com/vue-bootstrap-typeahead"></script>

<script>
    const app = new Vue({
        el: '#vue-app',
        components: {
            VueBootstrapTypeahead
        },
        created() {
            this.initSetadata();
        },
        data: {
            inits: {
                bed: <?php echo json_encode($bed_amounts); ?>,
                surgeon: <?php echo json_encode($surgeon_amounts); ?>,
                anesthesia: <?php echo json_encode($anesthesia_amounts); ?>,
                assistant: <?php echo json_encode($assistant_amounts); ?>,
                consultant: <?php echo json_encode($consultant_amounts); ?>,
                charge: <?php echo json_encode($charge_amounts); ?>,
            },
            tableData: [],
            discount: null,
            advanced: <?php echo $total_advanced ?? 0; ?>,
            commission: null,
            adf: {
                charges: []
            },
            calc: {
                qty: 0,
                bill: 0,
                discount: 0,
                payable: 0,
                net_total: 0,
                advanced: 0,
                due: 0,
                net_commission: 0
            }
        },
        methods: {
            initSetadata() {
                let _this = this;
                Object.keys(_this.inits).forEach(key => {
                    if (_this.inits && _this.inits[key].length > 0) {
                        _this.inits[key].forEach(function(item) {
                            let newData = {
                                id: null,
                                name: "",
                                type: "fixed",
                                code: null,
                                price: "",
                                commissions: 0,
                                quantity: 0,
                                total: 0
                            };
                            var type = item.type == '' ? "" : " (" + item.type + ")";
                            var name = item.name + type + "<br>";
                            var price = item.price;
                            newData.name += name;
                            newData.price += price;
                            newData.quantity += parseFloat(item.qty);
                            newData.total += parseFloat(item.amount);
                            _this.adf.charges.push(newData);
                        });
                    }
                });
                _this.calcAmount();
            },
            updateQty() {
                const data = collect(this.adf.charges).map(function(item) {
                    if (item.type == 'others') {
                        item.total = Math.abs(item.quantity) * parseFloat(item.price);
                    }
                    return item;
                }).all();
                this.adf.charges = data;
                this.calcAmount();
            },
            calcAmount() {
                let _this = this;
                _this.commission = 0;

                Object.keys(_this.calc).forEach(key => {
                    _this.calc[key] = 0;
                });

                const data = collect(_this.adf.charges);
                _this.calc.qty = data.sum('quantity');
                _this.calc.bill = data.sum('total');
                _this.calc.payable = _this.calc.net_total = data.sum('total');
                if (_this.adf.commission_user_id) {
                    let cid = _this.adf.commission_user_id.split(' - ');
                    var user = collect(_this.coms).where('user_id', cid[0]).first();
                    if (data.count() > 0 && user) {
                        data.each(function(item) {
                            _this.calc.net_commission += (parseFloat(item.commissions) * item.quantity);
                        });
                        _this.commission = _this.calc.net_commission;
                    }
                }

                if (_this.discount > 0) {
                    _this.calc.payable -= _this.discount;
                    _this.calc.net_total = _this.calc.payable;
                }
                if (_this.advanced > 0) {
                    _this.calc.net_total -= _this.advanced;
                }
                if (_this.calc.net_total > 0) {
                    _this.calc.due = _this.calc.net_total;
                }
            },
            setDataToTable(data) {
                var exists = collect(this.adf.charges).where('id', data.id).first();

                if (!exists) {
                    var newData = {
                        id: data.id,
                        name: data.name,
                        code: data.code,
                        type: "others",
                        price: parseFloat(data.price),
                        commissions: parseFloat(data.commission),
                        quantity: 1,
                        total: 1 * parseFloat(data.price)
                    };
                    this.adf.charges.push(newData);
                } else {
                    $.toast({
                        text: data.name + ' already added in list',
                        position: 'top-right',
                        loaderBg: '#7a5449',
                        class: 'jq-toast-danger',
                        hideAfter: 3500,
                        stack: 6,
                        showHideTransition: 'fade'
                    });
                }
                this.clearItem();
            }
        }
    });
</script>