<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('ipd'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container-fluid">
    <!-- Row -->
    <div class="row">
        <?php echo $this->load->view('ipd/patient-info'); ?>

        <!-- col-lg-12 -->
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(VIEW, 'ipd', 'bill')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-money font-30 mr-10"></i>
                            <?php echo $this->lang->line('billing'); ?> <?php echo $this->lang->line('list'); ?>
                        </h6>
                    <?php } ?>

                    <?php if (has_permission(VIEW, 'ipd', 'bill')) { ?>
                        <div class="align-items-center">
                            <button type="button" class="btn btn-primary btn-xs" onclick="printBill(<?php echo $this->uri->segment(4, 0); ?>);">
                                <i class="fa fa-print"></i>
                                <?php echo $this->lang->line('print'); ?>
                            </button>
                        </div>
                    <?php } ?>
                </div>
                <div class="card-body p-0" id="vue-app">
                    <div class="invoice-details">
                        <div class="table-wrap">
                            <div class="table-responsive">
                                <table class="table table-sm table-border mb-0">
                                    <thead class="text-center bg-gradient-sunset">
                                        <tr>
                                            <th class="text-white font-weight-700 text-center w-15">SL. No</th>
                                            <th class="text-white font-weight-700 text-left w-45">Service Name</th>
                                            <th class="text-white font-weight-700 text-center w-10">Qty</th>
                                            <th class="text-white font-weight-700 text-center w-10">Rate</th>
                                            <th class="text-white font-weight-700 text-center w-10">Total</th>
                                        </tr>
                                    </thead>
                                    <tbody v-if="adf.charges.length>0">
                                        <tr v-for="(charge, index) in adf.charges">
                                            <td class="text-center">{{ index + 1}}</td>
                                            <td class="text-left">
                                                <span v-html="charge.name"></span>
                                            </td>
                                            <td class="text-center">
                                                {{ charge.quantity }}
                                            </td>
                                            <td class="text-left">
                                                <span v-html="charge.price"></span>
                                            </td>
                                            <td class="text-right">
                                                {{ charge.total }}
                                            </td>
                                        </tr>

                                        <tr class="bg-transparent">
                                            <td colspan="4" class="text-right text-light">Sub Total</td>
                                            <td class="text-right">{{ calc.bill }}</td>
                                        </tr>
                                        <tr class="bg-transparent">
                                            <td colspan="4" class="text-right text-light border-top-0">Discount</td>
                                            <td class="text-right border-top-0">0.00</td>
                                        </tr>
                                        <tr class="bg-transparent">
                                            <td colspan="4" class="text-right text-light border-top-0">Net Payable</td>
                                            <td class="text-right border-top-0">{{ calc.payable }}</td>
                                        </tr>
                                        <tr class="bg-transparent">
                                            <td colspan="4" class="text-right text-light border-top-0">Paid Amount</td>
                                            <td class="text-right border-top-0">{{ advanced }}</td>
                                        </tr>
                                    </tbody>
                                    <tfoot class="border-bottom border-1">
                                        <tr>
                                            <th colspan="4" class="text-right font-weight-600">Due Amount</th>
                                            <th class="text-right font-weight-600 text-red">{{ calc.due }}</th>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->

<!-- Autocomplete -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/collect.js/4.28.4/collect.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/axios/0.20.0/axios.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/vue@2.6.12"></script>
<link href="https://unpkg.com/vue-bootstrap-typeahead/dist/VueBootstrapTypeahead.css" rel="stylesheet">
<script src="https://unpkg.com/vue-bootstrap-typeahead"></script>

<script>
    const app = new Vue({
        el: '#vue-app',
        components: {
            VueBootstrapTypeahead
        },
        created() {
            this.initSetadata();
        },
        data: {
            inits: {
                bed: <?php echo json_encode($bed_amounts); ?>,
                surgeon: <?php echo json_encode($surgeon_amounts); ?>,
                anesthesia: <?php echo json_encode($anesthesia_amounts); ?>,
                assistant: <?php echo json_encode($assistant_amounts); ?>,
                consultant: <?php echo json_encode($consultant_amounts); ?>,
                charge: <?php echo json_encode($charge_amounts); ?>,
            },
            tableData: [],
            discount: null,
            advanced: <?php echo $total_advanced ?? 0; ?>,
            commission: null,
            adf: {
                charges: []
            },
            calc: {
                qty: 0,
                bill: 0,
                discount: 0,
                payable: 0,
                net_total: 0,
                advanced: 0,
                due: 0,
                net_commission: 0
            }
        },
        methods: {
            initSetadata() {
                let _this = this;
                Object.keys(_this.inits).forEach(key => {
                    if (_this.inits && _this.inits[key].length > 0) {
                        _this.inits[key].forEach(function(item) {
                            let newData = {
                                id: null,
                                name: "",
                                type: "fixed",
                                code: null,
                                price: "",
                                commissions: 0,
                                quantity: 0,
                                total: 0
                            };
                            var type = item.type == '' ? "" : " (" + item.type + ")";
                            var name = item.name + type + "<br>";
                            var price = item.price;
                            newData.name += name;
                            newData.price += price;
                            newData.quantity += parseFloat(item.qty);
                            newData.total += parseFloat(item.amount);
                            _this.adf.charges.push(newData);
                        });
                    }
                });
                _this.calcAmount();
            },
            updateQty() {
                const data = collect(this.adf.charges).map(function(item) {
                    if (item.type == 'others') {
                        item.total = Math.abs(item.quantity) * parseFloat(item.price);
                    }
                    return item;
                }).all();
                this.adf.charges = data;
                this.calcAmount();
            },
            calcAmount() {
                let _this = this;
                _this.commission = 0;

                Object.keys(_this.calc).forEach(key => {
                    _this.calc[key] = 0;
                });

                const data = collect(_this.adf.charges);
                _this.calc.qty = data.sum('quantity');
                _this.calc.bill = data.sum('total');
                _this.calc.payable = _this.calc.net_total = data.sum('total');
                if (_this.adf.commission_user_id) {
                    let cid = _this.adf.commission_user_id.split(' - ');
                    var user = collect(_this.coms).where('user_id', cid[0]).first();
                    if (data.count() > 0 && user) {
                        data.each(function(item) {
                            _this.calc.net_commission += (parseFloat(item.commissions) * item.quantity);
                        });
                        _this.commission = _this.calc.net_commission;
                    }
                }

                if (_this.discount > 0) {
                    _this.calc.payable -= _this.discount;
                    _this.calc.net_total = _this.calc.payable;
                }
                if (_this.advanced > 0) {
                    _this.calc.net_total -= _this.advanced;
                }
                if (_this.calc.net_total > 0) {
                    _this.calc.due = _this.calc.net_total;
                }
            },
            setDataToTable(data) {
                var exists = collect(this.adf.charges).where('id', data.id).first();

                if (!exists) {
                    var newData = {
                        id: data.id,
                        name: data.name,
                        code: data.code,
                        type: "others",
                        price: parseFloat(data.price),
                        commissions: parseFloat(data.commission),
                        quantity: 1,
                        total: 1 * parseFloat(data.price)
                    };
                    this.adf.charges.push(newData);
                } else {
                    $.toast({
                        text: data.name + ' already added in list',
                        position: 'top-right',
                        loaderBg: '#7a5449',
                        class: 'jq-toast-danger',
                        hideAfter: 3500,
                        stack: 6,
                        showHideTransition: 'fade'
                    });
                }
                this.clearItem();
            }
        }
    });
</script>


<script>
    function printBill(ipd_id) {
        $.ajax({
            url: '<?php echo site_url('ipd/bill/print'); ?>',
            type: 'POST',
            data: {
                ipd_id: ipd_id
            },
            success: function(result) {
                $("#testdata").html(result);
                popup(result);
            }
        });
    }

    function popup(data) {
        var frame1 = $('<iframe />');
        frame1[0].name = "frame1";
        frame1.css({
            "position": "absolute",
            "top": "-1000000px"
        });
        $("body").append(frame1);
        var frameDoc = frame1[0].contentWindow ? frame1[0].contentWindow : frame1[0].contentDocument.document ? frame1[0].contentDocument.document : frame1[0].contentDocument;
        frameDoc.document.open();
        //Create a new HTML document.
        frameDoc.document.write('<html>');
        frameDoc.document.write('<head>');
        frameDoc.document.write('<title>Print Invoice</title>');

        frameDoc.document.write('</head>');
        frameDoc.document.write('<body>');
        frameDoc.document.write(data);
        frameDoc.document.write('</body>');
        frameDoc.document.write('</html>');
        frameDoc.document.close();
        setTimeout(function() {
            window.frames["frame1"].focus();
            window.frames["frame1"].print();
            frame1.remove();
            // window.location.reload(true);
        }, 500);

        return true;

    }
</script>