<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('ipd'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container-fluid">
    <!-- Row -->
    <div class="row">
        <?php echo $this->load->view('ipd/patient-info'); ?>

        <!-- col-lg-12 -->
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(VIEW, 'ipd', 'bed')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-user-md font-30 mr-10"></i>
                            <?php echo $this->lang->line('bed'); ?> <?php echo $this->lang->line('chart'); ?>
                        </h6>
                    <?php } ?>
                    <?php echo form_open_multipart(site_url('ipd/bed/index/' . $patient->id), array('name' => 'search', 'id' => 'search', 'class' => 'needs-validation', 'novalidate' => 'novalidate', 'method' => 'get'), ''); ?>
                    <div class="form-group">
                        <div class="input-group input-group-sm">
                            <input type="text" class="form-control" name="search" id="search" value="<?php echo isset($search) ?  $search : ''; ?>" placeholder="<?php echo $this->lang->line('search'); ?>">
                            <div class="input-group-append">
                                <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('search'); ?></button>
                            </div>
                        </div>
                    </div>
                    <?php echo form_close(); ?>

                    <?php if ($patient->discharged == 0 || $this->session->userdata('role_id') == SUPER_ADMIN ||  !empty(custom_permission('modified_discharged'))) { ?>
                        <?php if (has_permission(ADD, 'ipd', 'bed')) {
                            if ($patient->bed_empty == 0) {
                        ?>
                                <div class="align-items-center">
                                    <button type="button" class="btn btn-xs btn-primary" data-toggle="modal" data-target="#addBedModal">
                                        <i class="fa fa-plus font-12 mr-5"></i>
                                        <?php echo $this->lang->line('add'); ?> <?php echo $this->lang->line('bed'); ?>
                                    </button>
                                </div>
                            <?php } ?>
                        <?php } ?>
                    <?php } ?>
                </div>
                <div class="card-body">
                    <div class="table-wrap">
                        <div class="table-responsive">
                            <table class="table table-sm mb-0">
                                <thead>
                                    <tr>
                                        <th><?php echo $this->lang->line('sl_no'); ?></th>
                                        <th><?php echo $this->lang->line('ward'); ?></th>
                                        <th><?php echo $this->lang->line('bed'); ?></th>
                                        <th><?php echo $this->lang->line('from_date'); ?></th>
                                        <th><?php echo $this->lang->line('to_date'); ?></th>
                                        <th><?php echo $this->lang->line('charge'); ?></th>
                                        <th><?php echo $this->lang->line('status'); ?></th>
                                        <th class="w-20"><?php echo $this->lang->line('action'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if (isset($beds) && !empty($beds)) { ?>
                                        <?php foreach ($beds as $obj) { ?>
                                            <tr>
                                                <td><?php echo $sl_count; ?></td>
                                                <td><?php echo $obj->ward_name; ?></td>
                                                <td><?php echo $obj->bed; ?> - <?php echo $obj->floor; ?></td>
                                                <td><?php echo $obj->from_date ? date('d/m/Y h:ia', strtotime($obj->from_date)) : ''; ?></td>
                                                <td><?php echo $obj->to_date ? date('d/m/Y h:ia', strtotime($obj->to_date)) : ''; ?></td>
                                                <td>
                                                    <?php
                                                    $from_date = new DateTime(substr($obj->from_date, 0, 10));
                                                    $to_date = $obj->to_date ? new DateTime(substr($obj->to_date, 0, 10)) : new DateTime(date('Y-m-d'));
                                                    $interval = $to_date->diff($from_date, true)->days + 1;
                                                    $amount = abs((float) $obj->price) * abs($interval);
                                                    echo $amount;
                                                    ?>
                                                </td>
                                                <td><?php echo $obj->bed_status == 'complete' ? '<span class="badge badge-success">' .  $this->lang->line('complete') . '</span>' : '<span class="badge badge-danger">' .  $this->lang->line('rejected') . '</span>'; ?></td>
                                                <td>
                                                    <?php if (has_permission(VIEW, 'ipd', 'bed')) { ?>
                                                        <button type="button" onclick="get_view_modal(<?php echo $obj->id; ?>);" data-toggle="modal" data-target=".viewModalCenter" class="btn btn-primary btn-xs">
                                                            <i class="fa fa-eye"></i>
                                                        </button>
                                                    <?php } ?>

                                                    <?php if ($obj->to_date != NULL || $obj->to_date != '') { ?>
                                                        <?php if (has_permission(EDIT, 'ipd', 'bed')) {
                                                            if ($patient->discharged == 0) {
                                                        ?>
                                                                <button type="button" class="btn btn-xs btn-success" onclick="get_edit_bed_data(<?php echo $obj->id; ?>);" data-toggle="modal" data-target="#editBedModal">
                                                                    <i class="fa fa-pencil-square-o"></i>
                                                                </button>
                                                            <?php } ?>
                                                        <?php } ?>
                                                    <?php } ?>

                                                    <?php if ($patient->discharged == 0 || $this->session->userdata('role_id') == SUPER_ADMIN ||  !empty(custom_permission('modified_discharged'))) { ?>
                                                        <?php if (has_permission(DELETE, 'ipd', 'bed')) { ?>
                                                            <?php if ($obj->to_date != NULL || $obj->to_date != '') { ?>
                                                                <a class="btn btn-xs btn-danger round" href="<?php echo site_url('ipd/bed/delete/' . $obj->id); ?>" onclick="javascript: return confirm('<?php echo $this->lang->line('confirm_alert'); ?>');"> <i class="fa fa-trash text-white"></i></a>
                                                            <?php } ?>
                                                        <?php } ?>
                                                    <?php } ?>
                                                </td>
                                            </tr>
                                            <?php $sl_count++; ?>
                                        <?php } ?>
                                    <?php } else { ?>
                                        <tr class="text-center">
                                            <td colspan="8"><?php echo $this->lang->line('no_data_found'); ?></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <!-- Card Footer -->
                <?php if ($this->pagination->create_links()) { ?>
                    <div class="card-footer justify-content-end">
                        <?php echo $this->pagination->create_links(); ?>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->

<!-- Add Bed Modal-->
<div class="modal fade" id="addBedModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalForms" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?php echo $this->lang->line('add'); ?> <?php echo $this->lang->line('bed'); ?></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <form id="addBedForm" enctype="multipart/form-data" method="POST" autocomplete="off">
                <div class="modal-body">
                    <div class="form-row">
                        <div class="col-md-5 mb-10">
                            <label for="bed_group_id"><?php echo $this->lang->line('admitted'); ?> <?php echo $this->lang->line('ward'); ?> <span class="required">*</span></label>
                            <select class="form-control custom-select select2" name="bed_group_id" id="add_bed_group_id" required onchange="get_bed(this.value)">
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php foreach ($bed_groups as $obj) { ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($bed_group_id) && $bed_group_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?> [<?php echo $obj->floor_name; ?>]</option>
                                <?php } ?>
                            </select>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="bed_group_id" class="form-text text-muted">
                                <?php echo form_error('bed_group_id'); ?>
                            </small>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="bed_id"><?php echo $this->lang->line('bed'); ?> <?php echo $this->lang->line('number'); ?> <span class="required">*</span></label>
                            <select class="form-control custom-select select2" name="bed_id" id="add_bed_id" required>
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                            </select>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="bed_id" class="form-text text-muted">
                                <?php echo form_error('bed_id'); ?>
                            </small>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="from_date"><?php echo $this->lang->line('from_date'); ?></label>
                            <input type="text" class="form-control from_date" name="from_date" id="add_from_date" placeholder="<?php echo $this->lang->line('from_date'); ?>" required>
                        </div>
                        <div class="col-md-12 mb-10">
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><?php echo $this->lang->line('remark'); ?></span>
                                </div>
                                <textarea class="form-control" name="note" id="add_note" aria-label="<?php echo $this->lang->line('note'); ?>"><?php echo isset($note) ?  $note : ''; ?></textarea>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer pt-0">
                    <div class="button-list">
                        <input type="hidden" name="ipd_id" value="<?php echo $patient->id; ?>">
                        <input type="hidden" name="patient_id" value="<?php echo $patient->patient_id; ?>">
                        <button type="button" class="btn btn-gradient-danger" data-dismiss="modal"><?php echo $this->lang->line('cancel'); ?></button>
                        <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('submit'); ?></button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
<script>
    function get_bed(bed_group_id) {
        $.ajax({
            type: "POST",
            url: "<?php echo site_url('ajax/get_bed_group_by_bed'); ?>",
            data: {
                bed_group_id: bed_group_id
            },
            async: false,
            success: function(response) {
                if (response) {
                    $('#add_bed_id').html(response);
                }
            }
        });
    };

    $(document).ready(function(e) {
        $("#addBedForm").on('submit', (function(e) {
            $('button[type=submit]').attr('disabled', true);
            e.preventDefault();
            $.ajax({
                url: '<?php echo base_url('ipd/bed/add'); ?>',
                type: "POST",
                data: new FormData(this),
                dataType: 'json',
                contentType: false,
                cache: false,
                processData: false,
                success: function(data) {
                    if (data.status == "failed") {
                        var message = "";
                        $.each(data.error, function(index, value) {
                            message += value;
                        });
                        $.toast({
                            text: data.error,
                            position: 'top-right',
                            loaderBg: '#7a5449',
                            class: 'jq-toast-danger',
                            hideAfter: 3500,
                            stack: 6,
                            showHideTransition: 'fade'
                        });
                        $('button[type=submit]').attr('disabled', false);
                    } else {
                        $.toast({
                            text: data.message,
                            position: 'top-right',
                            loaderBg: '#7a5449',
                            class: 'jq-toast-primary',
                            hideAfter: 3500,
                            stack: 6,
                            showHideTransition: 'fade'
                        });
                        window.location.reload();
                    }
                }
            });
        }));
    });
</script>


<!-- Edit Bed Modal-->
<div class="modal fade" id="editBedModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalForms" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?php echo $this->lang->line('edit'); ?> <?php echo $this->lang->line('bed'); ?></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <form id="editBedForm" enctype="multipart/form-data" method="POST" action="<?php echo site_url('ipd/bed/edit'); ?>" autocomplete="off">
                <div class="modal-body">
                    <div class="form-row">
                        <div class="col-md-4 mb-10">
                            <label for="bed_group_id"><?php echo $this->lang->line('bed'); ?> <?php echo $this->lang->line('group'); ?> <span class="required">*</span></label>
                            <select class="form-control custom-select" name="bed_group_id" id="edit_bed_group_id" required onchange="get_edit_bed(this.value)">
                                <?php foreach ($bed_groups as $obj) { ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($bed_group_id) && $bed_group_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?> [<?php echo $obj->floor_name; ?>]</option>
                                <?php } ?>
                            </select>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="bed_group_id" class="form-text text-muted">
                                <?php echo form_error('bed_group_id'); ?>
                            </small>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="bed_id"><?php echo $this->lang->line('bed'); ?> <span class="required">*</span></label>
                            <select class="form-control custom-select" name="bed_id" id="edit_bed_id" required>
                                <?php foreach ($edit_bed_list as $obj) { ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($bed_id) && $bed_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="bed_id" class="form-text text-muted">
                                <?php echo form_error('bed_id'); ?>
                            </small>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="from_date"><?php echo $this->lang->line('from_date'); ?></label>
                            <input type="text" class="form-control" name="from_date" id="edit_from_date" placeholder="<?php echo $this->lang->line('from_date'); ?>" required>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="to_date"><?php echo $this->lang->line('to_date'); ?></label>
                            <input type="text" class="form-control" name="to_date" id="edit_to_date" placeholder="<?php echo $this->lang->line('to_date'); ?>" required>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="bed_status"><?php echo $this->lang->line('bed'); ?> <?php echo $this->lang->line('status'); ?> <span class="required">*</span></label>
                            <select class="form-control custom-select" name="bed_status" id="edit_bed_status" required>
                                <option value="complete" <?php echo isset($bed_status) && $bed_status == 'complete' ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('complete'); ?></option>
                                <option value="rejected" <?php echo isset($bed_status) && $bed_status == 'rejected' ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('rejected'); ?></option>
                            </select>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="edit_bed_status" class="form-text text-muted">
                                <?php echo form_error('edit_bed_status'); ?>
                            </small>
                        </div>
                        <div class="col-md-9 mb-10">
                            <label for="remark"><?php echo $this->lang->line('remark'); ?><span class="required">*</span></label>
                            <input type="text" class="form-control" name="note" id="edit_bed_note" value="<?php echo isset($note) ?  $note : ''; ?>" placeholder="<?php echo $this->lang->line('remark'); ?>" required autocomplete="off">
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="remark" class="form-text text-muted">
                                <?php echo form_error('remark'); ?>
                            </small>
                        </div>
                    </div>
                </div>
                <div class="modal-footer pt-0">
                    <div class="button-list">
                        <input type="hidden" id="edit_id" name="id">
                        <button type="button" class="btn btn-gradient-danger" data-dismiss="modal"><?php echo $this->lang->line('cancel'); ?></button>
                        <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('update'); ?></button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>


<script>
    function get_edit_bed_data(id) {
        $.ajax({
            url: '<?php echo site_url('ipd/bed/get_bed_data/') ?>' + id,
            dataType: 'json',
            success: function(data) {
                $('#edit_id').val(data.id);
                $('#edit_bed_group_id').val(data.bed_group_id).trigger('change');
                $('#edit_bed_id').val(data.bed_id).trigger('change');
                $('#edit_from_date').val(data.from_date);
                $('#edit_to_date').val(data.to_date);
                $('#edit_bed_note').val(data.note);
                $('#edit_bed_status').val(data.bed_status).trigger('change');
            }
        });
    }

    function get_edit_bed(bed_group_id) {
        $.ajax({
            type: "POST",
            url: "<?php echo site_url('ajax/get_edit_bed_group_by_bed'); ?>",
            data: {
                bed_group_id: bed_group_id
            },
            async: false,
            success: function(response) {
                if (response) {
                    $('#edit_bed_id').html(response);
                }
            }
        });
    };

    $(document).ready(function(e) {
        $("#editBedForm").on('submit', (function(e) {
            $('button[type=submit]').attr('disabled', true);
            e.preventDefault();
            $.ajax({
                url: '<?php echo base_url('ipd/bed/edit'); ?>',
                type: "POST",
                data: new FormData(this),
                dataType: 'json',
                contentType: false,
                cache: false,
                processData: false,
                success: function(data) {
                    if (data.status == "failed") {
                        var message = "";
                        $.each(data.error, function(index, value) {
                            message += value;
                        });
                        $.toast({
                            text: data.error,
                            position: 'top-right',
                            loaderBg: '#7a5449',
                            class: 'jq-toast-danger',
                            hideAfter: 3500,
                            stack: 6,
                            showHideTransition: 'fade'
                        });

                    } else {
                        $.toast({
                            text: data.message,
                            position: 'top-right',
                            loaderBg: '#7a5449',
                            class: 'jq-toast-primary',
                            hideAfter: 3500,
                            stack: 6,
                            showHideTransition: 'fade'
                        });
                        window.location.reload();
                    }
                }
            });
        }));
    });
</script>


<div class="modal fade viewModalCenter" tabindex="-1" role="dialog" aria-labelledby="viewModalCenter" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header bg-gradient-primary">
                <h5 class="modal-title text-white"><?php echo $this->lang->line('bed'); ?> <?php echo $this->lang->line('info'); ?></h5>
                <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body modal_data bg-gradient-secondary"></div>
        </div>
    </div>
</div>

<script type="text/javascript">
    function get_view_modal(id) {
        $('.modal_data').html('<p style="padding: 20px;"><p style="padding: 20px;text-align:center;"><img src="<?php echo IMG_URL; ?>loader.gif" /></p>');
        $.ajax({
            type: "POST",
            url: "<?php echo site_url('ipd/bed/get_single_bed'); ?>",
            data: {
                id: id
            },
            success: function(response) {
                if (response) {
                    $('.modal_data').html(response);
                }
            }
        });
    }
</script>


<!-- Daterangepicker -->
<link href="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>moment/min/moment.min.js"></script>
<script src="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.js"></script>

<!-- Select2 -->
<link href="<?php echo VENDOR_URL; ?>select2/dist/css/select2.min.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>select2/dist/js/select2.full.min.js"></script>

<style>
    .select2-container .select2-selection--single {
        height: calc(2.25rem + 4px) !important;
    }

    .select2-container--default .select2-search--dropdown .select2-search__field {
        color: #324148;
        border-width: 2px;
        border-color: #e0e3e4;
        padding: .375rem .75rem;
        height: calc(2.25rem + 4px);
    }

    .select2-container--default .select2-selection--single .select2-selection__arrow b {
        margin-top: 5px;
    }
</style>
<script>
    $(".select2").select2();
    $('#add_from_date, #edit_from_date, #edit_to_date').daterangepicker({
        singleDatePicker: true,
        startDate: new Date(),
        showDropdowns: true,
        minYear: 1901,
        timePicker: true,
        timePicker24Hour: true,
        timePickerIncrement: 1,
        timePickerSeconds: false,
        autoUpdateInput: true,
        autoApply: true,
        locale: {
            format: 'YYYY-MM-DD HH:mm',
        }
    });
</script>