<div class="table-wrap">
    <div class="table-responsive">
        <table class="table table-sm text-white">
            <tbody>
                <tr>
                    <td><?php echo $this->lang->line('patient'); ?> <?php echo $this->lang->line('name'); ?></td>
                    <td><?php echo $assistant->patient_name; ?></td>
                    <td><?php echo $this->lang->line('patient_id'); ?></td>
                    <td><?php echo $assistant->patient_unique_id; ?></td>
                </tr>
                <tr>
                    <td><?php echo $this->lang->line('assistant'); ?></td>
                    <td><?php echo $assistant->doctor; ?></td>
                    <td><?php echo $this->lang->line('assistant'); ?> <?php echo $this->lang->line('charge'); ?></td>
                    <td><?php echo $assistant->charge; ?></td>
                </tr>
                <tr>
                    <td><?php echo $this->lang->line('status'); ?></td>
                    <td>
                        <?php if ($assistant->assistant_status == 'complete') { ?>
                            <span class="badge badge-success"><?php echo $this->lang->line('complete'); ?></span>
                        <?php } elseif ($assistant->assistant_status == 'rejected') { ?>
                            <span class="badge badge-danger"><?php echo $this->lang->line('rejected'); ?></span>
                        <?php } elseif ($assistant->assistant_status == 'pending') { ?>
                            <span class="badge badge-info"><?php echo $this->lang->line('pending'); ?></span>
                        <?php } else { ?>
                            <span class="badge badge-warning"><?php echo $this->lang->line('cancel'); ?></span>
                        <?php } ?>
                    </td>
                    <td><?php echo $this->lang->line('date'); ?></td>
                    <td><?php echo date('d/m/Y h:i A', strtotime($assistant->date)); ?></td>
                </tr>
                <tr>
                    <td><?php echo $this->lang->line('instruction'); ?></td>
                    <td><?php echo $assistant->instruction; ?></td>
                    <td><?php echo $this->lang->line('remark'); ?></td>
                    <td><?php echo $assistant->note; ?></td>
                </tr>
                <tr>
                    <td><?php echo $this->lang->line('created_by'); ?></td>
                    <td><?php echo $assistant->created_by; ?></td>
                    <td><?php echo $this->lang->line('date'); ?></td>
                    <td><?php echo date('d F, Y h:i A', strtotime($assistant->created_at)); ?></td>
                </tr>
                <?php if ($this->session->userdata('role_id') == SUPER_ADMIN || !empty(custom_permission('modified_by'))) { ?>
                    <tr>
                        <td><?php echo $this->lang->line('modified_by'); ?></td>
                        <td><?php echo $assistant->modified_by; ?></td>
                        <td><?php echo $this->lang->line('date'); ?></td>
                        <td><?php echo $assistant->modified_by ? date('d F, Y h:i A', strtotime($assistant->modified_at)) : ''; ?>
                        </td>
                    </tr>
                <?php } ?>
            </tbody>
        </table>
    </div>
</div>