<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('ipd'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container-fluid">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('ipd'); ?>
        </h4>
        <div class="d-flex">
            <?php if (has_permission(ADD, 'ipd', 'ipd')) { ?>
                <a href="<?php echo site_url('ipd/new'); ?>" class="btn btn-primary btn-sm mr-15">
                    <i class="fa fa-user-plus"></i>
                    <?php echo $this->lang->line('new'); ?> <?php echo $this->lang->line('patient'); ?>
                </a>
            <?php } ?>

            <?php if (has_permission(ADD, 'ipd', 'ipd')) { ?>
                <a href="<?php echo site_url('ipd/existing'); ?>" class="btn btn-success btn-sm">
                    <i class="fa fa-users"></i>
                    <?php echo $this->lang->line('existing'); ?> <?php echo $this->lang->line('patient'); ?>
                </a>
            <?php } ?>
        </div>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <!-- col-lg-12 -->
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(VIEW, 'ipd', 'ipd')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-bed font-30 mr-10"></i>
                            <?php echo $this->lang->line('admitted'); ?> <?php echo $this->lang->line('patient'); ?> <?php echo $this->lang->line('list'); ?>
                        </h6>
                    <?php } ?>
                    <?php echo form_open_multipart(site_url('ipd/admitted'), array('name' => 'search', 'id' => 'search', 'class' => 'needs-validation form-inline', 'novalidate' => 'novalidate', 'method' => 'get'), ''); ?>
                    <div class="form-group">
                        <div class="input-group input-group-sm">
                            <input type="text" class="form-control" name="search" id="search" value="<?php echo isset($search) ?  $search : ''; ?>" placeholder="<?php echo $this->lang->line('search'); ?>">
                            <div class="input-group-append">
                                <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('search'); ?></button>
                            </div>
                        </div>
                    </div>
                    <?php echo form_close(); ?>
                </div>
                <div class="card-body">
                    <div class="table-wrap">
                        <div class="table-responsive">
                            <table class="table table-sm mb-0">
                                <thead>
                                    <tr>
                                        <th><?php echo $this->lang->line('sl_no'); ?></th>
                                        <th width="10%"><?php echo $this->lang->line('admitted'); ?> <?php echo $this->lang->line('date'); ?></th>
                                        <th><?php echo $this->lang->line('admission_id'); ?></th>
                                        <th><?php echo $this->lang->line('patient_id'); ?></th>
                                        <th><?php echo $this->lang->line('name'); ?></th>
                                        <th><?php echo $this->lang->line('ref_by'); ?></th>
                                        <th><?php echo $this->lang->line('admitted'); ?> <?php echo $this->lang->line('ward'); ?></th>
                                        <th><?php echo $this->lang->line('bed'); ?></th>
                                        <th width="22%"><?php echo $this->lang->line('action'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if (isset($patients) && !empty($patients)) { ?>
                                        <?php foreach ($patients as $obj) {
                                            $bed_empty = $this->ipd->get_single('ipd_beds', array('ipd_id' => $obj->id, 'patient_id' => $obj->patient_id, 'discharged' => 1));
                                        ?>
                                            <tr>
                                                <td><?php echo $sl_count; ?></td>
                                                <td><?php echo date('d/m/Y h:i A', strtotime($obj->admission_date)); ?></td>
                                                <td><?php echo $obj->ipd_no; ?></td>
                                                <td><?php echo $obj->patient_unique_id; ?></td>
                                                <td>
                                                    <a href="<?php echo site_url('ipd/profile/' . $obj->id); ?>">
                                                        <?php echo $obj->patient_name; ?>
                                                    </a>
                                                </td>
                                                <td><?php echo $obj->doctor_name; ?></td>
                                                <td><?php echo $obj->ward_name; ?></td>
                                                <td>
                                                    <i class="fa fa-bed text-green"></i>
                                                    <?php echo $obj->bed; ?> - <?php echo $obj->floor; ?>
                                                </td>
                                                <td>
                                                    <?php if (has_permission(VIEW, 'ipd', 'ipd')) { ?>
                                                        <button type="button" class="btn btn-xs btn-orange" onclick="printBill('<?php echo $obj->id; ?>')">
                                                            <i class="fa fa-print"></i>
                                                        </button>
                                                    <?php } ?>
                                                    <?php if (has_permission(VIEW, 'ipd', 'ipd')) { ?>
                                                        <button type="button" class="btn btn-xs btn-primary" onclick="printConsent('<?php echo $obj->id; ?>')">
                                                            <i class="fa fa-print"></i> <?php echo $this->lang->line('consent'); ?>
                                                        </button>
                                                    <?php } ?>
                                                    <?php if (isset($bed_empty) && $bed_empty) { ?>
                                                        <?php if (has_permission(ADD, 'ipd', 'ipd')) { ?>
                                                            <a class="btn btn-xs btn-danger" href="<?php echo site_url('ipd/create/' . $obj->id); ?>">
                                                                <i class="fa fa-money"></i>
                                                                <?php echo $this->lang->line('bill'); ?>
                                                            </a>
                                                        <?php } ?>
                                                    <?php } else { ?>
                                                        <?php if (has_permission(ADD, 'ipd', 'ipd')) { ?>
                                                            <button type="button" onclick="dischargePatient('<?php echo $obj->id; ?>')" class="btn btn-xs btn-danger" data-toggle="modal" data-target="#dischargePatientModal">
                                                                <i class="fa fa-hospital-o"></i>
                                                                <?php echo $this->lang->line('discharge'); ?>
                                                            </button>
                                                        <?php } ?>
                                                    <?php } ?>
                                                    <?php if (has_permission(VIEW, 'ipd', 'ipd_admission_sms')) { ?>
                                                        <button type="button" onclick="send_sms(<?php echo $obj->id; ?>);" class="btn btn-warning btn-xs">
                                                            <i class="fa fa-envelope-o"></i>
                                                        </button>
                                                    <?php } ?>
                                                    <?php if (has_permission(VIEW, 'ipd', 'ipd')) { ?>
                                                        <a class="btn btn-xs btn-info" href="<?php echo site_url('ipd/profile/' . $obj->id); ?>">
                                                            <i class="fa fa-eye"></i>
                                                        </a>
                                                    <?php } ?>
                                                    <?php if (has_permission(EDIT, 'ipd', 'ipd')) { ?>
                                                        <a class="btn btn-xs btn-success" href="<?php echo site_url('ipd/edit/' . $obj->id); ?>"><i class="fa fa-pencil-square-o"></i></a>
                                                    <?php } ?>
                                                    <?php if (has_permission(DELETE, 'ipd', 'ipd')) { ?>
                                                        <a class="btn btn-xs btn-danger" href="#" onclick="javascript: return confirm('<?php echo $this->lang->line('confirm_alert'); ?>');"> <i class="fa fa-trash text-white"></i></a>
                                                    <?php } ?>
                                                </td>
                                            </tr>
                                            <?php $sl_count++; ?>
                                        <?php } ?>
                                    <?php } else { ?>
                                        <tr class="text-center">
                                            <td colspan="9"><?php echo $this->lang->line('no_data_found'); ?></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <!-- Card Footer -->
                <?php if ($this->pagination->create_links()) { ?>
                    <div class="card-footer justify-content-end">
                        <?php echo $this->pagination->create_links(); ?>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->

<script>
    function printBill(id) {
        $.ajax({
            url: '<?php echo site_url('ipd/print'); ?>',
            type: 'POST',
            data: {
                id: id,
            },
            success: function(result) {
                $("#testdata").html(result);
                popup(result);
            }
        });
    }

    function printConsent(id) {
        $.ajax({
            url: '<?php echo site_url('ipd/consent'); ?>',
            type: 'POST',
            data: {
                id: id,
            },
            success: function(result) {
                $("#testdata").html(result);
                popup(result);
            }
        });
    }

    function popup(data) {
        var frame1 = $('<iframe />');
        frame1[0].name = "frame1";
        frame1.css({
            "position": "absolute",
            "top": "-1000000px"
        });
        $("body").append(frame1);
        var frameDoc = frame1[0].contentWindow ? frame1[0].contentWindow : frame1[0].contentDocument.document ? frame1[0].contentDocument.document : frame1[0].contentDocument;
        frameDoc.document.open();
        //Create a new HTML document.
        frameDoc.document.write('<html>');
        frameDoc.document.write('<head>');
        frameDoc.document.write('<title>Print</title>');

        frameDoc.document.write('</head>');
        frameDoc.document.write('<body>');
        frameDoc.document.write(data);
        frameDoc.document.write('</body>');
        frameDoc.document.write('</html>');
        frameDoc.document.close();
        setTimeout(function() {
            window.frames["frame1"].focus();
            window.frames["frame1"].print();
            frame1.remove();
            //window.location.reload(true);
        }, 500);

        return true;

    }
</script>


<!-- Add Discharge Patient Modal-->
<div class="modal fade" id="dischargePatientModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalForms" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?php echo $this->lang->line('add'); ?> <?php echo $this->lang->line('discharge'); ?> <?php echo $this->lang->line('patient'); ?></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <form id="dischargePatientForm" enctype="multipart/form-data" method="POST" action="<?php echo site_url('ipd/dischargePatient'); ?>">
                <div class="modal-body">
                    <div class="form-row">
                        <div class="col-md-6 mb-10">
                            <label for="to_date"><?php echo $this->lang->line('date'); ?></label>
                            <input type="text" class="form-control" name="to_date" id="to_date" value="<?php echo isset($to_date) ?  $to_date : ''; ?>" placeholder="<?php echo $this->lang->line('date'); ?>" required>
                        </div>
                        <div class="col-md-6 mb-10">
                            <label for="note"><?php echo $this->lang->line('remark'); ?></label>
                            <input type="text" class="form-control" name="note" id="note" value="<?php echo isset($note) ?  $note : ''; ?>" placeholder="<?php echo $this->lang->line('remark'); ?>">
                        </div>
                    </div>
                </div>
                <div class="modal-footer pt-0">
                    <div class="button-list">
                        <input type="hidden" name="id" id="ipd_id">
                        <input type="hidden" name="patient_id" id="patient_id">
                        <input type="hidden" name="bed_group_id" id="bed_group_id">
                        <input type="hidden" name="bed_id" id="bed_id">
                        <button type="button" class="btn btn-gradient-danger" data-dismiss="modal"><?php echo $this->lang->line('cancel'); ?></button>
                        <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('submit'); ?></button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
    function dischargePatient(id) {
        $.ajax({
            url: '<?php echo site_url('ipd/get_single_ipd/') ?>' + id,
            dataType: 'json',
            success: function(data) {
                $('#ipd_id').val(data.id);
                $('#patient_id').val(data.patient_id);
                $('#bed_group_id').val(data.bed_group_id);
                $('#bed_id').val(data.bed_id);
            }
        });
    }
</script>

<!-- Daterangepicker -->
<link href="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>moment/min/moment.min.js"></script>
<script src="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.2/jquery-confirm.min.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.2/jquery-confirm.min.js"></script>

<script>
    $('#to_date').daterangepicker({
        singleDatePicker: true,
        startDate: new Date(),
        showDropdowns: true,
        minYear: 1901,
        timePicker: true,
        timePicker24Hour: true,
        timePickerIncrement: 1,
        timePickerSeconds: false,
        autoUpdateInput: true,
        autoApply: true,
        locale: {
            format: 'YYYY-MM-DD HH:mm',
        }
    });

    function send_sms(id) {
        $.confirm({
            title: 'Send SMS!',
            content: 'Are you sure to send SMS?',
            type: 'red',
            typeAnimated: true,
            buttons: {
                tryAgain: {
                    text: 'Yes',
                    btnClass: 'btn-red',
                    action: function() {
                        $.ajax({
                            url: "<?php echo site_url('ipd/ipd_admission_sms'); ?>/" + id,
                            method: 'get'
                        });
                        $.alert('SMS Sent Successfully!');
                    }
                },
                close: function() {}
            }
        });
    }
</script>