<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Consultant_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }

    public function get_patient_consultant_list($limit, $offset, $ipd_id, $search, $count) {
        $this->db->select('CV.*, D.name as doctor, D.specialist, DC.ipd_charge, P.patient_unique_id, P.name as patient_name, P.gender, P.dob, P.phone, P.address, PA.paid_status');
        $this->db->from('ipd_consultant_visits AS CV');
        $this->db->join('patients AS P', 'P.user_id = CV.patient_id', 'left');
        $this->db->join('employees AS D', 'D.user_id = CV.doctor_id', 'left');
        $this->db->join('doctor_charges AS DC', 'DC.doctor_id = CV.doctor_id', 'left');
        $this->db->join('ipd_patients AS IP', 'IP.id = CV.ipd_id', 'left');
        $this->db->join('payments AS PA', 'PA.invoice_id = CV.id AND PA.invoice_type = CV.type', 'left');
        if ($search) {
            $this->db->group_start();
            $this->db->like('P.patient_unique_id', $search);
            $this->db->or_like('P.phone', $search);
            $this->db->or_like('P.name', $search);
            $this->db->or_like('P.bn_name', $search);
            $this->db->or_like('P.gender', $search);
            $this->db->or_like('P.religion', $search);
            $this->db->or_like('P.blood_group', $search);
            $this->db->or_like('P.marital_status', $search);
            $this->db->or_like('P.address', $search);
            $this->db->or_like('D.name', $search);
            $this->db->or_like('CV.instruction', $search);
            $this->db->or_like('CV.visit_status', $search);
            $this->db->group_end();
        }
        $this->db->where('CV.ipd_id', $ipd_id);
        $this->db->order_by('CV.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }

    public function get_single_consultant($id) {
        $this->db->select('CV.*, D.name as doctor, D.specialist, P.patient_unique_id, P.name as patient_name, P.gender, P.dob, P.phone, P.address, C.name as created_by, M.name as modified_by');
        $this->db->from('ipd_consultant_visits AS CV');
        $this->db->join('patients AS P', 'P.user_id = CV.patient_id', 'left');
        $this->db->join('employees AS D', 'D.user_id = CV.doctor_id', 'left');
        $this->db->join('ipd_patients AS IP', 'IP.id = CV.ipd_id', 'left');
        $this->db->join('employees AS C', 'C.user_id = CV.created_by', 'left');
        $this->db->join('employees AS M', 'M.user_id = CV.modified_by', 'left');
        $this->db->where('CV.id', $id);
        return $this->db->get()->row();
    }
}
