<?php

defined('BASEPATH') or exit('No direct script access allowed');

/* * *****************Timeline.php**********************************
 * @product name    : Hospital Management System
 * @type            : Class
 * @class name      : Timeline
 * @description     : Manage IPD Timeline Chart.
 * @author          : South Bangla IT Zone Team
 * @url             : http://hms.sbitzone.com
 * @support         : rabibd.it@gmail.com
 * @copyright       : South Bangla IT Zone Team
 * ********************************************************** */

class timeline extends MY_Controller {

    public $data = array();

    function __construct() {
        parent::__construct();
        $this->load->model('Timeline_Model', 'timeline', true);
        $this->load->model('Ipd_Model', 'ipd', true);
    }

    public function index($ipd_id) {

        check_permission(VIEW);

        $this->data['patient'] = $this->ipd->get_single_ipd_patient($ipd_id);

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('patient') . ' ' . $this->lang->line('timeline') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('timeline/index', $this->data);
    }
}
