<?php

defined('BASEPATH') or exit('No direct script access allowed');

/* * *****************Prescription.php**********************************
 * @product name    : Hospital Management System
 * @type            : Class
 * @class name      : Prescription
 * @description     : Manage IPD Prescription.
 * @author          : South Bangla IT Zone Team
 * @url             : http://hms.sbitzone.com
 * @support         : rabibd.it@gmail.com
 * @copyright       : South Bangla IT Zone Team
 * ********************************************************** */

class prescription extends MY_Controller {

    public $data = array();

    function __construct() {
        parent::__construct();
        $this->load->model('Prescription_Model', 'prescription', true);
        $this->load->model('Ipd_Model', 'ipd', true);
    }

    public function index($ipd_id) {

        check_permission(VIEW);

        $this->data['patient'] = $this->ipd->get_single_ipd_patient($ipd_id);

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('patient') . ' ' . $this->lang->line('prescription') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('prescription/index', $this->data);
    }
}
