<?php

defined('BASEPATH') or exit('No direct script access allowed');

/* * *****************Diagnosis.php**********************************
 * @product name    : Hospital Management System
 * @type            : Class
 * @class name      : Diagnosis
 * @description     : Manage IPD Diagnosis Chart.
 * @author          : South Bangla IT Zone Team
 * @url             : http://hms.sbitzone.com
 * @support         : rabibd.it@gmail.com
 * @copyright       : South Bangla IT Zone Team
 * ********************************************************** */

class Diagnosis extends MY_Controller {

    public $data = array();

    function __construct() {
        parent::__construct();
        $this->load->model('Diagnosis_Model', 'diagnosis', true);
        $this->load->model('Ipd_Model', 'ipd', true);
    }

    public function index($ipd_id) {

        check_permission(VIEW);

        $this->data['patient'] = $this->ipd->get_single_ipd_patient($ipd_id);

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('diagnosis') . ' ' . $this->lang->line('chart') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('diagnosis/index', $this->data);
    }
}
