<?php

defined('BASEPATH') or exit('No direct script access allowed');

/* * *****************Charge.php**********************************
 * @product name    : Hospital Management System
 * @type            : Class
 * @class name      : Charge
 * @description     : Manage IPD Charge Chart.
 * @author          : South Bangla IT Zone Team
 * @url             : http://hms.sbitzone.com
 * @support         : rabibd.it@gmail.com
 * @copyright       : South Bangla IT Zone Team
 * ********************************************************** */

class Charge extends MY_Controller {

    public $data = array();

    function __construct() {
        parent::__construct();
        $this->load->model('Charge_Model', 'charge', true);
        $this->load->model('Ipd_Model', 'ipd', true);
        $this->data['charge_items'] = $this->charge->get_list('charges', array('status' => 1), '', '', '', 'sort_by', 'ASC');
    }

    public function index($ipd_id) {

        check_permission(VIEW);

        $this->data['patient'] = $this->ipd->get_single_ipd_patient($ipd_id);
        $this->data['total_investigation_due'] = $this->ipd->get_total_investigation_due($this->data['patient']->patient_id);
        $this->data['total_pharmacy_due'] = $this->ipd->get_total_pharmacy_due($this->data['patient']->patient_id);
        $this->data['total_ipd_advanced'] = $this->ipd->get_total_ipd_advaced($ipd_id, $this->data['patient']->patient_id);
        

        $search = trim($this->input->get('search'));
        $config = array();
        $config = get_pagination(ADMIN_PER_PAGE);
        if ($search) {
            $config['base_url'] = site_url('ipd/charge/index/' . $ipd_id . '/?search=' . $search);
        } else {
            $config['base_url'] = current_url();
        }
        if ($this->input->get('page')) {
            $sgm = (int) trim($this->input->get('page'));
            $offset = $config['per_page'] * ($sgm - 1);
        } else {
            $offset = 0;
        }

        $config['total_rows'] = $this->charge->get_patient_charge_list($config['per_page'], $offset, $ipd_id, $search, $count = TRUE);
        $this->pagination->initialize($config);
        $this->data['charges'] = $this->charge->get_patient_charge_list($config['per_page'], $offset, $ipd_id, $search, $count = FALSE);
        $this->data['sl_count'] = ($this->input->get('page') == 0 ? 1 : (($this->input->get('page') - 1) * $config["per_page"] + 1));
        $this->data['search'] = $search;

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('charge') . ' ' . $this->lang->line('chart') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('charge/index', $this->data);
    }

    /*****************Function add**********************************
     * @type            : Function
     * @function name   : add
     * @description     : Load "Add Charge" user interface
     *                    and process to store "ipd_charges" into database
     * @param           : null
     * @return          : null
     * ********************************************************** */

    public function add() {

        check_permission(ADD);

        if ($_POST) {
            $this->load->library('form_validation');
            $this->form_validation->set_error_delimiters('<div class="error-message" style="color: red;">', '</div>');
            $this->form_validation->set_rules('charge_id', $this->lang->line('charge') . ' ' . $this->lang->line('name'), 'trim|required');
            $this->form_validation->set_rules('rate', $this->lang->line('rate'), 'trim|required');
            $this->form_validation->set_rules('quantity', $this->lang->line('quantity'), 'trim|required');
            $this->form_validation->set_rules('charge', $this->lang->line('charge'), 'trim|required');
            if ($this->form_validation->run() === TRUE) {
                $data['ipd_id'] = $this->input->post('ipd_id');
                $data['patient_id'] = $this->input->post('patient_id');
                $data['charge_id'] = $this->input->post('charge_id');
                $data['type'] = 'charge';
                $data['rate'] = $this->input->post('rate');
                $data['quantity'] = $this->input->post('quantity');
                $data['charge'] = $this->input->post('charge');
                $data['date'] = date('Y-m-d H:i', strtotime($this->input->post('date')));
                $data['note'] = $this->input->post('note');
                $data['charge_status'] = 'complete';
                $data['created_at'] = date('Y-m-d H:i:s');
                $data['created_by'] = logged_in_user_id();
                $insert_id = $this->charge->insert('ipd_charges', $data);
                if ($insert_id) {
                    $patient = $this->charge->get_single('patients', array('user_id' => $data['patient_id']));
                    create_log('Has been created a charge : ' . $patient->name);
                    success($this->lang->line('insert_success'));
                    redirect('ipd/charge/index/' . $data['ipd_id']);
                } else {
                    error($this->lang->line('insert_failed'));
                    redirect('ipd/charge/index/' . $data['ipd_id']);
                }
            } else {
                $this->data = $_POST;
            }
        }
    }

    /*****************Function get_charge**********************************
     * @type            : Function
     * @function name   : get_charge
     * @description     : Load "Single Charge" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function get_charge($id) {
        if ($id > 0) {
            $charge = $this->charge->get_single('ipd_charges', array('id' => $id));
            echo (json_encode($charge));
        }
    }

    /*****************Function edit**********************************
     * @type            : Function
     * @function name   : edit
     * @description     : Load Update "Charge Chart" user interface
     *                    with populate "Charge Chart" value
     *                    and process to update "ipd_charges" into database
     * @param           : $id integer value
     * @return          : null
     * ********************************************************** */
    public function edit() {

        check_permission(EDIT);

        if ($_POST) {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('charge_id', $this->lang->line('charge') . ' ' . $this->lang->line('name'), 'trim|required');
            $this->form_validation->set_rules('rate', $this->lang->line('rate'), 'trim|required');
            $this->form_validation->set_rules('quantity', $this->lang->line('quantity'), 'trim|required');
            $this->form_validation->set_rules('charge', $this->lang->line('charge'), 'trim|required');
            if ($this->form_validation->run() === TRUE) {
                $data['charge_id'] = $this->input->post('charge_id');
                $data['type'] = 'charge';
                $data['rate'] = $this->input->post('rate');
                $data['quantity'] = $this->input->post('quantity');
                $data['charge'] = $this->input->post('charge');
                $data['date'] = date('Y-m-d H:i', strtotime($this->input->post('date')));
                $data['charge_status'] = $this->input->post('charge_status');
                $data['note'] = $this->input->post('note');
                $data['modified_at'] = date('Y-m-d H:i:s');
                $data['modified_by'] = logged_in_user_id();

                $this->charge->update('ipd_charges', $data, array('id' => $this->input->post('edit_id')));
                $patient = $this->charge->get_single('patients', array('user_id' => $this->input->post('patient_id')));
                create_log('Has been updated a charge : ' . $patient->name);
                $array = array('status' => 'success', 'error' => '', 'message' => $this->lang->line('update_success'));
            } else {
                $msg = array(
                    'charge_id' => form_error('charge_id'),
                    'date' => form_error('date'),
                );
                $array = array('status' => 'failed', 'error' => $msg, 'message' => '');
            }

            echo json_encode($array);
        }
    }

    /*     * ***************Function get_single_charge**********************************
     * @type            : Function
     * @function name   : get_single_charge
     * @description     : "Load single charge information" from database                  
     *                    to the user interface   
     * @param           : null
     * @return          : null 
     * ********************************************************** */

    public function get_single_charge() {
        $id = $this->input->post('id');
        $this->data['charge'] = $this->charge->get_single_charge($id);
        echo $this->load->view('ipd/charge/view', $this->data);
    }

    /*****************Function get_ipd_charge**********************************
     * @type            : Function
     * @function name   : get_ipd_charge
     * @description     : Load "IPD Charge" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function get_ipd_charge() {
        $charge_id = $this->input->post('charge_id');
        if ($charge_id > 0) {
            $charges = $this->charge->get_single('charges', array('id' => $charge_id));
            $charge = array(
                'charge' => $charges->price
            );
        }
        echo (json_encode($charge));
    }

    /*****************Function delete**********************************
     * @type            : Function
     * @function name   : delete
     * @description     : delete "Charge" data from database
     *
     * @param           : $id integer value
     * @return          : null
     * ********************************************************** */
    public function delete($id = null) {

        check_permission(DELETE);

        if (!is_numeric($id)) {
            error($this->lang->line('unexpected_error'));
            redirect($_SERVER['HTTP_REFERER']);
        }

        $charge = $this->charge->get_single('ipd_charges', array('id' => $id));
        $patient = $this->charge->get_single('patients', array('user_id' => $charge->patient_id));

        if ($this->ipd->delete('ipd_charges', array('id' => $id))) {
            create_log('Has been deleted a charge : ' . $patient->name);
            success($this->lang->line('delete_success'));
        } else {
            error($this->lang->line('delete_failed'));
        }
        redirect($_SERVER['HTTP_REFERER']);
    }
}
