<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('department'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('manage_department'); ?>
        </h4>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <?php $this->load->view('hrm/left-side'); ?>
        <!-- col-lg-9 -->
        <div class="col-lg-9">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(VIEW, 'hrm', 'department')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-university font-30 mr-10"></i>
                            <?php echo $this->lang->line('department'); ?> <?php echo $this->lang->line('list'); ?>
                        </h6>
                    <?php } ?>

                    <?php echo form_open_multipart(site_url('hrm/department'), array('name' => 'search', 'id' => 'search', 'class' => 'needs-validation', 'novalidate' => 'novalidate', 'method' => 'get'), ''); ?>
                    <div class="form-group">
                        <div class="input-group input-group-sm">
                            <input type="text" class="form-control" name="keyword" id="keyword" value="<?php echo isset($keyword) ?  $keyword : ''; ?>" placeholder="<?php echo $this->lang->line('keyword'); ?>">
                            <div class="input-group-append">
                                <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('search'); ?></button>
                            </div>
                        </div>
                    </div>
                    <?php echo form_close(); ?>

                    <?php if (has_permission(ADD, 'hrm', 'department')) { ?>
                        <div class="align-items-center">
                            <a href="<?php echo site_url('hrm/department/add'); ?>" class="btn btn-xs btn-primary">
                                <i class="fa fa-plus font-12 mr-5"></i>
                                <?php echo $this->lang->line('add'); ?> <?php echo $this->lang->line('department'); ?>
                            </a>
                        </div>
                    <?php } ?>
                </div>
                <div class="card-body">
                    <div class="table-wrap">
                        <div class="table-responsive">
                            <table class="table table-sm mb-0">
                                <thead>
                                    <tr>
                                        <th><?php echo $this->lang->line('sl_no'); ?></th>
                                        <th><?php echo $this->lang->line('image'); ?></th>
                                        <th><?php echo $this->lang->line('type'); ?></th>
                                        <th><?php echo $this->lang->line('name'); ?></th>
                                        <th><?php echo $this->lang->line('status'); ?></th>
                                        <th><?php echo $this->lang->line('sort_by'); ?></th>
                                        <th class="w-15"><?php echo $this->lang->line('action'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if (isset($departments) && !empty($departments)) { ?>
                                        <?php foreach ($departments as $obj) { ?>
                                            <tr>
                                                <td><?php echo $sl_count; ?></td>
                                                <td>
                                                    <div class="avatar">
                                                        <?php if ($obj->image) { ?>
                                                            <img class="avatar-img rounded" src="<?php echo UPLOAD_PATH; ?>department-image/<?php echo $obj->image; ?>" alt="<?php echo $obj->name; ?>" />
                                                        <?php } else { ?>
                                                            <img class="avatar-img rounded" src="<?php echo IMG_URL; ?>department.png" alt="department" />
                                                        <?php } ?>
                                                    </div>
                                                </td>
                                                <td><?php echo $this->lang->line($obj->type); ?></td>
                                                <td><?php echo $obj->name; ?></td>
                                                <td>
                                                    <div class="toggle-wrap">
                                                        <div data-toggle-on="<?php echo $obj->status ? 'true' : 'false'; ?>" id="<?php echo $obj->id; ?>" status="<?php echo $obj->status ? '0' : '1'; ?>" class="toggle toggle-light toggle-bg-primary _status status_update"></div>
                                                    </div>
                                                </td>
                                                <td><?php echo $obj->sort_by; ?></td>
                                                <td>
                                                    <?php if (has_permission(VIEW, 'hrm', 'department')) { ?>
                                                        <button type="button" onclick="get_view_modal(<?php echo $obj->id; ?>);" data-toggle="modal" data-target=".viewModalCenter" class="btn btn-primary btn-xs">
                                                            <i class="fa fa-eye"></i>
                                                        </button>
                                                    <?php } ?>
                                                    <?php if (has_permission(EDIT, 'hrm', 'department')) { ?>
                                                        <a class="btn btn-xs btn-success" href="<?php echo site_url('hrm/department/edit/' . $obj->id); ?>"><i class="fa fa-pencil-square-o"></i></a>
                                                    <?php } ?>
                                                    <?php if (has_permission(DELETE, 'hrm', 'department')) { ?>
                                                        <a class="btn btn-xs btn-danger" href="<?php echo site_url('hrm/department/delete/' . $obj->id); ?>" onclick="javascript: return confirm('<?php echo $this->lang->line('confirm_alert'); ?>');"> <i class="fa fa-trash text-white"></i></a>
                                                    <?php } ?>
                                                </td>
                                            </tr>
                                            <?php $sl_count++; ?>
                                        <?php } ?>
                                    <?php } else { ?>
                                        <tr class="text-center">
                                            <td colspan="6"><?php echo $this->lang->line('no_data_found'); ?></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <!-- Card Footer -->
                <?php if ($this->pagination->create_links()) { ?>
                    <div class="card-footer justify-content-end">
                        <?php echo $this->pagination->create_links(); ?>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->

<!-- Toggles CSS -->
<link href="<?php echo VENDOR_URL;  ?>jquery-toggles/css/toggles.css" rel="stylesheet" type="text/css">
<link href="<?php echo VENDOR_URL;  ?>jquery-toggles/css/themes/toggles-light.css" rel="stylesheet" type="text/css">
<!-- Toggles JavaScript -->
<script src="<?php echo VENDOR_URL; ?>jquery-toggles/toggles.min.js"></script>

<script>
    $('._status').toggles({
        drag: true, // allow dragging the toggle between positions
        click: true, // allow clicking on the toggle
        text: {
            on: '<?php echo $this->lang->line('on'); ?>', // text for the ON position
            off: '<?php echo $this->lang->line('off'); ?>' // and off
        },
        on: true, // is the toggle ON on init
        animate: 250, // animation time (ms)
        easing: 'swing', // animation transition easing function
        checkbox: null, // the checkbox to toggle (for use in forms)
        clicker: null, // element that can be clicked on to toggle. removes binding from the toggle itself (use nesting)

        type: 'compact' // if this is set to 'select' then the select style toggle will be used
    });
</script>

<script>
    $('.status_update').click(function() {
        var id = $(this).attr('id');
        var status = $(this).attr('status');
        $.ajax({
            type: "POST",
            url: "<?php echo site_url('ajax/update_department_status'); ?>",
            data: {
                id: id,
                status: status
            },
            async: false,
            success: function(response) {
                if (response) {
                    $.toast({
                        heading: 'Success !',
                        text: '<p><?php echo $this->lang->line('update_success'); ?></p>',
                        position: 'top-right',
                        loaderBg: '#7a5449',
                        class: 'jq-toast-primary',
                        hideAfter: 3500,
                        stack: 6,
                        showHideTransition: 'fade'
                    });
                    location.reload();
                }
            }
        });
    });
</script>


<div class="modal fade viewModalCenter" tabindex="-1" role="dialog" aria-labelledby="viewModalCenter" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header bg-gradient-primary">
                <h5 class="modal-title text-white"><?php echo $this->lang->line('department'); ?> <?php echo $this->lang->line('info'); ?></h5>
                <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body modal_data bg-gradient-secondary"></div>
        </div>
    </div>
</div>

<script type="text/javascript">
    function get_view_modal(id) {
        $('.modal_data').html('<p style="padding: 20px;"><p style="padding: 20px;text-align:center;"><img src="<?php echo IMG_URL; ?>loader.gif" /></p>');
        $.ajax({
            type: "POST",
            url: "<?php echo site_url('hrm/department/get_single_department'); ?>",
            data: {
                id: id
            },
            success: function(response) {
                if (response) {
                    $('.modal_data').html(response);
                }
            }
        });
    }
</script>