<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('test'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('manage_test'); ?>
        </h4>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <?php $this->load->view('hospital/diagnostic/left-side'); ?>
        <!-- col-xl-9 -->
        <div class="col-lg-9">
            <!-- Counter Start -->
            <div class="hk-row">
                <div class="col-lg-6 col-md-6 col-sm-6">
                    <div class="card card-sm">
                        <div class="card-body">
                            <div class="d-flex align-items-center justify-content-between">
                                <div>
                                    <span class="d-block font-12 font-weight-bold text-dark text-uppercase mb-5">
                                        <?php echo $this->lang->line('total'); ?> <?php echo $this->lang->line('department'); ?>
                                    </span>
                                    <span class="d-block display-6 font-weight-400 text-dark">
                                        <?php echo $this->diagnostic->count_all('diagnostic_departments', array('status' => 1)); ?>
                                    </span>
                                </div>
                                <div>
                                    <a href="<?php echo site_url('hospital/diagnostic/department'); ?>" class="btn btn-primary btn-sm">
                                        <i class="fa fa-building" aria-hidden="true"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!--/ col-lg-3 col-md-3 col-sm-6 -->
                <div class="col-lg-6 col-md-6 col-sm-6">
                    <div class="card card-sm">
                        <div class="card-body">
                            <div class="d-flex align-items-center justify-content-between">
                                <div>
                                    <span class="d-block font-12 font-weight-bold text-dark text-uppercase mb-5">
                                        <?php echo $this->lang->line('total'); ?> <?php echo $this->lang->line('group'); ?>
                                    </span>
                                    <span class="d-block display-6 font-weight-400 text-dark">
                                        <?php echo $this->diagnostic->count_all('diagnostic_groups', array('status' => 1)); ?>
                                    </span>
                                </div>
                                <div>
                                    <a href="<?php echo site_url('hospital/diagnostic/group'); ?>" class="btn btn-success btn-sm">
                                        <i class="fa fa-group" aria-hidden="true"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!--/ col-lg-3 col-md-3 col-sm-6 -->
                <div class="col-lg-6 col-md-6 col-sm-6">
                    <div class="card card-sm">
                        <div class="card-body">
                            <div class="d-flex align-items-center justify-content-between">
                                <div>
                                    <span class="d-block font-12 font-weight-bold text-dark text-uppercase mb-5">
                                        <?php echo $this->lang->line('total'); ?> <?php echo $this->lang->line('test'); ?>
                                    </span>
                                    <span class="d-block display-6 font-weight-400 text-dark">
                                        <?php echo $this->diagnostic->count_all('diagnostic_tests', array('status' => 1)); ?>
                                    </span>
                                </div>
                                <div>
                                    <a href="<?php echo site_url('hospital/diagnostic/test'); ?>" class="btn btn-info btn-sm">
                                        <i class="fa fa-h-square" aria-hidden="true"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!--/ col-lg-3 col-md-3 col-sm-6 -->
                <div class="col-lg-6 col-md-6 col-sm-6">
                    <div class="card card-sm">
                        <div class="card-body">
                            <div class="d-flex align-items-center justify-content-between">
                                <div>
                                    <span class="d-block font-12 font-weight-bold text-dark text-uppercase mb-5">
                                        <?php echo $this->lang->line('total'); ?> <?php echo $this->lang->line('rate'); ?>
                                    </span>
                                    <span class="d-block display-6 font-weight-400 text-dark">
                                        <?php echo $total->total_rate ? $total->total_rate : '0.00'; ?>
                                    </span>
                                </div>
                                <div>
                                    <a href="<?php echo site_url('hospital/diagnostic/test'); ?>" class="btn btn-blue btn-sm">
                                        <i class="fa fa-money" aria-hidden="true"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!--/ col-lg-3 col-md-3 col-sm-6 -->
                <div class="col-lg-6 col-md-6 col-sm-6">
                    <div class="card card-sm">
                        <div class="card-body">
                            <div class="d-flex align-items-center justify-content-between">
                                <div>
                                    <span class="d-block font-12 font-weight-bold text-dark text-uppercase mb-5">
                                        <?php echo $this->lang->line('mbbs'); ?> <?php echo $this->lang->line('commission'); ?>
                                    </span>
                                    <span class="d-block display-6 font-weight-400 text-dark">
                                        <?php echo ($total->total_rate - $total->total_mbbs) ? ($total->total_rate - $total->total_mbbs) : '0.00'; ?>
                                    </span>
                                </div>
                                <div>
                                    <a href="<?php echo site_url('hospital/diagnostic/test'); ?>" class="btn btn-sky btn-sm">
                                        <i class="fa fa-user-md" aria-hidden="true"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!--/ col-lg-3 col-md-3 col-sm-6 -->
                <div class="col-lg-6 col-md-6 col-sm-6">
                    <div class="card card-sm">
                        <div class="card-body">
                            <div class="d-flex align-items-center justify-content-between">
                                <div>
                                    <span class="d-block font-12 font-weight-bold text-dark text-uppercase mb-5">
                                        <?php echo $this->lang->line('vd'); ?> <?php echo $this->lang->line('commission'); ?>
                                    </span>
                                    <span class="d-block display-6 font-weight-400 text-dark">
                                        <?php echo ($total->total_rate - $total->total_vd) ? ($total->total_rate - $total->total_vd) : '0.00'; ?>
                                    </span>
                                </div>
                                <div>
                                    <a href="<?php echo site_url('hospital/diagnostic/test'); ?>" class="btn btn-teal btn-sm">
                                        <i class="fa fa-user-md" aria-hidden="true"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!--/ col-lg-3 col-md-3 col-sm-6 -->
                <div class="col-lg-6 col-md-6 col-sm-6">
                    <div class="card card-sm">
                        <div class="card-body">
                            <div class="d-flex align-items-center justify-content-between">
                                <div>
                                    <span class="d-block font-12 font-weight-bold text-dark text-uppercase mb-5">
                                        <?php echo $this->lang->line('employee'); ?> <?php echo $this->lang->line('commission'); ?>
                                    </span>
                                    <span class="d-block display-6 font-weight-400 text-dark">
                                        <?php echo ($total->total_rate - $total->total_emp) ? ($total->total_rate - $total->total_emp) : '0.00'; ?>
                                    </span>
                                </div>
                                <div>
                                    <a href="<?php echo site_url('hospital/diagnostic/test'); ?>" class="btn btn-yellow btn-sm">
                                        <i class="fa fa-user" aria-hidden="true"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!--/ col-lg-3 col-md-3 col-sm-6 -->
                <div class="col-lg-6 col-md-6 col-sm-6">
                    <div class="card card-sm">
                        <div class="card-body">
                            <div class="d-flex align-items-center justify-content-between">
                                <div>
                                    <span class="d-block font-12 font-weight-bold text-dark text-uppercase mb-5">
                                        <?php echo $this->lang->line('corporate'); ?> <?php echo $this->lang->line('commission'); ?>
                                    </span>
                                    <span class="d-block display-6 font-weight-400 text-dark">
                                        <?php echo ($total->total_rate - $total->total_corporate) ? ($total->total_rate - $total->total_corporate) : '0.00'; ?>
                                    </span>
                                </div>
                                <div>
                                    <a href="<?php echo site_url('hospital/diagnostic/test'); ?>" class="btn btn-pumpkin btn-sm">
                                        <i class="fa fa-user-o" aria-hidden="true"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!--/ col-lg-3 col-md-3 col-sm-6 -->
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->