<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('bed'); ?> <?php echo $this->lang->line('status'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('bed'); ?> <?php echo $this->lang->line('status'); ?>
        </h4>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <?php $this->load->view('hospital/bed/left-side'); ?>
        <!-- col-xl-8 -->
        <div class="col-lg-9">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(VIEW, 'hospital', 'bed')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-hourglass-start font-30 mr-10"></i>
                            <?php echo $this->lang->line('bed'); ?> <?php echo $this->lang->line('status'); ?>
                        </h6>
                    <?php } ?>
                    <?php echo form_open_multipart(site_url('hospital/bed/status'), array('name' => 'search', 'id' => 'search', 'class' => 'needs-validation', 'novalidate' => 'novalidate', 'method' => 'get'), ''); ?>
                    <div class="form-group">
                        <div class="input-group input-group-sm">
                            <input type="text" class="form-control" name="search" id="search" value="<?php echo isset($search) ?  $search : ''; ?>" placeholder="<?php echo $this->lang->line('search'); ?>">
                            <div class="input-group-append">
                                <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('search'); ?></button>
                            </div>
                        </div>
                    </div>
                    <?php echo form_close(); ?>
                    <?php if (has_permission(ADD, 'hospital', 'bed')) { ?>
                        <div class="align-items-center">
                            <a href="<?php echo site_url('hospital/bed/add'); ?>" class="btn btn-xs btn-primary">
                                <i class="fa fa-plus font-12 mr-5"></i>
                                <?php echo $this->lang->line('add'); ?> <?php echo $this->lang->line('bed'); ?>
                            </a>
                        </div>
                    <?php } ?>
                </div>
                <div class="card-body">
                    <div class="table-wrap">
                        <div class="table-responsive">
                            <table class="table table-sm mb-0">
                                <thead>
                                    <tr>
                                        <th><?php echo $this->lang->line('sl_no'); ?></th>
                                        <th><?php echo $this->lang->line('bed'); ?> <?php echo $this->lang->line('type'); ?></th>
                                        <th><?php echo $this->lang->line('bed'); ?> <?php echo $this->lang->line('group'); ?></th>
                                        <th><?php echo $this->lang->line('name'); ?></th>
                                        <th><?php echo $this->lang->line('floor'); ?></th>
                                        <th><?php echo $this->lang->line('status'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if (isset($beds) && !empty($beds)) { ?>
                                        <?php foreach ($beds as $obj) { ?>
                                            <tr class="<?php echo $obj->is_active ? 'table-danger' : ''; ?>">
                                                <td><?php echo $sl_count; ?></td>
                                                <td><?php echo $obj->type; ?></td>
                                                <td><?php echo $obj->group; ?></td>
                                                <td><?php echo $obj->name; ?></td>
                                                <td><?php echo $obj->floor; ?></td>
                                                <td>
                                                    <?php echo $obj->is_active ? '<span class="badge badge-danger">' . $this->lang->line('allotted') . '</span>' : '<span class="badge badge-success">' . $this->lang->line('available') . '</span>'; ?>
                                                </td>
                                            </tr>
                                            <?php $sl_count++; ?>
                                        <?php } ?>
                                    <?php } else { ?>
                                        <tr class="text-center">
                                            <td colspan="6"><?php echo $this->lang->line('no_data_found'); ?></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <!-- Card Footer -->
                <?php if ($this->pagination->create_links()) { ?>
                    <div class="card-footer justify-content-end">
                        <?php echo $this->pagination->create_links(); ?>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->